import { Component, OnInit, ViewChild } from "@angular/core";
import { NgForm } from "@angular/forms";
import { LayoutService, PageInfoService } from "../../_metronic/layout";

type Tabs = "Header" | "Toolbar" | "PageTitle" | "Aside" | "Content" | "Footer";

@Component({
  selector: "app-builder",
  templateUrl: "./builder.component.html",
})
export class BuilderComponent implements OnInit {
  activeTab: Tabs = "Header";
  model: any;
  @ViewChild("form", { static: true }) form: NgForm;
  configLoading: boolean = false;
  resetLoading: boolean = false;
  constructor(
    private layout: LayoutService,
    private pageInfo: PageInfoService
  ) {}

  ngOnInit(): void {
    this.model = this.layout.getConfig();
    this.pageInfo.updateBreadcrumbs([]);
  }

  setActiveTab(tab: Tabs) {
    this.activeTab = tab;
  }

  resetPreview(): void {
    this.resetLoading = true;
    this.layout.refreshConfigToDefault();
  }

  submitPreview(): void {
    this.configLoading = true;
    this.layout.setConfig(this.model);
    location.reload();
  }
}
