<x-base-layout>

    <!--begin::Section-->
    <div class="pb-10">
        <!--begin::Heading-->
        <h1 class="anchor fw-bolder mb-5" id="title">
            <a href="#title"></a>
            {{ theme()->getPageTitle() }}
        </h1>
        <!--end::Heading-->

        <!--begin::Block-->
        <div class="py-5">
            {!! theme()->getProductNameHtml() !!} was specifically designed to support a multi-demo concept.
            This Multi-Demo concept is included within {!! theme()->getProductNameHtml() !!}’s package files that also includes
            {!! theme()->getProductNameHtml() !!}’s default global components and plugins.
        </div>
        <!--end::Block-->
    </div>
    <!--end::Section-->

    <!--begin::Section-->
    <div class="pb-10">
        <!--begin::Heading-->
        <h1 class="anchor fw-bolder mb-2" id="concep">
            <a href="#concep"></a>
            What is "Multi-Demo" concept?
        </h1>
        <!--end::Heading-->

        <!--begin::Block-->
        <div class="py-5">
            A Multi-Demo means that by purchasing a single license of {!! theme()->getProductNameHtml() !!},
            you are entitled to receive and use all the different demo types that comes packed within {!! theme()->getProductNameHtml() !!} itself.

            Each Demo within {!! theme()->getProductNameHtml() !!} is uniquely designed for specific types of solutions or project requirement.
            For example, when you purchase {!! theme()->getProductNameHtml() !!}, you’ll be able to utilize {!! theme()->getProductNameHtml() !!}’s Default demo,
            a CRM Application demo, an Intranet System demo, an eCommerce Backend demo, a SAAS Service demo and so much more.
            Each Demo is organized within its own folder, which is also neatly packed with its own SCSS and JS files or any other files that are specifically required for that demo.
        </div>
        <!--end::Block-->
    </div>
    <!--end::Section-->

    <!--begin::Section-->
    <div class="pb-10">
        <!--begin::Heading-->
        <h1 class="anchor fw-bolder mb-2" id="components">
            <a href="#components"></a>
            What is a "Global Component Component/Plugin" ?
        </h1>
        <!--end::Heading-->

        <!--begin::Block-->
        <div class="py-5">
            Global components or Global Plugins are abstract functional elements that can function independently within any of
            {!! theme()->getProductNameHtml() !!}’s demos. For example, an invoice template or button styles are global components and a datatable or a form wizard are global plugins.

            Each demo is cross-compatible with {!! theme()->getProductNameHtml() !!}’s default global components and plugins.
            This allows you to create and develop uniquely design projects by using different demo types together with hand-picked global components and plugins.
        </div>
        <!--end::Block-->
    </div>
    <!--end::Section-->

    <!--begin::Section-->
    <div class="pb-10">
        <!--begin::Heading-->
        <h1 class="anchor fw-bolder mb-2" id="customization">
            <a href="#customization"></a>
            Further Customization Options
        </h1>
        <!--end::Heading-->

        <!--begin::Block-->
        <div class="py-5">
            All these options can also be overridden by your own customized component styles and settings to ensure that your projects with
            {!! theme()->getProductNameHtml() !!} will always stay fresh and unique for each deployment. Please note that each deployment of
            {!! theme()->getProductNameHtml() !!} will require a single regular license or higher.
        </div>
        <!--end::Block-->
    </div>
    <!--end::Section-->

</x-base-layout>
