<?php
    $path = theme()->getPagePath();
    $path_parts = explode("/", $path);
    $title = util()->camelize($path_parts[1], '-');

    $options = array(
        'skip-active' => false,
        'home' => array(
            'title' => $title,
            'active' => false
        )
    );

    $menu = new \App\Core\Adapters\Menu(theme()->getOption('menu', 'documentation'), theme()->getPagePath());

    $breadcrumb = $menu->getBreadcrumb($options);
?>

<!--begin::Page title-->
<div class="docs-page-title d-flex flex-column flex-lg-row align-items-lg-center py-5 mb-lg-0"
     data-kt-swapper="true"
     data-kt-swapper-mode="prepend"
     data-kt-swapper-parent="{default: '#kt_docs_content_container', 'lg': '#kt_docs_header_title'}"
>

    <!--begin::Title-->
    <h1 class="d-flex align-items-center text-dark my-1 fs-4">
        <?php echo e(__('Documentation')); ?>


        <a href="<?php echo e(theme()->getPageUrl('documentation/getting-started/changelog')); ?>" class="badge fw-bold fs-9 px-2 ms-2 <?php echo e(util()->putIf(theme()->isDarkMode(), 'badge-light-success text-hover-success', 'badge-white text-hover-primary shadow-sm')); ?>">
            v<?php echo e(theme()->getVersion()); ?>

        </a>

        <?php if(!empty(theme()->hasOption('page', 'description')) && theme()->getOption('layout', 'page-title/description') !== false): ?>
        <!--begin::Separator-->
            <span class="d-none d-lg-block bullet h-20px w-1px bg-secondary mx-4"></span>
            <!--end::Separator-->

            <!--begin::Description-->
            <small class="text-gray-700 fs-7 fw-bold my-1 ms-1">
                <?php echo e(theme()->getOption('page', 'description')); ?>

            </small>
            <!--end::Description-->
        <?php endif; ?>
    </h1>
    <!--end::Title-->

<?php if(!empty($breadcrumb)): ?>
        <!--begin::Separator-->
        <span class="d-none d-lg-block bullet h-20px w-1px bg-secondary mx-4"></span>
        <!--end::Separator-->

        <!--begin::Breadcrumb-->
        <ul class="breadcrumb breadcrumb-separatorless fw-bold fs-6 my-1">
        <?php $__currentLoopData = $breadcrumb; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <!--begin::Item-->
                <?php if( $item['active'] === true ): ?>
                    <li class="breadcrumb-item text-dark">
                        <?php echo e($item['title']); ?>


                        <?php if(theme()->getOption('page', 'exclusive') === true): ?>
                            <span class="badge badge-success fw-bold fs-9 px-2 ms-2 cursor-default ms-2" data-bs-toggle="tooltip" title="Developed in-house for Metronic">Exclusive</span>
                        <?php endif; ?>
                    </li>
                <?php else: ?>
                    <li class="breadcrumb-item text-gray-600">
                        <?php if( !empty($item['path']) ): ?>
                            <a href="<?php echo e(theme()->getPageUrl($item['path'])); ?>" class="text-gray-600 text-hover-primary">
                                <?php echo e($item['title']); ?>

                            </a>
                        <?php else: ?>
                            <?php echo e($item['title']); ?>

                        <?php endif; ?>
                    </li>
                <?php endif; ?>
            <!--end::Item-->
                <?php if(next($breadcrumb)): ?>
                <!--begin::Item-->
                    <li class="breadcrumb-item">
                        <span class="bullet w-5px h-2px"></span>
                    </li>
                    <!--end::Item-->
                <?php endif; ?>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </ul>
        <!--end::Breadcrumb-->
    <?php endif; ?>
</div>
<!--end::Page title-->
<?php /**PATH C:\wamp64\www\keenthemes\themes\metronic\laravel\resources\views/layout/docs/_page-title.blade.php ENDPATH**/ ?>