<?php
    $breadcrumb = bootstrap()->getBreadcrumb();
?>

<!--begin::Page title-->
<div <?php echo e(theme()->printHtmlAttributes("page-title")); ?> class="page-title d-flex flex-column py-1">
    <!--begin::Title-->
    <h1 class="d-flex align-items-center my-1">
        <span class="text-dark fw-bolder fs-1">
            <?php echo e(theme()->getOption('page', 'title')); ?>

        </span>

        <?php if(!empty(theme()->hasOption('page', 'description')) && theme()->getOption('layout', 'page-title/description') !== false): ?>
            <!--begin::Description-->
            <small class="text-muted fs-6 fw-bold ms-1">
                <?php echo e(theme()->getOption('page', 'description')); ?>

            </small>
            <!--end::Description-->
        <?php endif; ?>
    </h1>
    <!--end::Title-->

    <?php if( theme()->getOption('layout', 'page-title/breadcrumb') === true && !empty($breadcrumb)): ?>
        <!--begin::Breadcrumb-->
        <ul class="breadcrumb breadcrumb-separatorless fw-bold fs-7 <?php echo e(theme()->getOption('layout', 'page-title/direction') === 'row' ? 'my-1' : 'pt-1'); ?>">
        <?php $__currentLoopData = $breadcrumb; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <!--begin::Item-->
                <?php if( $item['active'] === true ): ?>
                    <li class="breadcrumb-item text-dark">
                        <?php echo e($item['title']); ?>

                    </li>
                <?php else: ?>
                    <li class="breadcrumb-item text-muted">
                        <?php if( ! empty($item['path']) ): ?>
                            <a href="<?php echo e(theme()->getPageUrl($item['path'])); ?>" class="text-muted text-hover-primary">
                                <?php echo e($item['title']); ?>

                            </a>
                        <?php else: ?>
                            <?php echo e($item['title']); ?>

                        <?php endif; ?>
                    </li>
                <?php endif; ?>
            <!--end::Item-->
                <?php if(next($breadcrumb)): ?>
                <!--begin::Item-->
                    <li class="breadcrumb-item">
                        <span class="bullet bg-gray-200 w-5px h-2px"></span>
                    </li>
                    <!--end::Item-->
                <?php endif; ?>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </ul>
        <!--end::Breadcrumb-->
    <?php endif; ?>
</div>
<!--end::Page title-->
<?php /**PATH C:\wamp64\www\keenthemes\themes\metronic\laravel\resources\views/layout/demo5/_page-title.blade.php ENDPATH**/ ?>