<?php
    $breadcrumb = bootstrap()->getBreadcrumb();
?>

<!--begin::Page title-->
<div
    class="page-title d-flex flex-column align-items-start justify-content-center flex-wrap me-lg-20 py-3 py-lg-0 me-3">

    <!--begin::Heading-->
    <h1 class="d-flex flex-column text-dark fw-bolder my-1">
        <span class="text-white fs-1">
            <?php echo e(theme()->getOption('page', 'title')); ?>

        </span>

        <?php if(theme()->getOption('layout', 'page-title/description') && theme()->hasOption('page', 'description')): ?>
            <small class="text-gray-600 fs-6 fw-normal pt-2"><?php echo e(theme()->getOption('page', 'description')); ?></small>
        <?php endif; ?>
    </h1>
    <!--end::Heading-->

    <?php if( theme()->getOption('layout', 'page-title/breadcrumb') && !empty($breadcrumb) ): ?>
        <!--begin::Breadcrumb-->
        <ul class="breadcrumb breadcrumb-line fw-bold fs-7 my-1">
            <?php $__currentLoopData = $breadcrumb; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <?php if( $item['active'] === true ): ?>
                    <li class="breadcrumb-item text-gray-400">
                        <?php echo e($item['title']); ?>

                    </li>
                <?php else: ?>
                    <li class="breadcrumb-item text-gray-600">
                        <?php if( ! empty($item['path']) ): ?>
                            <a href="<?php echo e(theme()->getPageUrl($item['path'])); ?>" class="text-gray-600">
                                <?php echo e($item['title']); ?>

                            </a>
                        <?php else: ?>
                            <?php echo e($item['title']); ?>

                        <?php endif; ?>
                    </li>
                <?php endif; ?>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </ul>
        <!--end::Breadcrumb-->
    <?php endif; ?>
</div>
<!--end::Page title--->
<?php /**PATH C:\wamp64\www\keenthemes\themes\metronic\laravel\resources\views/layout/demo9/_page-title.blade.php ENDPATH**/ ?>