
<?php
    $breadcrumb = bootstrap()->getBreadcrumb();

    if (theme()->getOption('layout', 'page-title/direction') == 'column') {
        $baseClass = 'flex-column align-items-start me-3';
    } else {
        $baseClass = 'me-3';
    }

    $attr = array();
    if (theme()->getOption('layout', 'page-title/responsive') === true) {
        $baseClass .= " flex-wrap mb-5 mb-lg-0 lh-1";
    }
?>

<!--begin::Page title-->
<div <?php echo e(theme()->printHtmlAttributes("page-title")); ?> class="page-title d-flex flex-column <?php echo e($baseClass); ?>">
    <!--begin::Title-->
    <h1 class="d-flex text-white fw-bolder my-1 fs-3">
        <?php echo e(theme()->getOption('page', 'title')); ?>


        <?php if(!empty(theme()->hasOption('page', 'description')) && theme()->getOption('layout', 'page-title/description') !== false): ?>
            <!--begin::Separator-->
            <span class="h-20px border-white opacity-75 border-start ms-3 mx-2"></span>
            <!--end::Separator-->

            <!--begin::Description-->
            <small class="text-white opacity-75 fs-7 fw-bold my-1 ms-1">
                <?php echo e(theme()->getOption('page', 'description')); ?>

            </small>
            <!--end::Description-->
        <?php endif; ?>
    </h1>
    <!--end::Title-->

    <?php if( theme()->getOption('layout', 'page-title/breadcrumb') === true && !empty($breadcrumb)): ?>
        <?php if(theme()->getOption('layout', 'page-title/direction') === 'row'): ?>
            <!--begin::Separator-->
            <span class="h-20px border-white opacity-75 border-start mx-4"></span>
            <!--end::Separator-->
        <?php endif; ?>

        <!--begin::Breadcrumb-->
        <ul class="breadcrumb breadcrumb-separatorless fw-bold fs-7 my-1">
            <?php $__currentLoopData = $breadcrumb; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <!--begin::Item-->
                <?php if( $item['active'] === true ): ?>
                    <li class="breadcrumb-item text-white opacity-75">
                        <?php echo e($item['title']); ?>

                    </li>
                <?php else: ?>
                    <li class="breadcrumb-item text-white opacity-75">
                        <?php if( ! empty($item['path']) ): ?>
                            <a href="<?php echo e(theme()->getPageUrl($item['path'])); ?>" class="text-white text-hover-primary">
                                <?php echo e($item['title']); ?>

                            </a>
                        <?php else: ?>
                            <?php echo e($item['title']); ?>

                        <?php endif; ?>
                    </li>
                <?php endif; ?>
                <!--end::Item-->
                <?php if(next($breadcrumb)): ?>
                    <!--begin::Item-->
                    <li class="breadcrumb-item">
                        <span class="bullet bg-white opacity-75 w-5px h-2px"></span>
                    </li>
                    <!--end::Item-->
                <?php endif; ?>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </ul>
        <!--end::Breadcrumb-->
    <?php endif; ?>
</div>
<!--end::Page title-->
<?php /**PATH C:\wamp64\www\keenthemes\themes\metronic\laravel\resources\views/layout/demo2/_page-title.blade.php ENDPATH**/ ?>