/******/ (function(modules) { // webpackBootstrap
/******/ 	// The module cache
/******/ 	var installedModules = {};
/******/
/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {
/******/
/******/ 		// Check if module is in cache
/******/ 		if(installedModules[moduleId]) {
/******/ 			return installedModules[moduleId].exports;
/******/ 		}
/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = installedModules[moduleId] = {
/******/ 			i: moduleId,
/******/ 			l: false,
/******/ 			exports: {}
/******/ 		};
/******/
/******/ 		// Execute the module function
/******/ 		modules[moduleId].call(module.exports, module, module.exports, __webpack_require__);
/******/
/******/ 		// Flag the module as loaded
/******/ 		module.l = true;
/******/
/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}
/******/
/******/
/******/ 	// expose the modules object (__webpack_modules__)
/******/ 	__webpack_require__.m = modules;
/******/
/******/ 	// expose the module cache
/******/ 	__webpack_require__.c = installedModules;
/******/
/******/ 	// define getter function for harmony exports
/******/ 	__webpack_require__.d = function(exports, name, getter) {
/******/ 		if(!__webpack_require__.o(exports, name)) {
/******/ 			Object.defineProperty(exports, name, { enumerable: true, get: getter });
/******/ 		}
/******/ 	};
/******/
/******/ 	// define __esModule on exports
/******/ 	__webpack_require__.r = function(exports) {
/******/ 		if(typeof Symbol !== 'undefined' && Symbol.toStringTag) {
/******/ 			Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });
/******/ 		}
/******/ 		Object.defineProperty(exports, '__esModule', { value: true });
/******/ 	};
/******/
/******/ 	// create a fake namespace object
/******/ 	// mode & 1: value is a module id, require it
/******/ 	// mode & 2: merge all properties of value into the ns
/******/ 	// mode & 4: return value when already ns object
/******/ 	// mode & 8|1: behave like require
/******/ 	__webpack_require__.t = function(value, mode) {
/******/ 		if(mode & 1) value = __webpack_require__(value);
/******/ 		if(mode & 8) return value;
/******/ 		if((mode & 4) && typeof value === 'object' && value && value.__esModule) return value;
/******/ 		var ns = Object.create(null);
/******/ 		__webpack_require__.r(ns);
/******/ 		Object.defineProperty(ns, 'default', { enumerable: true, value: value });
/******/ 		if(mode & 2 && typeof value != 'string') for(var key in value) __webpack_require__.d(ns, key, function(key) { return value[key]; }.bind(null, key));
/******/ 		return ns;
/******/ 	};
/******/
/******/ 	// getDefaultExport function for compatibility with non-harmony modules
/******/ 	__webpack_require__.n = function(module) {
/******/ 		var getter = module && module.__esModule ?
/******/ 			function getDefault() { return module['default']; } :
/******/ 			function getModuleExports() { return module; };
/******/ 		__webpack_require__.d(getter, 'a', getter);
/******/ 		return getter;
/******/ 	};
/******/
/******/ 	// Object.prototype.hasOwnProperty.call
/******/ 	__webpack_require__.o = function(object, property) { return Object.prototype.hasOwnProperty.call(object, property); };
/******/
/******/ 	// __webpack_public_path__
/******/ 	__webpack_require__.p = "/";
/******/
/******/
/******/ 	// Load entry module and return exports
/******/ 	return __webpack_require__(__webpack_require__.s = 15);
/******/ })
/************************************************************************/
/******/ ({

/***/ "./node_modules/@terraformer/arcgis/dist/t-arcgis.esm.js":
/*!***************************************************************!*\
  !*** ./node_modules/@terraformer/arcgis/dist/t-arcgis.esm.js ***!
  \***************************************************************/
/*! exports provided: arcgisToGeoJSON, geojsonToArcGIS */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"arcgisToGeoJSON\", function() { return arcgisToGeoJSON; });\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"geojsonToArcGIS\", function() { return geojsonToArcGIS; });\n/* @preserve\n* @terraformer/arcgis - v2.0.6 - MIT\n* Copyright (c) 2012-2020 Environmental Systems Research Institute, Inc.\n* Mon May 18 2020 14:30:35 GMT-0700 (Pacific Daylight Time)\n*/\n/* Copyright (c) 2012-2019 Environmental Systems Research Institute, Inc.\n * Apache-2.0 */\n\nvar edgeIntersectsEdge = function edgeIntersectsEdge(a1, a2, b1, b2) {\n  var uaT = (b2[0] - b1[0]) * (a1[1] - b1[1]) - (b2[1] - b1[1]) * (a1[0] - b1[0]);\n  var ubT = (a2[0] - a1[0]) * (a1[1] - b1[1]) - (a2[1] - a1[1]) * (a1[0] - b1[0]);\n  var uB = (b2[1] - b1[1]) * (a2[0] - a1[0]) - (b2[0] - b1[0]) * (a2[1] - a1[1]);\n\n  if (uB !== 0) {\n    var ua = uaT / uB;\n    var ub = ubT / uB;\n\n    if (ua >= 0 && ua <= 1 && ub >= 0 && ub <= 1) {\n      return true;\n    }\n  }\n\n  return false;\n};\nvar coordinatesContainPoint = function coordinatesContainPoint(coordinates, point) {\n  var contains = false;\n\n  for (var i = -1, l = coordinates.length, j = l - 1; ++i < l; j = i) {\n    if ((coordinates[i][1] <= point[1] && point[1] < coordinates[j][1] || coordinates[j][1] <= point[1] && point[1] < coordinates[i][1]) && point[0] < (coordinates[j][0] - coordinates[i][0]) * (point[1] - coordinates[i][1]) / (coordinates[j][1] - coordinates[i][1]) + coordinates[i][0]) {\n      contains = !contains;\n    }\n  }\n\n  return contains;\n};\nvar pointsEqual = function pointsEqual(a, b) {\n  for (var i = 0; i < a.length; i++) {\n    if (a[i] !== b[i]) {\n      return false;\n    }\n  }\n\n  return true;\n};\nvar arrayIntersectsArray = function arrayIntersectsArray(a, b) {\n  for (var i = 0; i < a.length - 1; i++) {\n    for (var j = 0; j < b.length - 1; j++) {\n      if (edgeIntersectsEdge(a[i], a[i + 1], b[j], b[j + 1])) {\n        return true;\n      }\n    }\n  }\n\n  return false;\n};\n\n/* Copyright (c) 2012-2019 Environmental Systems Research Institute, Inc.\n * Apache-2.0 */\n\nvar closeRing = function closeRing(coordinates) {\n  if (!pointsEqual(coordinates[0], coordinates[coordinates.length - 1])) {\n    coordinates.push(coordinates[0]);\n  }\n\n  return coordinates;\n}; // determine if polygon ring coordinates are clockwise. clockwise signifies outer ring, counter-clockwise an inner ring\n// or hole. this logic was found at http://stackoverflow.com/questions/1165647/how-to-determine-if-a-list-of-polygon-\n// points-are-in-clockwise-order\n\nvar ringIsClockwise = function ringIsClockwise(ringToTest) {\n  var total = 0;\n  var i = 0;\n  var rLength = ringToTest.length;\n  var pt1 = ringToTest[i];\n  var pt2;\n\n  for (i; i < rLength - 1; i++) {\n    pt2 = ringToTest[i + 1];\n    total += (pt2[0] - pt1[0]) * (pt2[1] + pt1[1]);\n    pt1 = pt2;\n  }\n\n  return total >= 0;\n}; // This function ensures that rings are oriented in the right directions\n// from http://jsperf.com/cloning-an-object/2\n\nvar shallowClone = function shallowClone(obj) {\n  var target = {};\n\n  for (var i in obj) {\n    // both arcgis attributes and geojson props are just hardcoded keys\n    if (obj.hasOwnProperty(i)) {\n      // eslint-disable-line no-prototype-builtins\n      target[i] = obj[i];\n    }\n  }\n\n  return target;\n};\n\n/* Copyright (c) 2012-2019 Environmental Systems Research Institute, Inc.\n * Apache-2.0 */\n\nvar coordinatesContainCoordinates = function coordinatesContainCoordinates(outer, inner) {\n  var intersects = arrayIntersectsArray(outer, inner);\n  var contains = coordinatesContainPoint(outer, inner[0]);\n\n  if (!intersects && contains) {\n    return true;\n  }\n\n  return false;\n}; // do any polygons in this array contain any other polygons in this array?\n// used for checking for holes in arcgis rings\n\n\nvar convertRingsToGeoJSON = function convertRingsToGeoJSON(rings) {\n  var outerRings = [];\n  var holes = [];\n  var x; // iterator\n\n  var outerRing; // current outer ring being evaluated\n\n  var hole; // current hole being evaluated\n  // for each ring\n\n  for (var r = 0; r < rings.length; r++) {\n    var ring = closeRing(rings[r].slice(0));\n\n    if (ring.length < 4) {\n      continue;\n    } // is this ring an outer ring? is it clockwise?\n\n\n    if (ringIsClockwise(ring)) {\n      var polygon = [ring.slice().reverse()]; // wind outer rings counterclockwise for RFC 7946 compliance\n\n      outerRings.push(polygon); // push to outer rings\n    } else {\n      holes.push(ring.slice().reverse()); // wind inner rings clockwise for RFC 7946 compliance\n    }\n  }\n\n  var uncontainedHoles = []; // while there are holes left...\n\n  while (holes.length) {\n    // pop a hole off out stack\n    hole = holes.pop(); // loop over all outer rings and see if they contain our hole.\n\n    var contained = false;\n\n    for (x = outerRings.length - 1; x >= 0; x--) {\n      outerRing = outerRings[x][0];\n\n      if (coordinatesContainCoordinates(outerRing, hole)) {\n        // the hole is contained push it into our polygon\n        outerRings[x].push(hole);\n        contained = true;\n        break;\n      }\n    } // ring is not contained in any outer ring\n    // sometimes this happens https://github.com/Esri/esri-leaflet/issues/320\n\n\n    if (!contained) {\n      uncontainedHoles.push(hole);\n    }\n  } // if we couldn't match any holes using contains we can try intersects...\n\n\n  while (uncontainedHoles.length) {\n    // pop a hole off out stack\n    hole = uncontainedHoles.pop(); // loop over all outer rings and see if any intersect our hole.\n\n    var intersects = false;\n\n    for (x = outerRings.length - 1; x >= 0; x--) {\n      outerRing = outerRings[x][0];\n\n      if (arrayIntersectsArray(outerRing, hole)) {\n        // the hole is contained push it into our polygon\n        outerRings[x].push(hole);\n        intersects = true;\n        break;\n      }\n    }\n\n    if (!intersects) {\n      outerRings.push([hole.reverse()]);\n    }\n  }\n\n  if (outerRings.length === 1) {\n    return {\n      type: 'Polygon',\n      coordinates: outerRings[0]\n    };\n  } else {\n    return {\n      type: 'MultiPolygon',\n      coordinates: outerRings\n    };\n  }\n};\n\nvar getId = function getId(attributes, idAttribute) {\n  var keys = idAttribute ? [idAttribute, 'OBJECTID', 'FID'] : ['OBJECTID', 'FID'];\n\n  for (var i = 0; i < keys.length; i++) {\n    var key = keys[i];\n\n    if (key in attributes && (typeof attributes[key] === 'string' || typeof attributes[key] === 'number')) {\n      return attributes[key];\n    }\n  }\n\n  throw Error('No valid id attribute found');\n};\n\nvar arcgisToGeoJSON = function arcgisToGeoJSON(arcgis, idAttribute) {\n  var geojson = {};\n\n  if (arcgis.features) {\n    geojson.type = 'FeatureCollection';\n    geojson.features = [];\n\n    for (var i = 0; i < arcgis.features.length; i++) {\n      geojson.features.push(arcgisToGeoJSON(arcgis.features[i], idAttribute));\n    }\n  }\n\n  if (typeof arcgis.x === 'number' && typeof arcgis.y === 'number') {\n    geojson.type = 'Point';\n    geojson.coordinates = [arcgis.x, arcgis.y];\n\n    if (typeof arcgis.z === 'number') {\n      geojson.coordinates.push(arcgis.z);\n    }\n  }\n\n  if (arcgis.points) {\n    geojson.type = 'MultiPoint';\n    geojson.coordinates = arcgis.points.slice(0);\n  }\n\n  if (arcgis.paths) {\n    if (arcgis.paths.length === 1) {\n      geojson.type = 'LineString';\n      geojson.coordinates = arcgis.paths[0].slice(0);\n    } else {\n      geojson.type = 'MultiLineString';\n      geojson.coordinates = arcgis.paths.slice(0);\n    }\n  }\n\n  if (arcgis.rings) {\n    geojson = convertRingsToGeoJSON(arcgis.rings.slice(0));\n  }\n\n  if (typeof arcgis.xmin === 'number' && typeof arcgis.ymin === 'number' && typeof arcgis.xmax === 'number' && typeof arcgis.ymax === 'number') {\n    geojson.type = 'Polygon';\n    geojson.coordinates = [[[arcgis.xmax, arcgis.ymax], [arcgis.xmin, arcgis.ymax], [arcgis.xmin, arcgis.ymin], [arcgis.xmax, arcgis.ymin], [arcgis.xmax, arcgis.ymax]]];\n  }\n\n  if (arcgis.geometry || arcgis.attributes) {\n    geojson.type = 'Feature';\n    geojson.geometry = arcgis.geometry ? arcgisToGeoJSON(arcgis.geometry) : null;\n    geojson.properties = arcgis.attributes ? shallowClone(arcgis.attributes) : null;\n\n    if (arcgis.attributes) {\n      try {\n        geojson.id = getId(arcgis.attributes, idAttribute);\n      } catch (err) {// don't set an id\n      }\n    }\n  } // if no valid geometry was encountered\n\n\n  if (JSON.stringify(geojson.geometry) === JSON.stringify({})) {\n    geojson.geometry = null;\n  }\n\n  if (arcgis.spatialReference && arcgis.spatialReference.wkid && arcgis.spatialReference.wkid !== 4326) {\n    console.warn('Object converted in non-standard crs - ' + JSON.stringify(arcgis.spatialReference));\n  }\n\n  return geojson;\n};\n\n/* Copyright (c) 2012-2019 Environmental Systems Research Institute, Inc.\n * Apache-2.0 */\n// outer rings are clockwise, holes are counterclockwise\n// used for converting GeoJSON Polygons to ArcGIS Polygons\n\nvar orientRings = function orientRings(poly) {\n  var output = [];\n  var polygon = poly.slice(0);\n  var outerRing = closeRing(polygon.shift().slice(0));\n\n  if (outerRing.length >= 4) {\n    if (!ringIsClockwise(outerRing)) {\n      outerRing.reverse();\n    }\n\n    output.push(outerRing);\n\n    for (var i = 0; i < polygon.length; i++) {\n      var hole = closeRing(polygon[i].slice(0));\n\n      if (hole.length >= 4) {\n        if (ringIsClockwise(hole)) {\n          hole.reverse();\n        }\n\n        output.push(hole);\n      }\n    }\n  }\n\n  return output;\n}; // This function flattens holes in multipolygons to one array of polygons\n// used for converting GeoJSON Polygons to ArcGIS Polygons\n\n\nvar flattenMultiPolygonRings = function flattenMultiPolygonRings(rings) {\n  var output = [];\n\n  for (var i = 0; i < rings.length; i++) {\n    var polygon = orientRings(rings[i]);\n\n    for (var x = polygon.length - 1; x >= 0; x--) {\n      var ring = polygon[x].slice(0);\n      output.push(ring);\n    }\n  }\n\n  return output;\n};\n\nvar geojsonToArcGIS = function geojsonToArcGIS(geojson, idAttribute) {\n  idAttribute = idAttribute || 'OBJECTID';\n  var spatialReference = {\n    wkid: 4326\n  };\n  var result = {};\n  var i;\n\n  switch (geojson.type) {\n    case 'Point':\n      result.x = geojson.coordinates[0];\n      result.y = geojson.coordinates[1];\n      result.spatialReference = spatialReference;\n      break;\n\n    case 'MultiPoint':\n      result.points = geojson.coordinates.slice(0);\n      result.spatialReference = spatialReference;\n      break;\n\n    case 'LineString':\n      result.paths = [geojson.coordinates.slice(0)];\n      result.spatialReference = spatialReference;\n      break;\n\n    case 'MultiLineString':\n      result.paths = geojson.coordinates.slice(0);\n      result.spatialReference = spatialReference;\n      break;\n\n    case 'Polygon':\n      result.rings = orientRings(geojson.coordinates.slice(0));\n      result.spatialReference = spatialReference;\n      break;\n\n    case 'MultiPolygon':\n      result.rings = flattenMultiPolygonRings(geojson.coordinates.slice(0));\n      result.spatialReference = spatialReference;\n      break;\n\n    case 'Feature':\n      if (geojson.geometry) {\n        result.geometry = geojsonToArcGIS(geojson.geometry, idAttribute);\n      }\n\n      result.attributes = geojson.properties ? shallowClone(geojson.properties) : {};\n\n      if (geojson.id) {\n        result.attributes[idAttribute] = geojson.id;\n      }\n\n      break;\n\n    case 'FeatureCollection':\n      result = [];\n\n      for (i = 0; i < geojson.features.length; i++) {\n        result.push(geojsonToArcGIS(geojson.features[i], idAttribute));\n      }\n\n      break;\n\n    case 'GeometryCollection':\n      result = [];\n\n      for (i = 0; i < geojson.geometries.length; i++) {\n        result.push(geojsonToArcGIS(geojson.geometries[i], idAttribute));\n      }\n\n      break;\n  }\n\n  return result;\n};\n\n/* Copyright (c) 2012-2019 Environmental Systems Research Institute, Inc.\n * Apache-2.0 */\n\n\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///./node_modules/@terraformer/arcgis/dist/t-arcgis.esm.js\n");

/***/ }),

/***/ "./node_modules/esri-leaflet-geocoder/dist/esri-leaflet-geocoder-debug.js":
/*!********************************************************************************!*\
  !*** ./node_modules/esri-leaflet-geocoder/dist/esri-leaflet-geocoder-debug.js ***!
  \********************************************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

eval("/* esri-leaflet-geocoder - v2.3.4 - Tue Dec 29 2020 16:04:32 GMT-0600 (Central Standard Time)\n * Copyright (c) 2020 Environmental Systems Research Institute, Inc.\n * Apache-2.0 */\n(function (global, factory) {\n   true ? factory(exports, __webpack_require__(/*! leaflet */ \"./node_modules/leaflet/dist/leaflet-src.js\"), __webpack_require__(/*! esri-leaflet */ \"./node_modules/esri-leaflet/src/EsriLeaflet.js\")) :\n  undefined;\n}(this, (function (exports, leaflet, esriLeaflet) { 'use strict';\n\n  var version = \"2.3.4\";\n\n  var WorldGeocodingServiceUrl = 'https://geocode.arcgis.com/arcgis/rest/services/World/GeocodeServer/';\n\n  var Geocode = esriLeaflet.Task.extend({\r\n    path: 'findAddressCandidates',\r\n\r\n    params: {\r\n      outSr: 4326,\r\n      forStorage: false,\r\n      outFields: '*',\r\n      maxLocations: 20\r\n    },\r\n\r\n    setters: {\r\n      'address': 'address',\r\n      'neighborhood': 'neighborhood',\r\n      'city': 'city',\r\n      'subregion': 'subregion',\r\n      'region': 'region',\r\n      'postal': 'postal',\r\n      'country': 'country',\r\n      'text': 'singleLine',\r\n      'category': 'category',\r\n      'token': 'token',\r\n      'key': 'magicKey',\r\n      'fields': 'outFields',\r\n      'forStorage': 'forStorage',\r\n      'maxLocations': 'maxLocations',\r\n      // World Geocoding Service (only works with singleLine)\r\n      'countries': 'sourceCountry'\r\n    },\r\n\r\n    initialize: function (options) {\r\n      options = options || {};\r\n      options.url = options.url || WorldGeocodingServiceUrl;\r\n      esriLeaflet.Task.prototype.initialize.call(this, options);\r\n    },\r\n\r\n    within: function (bounds) {\r\n      bounds = leaflet.latLngBounds(bounds);\r\n      this.params.searchExtent = esriLeaflet.Util.boundsToExtent(bounds);\r\n      return this;\r\n    },\r\n\r\n    nearby: function (coords, radius) {\r\n      var centroid = leaflet.latLng(coords);\r\n      this.params.location = centroid.lng + ',' + centroid.lat;\r\n      if (radius) {\r\n        this.params.distance = Math.min(Math.max(radius, 2000), 50000);\r\n      }\r\n      return this;\r\n    },\r\n\r\n    run: function (callback, context) {\r\n      if (this.options.customParam) {\r\n        this.params[this.options.customParam] = this.params.singleLine;\r\n        delete this.params.singleLine;\r\n      }\r\n\r\n      return this.request(function (error, response) {\r\n        var processor = this._processGeocoderResponse;\r\n        var results = (!error) ? processor(response) : undefined;\r\n        callback.call(context, error, { results: results }, response);\r\n      }, this);\r\n    },\r\n\r\n    _processGeocoderResponse: function (response) {\r\n      var results = [];\r\n\r\n      for (var i = 0; i < response.candidates.length; i++) {\r\n        var candidate = response.candidates[i];\r\n        if (candidate.extent) {\r\n          var bounds = esriLeaflet.Util.extentToBounds(candidate.extent);\r\n        }\r\n\r\n        results.push({\r\n          text: candidate.address,\r\n          bounds: bounds,\r\n          score: candidate.score,\r\n          latlng: leaflet.latLng(candidate.location.y, candidate.location.x),\r\n          properties: candidate.attributes\r\n        });\r\n      }\r\n      return results;\r\n    }\r\n  });\r\n\r\n  function geocode (options) {\r\n    return new Geocode(options);\r\n  }\n\n  var ReverseGeocode = esriLeaflet.Task.extend({\r\n    path: 'reverseGeocode',\r\n\r\n    params: {\r\n      outSR: 4326,\r\n      returnIntersection: false\r\n    },\r\n\r\n    setters: {\r\n      'distance': 'distance',\r\n      'language': 'langCode',\r\n      'intersection': 'returnIntersection'\r\n    },\r\n\r\n    initialize: function (options) {\r\n      options = options || {};\r\n      options.url = options.url || WorldGeocodingServiceUrl;\r\n      esriLeaflet.Task.prototype.initialize.call(this, options);\r\n    },\r\n\r\n    latlng: function (coords) {\r\n      var centroid = leaflet.latLng(coords);\r\n      this.params.location = centroid.lng + ',' + centroid.lat;\r\n      return this;\r\n    },\r\n\r\n    run: function (callback, context) {\r\n      return this.request(function (error, response) {\r\n        var result;\r\n\r\n        if (!error) {\r\n          result = {\r\n            latlng: leaflet.latLng(response.location.y, response.location.x),\r\n            address: response.address\r\n          };\r\n        } else {\r\n          result = undefined;\r\n        }\r\n\r\n        callback.call(context, error, result, response);\r\n      }, this);\r\n    }\r\n  });\r\n\r\n  function reverseGeocode (options) {\r\n    return new ReverseGeocode(options);\r\n  }\n\n  var Suggest = esriLeaflet.Task.extend({\r\n    path: 'suggest',\r\n\r\n    params: {},\r\n\r\n    setters: {\r\n      text: 'text',\r\n      category: 'category',\r\n      countries: 'countryCode',\r\n      maxSuggestions: 'maxSuggestions'\r\n    },\r\n\r\n    initialize: function (options) {\r\n      options = options || {};\r\n      if (!options.url) {\r\n        options.url = WorldGeocodingServiceUrl;\r\n        options.supportsSuggest = true;\r\n      }\r\n      esriLeaflet.Task.prototype.initialize.call(this, options);\r\n    },\r\n\r\n    within: function (bounds) {\r\n      bounds = leaflet.latLngBounds(bounds);\r\n      bounds = bounds.pad(0.5);\r\n      var center = bounds.getCenter();\r\n      var ne = bounds.getNorthWest();\r\n      this.params.location = center.lng + ',' + center.lat;\r\n      this.params.distance = Math.min(Math.max(center.distanceTo(ne), 2000), 50000);\r\n      this.params.searchExtent = esriLeaflet.Util.boundsToExtent(bounds);\r\n      return this;\r\n    },\r\n\r\n    nearby: function (coords, radius) {\r\n      var centroid = leaflet.latLng(coords);\r\n      this.params.location = centroid.lng + ',' + centroid.lat;\r\n      if (radius) {\r\n        this.params.distance = Math.min(Math.max(radius, 2000), 50000);\r\n      }\r\n      return this;\r\n    },\r\n\r\n    run: function (callback, context) {\r\n      if (this.options.supportsSuggest) {\r\n        return this.request(function (error, response) {\r\n          callback.call(context, error, response, response);\r\n        }, this);\r\n      } else {\r\n        console.warn('this geocoding service does not support asking for suggestions');\r\n      }\r\n    }\r\n\r\n  });\r\n\r\n  function suggest (options) {\r\n    return new Suggest(options);\r\n  }\n\n  var GeocodeService = esriLeaflet.Service.extend({\r\n    initialize: function (options) {\r\n      options = options || {};\r\n      if (options.url) {\r\n        esriLeaflet.Service.prototype.initialize.call(this, options);\r\n        this._confirmSuggestSupport();\r\n      } else {\r\n        options.url = WorldGeocodingServiceUrl;\r\n        options.supportsSuggest = true;\r\n        esriLeaflet.Service.prototype.initialize.call(this, options);\r\n      }\r\n    },\r\n\r\n    geocode: function () {\r\n      return geocode(this);\r\n    },\r\n\r\n    reverse: function () {\r\n      return reverseGeocode(this);\r\n    },\r\n\r\n    suggest: function () {\r\n      // requires either the Esri World Geocoding Service or a <10.3 ArcGIS Server Geocoding Service that supports suggest.\r\n      return suggest(this);\r\n    },\r\n\r\n    _confirmSuggestSupport: function () {\r\n      this.metadata(function (error, response) {\r\n        if (error) { return; }\r\n        // pre 10.3 geocoding services dont list capabilities (and dont support maxLocations)\r\n        // only SOME individual services have been configured to support asking for suggestions\r\n        if (!response.capabilities) {\r\n          this.options.supportsSuggest = false;\r\n        } else if (response.capabilities.indexOf('Suggest') > -1) {\r\n          this.options.supportsSuggest = true;\r\n        } else {\r\n          this.options.supportsSuggest = false;\r\n        }\r\n        // whether the service supports suggest or not, utilize the metadata response to determine the appropriate parameter name for single line geocoding requests\r\n        this.options.customParam = response.singleLineAddressField.name;\r\n      }, this);\r\n    }\r\n  });\r\n\r\n  function geocodeService (options) {\r\n    return new GeocodeService(options);\r\n  }\n\n  var GeosearchCore = leaflet.Evented.extend({\r\n\r\n    options: {\r\n      zoomToResult: true,\r\n      useMapBounds: 12,\r\n      searchBounds: null\r\n    },\r\n\r\n    initialize: function (control, options) {\r\n      leaflet.Util.setOptions(this, options);\r\n      this._control = control;\r\n\r\n      if (!options || !options.providers || !options.providers.length) {\r\n        throw new Error('You must specify at least one provider');\r\n      }\r\n\r\n      this._providers = options.providers;\r\n    },\r\n\r\n    _geocode: function (text, key, provider) {\r\n      var activeRequests = 0;\r\n      var allResults = [];\r\n      var bounds;\r\n\r\n      var callback = leaflet.Util.bind(function (error, results) {\r\n        activeRequests--;\r\n        if (error) {\r\n          return;\r\n        }\r\n\r\n        if (results) {\r\n          allResults = allResults.concat(results);\r\n        }\r\n\r\n        if (activeRequests <= 0) {\r\n          bounds = this._boundsFromResults(allResults);\r\n\r\n          this.fire('results', {\r\n            results: allResults,\r\n            bounds: bounds,\r\n            latlng: (bounds) ? bounds.getCenter() : undefined,\r\n            text: text\r\n          }, true);\r\n\r\n          if (this.options.zoomToResult && bounds) {\r\n            this._control._map.fitBounds(bounds);\r\n          }\r\n\r\n          this.fire('load');\r\n        }\r\n      }, this);\r\n\r\n      if (key) {\r\n        activeRequests++;\r\n        provider.results(text, key, this._searchBounds(), callback);\r\n      } else {\r\n        for (var i = 0; i < this._providers.length; i++) {\r\n          activeRequests++;\r\n          this._providers[i].results(text, key, this._searchBounds(), callback);\r\n        }\r\n      }\r\n    },\r\n\r\n    _suggest: function (text) {\r\n      var activeRequests = this._providers.length;\r\n      var suggestionsLength = 0;\r\n\r\n      var createCallback = leaflet.Util.bind(function (text, provider) {\r\n        return leaflet.Util.bind(function (error, suggestions) {\r\n          activeRequests = activeRequests - 1;\r\n          suggestionsLength += suggestions.length;\r\n\r\n          if (error) {\r\n            // an error occurred for one of the providers' suggest requests\r\n            this._control._clearProviderSuggestions(provider);\r\n\r\n            // perform additional cleanup when all requests are finished\r\n            this._control._finalizeSuggestions(activeRequests, suggestionsLength);\r\n\r\n            return;\r\n          }\r\n\r\n          if (suggestions.length) {\r\n            for (var i = 0; i < suggestions.length; i++) {\r\n              suggestions[i].provider = provider;\r\n            }\r\n          } else {\r\n            // we still need to update the UI\r\n            this._control._renderSuggestions(suggestions);\r\n          }\r\n\r\n          if (provider._lastRender !== text) {\r\n            this._control._clearProviderSuggestions(provider);\r\n          }\r\n\r\n          if (suggestions.length && this._control._input.value === text) {\r\n            provider._lastRender = text;\r\n            this._control._renderSuggestions(suggestions);\r\n          }\r\n\r\n          // perform additional cleanup when all requests are finished\r\n          this._control._finalizeSuggestions(activeRequests, suggestionsLength);\r\n        }, this);\r\n      }, this);\r\n\r\n      this._pendingSuggestions = [];\r\n\r\n      for (var i = 0; i < this._providers.length; i++) {\r\n        var provider = this._providers[i];\r\n        var request = provider.suggestions(text, this._searchBounds(), createCallback(text, provider));\r\n        this._pendingSuggestions.push(request);\r\n      }\r\n    },\r\n\r\n    _searchBounds: function () {\r\n      if (this.options.searchBounds !== null) {\r\n        return this.options.searchBounds;\r\n      }\r\n\r\n      if (this.options.useMapBounds === false) {\r\n        return null;\r\n      }\r\n\r\n      if (this.options.useMapBounds === true) {\r\n        return this._control._map.getBounds();\r\n      }\r\n\r\n      if (this.options.useMapBounds <= this._control._map.getZoom()) {\r\n        return this._control._map.getBounds();\r\n      }\r\n\r\n      return null;\r\n    },\r\n\r\n    _boundsFromResults: function (results) {\r\n      if (!results.length) {\r\n        return;\r\n      }\r\n\r\n      var nullIsland = leaflet.latLngBounds([0, 0], [0, 0]);\r\n      var resultBounds = [];\r\n      var resultLatlngs = [];\r\n\r\n      // collect the bounds and center of each result\r\n      for (var i = results.length - 1; i >= 0; i--) {\r\n        var result = results[i];\r\n\r\n        resultLatlngs.push(result.latlng);\r\n\r\n        // make sure bounds are valid and not 0,0. sometimes bounds are incorrect or not present\r\n        if (result.bounds && result.bounds.isValid() && !result.bounds.equals(nullIsland)) {\r\n          resultBounds.push(result.bounds);\r\n        }\r\n      }\r\n\r\n      // form a bounds object containing all center points\r\n      var bounds = leaflet.latLngBounds(resultLatlngs);\r\n\r\n      // and extend it to contain all bounds objects\r\n      for (var j = 0; j < resultBounds.length; j++) {\r\n        bounds.extend(resultBounds[j]);\r\n      }\r\n\r\n      return bounds;\r\n    },\r\n\r\n    _getAttribution: function () {\r\n      var attribs = [];\r\n      var providers = this._providers;\r\n\r\n      for (var i = 0; i < providers.length; i++) {\r\n        if (providers[i].options.attribution) {\r\n          attribs.push(providers[i].options.attribution);\r\n        }\r\n      }\r\n\r\n      return attribs.join(', ');\r\n    }\r\n\r\n  });\r\n\r\n  function geosearchCore (control, options) {\r\n    return new GeosearchCore(control, options);\r\n  }\n\n  var ArcgisOnlineProvider = GeocodeService.extend({\r\n    options: {\r\n      label: 'Places and Addresses',\r\n      maxResults: 5\r\n    },\r\n\r\n    suggestions: function (text, bounds, callback) {\r\n      var request = this.suggest().text(text);\r\n\r\n      if (bounds) {\r\n        request.within(bounds);\r\n      }\r\n\r\n      if (this.options.nearby) {\r\n        // \"distance\"/\"radius\" is not supported by the ArcGIS Online Geocoder,\r\n        // so that is intentionally not passed here:\r\n        request.nearby(this.options.nearby);\r\n      }\r\n\r\n      if (this.options.countries) {\r\n        request.countries(this.options.countries);\r\n      }\r\n\r\n      if (this.options.categories) {\r\n        request.category(this.options.categories);\r\n      }\r\n\r\n      // 15 is the maximum number of suggestions that can be returned\r\n      request.maxSuggestions(this.options.maxResults);\r\n\r\n      return request.run(function (error, results, response) {\r\n        var suggestions = [];\r\n        if (!error) {\r\n          while (response.suggestions.length && suggestions.length <= (this.options.maxResults - 1)) {\r\n            var suggestion = response.suggestions.shift();\r\n            if (!suggestion.isCollection) {\r\n              suggestions.push({\r\n                text: suggestion.text,\r\n                unformattedText: suggestion.text,\r\n                magicKey: suggestion.magicKey\r\n              });\r\n            }\r\n          }\r\n        }\r\n        callback(error, suggestions);\r\n      }, this);\r\n    },\r\n\r\n    results: function (text, key, bounds, callback) {\r\n      var request = this.geocode().text(text);\r\n\r\n      if (key) {\r\n        request.key(key);\r\n      }\r\n      // in the future Address/StreetName geocoding requests that include a magicKey will always only return one match\r\n      request.maxLocations(this.options.maxResults);\r\n\r\n      if (bounds) {\r\n        request.within(bounds);\r\n      }\r\n\r\n      if (this.options.forStorage) {\r\n        request.forStorage(true);\r\n      }\r\n\r\n      if (this.options.nearby) {\r\n        // \"distance\"/\"radius\" is not supported by the ArcGIS Online Geocoder,\r\n        // so that is intentionally not passed here:\r\n        request.nearby(this.options.nearby);\r\n      }\r\n\r\n      if (this.options.countries) {\r\n        request.countries(this.options.countries);\r\n      }\r\n\r\n      if (this.options.categories) {\r\n        request.category(this.options.categories);\r\n      }\r\n\r\n      return request.run(function (error, response) {\r\n        callback(error, response.results);\r\n      }, this);\r\n    }\r\n  });\r\n\r\n  function arcgisOnlineProvider (options) {\r\n    return new ArcgisOnlineProvider(options);\r\n  }\n\n  var Geosearch = leaflet.Control.extend({\r\n    includes: leaflet.Evented.prototype,\r\n\r\n    options: {\r\n      position: 'topleft',\r\n      collapseAfterResult: true,\r\n      expanded: false,\r\n      allowMultipleResults: true,\r\n      placeholder: 'Search for places or addresses',\r\n      title: 'Location Search'\r\n    },\r\n\r\n    initialize: function (options) {\r\n      leaflet.Util.setOptions(this, options);\r\n\r\n      if (!options || !options.providers || !options.providers.length) {\r\n        if (!options) {\r\n          options = {};\r\n        }\r\n        options.providers = [ arcgisOnlineProvider() ];\r\n      }\r\n\r\n      // instantiate the underlying class and pass along options\r\n      this._geosearchCore = geosearchCore(this, options);\r\n      this._geosearchCore._providers = options.providers;\r\n\r\n      // bubble each providers events to the control\r\n      this._geosearchCore.addEventParent(this);\r\n      for (var i = 0; i < this._geosearchCore._providers.length; i++) {\r\n        this._geosearchCore._providers[i].addEventParent(this);\r\n      }\r\n\r\n      this._geosearchCore._pendingSuggestions = [];\r\n\r\n      leaflet.Control.prototype.initialize.call(this, options);\r\n    },\r\n\r\n    _renderSuggestions: function (suggestions) {\r\n      var currentGroup;\r\n\r\n      if (suggestions.length > 0) {\r\n        this._suggestions.style.display = 'block';\r\n      }\r\n\r\n      var list;\r\n      var header;\r\n      var suggestionTextArray = [];\r\n\r\n      for (var i = 0; i < suggestions.length; i++) {\r\n        var suggestion = suggestions[i];\r\n        if (!header && this._geosearchCore._providers.length > 1 && currentGroup !== suggestion.provider.options.label) {\r\n          header = leaflet.DomUtil.create('div', 'geocoder-control-header', suggestion.provider._contentsElement);\r\n          header.textContent = suggestion.provider.options.label;\r\n          header.innerText = suggestion.provider.options.label;\r\n          currentGroup = suggestion.provider.options.label;\r\n        }\r\n\r\n        if (!list) {\r\n          list = leaflet.DomUtil.create('ul', 'geocoder-control-list', suggestion.provider._contentsElement);\r\n        }\r\n\r\n        if (suggestionTextArray.indexOf(suggestion.text) === -1) {\r\n          var suggestionItem = leaflet.DomUtil.create('li', 'geocoder-control-suggestion', list);\r\n\r\n          suggestionItem.innerHTML = suggestion.text;\r\n          suggestionItem.provider = suggestion.provider;\r\n          suggestionItem['data-magic-key'] = suggestion.magicKey;\r\n          suggestionItem.unformattedText = suggestion.unformattedText;\r\n        } else {\r\n          for (var j = 0; j < list.childNodes.length; j++) {\r\n            // if the same text already appears in the list of suggestions, append an additional ObjectID to its magicKey instead\r\n            if (list.childNodes[j].innerHTML === suggestion.text) {\r\n              list.childNodes[j]['data-magic-key'] += ',' + suggestion.magicKey;\r\n            }\r\n          }\r\n        }\r\n        suggestionTextArray.push(suggestion.text);\r\n      }\r\n\r\n      // when the geocoder position is either \"topleft\" or \"topright\":\r\n      // set the maxHeight of the suggestions box to:\r\n      //  map height\r\n      //  - suggestions offset (distance from top of suggestions to top of control)\r\n      //  - control offset (distance from top of control to top of map)\r\n      //  - 10 (extra padding)\r\n      if (this.getPosition().indexOf('top') > -1) {\r\n        this._suggestions.style.maxHeight = (this._map.getSize().y - this._suggestions.offsetTop - this._wrapper.offsetTop - 10) + 'px';\r\n      }\r\n\r\n      // when the geocoder position is either \"bottomleft\" or \"bottomright\":\r\n      // 1. set the maxHeight of the suggestions box to:\r\n      //  map height\r\n      //  - corner control container offsetHeight (height of container of bottom corner)\r\n      //  - control offsetHeight (height of geocoder control wrapper, the main expandable button)\r\n      // 2. to move it up, set the top of the suggestions box to:\r\n      //  negative offsetHeight of suggestions box (its own negative height now that it has children elements\r\n      //  - control offsetHeight (height of geocoder control wrapper, the main expandable button)\r\n      //  + 20 (extra spacing)\r\n      if (this.getPosition().indexOf('bottom') > -1) {\r\n        this._setSuggestionsBottomPosition();\r\n      }\r\n    },\r\n\r\n    _setSuggestionsBottomPosition: function () {\r\n      this._suggestions.style.maxHeight = (this._map.getSize().y - this._map._controlCorners[this.getPosition()].offsetHeight - this._wrapper.offsetHeight) + 'px';\r\n      this._suggestions.style.top = (-this._suggestions.offsetHeight - this._wrapper.offsetHeight + 20) + 'px';\r\n    },\r\n\r\n    _boundsFromResults: function (results) {\r\n      if (!results.length) {\r\n        return;\r\n      }\r\n\r\n      var nullIsland = leaflet.latLngBounds([0, 0], [0, 0]);\r\n      var resultBounds = [];\r\n      var resultLatlngs = [];\r\n\r\n      // collect the bounds and center of each result\r\n      for (var i = results.length - 1; i >= 0; i--) {\r\n        var result = results[i];\r\n\r\n        resultLatlngs.push(result.latlng);\r\n\r\n        // make sure bounds are valid and not 0,0. sometimes bounds are incorrect or not present\r\n        if (result.bounds && result.bounds.isValid() && !result.bounds.equals(nullIsland)) {\r\n          resultBounds.push(result.bounds);\r\n        }\r\n      }\r\n\r\n      // form a bounds object containing all center points\r\n      var bounds = leaflet.latLngBounds(resultLatlngs);\r\n\r\n      // and extend it to contain all bounds objects\r\n      for (var j = 0; j < resultBounds.length; j++) {\r\n        bounds.extend(resultBounds[j]);\r\n      }\r\n\r\n      return bounds;\r\n    },\r\n\r\n    clear: function () {\r\n      this._clearAllSuggestions();\r\n\r\n      if (this.options.collapseAfterResult) {\r\n        this._input.value = '';\r\n        this._lastValue = '';\r\n        this._input.placeholder = '';\r\n        leaflet.DomUtil.removeClass(this._wrapper, 'geocoder-control-expanded');\r\n      }\r\n\r\n      if (!this._map.scrollWheelZoom.enabled() && this._map.options.scrollWheelZoom) {\r\n        this._map.scrollWheelZoom.enable();\r\n      }\r\n    },\r\n\r\n    _clearAllSuggestions: function () {\r\n      this._suggestions.style.display = 'none';\r\n\r\n      for (var i = 0; i < this.options.providers.length; i++) {\r\n        this._clearProviderSuggestions(this.options.providers[i]);\r\n      }\r\n    },\r\n\r\n    _clearProviderSuggestions: function (provider) {\r\n      provider._contentsElement.innerHTML = '';\r\n    },\r\n\r\n    _finalizeSuggestions: function (activeRequests, suggestionsLength) {\r\n      // check if all requests are finished to remove the loading indicator\r\n      if (!activeRequests) {\r\n        leaflet.DomUtil.removeClass(this._input, 'geocoder-control-loading');\r\n\r\n        // when the geocoder position is either \"bottomleft\" or \"bottomright\",\r\n        // it is necessary in some cases to recalculate the maxHeight and top values of the this._suggestions element,\r\n        // even though this is also being done after each provider returns their own suggestions\r\n        if (this.getPosition().indexOf('bottom') > -1) {\r\n          this._setSuggestionsBottomPosition();\r\n        }\r\n\r\n        // also check if there were 0 total suggest results to clear the parent suggestions element\r\n        // otherwise its display value may be \"block\" instead of \"none\"\r\n        if (!suggestionsLength) {\r\n          this._clearAllSuggestions();\r\n        }\r\n      }\r\n    },\r\n\r\n    _setupClick: function () {\r\n      leaflet.DomUtil.addClass(this._wrapper, 'geocoder-control-expanded');\r\n      this._input.focus();\r\n    },\r\n\r\n    disable: function () {\r\n      this._input.disabled = true;\r\n      leaflet.DomUtil.addClass(this._input, 'geocoder-control-input-disabled');\r\n      leaflet.DomEvent.removeListener(this._wrapper, 'click', this._setupClick, this);\r\n    },\r\n\r\n    enable: function () {\r\n      this._input.disabled = false;\r\n      leaflet.DomUtil.removeClass(this._input, 'geocoder-control-input-disabled');\r\n      leaflet.DomEvent.addListener(this._wrapper, 'click', this._setupClick, this);\r\n    },\r\n\r\n    getAttribution: function () {\r\n      var attribs = [];\r\n\r\n      for (var i = 0; i < this._providers.length; i++) {\r\n        if (this._providers[i].options.attribution) {\r\n          attribs.push(this._providers[i].options.attribution);\r\n        }\r\n      }\r\n\r\n      return attribs.join(', ');\r\n    },\r\n\r\n    geocodeSuggestion: function (e) {\r\n      var suggestionItem = e.target || e.srcElement;\r\n\r\n      if (\r\n        suggestionItem.classList.contains('geocoder-control-suggestions') ||\r\n        suggestionItem.classList.contains('geocoder-control-header')\r\n      ) {\r\n        return;\r\n      }\r\n\r\n      // make sure and point at the actual 'geocoder-control-suggestion'\r\n      if (suggestionItem.classList.length < 1) {\r\n        suggestionItem = suggestionItem.parentNode;\r\n      }\r\n\r\n      this._geosearchCore._geocode(suggestionItem.unformattedText, suggestionItem['data-magic-key'], suggestionItem.provider);\r\n      this.clear();\r\n    },\r\n\r\n    onAdd: function (map) {\r\n      // include 'Powered by Esri' in map attribution\r\n      esriLeaflet.Util.setEsriAttribution(map);\r\n\r\n      this._map = map;\r\n      this._wrapper = leaflet.DomUtil.create('div', 'geocoder-control');\r\n      this._input = leaflet.DomUtil.create('input', 'geocoder-control-input leaflet-bar', this._wrapper);\r\n      this._input.title = this.options.title;\r\n\r\n      if (this.options.expanded) {\r\n        leaflet.DomUtil.addClass(this._wrapper, 'geocoder-control-expanded');\r\n        this._input.placeholder = this.options.placeholder;\r\n      }\r\n\r\n      // create the main suggested results container element\r\n      this._suggestions = leaflet.DomUtil.create('div', 'geocoder-control-suggestions leaflet-bar', this._wrapper);\r\n\r\n      // create a child contents container element for each provider inside of this._suggestions\r\n      // to maintain the configured order of providers for suggested results\r\n      for (var i = 0; i < this.options.providers.length; i++) {\r\n        this.options.providers[i]._contentsElement = leaflet.DomUtil.create('div', null, this._suggestions);\r\n      }\r\n\r\n      var credits = this._geosearchCore._getAttribution();\r\n\r\n      if (map.attributionControl) {\r\n        map.attributionControl.addAttribution(credits);\r\n      }\r\n\r\n      leaflet.DomEvent.addListener(this._input, 'focus', function (e) {\r\n        this._input.placeholder = this.options.placeholder;\r\n        leaflet.DomUtil.addClass(this._wrapper, 'geocoder-control-expanded');\r\n      }, this);\r\n\r\n      leaflet.DomEvent.addListener(this._wrapper, 'click', this._setupClick, this);\r\n\r\n      // make sure both click and touch spawn an address/poi search\r\n      leaflet.DomEvent.addListener(this._suggestions, 'mousedown', this.geocodeSuggestion, this);\r\n\r\n      leaflet.DomEvent.addListener(this._input, 'blur', function (e) {\r\n        // TODO: this is too greedy and should not \"clear\"\r\n        // when trying to use the scrollbar or clicking on a non-suggestion item (such as a provider header)\r\n        this.clear();\r\n      }, this);\r\n\r\n      leaflet.DomEvent.addListener(this._input, 'keydown', function (e) {\r\n        var text = (e.target || e.srcElement).value;\r\n\r\n        leaflet.DomUtil.addClass(this._wrapper, 'geocoder-control-expanded');\r\n\r\n        var list = this._suggestions.querySelectorAll('.' + 'geocoder-control-suggestion');\r\n        var selected = this._suggestions.querySelectorAll('.' + 'geocoder-control-selected')[0];\r\n        var selectedPosition;\r\n\r\n        for (var i = 0; i < list.length; i++) {\r\n          if (list[i] === selected) {\r\n            selectedPosition = i;\r\n            break;\r\n          }\r\n        }\r\n\r\n        switch (e.keyCode) {\r\n          case 13:\r\n            /*\r\n              if an item has been selected, geocode it\r\n              if focus is on the input textbox, geocode only if multiple results are allowed and more than two characters are present, or if a single suggestion is displayed.\r\n              if less than two characters have been typed, abort the geocode\r\n            */\r\n            if (selected) {\r\n              this._input.value = selected.innerText;\r\n              this._geosearchCore._geocode(selected.unformattedText, selected['data-magic-key'], selected.provider);\r\n              this.clear();\r\n            } else if (this.options.allowMultipleResults && text.length >= 2) {\r\n              this._geosearchCore._geocode(this._input.value, undefined);\r\n              this.clear();\r\n            } else {\r\n              if (list.length === 1) {\r\n                leaflet.DomUtil.addClass(list[0], 'geocoder-control-selected');\r\n                this._geosearchCore._geocode(list[0].innerHTML, list[0]['data-magic-key'], list[0].provider);\r\n              } else {\r\n                this.clear();\r\n                this._input.blur();\r\n              }\r\n            }\r\n            leaflet.DomEvent.preventDefault(e);\r\n            break;\r\n          case 38:\r\n            if (selected) {\r\n              leaflet.DomUtil.removeClass(selected, 'geocoder-control-selected');\r\n            }\r\n\r\n            var previousItem = list[selectedPosition - 1];\r\n\r\n            if (selected && previousItem) {\r\n              leaflet.DomUtil.addClass(previousItem, 'geocoder-control-selected');\r\n            } else {\r\n              leaflet.DomUtil.addClass(list[list.length - 1], 'geocoder-control-selected');\r\n            }\r\n            leaflet.DomEvent.preventDefault(e);\r\n            break;\r\n          case 40:\r\n            if (selected) {\r\n              leaflet.DomUtil.removeClass(selected, 'geocoder-control-selected');\r\n            }\r\n\r\n            var nextItem = list[selectedPosition + 1];\r\n\r\n            if (selected && nextItem) {\r\n              leaflet.DomUtil.addClass(nextItem, 'geocoder-control-selected');\r\n            } else {\r\n              leaflet.DomUtil.addClass(list[0], 'geocoder-control-selected');\r\n            }\r\n            leaflet.DomEvent.preventDefault(e);\r\n            break;\r\n          default:\r\n            // when the input changes we should cancel all pending suggestion requests if possible to avoid result collisions\r\n            for (var x = 0; x < this._geosearchCore._pendingSuggestions.length; x++) {\r\n              var request = this._geosearchCore._pendingSuggestions[x];\r\n              if (request && request.abort && !request.id) {\r\n                request.abort();\r\n              }\r\n            }\r\n            break;\r\n        }\r\n      }, this);\r\n\r\n      leaflet.DomEvent.addListener(this._input, 'keyup', leaflet.Util.throttle(function (e) {\r\n        var key = e.which || e.keyCode;\r\n        var text = (e.target || e.srcElement).value;\r\n\r\n        // require at least 2 characters for suggestions\r\n        if (text.length < 2) {\r\n          this._lastValue = this._input.value;\r\n          this._clearAllSuggestions();\r\n          leaflet.DomUtil.removeClass(this._input, 'geocoder-control-loading');\r\n          return;\r\n        }\r\n\r\n        // if this is the escape key it will clear the input so clear suggestions\r\n        if (key === 27) {\r\n          this._clearAllSuggestions();\r\n          return;\r\n        }\r\n\r\n        // if this is NOT the up/down arrows or enter make a suggestion\r\n        if (key !== 13 && key !== 38 && key !== 40) {\r\n          if (this._input.value !== this._lastValue) {\r\n            this._lastValue = this._input.value;\r\n            leaflet.DomUtil.addClass(this._input, 'geocoder-control-loading');\r\n            this._geosearchCore._suggest(text);\r\n          }\r\n        }\r\n      }, 50, this), this);\r\n\r\n      leaflet.DomEvent.disableClickPropagation(this._wrapper);\r\n\r\n      // when mouse moves over suggestions disable scroll wheel zoom if its enabled\r\n      leaflet.DomEvent.addListener(this._suggestions, 'mouseover', function (e) {\r\n        if (map.scrollWheelZoom.enabled() && map.options.scrollWheelZoom) {\r\n          map.scrollWheelZoom.disable();\r\n        }\r\n      });\r\n\r\n      // when mouse moves leaves suggestions enable scroll wheel zoom if its disabled\r\n      leaflet.DomEvent.addListener(this._suggestions, 'mouseout', function (e) {\r\n        if (!map.scrollWheelZoom.enabled() && map.options.scrollWheelZoom) {\r\n          map.scrollWheelZoom.enable();\r\n        }\r\n      });\r\n\r\n      this._geosearchCore.on('load', function (e) {\r\n        leaflet.DomUtil.removeClass(this._input, 'geocoder-control-loading');\r\n        this.clear();\r\n        this._input.blur();\r\n      }, this);\r\n\r\n      return this._wrapper;\r\n    }\r\n  });\r\n\r\n  function geosearch (options) {\r\n    return new Geosearch(options);\r\n  }\n\n  var FeatureLayerProvider = esriLeaflet.FeatureLayerService.extend({\r\n    options: {\r\n      label: 'Feature Layer',\r\n      maxResults: 5,\r\n      bufferRadius: 1000,\r\n      searchMode: 'contain',\r\n      formatSuggestion: function (feature) {\r\n        return feature.properties[this.options.searchFields[0]];\r\n      }\r\n    },\r\n\r\n    initialize: function (options) {\r\n      esriLeaflet.FeatureLayerService.prototype.initialize.call(this, options);\r\n      if (typeof this.options.searchFields === 'string') {\r\n        this.options.searchFields = [this.options.searchFields];\r\n      }\r\n      this._suggestionsQuery = this.query();\r\n      this._resultsQuery = this.query();\r\n    },\r\n\r\n    suggestions: function (text, bounds, callback) {\r\n      var query = this._suggestionsQuery.where(this._buildQuery(text))\r\n        .returnGeometry(false);\r\n\r\n      if (bounds) {\r\n        query.intersects(bounds);\r\n      }\r\n\r\n      if (this.options.idField) {\r\n        query.fields([this.options.idField].concat(this.options.searchFields));\r\n      }\r\n\r\n      var request = query.run(function (error, results, raw) {\r\n        if (error) {\r\n          callback(error, []);\r\n        } else {\r\n          this.options.idField = raw.objectIdFieldName;\r\n          var suggestions = [];\r\n          for (var i = results.features.length - 1; i >= 0; i--) {\r\n            var feature = results.features[i];\r\n            suggestions.push({\r\n              text: this.options.formatSuggestion.call(this, feature),\r\n              unformattedText: feature.properties[this.options.searchFields[0]],\r\n              magicKey: feature.id\r\n            });\r\n          }\r\n          callback(error, suggestions.slice(0, this.options.maxResults));\r\n        }\r\n      }, this);\r\n\r\n      return request;\r\n    },\r\n\r\n    results: function (text, key, bounds, callback) {\r\n      var query = this._resultsQuery;\r\n\r\n      if (key) {\r\n        // if there are 1 or more keys available, use query.featureIds()\r\n        delete query.params.where;\r\n        query.featureIds([key]);\r\n      } else {\r\n        // if there are no keys available, use query.where()\r\n        query.where(this._buildQuery(text));\r\n      }\r\n\r\n      if (bounds) {\r\n        query.within(bounds);\r\n      }\r\n\r\n      return query.run(leaflet.Util.bind(function (error, features) {\r\n        var results = [];\r\n        for (var i = 0; i < features.features.length; i++) {\r\n          var feature = features.features[i];\r\n          if (feature) {\r\n            var bounds = this._featureBounds(feature);\r\n\r\n            var result = {\r\n              latlng: bounds.getCenter(),\r\n              bounds: bounds,\r\n              text: this.options.formatSuggestion.call(this, feature),\r\n              properties: feature.properties,\r\n              geojson: feature\r\n            };\r\n\r\n            results.push(result);\r\n\r\n            // clear query parameters for the next search\r\n            delete this._resultsQuery.params['objectIds'];\r\n          }\r\n        }\r\n        callback(error, results);\r\n      }, this));\r\n    },\r\n\r\n    orderBy: function (fieldName, order) {\r\n      this._suggestionsQuery.orderBy(fieldName, order);\r\n    },\r\n\r\n    _buildQuery: function (text) {\r\n      var queryString = [];\r\n\r\n      for (var i = this.options.searchFields.length - 1; i >= 0; i--) {\r\n        var field = 'upper(\"' + this.options.searchFields[i] + '\")';\r\n        if (this.options.searchMode === 'contain') {\r\n          queryString.push(field + \" LIKE upper('%\" + text + \"%')\");\r\n        } else if (this.options.searchMode === 'startWith') {\r\n          queryString.push(field + \" LIKE upper('\" + text + \"%')\");\r\n        } else if (this.options.searchMode === 'endWith') {\r\n          queryString.push(field + \" LIKE upper('%\" + text + \"')\");\r\n        } else if (this.options.searchMode === 'strict') {\r\n          queryString.push(field + \" LIKE upper('\" + text + \"')\");\r\n        } else {\r\n          throw new Error('L.esri.Geocoding.featureLayerProvider: Invalid parameter for \"searchMode\". Use one of \"contain\", \"startWith\", \"endWith\", or \"strict\"');\r\n        }\r\n      }\r\n      if (this.options.where) {\r\n        return this.options.where + ' AND (' + queryString.join(' OR ') + ')';\r\n      } else {\r\n        return queryString.join(' OR ');\r\n      }\r\n    },\r\n\r\n    _featureBounds: function (feature) {\r\n      var geojson = leaflet.geoJson(feature);\r\n      if (feature.geometry.type === 'Point') {\r\n        var center = geojson.getBounds().getCenter();\r\n        var lngRadius = ((this.options.bufferRadius / 40075017) * 360) / Math.cos((180 / Math.PI) * center.lat);\r\n        var latRadius = (this.options.bufferRadius / 40075017) * 360;\r\n        return leaflet.latLngBounds([center.lat - latRadius, center.lng - lngRadius], [center.lat + latRadius, center.lng + lngRadius]);\r\n      } else {\r\n        return geojson.getBounds();\r\n      }\r\n    }\r\n  });\r\n\r\n  function featureLayerProvider (options) {\r\n    return new FeatureLayerProvider(options);\r\n  }\n\n  var MapServiceProvider = esriLeaflet.MapService.extend({\r\n    options: {\r\n      layers: [0],\r\n      label: 'Map Service',\r\n      bufferRadius: 1000,\r\n      maxResults: 5,\r\n      formatSuggestion: function (feature) {\r\n        return feature.properties[feature.displayFieldName] + ' <small>' + feature.layerName + '</small>';\r\n      }\r\n    },\r\n\r\n    initialize: function (options) {\r\n      esriLeaflet.MapService.prototype.initialize.call(this, options);\r\n      this._getIdFields();\r\n    },\r\n\r\n    suggestions: function (text, bounds, callback) {\r\n      var request = this.find().text(text).fields(this.options.searchFields).returnGeometry(false).layers(this.options.layers);\r\n\r\n      return request.run(function (error, results, raw) {\r\n        var suggestions = [];\r\n        if (!error) {\r\n          var count = Math.min(this.options.maxResults, results.features.length);\r\n          raw.results = raw.results.reverse();\r\n          for (var i = 0; i < count; i++) {\r\n            var feature = results.features[i];\r\n            var result = raw.results[i];\r\n            var layer = result.layerId;\r\n            var idField = this._idFields[layer];\r\n            feature.layerId = layer;\r\n            feature.layerName = this._layerNames[layer];\r\n            feature.displayFieldName = this._displayFields[layer];\r\n            if (idField) {\r\n              suggestions.push({\r\n                text: this.options.formatSuggestion.call(this, feature),\r\n                unformattedText: feature.properties[feature.displayFieldName],\r\n                magicKey: result.attributes[idField] + ':' + layer\r\n              });\r\n            }\r\n          }\r\n        }\r\n        callback(error, suggestions.reverse());\r\n      }, this);\r\n    },\r\n\r\n    results: function (text, key, bounds, callback) {\r\n      var results = [];\r\n      var request;\r\n\r\n      if (key && !key.includes(',')) {\r\n        // if there is only 1 key available, use query()\r\n        var featureId = key.split(':')[0];\r\n        var layer = key.split(':')[1];\r\n        request = this.query().layer(layer).featureIds(featureId);\r\n      } else {\r\n        // if there are no keys or more than 1 keys available, use find()\r\n        request = this.find().text(text).fields(this.options.searchFields).layers(this.options.layers);\r\n      }\r\n\r\n      return request.run(function (error, features, response) {\r\n        if (!error) {\r\n          if (response.results) {\r\n            response.results = response.results.reverse();\r\n          }\r\n          for (var i = 0; i < features.features.length; i++) {\r\n            var feature = features.features[i];\r\n            layer = layer || response.results[i].layerId;\r\n\r\n            if (feature && layer !== undefined) {\r\n              var bounds = this._featureBounds(feature);\r\n              feature.layerId = layer;\r\n              feature.layerName = this._layerNames[layer];\r\n              feature.displayFieldName = this._displayFields[layer];\r\n\r\n              var result = {\r\n                latlng: bounds.getCenter(),\r\n                bounds: bounds,\r\n                text: this.options.formatSuggestion.call(this, feature),\r\n                properties: feature.properties,\r\n                geojson: feature\r\n              };\r\n\r\n              results.push(result);\r\n            }\r\n          }\r\n        }\r\n        callback(error, results.reverse());\r\n      }, this);\r\n    },\r\n\r\n    _featureBounds: function (feature) {\r\n      var geojson = leaflet.geoJson(feature);\r\n      if (feature.geometry.type === 'Point') {\r\n        var center = geojson.getBounds().getCenter();\r\n        var lngRadius = ((this.options.bufferRadius / 40075017) * 360) / Math.cos((180 / Math.PI) * center.lat);\r\n        var latRadius = (this.options.bufferRadius / 40075017) * 360;\r\n        return leaflet.latLngBounds([center.lat - latRadius, center.lng - lngRadius], [center.lat + latRadius, center.lng + lngRadius]);\r\n      } else {\r\n        return geojson.getBounds();\r\n      }\r\n    },\r\n\r\n    _layerMetadataCallback: function (layerid) {\r\n      return leaflet.Util.bind(function (error, metadata) {\r\n        if (error) { return; }\r\n        this._displayFields[layerid] = metadata.displayField;\r\n        this._layerNames[layerid] = metadata.name;\r\n        for (var i = 0; i < metadata.fields.length; i++) {\r\n          var field = metadata.fields[i];\r\n          if (field.type === 'esriFieldTypeOID') {\r\n            this._idFields[layerid] = field.name;\r\n            break;\r\n          }\r\n        }\r\n      }, this);\r\n    },\r\n\r\n    _getIdFields: function () {\r\n      this._idFields = {};\r\n      this._displayFields = {};\r\n      this._layerNames = {};\r\n      for (var i = 0; i < this.options.layers.length; i++) {\r\n        var layer = this.options.layers[i];\r\n        this.get(layer, {}, this._layerMetadataCallback(layer));\r\n      }\r\n    }\r\n  });\r\n\r\n  function mapServiceProvider (options) {\r\n    return new MapServiceProvider(options);\r\n  }\n\n  var GeocodeServiceProvider = GeocodeService.extend({\r\n    options: {\r\n      label: 'Geocode Server',\r\n      maxResults: 5\r\n    },\r\n\r\n    suggestions: function (text, bounds, callback) {\r\n      if (this.options.supportsSuggest) {\r\n        var request = this.suggest().text(text);\r\n        if (bounds) {\r\n          request.within(bounds);\r\n        }\r\n\r\n        return request.run(function (error, results, response) {\r\n          var suggestions = [];\r\n          if (!error) {\r\n            while (response.suggestions.length && suggestions.length <= (this.options.maxResults - 1)) {\r\n              var suggestion = response.suggestions.shift();\r\n              if (!suggestion.isCollection) {\r\n                suggestions.push({\r\n                  text: suggestion.text,\r\n                  unformattedText: suggestion.text,\r\n                  magicKey: suggestion.magicKey\r\n                });\r\n              }\r\n            }\r\n          }\r\n          callback(error, suggestions);\r\n        }, this);\r\n      } else {\r\n        callback(undefined, []);\r\n        return false;\r\n      }\r\n    },\r\n\r\n    results: function (text, key, bounds, callback) {\r\n      var request = this.geocode().text(text);\r\n\r\n      if (key) {\r\n        request.key(key);\r\n      }\r\n\r\n      request.maxLocations(this.options.maxResults);\r\n\r\n      if (bounds) {\r\n        request.within(bounds);\r\n      }\r\n\r\n      return request.run(function (error, response) {\r\n        callback(error, response.results);\r\n      }, this);\r\n    }\r\n  });\r\n\r\n  function geocodeServiceProvider (options) {\r\n    return new GeocodeServiceProvider(options);\r\n  }\n\n  exports.ArcgisOnlineProvider = ArcgisOnlineProvider;\n  exports.FeatureLayerProvider = FeatureLayerProvider;\n  exports.Geocode = Geocode;\n  exports.GeocodeService = GeocodeService;\n  exports.GeocodeServiceProvider = GeocodeServiceProvider;\n  exports.Geosearch = Geosearch;\n  exports.GeosearchCore = GeosearchCore;\n  exports.MapServiceProvider = MapServiceProvider;\n  exports.ReverseGeocode = ReverseGeocode;\n  exports.Suggest = Suggest;\n  exports.VERSION = version;\n  exports.WorldGeocodingServiceUrl = WorldGeocodingServiceUrl;\n  exports.arcgisOnlineProvider = arcgisOnlineProvider;\n  exports.featureLayerProvider = featureLayerProvider;\n  exports.geocode = geocode;\n  exports.geocodeService = geocodeService;\n  exports.geocodeServiceProvider = geocodeServiceProvider;\n  exports.geosearch = geosearch;\n  exports.geosearchCore = geosearchCore;\n  exports.mapServiceProvider = mapServiceProvider;\n  exports.reverseGeocode = reverseGeocode;\n  exports.suggest = suggest;\n\n  Object.defineProperty(exports, '__esModule', { value: true });\n\n})));\n//# sourceMappingURL=esri-leaflet-geocoder-debug.js.map\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///./node_modules/esri-leaflet-geocoder/dist/esri-leaflet-geocoder-debug.js\n");

/***/ }),

/***/ "./node_modules/esri-leaflet/package.json":
/*!************************************************!*\
  !*** ./node_modules/esri-leaflet/package.json ***!
  \************************************************/
/*! exports provided: _from, _id, _inBundle, _integrity, _location, _phantomChildren, _requested, _requiredBy, _resolved, _shasum, _spec, _where, author, bugs, bundleDependencies, contributors, dependencies, deprecated, description, devDependencies, files, homepage, jsnext:main, jspm, keywords, license, main, module, name, peerDependencies, repository, scripts, semistandard, unpkg, version, default */
/***/ (function(module) {

eval("module.exports = JSON.parse(\"{\\\"_from\\\":\\\"esri-leaflet@2.5.3\\\",\\\"_id\\\":\\\"esri-leaflet@2.5.3\\\",\\\"_inBundle\\\":false,\\\"_integrity\\\":\\\"sha512-zapunrhhhKyiVP5NCSfFjD7YqWYYYD3OONVjBFWZgX2KbD6ssUQ3KnXVo2U0hswWfJDIoHF7g9PLZ4rDNuQnvA==\\\",\\\"_location\\\":\\\"/esri-leaflet\\\",\\\"_phantomChildren\\\":{},\\\"_requested\\\":{\\\"type\\\":\\\"version\\\",\\\"registry\\\":true,\\\"raw\\\":\\\"esri-leaflet@2.5.3\\\",\\\"name\\\":\\\"esri-leaflet\\\",\\\"escapedName\\\":\\\"esri-leaflet\\\",\\\"rawSpec\\\":\\\"2.5.3\\\",\\\"saveSpec\\\":null,\\\"fetchSpec\\\":\\\"2.5.3\\\"},\\\"_requiredBy\\\":[\\\"#USER\\\",\\\"/\\\",\\\"/esri-leaflet-geocoder\\\"],\\\"_resolved\\\":\\\"https://registry.npmjs.org/esri-leaflet/-/esri-leaflet-2.5.3.tgz\\\",\\\"_shasum\\\":\\\"ccf0c7463c7f9b6dfe27aab478740c3dbd8fe25b\\\",\\\"_spec\\\":\\\"esri-leaflet@2.5.3\\\",\\\"_where\\\":\\\"C:\\\\\\\\wamp64\\\\\\\\www\\\\\\\\keenthemes\\\\\\\\themes\\\\\\\\metronic\\\\\\\\theme\\\\\\\\html_laravel\\\\\\\\demo1\\\\\\\\skeleton\\\",\\\"author\\\":{\\\"name\\\":\\\"Patrick Arlt\\\",\\\"email\\\":\\\"parlt@esri.com\\\",\\\"url\\\":\\\"http://patrickarlt.com\\\"},\\\"bugs\\\":{\\\"url\\\":\\\"https://github.com/esri/esri-leaflet/issues\\\"},\\\"bundleDependencies\\\":false,\\\"contributors\\\":[{\\\"name\\\":\\\"Patrick Arlt\\\",\\\"email\\\":\\\"parlt@esri.com\\\",\\\"url\\\":\\\"http://patrickarlt.com\\\"},{\\\"name\\\":\\\"John Gravois\\\",\\\"email\\\":\\\"jgravois@esri.com\\\",\\\"url\\\":\\\"http://johngravois.com\\\"}],\\\"dependencies\\\":{\\\"@terraformer/arcgis\\\":\\\"^2.0.7\\\",\\\"tiny-binary-search\\\":\\\"^1.0.3\\\"},\\\"deprecated\\\":false,\\\"description\\\":\\\"Leaflet plugins for consuming ArcGIS Online and ArcGIS Server services.\\\",\\\"devDependencies\\\":{\\\"@rollup/plugin-json\\\":\\\"^4.0.3\\\",\\\"@rollup/plugin-node-resolve\\\":\\\"^7.1.3\\\",\\\"chai\\\":\\\"4.2.0\\\",\\\"gh-release\\\":\\\"^4.0.3\\\",\\\"highlight.js\\\":\\\"^9.12.0\\\",\\\"http-server\\\":\\\"^0.12.3\\\",\\\"husky\\\":\\\"^1.1.1\\\",\\\"istanbul\\\":\\\"^0.4.5\\\",\\\"karma\\\":\\\"^5.2.3\\\",\\\"karma-chai-sinon\\\":\\\"^0.1.5\\\",\\\"karma-chrome-launcher\\\":\\\"^2.2.0\\\",\\\"karma-coverage\\\":\\\"^1.1.2\\\",\\\"karma-mocha\\\":\\\"^2.0.1\\\",\\\"karma-mocha-reporter\\\":\\\"^2.2.5\\\",\\\"karma-sourcemap-loader\\\":\\\"^0.3.7\\\",\\\"leaflet\\\":\\\"^1.6.0\\\",\\\"mkdirp\\\":\\\"^0.5.1\\\",\\\"mocha\\\":\\\"^8.1.3\\\",\\\"npm-run-all\\\":\\\"^4.0.2\\\",\\\"rollup\\\":\\\"^2.0.0\\\",\\\"rollup-plugin-uglify\\\":\\\"^6.0.4\\\",\\\"semistandard\\\":\\\"^9.0.0\\\",\\\"sinon\\\":\\\"^6.3.5\\\",\\\"sinon-chai\\\":\\\"3.2.0\\\",\\\"snazzy\\\":\\\"^8.0.0\\\",\\\"uglify-js\\\":\\\"^2.8.29\\\",\\\"watch\\\":\\\"^1.0.2\\\"},\\\"files\\\":[\\\"src/**/*.js\\\",\\\"dist/esri-leaflet.js\\\",\\\"dist/esri-leaflet.js.map\\\",\\\"dist/esri-leaflet-debug.js.map\\\",\\\"profiles/*.js\\\"],\\\"homepage\\\":\\\"http://esri.github.io/esri-leaflet\\\",\\\"jsnext:main\\\":\\\"src/EsriLeaflet.js\\\",\\\"jspm\\\":{\\\"registry\\\":\\\"npm\\\",\\\"format\\\":\\\"es6\\\",\\\"main\\\":\\\"src/EsriLeaflet.js\\\"},\\\"keywords\\\":[\\\"arcgis\\\",\\\"esri\\\",\\\"esri leaflet\\\",\\\"gis\\\",\\\"leaflet plugin\\\",\\\"mapping\\\"],\\\"license\\\":\\\"Apache-2.0\\\",\\\"main\\\":\\\"dist/esri-leaflet-debug.js\\\",\\\"module\\\":\\\"src/EsriLeaflet.js\\\",\\\"name\\\":\\\"esri-leaflet\\\",\\\"peerDependencies\\\":{\\\"leaflet\\\":\\\"^1.0.0\\\"},\\\"repository\\\":{\\\"type\\\":\\\"git\\\",\\\"url\\\":\\\"git+ssh://git@github.com/Esri/esri-leaflet.git\\\"},\\\"scripts\\\":{\\\"build\\\":\\\"rollup -c profiles/debug.js & rollup -c profiles/production.js\\\",\\\"fix\\\":\\\"semistandard --fix\\\",\\\"lint\\\":\\\"semistandard | snazzy\\\",\\\"prebuild\\\":\\\"mkdirp dist\\\",\\\"precommit\\\":\\\"npm run lint\\\",\\\"prepare\\\":\\\"npm run build\\\",\\\"pretest\\\":\\\"npm run build\\\",\\\"release\\\":\\\"./scripts/release.sh\\\",\\\"serve\\\":\\\"http-server -p 5000 -c-1 -o\\\",\\\"start\\\":\\\"run-p start-watch serve\\\",\\\"start-watch\\\":\\\"watch \\\\\\\"npm run build\\\\\\\" src\\\",\\\"test\\\":\\\"npm run lint && karma start\\\",\\\"test:ci\\\":\\\"npm run lint && karma start --browsers Chrome_travis_ci\\\"},\\\"semistandard\\\":{\\\"globals\\\":[\\\"expect\\\",\\\"L\\\",\\\"XMLHttpRequest\\\",\\\"sinon\\\",\\\"xhr\\\",\\\"proj4\\\"]},\\\"unpkg\\\":\\\"dist/esri-leaflet-debug.js\\\",\\\"version\\\":\\\"2.5.3\\\"}\");//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6IiIsImZpbGUiOiIuL25vZGVfbW9kdWxlcy9lc3JpLWxlYWZsZXQvcGFja2FnZS5qc29uLmpzIiwic291cmNlUm9vdCI6IiJ9\n//# sourceURL=webpack-internal:///./node_modules/esri-leaflet/package.json\n");

/***/ }),

/***/ "./node_modules/esri-leaflet/src/EsriLeaflet.js":
/*!******************************************************!*\
  !*** ./node_modules/esri-leaflet/src/EsriLeaflet.js ***!
  \******************************************************/
/*! exports provided: VERSION, Support, options, Util, get, post, request, Task, task, Query, query, Find, find, Identify, identify, IdentifyFeatures, identifyFeatures, IdentifyImage, identifyImage, Service, service, MapService, mapService, ImageService, imageService, FeatureLayerService, featureLayerService, BasemapLayer, basemapLayer, TiledMapLayer, tiledMapLayer, RasterLayer, ImageMapLayer, imageMapLayer, DynamicMapLayer, dynamicMapLayer, FeatureManager, FeatureLayer, featureLayer */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony import */ var _package_json__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../package.json */ \"./node_modules/esri-leaflet/package.json\");\nvar _package_json__WEBPACK_IMPORTED_MODULE_0___namespace = /*#__PURE__*/__webpack_require__.t(/*! ../package.json */ \"./node_modules/esri-leaflet/package.json\", 1);\n/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, \"VERSION\", function() { return _package_json__WEBPACK_IMPORTED_MODULE_0__[\"version\"]; });\n\n/* harmony import */ var _Support__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./Support */ \"./node_modules/esri-leaflet/src/Support.js\");\n/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, \"Support\", function() { return _Support__WEBPACK_IMPORTED_MODULE_1__[\"Support\"]; });\n\n/* harmony import */ var _Options__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./Options */ \"./node_modules/esri-leaflet/src/Options.js\");\n/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, \"options\", function() { return _Options__WEBPACK_IMPORTED_MODULE_2__[\"options\"]; });\n\n/* harmony import */ var _Util__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./Util */ \"./node_modules/esri-leaflet/src/Util.js\");\n/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, \"Util\", function() { return _Util__WEBPACK_IMPORTED_MODULE_3__[\"EsriUtil\"]; });\n\n/* harmony import */ var _Request__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./Request */ \"./node_modules/esri-leaflet/src/Request.js\");\n/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, \"get\", function() { return _Request__WEBPACK_IMPORTED_MODULE_4__[\"get\"]; });\n\n/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, \"post\", function() { return _Request__WEBPACK_IMPORTED_MODULE_4__[\"post\"]; });\n\n/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, \"request\", function() { return _Request__WEBPACK_IMPORTED_MODULE_4__[\"request\"]; });\n\n/* harmony import */ var _Tasks_Task__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./Tasks/Task */ \"./node_modules/esri-leaflet/src/Tasks/Task.js\");\n/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, \"Task\", function() { return _Tasks_Task__WEBPACK_IMPORTED_MODULE_5__[\"Task\"]; });\n\n/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, \"task\", function() { return _Tasks_Task__WEBPACK_IMPORTED_MODULE_5__[\"task\"]; });\n\n/* harmony import */ var _Tasks_Query__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./Tasks/Query */ \"./node_modules/esri-leaflet/src/Tasks/Query.js\");\n/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, \"Query\", function() { return _Tasks_Query__WEBPACK_IMPORTED_MODULE_6__[\"Query\"]; });\n\n/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, \"query\", function() { return _Tasks_Query__WEBPACK_IMPORTED_MODULE_6__[\"query\"]; });\n\n/* harmony import */ var _Tasks_Find__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./Tasks/Find */ \"./node_modules/esri-leaflet/src/Tasks/Find.js\");\n/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, \"Find\", function() { return _Tasks_Find__WEBPACK_IMPORTED_MODULE_7__[\"Find\"]; });\n\n/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, \"find\", function() { return _Tasks_Find__WEBPACK_IMPORTED_MODULE_7__[\"find\"]; });\n\n/* harmony import */ var _Tasks_Identify__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ./Tasks/Identify */ \"./node_modules/esri-leaflet/src/Tasks/Identify.js\");\n/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, \"Identify\", function() { return _Tasks_Identify__WEBPACK_IMPORTED_MODULE_8__[\"Identify\"]; });\n\n/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, \"identify\", function() { return _Tasks_Identify__WEBPACK_IMPORTED_MODULE_8__[\"identify\"]; });\n\n/* harmony import */ var _Tasks_IdentifyFeatures__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ./Tasks/IdentifyFeatures */ \"./node_modules/esri-leaflet/src/Tasks/IdentifyFeatures.js\");\n/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, \"IdentifyFeatures\", function() { return _Tasks_IdentifyFeatures__WEBPACK_IMPORTED_MODULE_9__[\"IdentifyFeatures\"]; });\n\n/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, \"identifyFeatures\", function() { return _Tasks_IdentifyFeatures__WEBPACK_IMPORTED_MODULE_9__[\"identifyFeatures\"]; });\n\n/* harmony import */ var _Tasks_IdentifyImage__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ./Tasks/IdentifyImage */ \"./node_modules/esri-leaflet/src/Tasks/IdentifyImage.js\");\n/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, \"IdentifyImage\", function() { return _Tasks_IdentifyImage__WEBPACK_IMPORTED_MODULE_10__[\"IdentifyImage\"]; });\n\n/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, \"identifyImage\", function() { return _Tasks_IdentifyImage__WEBPACK_IMPORTED_MODULE_10__[\"identifyImage\"]; });\n\n/* harmony import */ var _Services_Service__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ./Services/Service */ \"./node_modules/esri-leaflet/src/Services/Service.js\");\n/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, \"Service\", function() { return _Services_Service__WEBPACK_IMPORTED_MODULE_11__[\"Service\"]; });\n\n/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, \"service\", function() { return _Services_Service__WEBPACK_IMPORTED_MODULE_11__[\"service\"]; });\n\n/* harmony import */ var _Services_MapService__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ./Services/MapService */ \"./node_modules/esri-leaflet/src/Services/MapService.js\");\n/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, \"MapService\", function() { return _Services_MapService__WEBPACK_IMPORTED_MODULE_12__[\"MapService\"]; });\n\n/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, \"mapService\", function() { return _Services_MapService__WEBPACK_IMPORTED_MODULE_12__[\"mapService\"]; });\n\n/* harmony import */ var _Services_ImageService__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! ./Services/ImageService */ \"./node_modules/esri-leaflet/src/Services/ImageService.js\");\n/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, \"ImageService\", function() { return _Services_ImageService__WEBPACK_IMPORTED_MODULE_13__[\"ImageService\"]; });\n\n/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, \"imageService\", function() { return _Services_ImageService__WEBPACK_IMPORTED_MODULE_13__[\"imageService\"]; });\n\n/* harmony import */ var _Services_FeatureLayerService__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! ./Services/FeatureLayerService */ \"./node_modules/esri-leaflet/src/Services/FeatureLayerService.js\");\n/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, \"FeatureLayerService\", function() { return _Services_FeatureLayerService__WEBPACK_IMPORTED_MODULE_14__[\"FeatureLayerService\"]; });\n\n/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, \"featureLayerService\", function() { return _Services_FeatureLayerService__WEBPACK_IMPORTED_MODULE_14__[\"featureLayerService\"]; });\n\n/* harmony import */ var _Layers_BasemapLayer__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! ./Layers/BasemapLayer */ \"./node_modules/esri-leaflet/src/Layers/BasemapLayer.js\");\n/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, \"BasemapLayer\", function() { return _Layers_BasemapLayer__WEBPACK_IMPORTED_MODULE_15__[\"BasemapLayer\"]; });\n\n/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, \"basemapLayer\", function() { return _Layers_BasemapLayer__WEBPACK_IMPORTED_MODULE_15__[\"basemapLayer\"]; });\n\n/* harmony import */ var _Layers_TiledMapLayer__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! ./Layers/TiledMapLayer */ \"./node_modules/esri-leaflet/src/Layers/TiledMapLayer.js\");\n/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, \"TiledMapLayer\", function() { return _Layers_TiledMapLayer__WEBPACK_IMPORTED_MODULE_16__[\"TiledMapLayer\"]; });\n\n/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, \"tiledMapLayer\", function() { return _Layers_TiledMapLayer__WEBPACK_IMPORTED_MODULE_16__[\"tiledMapLayer\"]; });\n\n/* harmony import */ var _Layers_RasterLayer__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(/*! ./Layers/RasterLayer */ \"./node_modules/esri-leaflet/src/Layers/RasterLayer.js\");\n/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, \"RasterLayer\", function() { return _Layers_RasterLayer__WEBPACK_IMPORTED_MODULE_17__[\"RasterLayer\"]; });\n\n/* harmony import */ var _Layers_ImageMapLayer__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(/*! ./Layers/ImageMapLayer */ \"./node_modules/esri-leaflet/src/Layers/ImageMapLayer.js\");\n/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, \"ImageMapLayer\", function() { return _Layers_ImageMapLayer__WEBPACK_IMPORTED_MODULE_18__[\"ImageMapLayer\"]; });\n\n/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, \"imageMapLayer\", function() { return _Layers_ImageMapLayer__WEBPACK_IMPORTED_MODULE_18__[\"imageMapLayer\"]; });\n\n/* harmony import */ var _Layers_DynamicMapLayer__WEBPACK_IMPORTED_MODULE_19__ = __webpack_require__(/*! ./Layers/DynamicMapLayer */ \"./node_modules/esri-leaflet/src/Layers/DynamicMapLayer.js\");\n/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, \"DynamicMapLayer\", function() { return _Layers_DynamicMapLayer__WEBPACK_IMPORTED_MODULE_19__[\"DynamicMapLayer\"]; });\n\n/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, \"dynamicMapLayer\", function() { return _Layers_DynamicMapLayer__WEBPACK_IMPORTED_MODULE_19__[\"dynamicMapLayer\"]; });\n\n/* harmony import */ var _Layers_FeatureLayer_FeatureManager__WEBPACK_IMPORTED_MODULE_20__ = __webpack_require__(/*! ./Layers/FeatureLayer/FeatureManager */ \"./node_modules/esri-leaflet/src/Layers/FeatureLayer/FeatureManager.js\");\n/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, \"FeatureManager\", function() { return _Layers_FeatureLayer_FeatureManager__WEBPACK_IMPORTED_MODULE_20__[\"FeatureManager\"]; });\n\n/* harmony import */ var _Layers_FeatureLayer_FeatureLayer__WEBPACK_IMPORTED_MODULE_21__ = __webpack_require__(/*! ./Layers/FeatureLayer/FeatureLayer */ \"./node_modules/esri-leaflet/src/Layers/FeatureLayer/FeatureLayer.js\");\n/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, \"FeatureLayer\", function() { return _Layers_FeatureLayer_FeatureLayer__WEBPACK_IMPORTED_MODULE_21__[\"FeatureLayer\"]; });\n\n/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, \"featureLayer\", function() { return _Layers_FeatureLayer_FeatureLayer__WEBPACK_IMPORTED_MODULE_21__[\"featureLayer\"]; });\n\n// export version\r\n\r\n\r\n// import base\r\n\r\n\r\n\r\n\r\n\r\n// export tasks\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n// export services\r\n\r\n\r\n\r\n\r\n\r\n// export layers\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///./node_modules/esri-leaflet/src/EsriLeaflet.js\n");

/***/ }),

/***/ "./node_modules/esri-leaflet/src/Layers/BasemapLayer.js":
/*!**************************************************************!*\
  !*** ./node_modules/esri-leaflet/src/Layers/BasemapLayer.js ***!
  \**************************************************************/
/*! exports provided: BasemapLayer, basemapLayer, default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"BasemapLayer\", function() { return BasemapLayer; });\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"basemapLayer\", function() { return basemapLayer; });\n/* harmony import */ var leaflet__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! leaflet */ \"./node_modules/leaflet/dist/leaflet-src.js\");\n/* harmony import */ var leaflet__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(leaflet__WEBPACK_IMPORTED_MODULE_0__);\n/* harmony import */ var _Support__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../Support */ \"./node_modules/esri-leaflet/src/Support.js\");\n/* harmony import */ var _Util__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../Util */ \"./node_modules/esri-leaflet/src/Util.js\");\n\r\n\r\n\r\n\r\nvar tileProtocol = (window.location.protocol !== 'https:') ? 'http:' : 'https:';\r\n\r\nvar BasemapLayer = leaflet__WEBPACK_IMPORTED_MODULE_0__[\"TileLayer\"].extend({\r\n  statics: {\r\n    TILES: {\r\n      Streets: {\r\n        urlTemplate: tileProtocol + '//{s}.arcgisonline.com/ArcGIS/rest/services/World_Street_Map/MapServer/tile/{z}/{y}/{x}',\r\n        options: {\r\n          minZoom: 1,\r\n          maxZoom: 19,\r\n          subdomains: ['server', 'services'],\r\n          attribution: 'USGS, NOAA',\r\n          attributionUrl: 'https://static.arcgis.com/attribution/World_Street_Map'\r\n        }\r\n      },\r\n      Topographic: {\r\n        urlTemplate: tileProtocol + '//{s}.arcgisonline.com/ArcGIS/rest/services/World_Topo_Map/MapServer/tile/{z}/{y}/{x}',\r\n        options: {\r\n          minZoom: 1,\r\n          maxZoom: 19,\r\n          subdomains: ['server', 'services'],\r\n          attribution: 'USGS, NOAA',\r\n          attributionUrl: 'https://static.arcgis.com/attribution/World_Topo_Map'\r\n        }\r\n      },\r\n      Oceans: {\r\n        urlTemplate: tileProtocol + '//{s}.arcgisonline.com/arcgis/rest/services/Ocean/World_Ocean_Base/MapServer/tile/{z}/{y}/{x}',\r\n        options: {\r\n          minZoom: 1,\r\n          maxZoom: 16,\r\n          subdomains: ['server', 'services'],\r\n          attribution: 'USGS, NOAA',\r\n          attributionUrl: 'https://static.arcgis.com/attribution/Ocean_Basemap'\r\n        }\r\n      },\r\n      OceansLabels: {\r\n        urlTemplate: tileProtocol + '//{s}.arcgisonline.com/arcgis/rest/services/Ocean/World_Ocean_Reference/MapServer/tile/{z}/{y}/{x}',\r\n        options: {\r\n          minZoom: 1,\r\n          maxZoom: 16,\r\n          subdomains: ['server', 'services'],\r\n          pane: (_Support__WEBPACK_IMPORTED_MODULE_1__[\"pointerEvents\"]) ? 'esri-labels' : 'tilePane',\r\n          attribution: ''\r\n        }\r\n      },\r\n      NationalGeographic: {\r\n        urlTemplate: tileProtocol + '//{s}.arcgisonline.com/ArcGIS/rest/services/NatGeo_World_Map/MapServer/tile/{z}/{y}/{x}',\r\n        options: {\r\n          minZoom: 1,\r\n          maxZoom: 16,\r\n          subdomains: ['server', 'services'],\r\n          attribution: 'National Geographic, DeLorme, HERE, UNEP-WCMC, USGS, NASA, ESA, METI, NRCAN, GEBCO, NOAA, increment P Corp.'\r\n        }\r\n      },\r\n      DarkGray: {\r\n        urlTemplate: tileProtocol + '//{s}.arcgisonline.com/ArcGIS/rest/services/Canvas/World_Dark_Gray_Base/MapServer/tile/{z}/{y}/{x}',\r\n        options: {\r\n          minZoom: 1,\r\n          maxZoom: 16,\r\n          subdomains: ['server', 'services'],\r\n          attribution: 'HERE, DeLorme, MapmyIndia, &copy; OpenStreetMap contributors'\r\n        }\r\n      },\r\n      DarkGrayLabels: {\r\n        urlTemplate: tileProtocol + '//{s}.arcgisonline.com/ArcGIS/rest/services/Canvas/World_Dark_Gray_Reference/MapServer/tile/{z}/{y}/{x}',\r\n        options: {\r\n          minZoom: 1,\r\n          maxZoom: 16,\r\n          subdomains: ['server', 'services'],\r\n          pane: (_Support__WEBPACK_IMPORTED_MODULE_1__[\"pointerEvents\"]) ? 'esri-labels' : 'tilePane',\r\n          attribution: ''\r\n\r\n        }\r\n      },\r\n      Gray: {\r\n        urlTemplate: tileProtocol + '//{s}.arcgisonline.com/ArcGIS/rest/services/Canvas/World_Light_Gray_Base/MapServer/tile/{z}/{y}/{x}',\r\n        options: {\r\n          minZoom: 1,\r\n          maxZoom: 16,\r\n          subdomains: ['server', 'services'],\r\n          attribution: 'HERE, DeLorme, MapmyIndia, &copy; OpenStreetMap contributors'\r\n        }\r\n      },\r\n      GrayLabels: {\r\n        urlTemplate: tileProtocol + '//{s}.arcgisonline.com/ArcGIS/rest/services/Canvas/World_Light_Gray_Reference/MapServer/tile/{z}/{y}/{x}',\r\n        options: {\r\n          minZoom: 1,\r\n          maxZoom: 16,\r\n          subdomains: ['server', 'services'],\r\n          pane: (_Support__WEBPACK_IMPORTED_MODULE_1__[\"pointerEvents\"]) ? 'esri-labels' : 'tilePane',\r\n          attribution: ''\r\n        }\r\n      },\r\n      Imagery: {\r\n        urlTemplate: tileProtocol + '//{s}.arcgisonline.com/ArcGIS/rest/services/World_Imagery/MapServer/tile/{z}/{y}/{x}',\r\n        options: {\r\n          minZoom: 1,\r\n          maxZoom: 19,\r\n          subdomains: ['server', 'services'],\r\n          attribution: 'DigitalGlobe, GeoEye, i-cubed, USDA, USGS, AEX, Getmapping, Aerogrid, IGN, IGP, swisstopo, and the GIS User Community',\r\n          attributionUrl: 'https://static.arcgis.com/attribution/World_Imagery'\r\n        }\r\n      },\r\n      ImageryLabels: {\r\n        urlTemplate: tileProtocol + '//{s}.arcgisonline.com/ArcGIS/rest/services/Reference/World_Boundaries_and_Places/MapServer/tile/{z}/{y}/{x}',\r\n        options: {\r\n          minZoom: 1,\r\n          maxZoom: 19,\r\n          subdomains: ['server', 'services'],\r\n          pane: (_Support__WEBPACK_IMPORTED_MODULE_1__[\"pointerEvents\"]) ? 'esri-labels' : 'tilePane',\r\n          attribution: ''\r\n        }\r\n      },\r\n      ImageryTransportation: {\r\n        urlTemplate: tileProtocol + '//{s}.arcgisonline.com/ArcGIS/rest/services/Reference/World_Transportation/MapServer/tile/{z}/{y}/{x}',\r\n        options: {\r\n          minZoom: 1,\r\n          maxZoom: 19,\r\n          subdomains: ['server', 'services'],\r\n          pane: (_Support__WEBPACK_IMPORTED_MODULE_1__[\"pointerEvents\"]) ? 'esri-labels' : 'tilePane',\r\n          attribution: ''\r\n        }\r\n      },\r\n      ShadedRelief: {\r\n        urlTemplate: tileProtocol + '//{s}.arcgisonline.com/ArcGIS/rest/services/World_Shaded_Relief/MapServer/tile/{z}/{y}/{x}',\r\n        options: {\r\n          minZoom: 1,\r\n          maxZoom: 13,\r\n          subdomains: ['server', 'services'],\r\n          attribution: 'USGS'\r\n        }\r\n      },\r\n      ShadedReliefLabels: {\r\n        urlTemplate: tileProtocol + '//{s}.arcgisonline.com/ArcGIS/rest/services/Reference/World_Boundaries_and_Places_Alternate/MapServer/tile/{z}/{y}/{x}',\r\n        options: {\r\n          minZoom: 1,\r\n          maxZoom: 12,\r\n          subdomains: ['server', 'services'],\r\n          pane: (_Support__WEBPACK_IMPORTED_MODULE_1__[\"pointerEvents\"]) ? 'esri-labels' : 'tilePane',\r\n          attribution: ''\r\n        }\r\n      },\r\n      Terrain: {\r\n        urlTemplate: tileProtocol + '//{s}.arcgisonline.com/ArcGIS/rest/services/World_Terrain_Base/MapServer/tile/{z}/{y}/{x}',\r\n        options: {\r\n          minZoom: 1,\r\n          maxZoom: 13,\r\n          subdomains: ['server', 'services'],\r\n          attribution: 'USGS, NOAA'\r\n        }\r\n      },\r\n      TerrainLabels: {\r\n        urlTemplate: tileProtocol + '//{s}.arcgisonline.com/ArcGIS/rest/services/Reference/World_Reference_Overlay/MapServer/tile/{z}/{y}/{x}',\r\n        options: {\r\n          minZoom: 1,\r\n          maxZoom: 13,\r\n          subdomains: ['server', 'services'],\r\n          pane: (_Support__WEBPACK_IMPORTED_MODULE_1__[\"pointerEvents\"]) ? 'esri-labels' : 'tilePane',\r\n          attribution: ''\r\n        }\r\n      },\r\n      USATopo: {\r\n        urlTemplate: tileProtocol + '//{s}.arcgisonline.com/ArcGIS/rest/services/USA_Topo_Maps/MapServer/tile/{z}/{y}/{x}',\r\n        options: {\r\n          minZoom: 1,\r\n          maxZoom: 15,\r\n          subdomains: ['server', 'services'],\r\n          attribution: 'USGS, National Geographic Society, i-cubed'\r\n        }\r\n      },\r\n      ImageryClarity: {\r\n        urlTemplate: tileProtocol + '//clarity.maptiles.arcgis.com/arcgis/rest/services/World_Imagery/MapServer/tile/{z}/{y}/{x}',\r\n        options: {\r\n          minZoom: 1,\r\n          maxZoom: 19,\r\n          attribution: 'Esri, DigitalGlobe, GeoEye, Earthstar Geographics, CNES/Airbus DS, USDA, USGS, AeroGRID, IGN, and the GIS User Community'\r\n        }\r\n      },\r\n      Physical: {\r\n        urlTemplate: tileProtocol + '//{s}.arcgisonline.com/arcgis/rest/services/World_Physical_Map/MapServer/tile/{z}/{y}/{x}',\r\n        options: {\r\n          minZoom: 1,\r\n          maxZoom: 8,\r\n          subdomains: ['server', 'services'],\r\n          attribution: 'U.S. National Park Service'\r\n        }\r\n      },\r\n      ImageryFirefly: {\r\n        urlTemplate: tileProtocol + '//fly.maptiles.arcgis.com/arcgis/rest/services/World_Imagery_Firefly/MapServer/tile/{z}/{y}/{x}',\r\n        options: {\r\n          minZoom: 1,\r\n          maxZoom: 19,\r\n          attribution: 'Esri, DigitalGlobe, GeoEye, Earthstar Geographics, CNES/Airbus DS, USDA, USGS, AeroGRID, IGN, and the GIS User Community',\r\n          attributionUrl: 'https://static.arcgis.com/attribution/World_Imagery'\r\n        }\r\n      }\r\n    }\r\n  },\r\n\r\n  initialize: function (key, options) {\r\n    var config;\r\n\r\n    // set the config variable with the appropriate config object\r\n    if (typeof key === 'object' && key.urlTemplate && key.options) {\r\n      config = key;\r\n    } else if (typeof key === 'string' && BasemapLayer.TILES[key]) {\r\n      config = BasemapLayer.TILES[key];\r\n    } else {\r\n      throw new Error('L.esri.BasemapLayer: Invalid parameter. Use one of \"Streets\", \"Topographic\", \"Oceans\", \"OceansLabels\", \"NationalGeographic\", \"Physical\", \"Gray\", \"GrayLabels\", \"DarkGray\", \"DarkGrayLabels\", \"Imagery\", \"ImageryLabels\", \"ImageryTransportation\", \"ImageryClarity\", \"ImageryFirefly\", ShadedRelief\", \"ShadedReliefLabels\", \"Terrain\", \"TerrainLabels\" or \"USATopo\"');\r\n    }\r\n\r\n    // merge passed options into the config options\r\n    var tileOptions = leaflet__WEBPACK_IMPORTED_MODULE_0__[\"Util\"].extend(config.options, options);\r\n\r\n    leaflet__WEBPACK_IMPORTED_MODULE_0__[\"Util\"].setOptions(this, tileOptions);\r\n\r\n    if (this.options.token && config.urlTemplate.indexOf('token=') === -1) {\r\n      config.urlTemplate += ('?token=' + this.options.token);\r\n    }\r\n    if (this.options.proxy) {\r\n      config.urlTemplate = this.options.proxy + '?' + config.urlTemplate;\r\n    }\r\n\r\n    // call the initialize method on L.TileLayer to set everything up\r\n    leaflet__WEBPACK_IMPORTED_MODULE_0__[\"TileLayer\"].prototype.initialize.call(this, config.urlTemplate, tileOptions);\r\n  },\r\n\r\n  onAdd: function (map) {\r\n    // include 'Powered by Esri' in map attribution\r\n    Object(_Util__WEBPACK_IMPORTED_MODULE_2__[\"setEsriAttribution\"])(map);\r\n\r\n    if (this.options.pane === 'esri-labels') {\r\n      this._initPane();\r\n    }\r\n    // some basemaps can supply dynamic attribution\r\n    if (this.options.attributionUrl) {\r\n      Object(_Util__WEBPACK_IMPORTED_MODULE_2__[\"_getAttributionData\"])((this.options.proxy ? this.options.proxy + '?' : '') + this.options.attributionUrl, map);\r\n    }\r\n\r\n    map.on('moveend', _Util__WEBPACK_IMPORTED_MODULE_2__[\"_updateMapAttribution\"]);\r\n\r\n    leaflet__WEBPACK_IMPORTED_MODULE_0__[\"TileLayer\"].prototype.onAdd.call(this, map);\r\n  },\r\n\r\n  onRemove: function (map) {\r\n    Object(_Util__WEBPACK_IMPORTED_MODULE_2__[\"removeEsriAttribution\"])(map);\r\n\r\n    map.off('moveend', _Util__WEBPACK_IMPORTED_MODULE_2__[\"_updateMapAttribution\"]);\r\n\r\n    leaflet__WEBPACK_IMPORTED_MODULE_0__[\"TileLayer\"].prototype.onRemove.call(this, map);\r\n  },\r\n\r\n  _initPane: function () {\r\n    if (!this._map.getPane(this.options.pane)) {\r\n      var pane = this._map.createPane(this.options.pane);\r\n      pane.style.pointerEvents = 'none';\r\n      pane.style.zIndex = 500;\r\n    }\r\n  },\r\n\r\n  getAttribution: function () {\r\n    if (this.options.attribution) {\r\n      var attribution = '<span class=\"esri-dynamic-attribution\">' + this.options.attribution + '</span>';\r\n    }\r\n    return attribution;\r\n  }\r\n});\r\n\r\nfunction basemapLayer (key, options) {\r\n  return new BasemapLayer(key, options);\r\n}\r\n\r\n/* harmony default export */ __webpack_exports__[\"default\"] = (basemapLayer);\r\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///./node_modules/esri-leaflet/src/Layers/BasemapLayer.js\n");

/***/ }),

/***/ "./node_modules/esri-leaflet/src/Layers/DynamicMapLayer.js":
/*!*****************************************************************!*\
  !*** ./node_modules/esri-leaflet/src/Layers/DynamicMapLayer.js ***!
  \*****************************************************************/
/*! exports provided: DynamicMapLayer, dynamicMapLayer, default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"DynamicMapLayer\", function() { return DynamicMapLayer; });\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"dynamicMapLayer\", function() { return dynamicMapLayer; });\n/* harmony import */ var leaflet__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! leaflet */ \"./node_modules/leaflet/dist/leaflet-src.js\");\n/* harmony import */ var leaflet__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(leaflet__WEBPACK_IMPORTED_MODULE_0__);\n/* harmony import */ var _RasterLayer__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./RasterLayer */ \"./node_modules/esri-leaflet/src/Layers/RasterLayer.js\");\n/* harmony import */ var _Util__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../Util */ \"./node_modules/esri-leaflet/src/Util.js\");\n/* harmony import */ var _Services_MapService__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../Services/MapService */ \"./node_modules/esri-leaflet/src/Services/MapService.js\");\n\r\n\r\n\r\n\r\n\r\nvar DynamicMapLayer = _RasterLayer__WEBPACK_IMPORTED_MODULE_1__[\"RasterLayer\"].extend({\r\n\r\n  options: {\r\n    updateInterval: 150,\r\n    layers: false,\r\n    layerDefs: false,\r\n    timeOptions: false,\r\n    format: 'png32',\r\n    transparent: true,\r\n    f: 'json'\r\n  },\r\n\r\n  initialize: function (options) {\r\n    options = Object(_Util__WEBPACK_IMPORTED_MODULE_2__[\"getUrlParams\"])(options);\r\n    this.service = Object(_Services_MapService__WEBPACK_IMPORTED_MODULE_3__[\"default\"])(options);\r\n    this.service.addEventParent(this);\r\n\r\n    leaflet__WEBPACK_IMPORTED_MODULE_0__[\"Util\"].setOptions(this, options);\r\n  },\r\n\r\n  getDynamicLayers: function () {\r\n    return this.options.dynamicLayers;\r\n  },\r\n\r\n  setDynamicLayers: function (dynamicLayers) {\r\n    this.options.dynamicLayers = dynamicLayers;\r\n    this._update();\r\n    return this;\r\n  },\r\n\r\n  getLayers: function () {\r\n    return this.options.layers;\r\n  },\r\n\r\n  setLayers: function (layers) {\r\n    this.options.layers = layers;\r\n    this._update();\r\n    return this;\r\n  },\r\n\r\n  getLayerDefs: function () {\r\n    return this.options.layerDefs;\r\n  },\r\n\r\n  setLayerDefs: function (layerDefs) {\r\n    this.options.layerDefs = layerDefs;\r\n    this._update();\r\n    return this;\r\n  },\r\n\r\n  getTimeOptions: function () {\r\n    return this.options.timeOptions;\r\n  },\r\n\r\n  setTimeOptions: function (timeOptions) {\r\n    this.options.timeOptions = timeOptions;\r\n    this._update();\r\n    return this;\r\n  },\r\n\r\n  query: function () {\r\n    return this.service.query();\r\n  },\r\n\r\n  identify: function () {\r\n    return this.service.identify();\r\n  },\r\n\r\n  find: function () {\r\n    return this.service.find();\r\n  },\r\n\r\n  _getPopupData: function (e) {\r\n    var callback = leaflet__WEBPACK_IMPORTED_MODULE_0__[\"Util\"].bind(function (error, featureCollection, response) {\r\n      if (error) { return; } // we really can't do anything here but authenticate or requesterror will fire\r\n      setTimeout(leaflet__WEBPACK_IMPORTED_MODULE_0__[\"Util\"].bind(function () {\r\n        this._renderPopup(e.latlng, error, featureCollection, response);\r\n      }, this), 300);\r\n    }, this);\r\n\r\n    var identifyRequest;\r\n    if (this.options.popup) {\r\n      identifyRequest = this.options.popup.on(this._map).at(e.latlng);\r\n    } else {\r\n      identifyRequest = this.identify().on(this._map).at(e.latlng);\r\n    }\r\n\r\n    // remove extraneous vertices from response features if it has not already been done\r\n    identifyRequest.params.maxAllowableOffset ? true : identifyRequest.simplify(this._map, 0.5);\r\n\r\n    if (!(this.options.popup && this.options.popup.params && this.options.popup.params.layers)) {\r\n      if (this.options.layers) {\r\n        identifyRequest.layers('visible:' + this.options.layers.join(','));\r\n      } else {\r\n        identifyRequest.layers('visible');\r\n      }\r\n    }\r\n\r\n    // if present, pass layer ids and sql filters through to the identify task\r\n    if (this.options.layerDefs && typeof this.options.layerDefs !== 'string' && !identifyRequest.params.layerDefs) {\r\n      for (var id in this.options.layerDefs) {\r\n        if (this.options.layerDefs.hasOwnProperty(id)) {\r\n          identifyRequest.layerDef(id, this.options.layerDefs[id]);\r\n        }\r\n      }\r\n    }\r\n\r\n    identifyRequest.run(callback);\r\n\r\n    // set the flags to show the popup\r\n    this._shouldRenderPopup = true;\r\n    this._lastClick = e.latlng;\r\n  },\r\n\r\n  _buildExportParams: function () {\r\n    var sr = parseInt(this._map.options.crs.code.split(':')[1], 10);\r\n\r\n    var params = {\r\n      bbox: this._calculateBbox(),\r\n      size: this._calculateImageSize(),\r\n      dpi: 96,\r\n      format: this.options.format,\r\n      transparent: this.options.transparent,\r\n      bboxSR: sr,\r\n      imageSR: sr\r\n    };\r\n\r\n    if (this.options.dynamicLayers) {\r\n      params.dynamicLayers = this.options.dynamicLayers;\r\n    }\r\n\r\n    if (this.options.layers) {\r\n      if (this.options.layers.length === 0) {\r\n        return;\r\n      } else {\r\n        params.layers = 'show:' + this.options.layers.join(',');\r\n      }\r\n    }\r\n\r\n    if (this.options.layerDefs) {\r\n      params.layerDefs = typeof this.options.layerDefs === 'string' ? this.options.layerDefs : JSON.stringify(this.options.layerDefs);\r\n    }\r\n\r\n    if (this.options.timeOptions) {\r\n      params.timeOptions = JSON.stringify(this.options.timeOptions);\r\n    }\r\n\r\n    if (this.options.from && this.options.to) {\r\n      params.time = this.options.from.valueOf() + ',' + this.options.to.valueOf();\r\n    }\r\n\r\n    if (this.service.options.token) {\r\n      params.token = this.service.options.token;\r\n    }\r\n\r\n    if (this.options.proxy) {\r\n      params.proxy = this.options.proxy;\r\n    }\r\n\r\n    // use a timestamp to bust server cache\r\n    if (this.options.disableCache) {\r\n      params._ts = Date.now();\r\n    }\r\n\r\n    return params;\r\n  },\r\n\r\n  _requestExport: function (params, bounds) {\r\n    if (this.options.f === 'json') {\r\n      this.service.request('export', params, function (error, response) {\r\n        if (error) { return; } // we really can't do anything here but authenticate or requesterror will fire\r\n\r\n        if (this.options.token && response.href) {\r\n          response.href += ('?token=' + this.options.token);\r\n        }\r\n        if (this.options.proxy && response.href) {\r\n          response.href = this.options.proxy + '?' + response.href;\r\n        }\r\n        if (response.href) {\r\n          this._renderImage(response.href, bounds);\r\n        } else {\r\n          this._renderImage(response.imageData, bounds, response.contentType);\r\n        }\r\n      }, this);\r\n    } else {\r\n      params.f = 'image';\r\n      var fullUrl = this.options.url + 'export' + leaflet__WEBPACK_IMPORTED_MODULE_0__[\"Util\"].getParamString(params);\r\n      if (this.options.proxy) {\r\n        fullUrl = this.options.proxy + '?' + fullUrl;\r\n      }\r\n      this._renderImage(fullUrl, bounds);\r\n    }\r\n  }\r\n});\r\n\r\nfunction dynamicMapLayer (url, options) {\r\n  return new DynamicMapLayer(url, options);\r\n}\r\n\r\n/* harmony default export */ __webpack_exports__[\"default\"] = (dynamicMapLayer);\r\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///./node_modules/esri-leaflet/src/Layers/DynamicMapLayer.js\n");

/***/ }),

/***/ "./node_modules/esri-leaflet/src/Layers/FeatureLayer/FeatureGrid.js":
/*!**************************************************************************!*\
  !*** ./node_modules/esri-leaflet/src/Layers/FeatureLayer/FeatureGrid.js ***!
  \**************************************************************************/
/*! exports provided: FeatureGrid */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"FeatureGrid\", function() { return FeatureGrid; });\n/* harmony import */ var leaflet__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! leaflet */ \"./node_modules/leaflet/dist/leaflet-src.js\");\n/* harmony import */ var leaflet__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(leaflet__WEBPACK_IMPORTED_MODULE_0__);\n\r\n\r\nvar FeatureGrid = leaflet__WEBPACK_IMPORTED_MODULE_0__[\"Layer\"].extend({\r\n  // @section\r\n  // @aka GridLayer options\r\n  options: {\r\n    // @option cellSize: Number|Point = 256\r\n    // Width and height of cells in the grid. Use a number if width and height are equal, or `L.point(width, height)` otherwise.\r\n    cellSize: 512,\r\n\r\n    // @option updateWhenIdle: Boolean = (depends)\r\n    // Load new cells only when panning ends.\r\n    // `true` by default on mobile browsers, in order to avoid too many requests and keep smooth navigation.\r\n    // `false` otherwise in order to display new cells _during_ panning, since it is easy to pan outside the\r\n    // [`keepBuffer`](#gridlayer-keepbuffer) option in desktop browsers.\r\n    updateWhenIdle: leaflet__WEBPACK_IMPORTED_MODULE_0__[\"Browser\"].mobile,\r\n\r\n    // @option updateInterval: Number = 150\r\n    // Cells will not update more than once every `updateInterval` milliseconds when panning.\r\n    updateInterval: 150,\r\n\r\n    // @option noWrap: Boolean = false\r\n    // Whether the layer is wrapped around the antimeridian. If `true`, the\r\n    // GridLayer will only be displayed once at low zoom levels. Has no\r\n    // effect when the [map CRS](#map-crs) doesn't wrap around. Can be used\r\n    // in combination with [`bounds`](#gridlayer-bounds) to prevent requesting\r\n    // cells outside the CRS limits.\r\n    noWrap: false,\r\n\r\n    // @option keepBuffer: Number = 1.5\r\n    // When panning the map, keep this many rows and columns of cells before unloading them.\r\n    keepBuffer: 1.5\r\n  },\r\n\r\n  initialize: function (options) {\r\n    leaflet__WEBPACK_IMPORTED_MODULE_0__[\"Util\"].setOptions(this, options);\r\n  },\r\n\r\n  onAdd: function (map) {\r\n    this._cells = {};\r\n    this._activeCells = {};\r\n    this._resetView();\r\n    this._update();\r\n  },\r\n\r\n  onRemove: function (map) {\r\n    this._removeAllCells();\r\n    this._cellZoom = undefined;\r\n  },\r\n\r\n  // @method isLoading: Boolean\r\n  // Returns `true` if any cell in the grid layer has not finished loading.\r\n  isLoading: function () {\r\n    return this._loading;\r\n  },\r\n\r\n  // @method redraw: this\r\n  // Causes the layer to clear all the cells and request them again.\r\n  redraw: function () {\r\n    if (this._map) {\r\n      this._removeAllCells();\r\n      this._update();\r\n    }\r\n    return this;\r\n  },\r\n\r\n  getEvents: function () {\r\n    var events = {\r\n      viewprereset: this._invalidateAll,\r\n      viewreset: this._resetView,\r\n      zoom: this._resetView,\r\n      moveend: this._onMoveEnd\r\n    };\r\n\r\n    if (!this.options.updateWhenIdle) {\r\n      // update cells on move, but not more often than once per given interval\r\n      if (!this._onMove) {\r\n        this._onMove = leaflet__WEBPACK_IMPORTED_MODULE_0__[\"Util\"].throttle(\r\n          this._onMoveEnd,\r\n          this.options.updateInterval,\r\n          this\r\n        );\r\n      }\r\n\r\n      events.move = this._onMove;\r\n    }\r\n\r\n    return events;\r\n  },\r\n\r\n  // @section Extension methods\r\n  // Layers extending `GridLayer` shall reimplement the following method.\r\n  // @method createCell(coords: Object, done?: Function): HTMLElement\r\n  // Called only internally, must be overridden by classes extending `GridLayer`.\r\n  // Returns the `HTMLElement` corresponding to the given `coords`. If the `done` callback\r\n  // is specified, it must be called when the cell has finished loading and drawing.\r\n  createCell: function () {\r\n    return document.createElement('div');\r\n  },\r\n\r\n  removeCell: function () {\r\n    return;\r\n  },\r\n\r\n  reuseCell: function () {\r\n    return;\r\n  },\r\n\r\n  cellLeave: function () {\r\n    return;\r\n  },\r\n\r\n  cellEnter: function () {\r\n    return;\r\n  },\r\n  // @section\r\n  // @method getCellSize: Point\r\n  // Normalizes the [cellSize option](#gridlayer-cellsize) into a point. Used by the `createCell()` method.\r\n  getCellSize: function () {\r\n    var s = this.options.cellSize;\r\n    return s instanceof leaflet__WEBPACK_IMPORTED_MODULE_0__[\"Point\"] ? s : new leaflet__WEBPACK_IMPORTED_MODULE_0__[\"Point\"](s, s);\r\n  },\r\n\r\n  _pruneCells: function () {\r\n    if (!this._map) {\r\n      return;\r\n    }\r\n\r\n    var key, cell;\r\n\r\n    for (key in this._cells) {\r\n      cell = this._cells[key];\r\n      cell.retain = cell.current;\r\n    }\r\n\r\n    for (key in this._cells) {\r\n      cell = this._cells[key];\r\n      if (cell.current && !cell.active) {\r\n        var coords = cell.coords;\r\n        if (!this._retainParent(coords.x, coords.y, coords.z, coords.z - 5)) {\r\n          this._retainChildren(coords.x, coords.y, coords.z, coords.z + 2);\r\n        }\r\n      }\r\n    }\r\n\r\n    for (key in this._cells) {\r\n      if (!this._cells[key].retain) {\r\n        this._removeCell(key);\r\n      }\r\n    }\r\n  },\r\n\r\n  _removeAllCells: function () {\r\n    for (var key in this._cells) {\r\n      this._removeCell(key);\r\n    }\r\n  },\r\n\r\n  _invalidateAll: function () {\r\n    this._removeAllCells();\r\n\r\n    this._cellZoom = undefined;\r\n  },\r\n\r\n  _retainParent: function (x, y, z, minZoom) {\r\n    var x2 = Math.floor(x / 2);\r\n    var y2 = Math.floor(y / 2);\r\n    var z2 = z - 1;\r\n    var coords2 = new leaflet__WEBPACK_IMPORTED_MODULE_0__[\"Point\"](+x2, +y2);\r\n    coords2.z = +z2;\r\n\r\n    var key = this._cellCoordsToKey(coords2);\r\n    var cell = this._cells[key];\r\n\r\n    if (cell && cell.active) {\r\n      cell.retain = true;\r\n      return true;\r\n    } else if (cell && cell.loaded) {\r\n      cell.retain = true;\r\n    }\r\n\r\n    if (z2 > minZoom) {\r\n      return this._retainParent(x2, y2, z2, minZoom);\r\n    }\r\n\r\n    return false;\r\n  },\r\n\r\n  _retainChildren: function (x, y, z, maxZoom) {\r\n    for (var i = 2 * x; i < 2 * x + 2; i++) {\r\n      for (var j = 2 * y; j < 2 * y + 2; j++) {\r\n        var coords = new leaflet__WEBPACK_IMPORTED_MODULE_0__[\"Point\"](i, j);\r\n        coords.z = z + 1;\r\n\r\n        var key = this._cellCoordsToKey(coords);\r\n        var cell = this._cells[key];\r\n\r\n        if (cell && cell.active) {\r\n          cell.retain = true;\r\n          continue;\r\n        } else if (cell && cell.loaded) {\r\n          cell.retain = true;\r\n        }\r\n\r\n        if (z + 1 < maxZoom) {\r\n          this._retainChildren(i, j, z + 1, maxZoom);\r\n        }\r\n      }\r\n    }\r\n  },\r\n\r\n  _resetView: function (e) {\r\n    var animating = e && (e.pinch || e.flyTo);\r\n\r\n    if (animating) {\r\n      return;\r\n    }\r\n\r\n    this._setView(\r\n      this._map.getCenter(),\r\n      this._map.getZoom(),\r\n      animating,\r\n      animating\r\n    );\r\n  },\r\n\r\n  _setView: function (center, zoom, noPrune, noUpdate) {\r\n    var cellZoom = Math.round(zoom);\r\n\r\n    if (!noUpdate) {\r\n      this._cellZoom = cellZoom;\r\n\r\n      if (this._abortLoading) {\r\n        this._abortLoading();\r\n      }\r\n\r\n      this._resetGrid();\r\n\r\n      if (cellZoom !== undefined) {\r\n        this._update(center);\r\n      }\r\n\r\n      if (!noPrune) {\r\n        this._pruneCells();\r\n      }\r\n\r\n      // Flag to prevent _updateOpacity from pruning cells during\r\n      // a zoom anim or a pinch gesture\r\n      this._noPrune = !!noPrune;\r\n    }\r\n  },\r\n\r\n  _resetGrid: function () {\r\n    var map = this._map;\r\n    var crs = map.options.crs;\r\n    var cellSize = (this._cellSize = this.getCellSize());\r\n    var cellZoom = this._cellZoom;\r\n\r\n    var bounds = this._map.getPixelWorldBounds(this._cellZoom);\r\n    if (bounds) {\r\n      this._globalCellRange = this._pxBoundsToCellRange(bounds);\r\n    }\r\n\r\n    this._wrapX = crs.wrapLng &&\r\n      !this.options.noWrap && [\r\n        Math.floor(map.project([0, crs.wrapLng[0]], cellZoom).x / cellSize.x),\r\n        Math.ceil(map.project([0, crs.wrapLng[1]], cellZoom).x / cellSize.y)\r\n      ];\r\n    this._wrapY = crs.wrapLat &&\r\n      !this.options.noWrap && [\r\n        Math.floor(map.project([crs.wrapLat[0], 0], cellZoom).y / cellSize.x),\r\n        Math.ceil(map.project([crs.wrapLat[1], 0], cellZoom).y / cellSize.y)\r\n      ];\r\n  },\r\n\r\n  _onMoveEnd: function (e) {\r\n    var animating = e && (e.pinch || e.flyTo);\r\n\r\n    if (animating || !this._map || this._map._animatingZoom) {\r\n      return;\r\n    }\r\n\r\n    this._update();\r\n  },\r\n\r\n  _getCelldPixelBounds: function (center) {\r\n    var map = this._map;\r\n    var mapZoom = map._animatingZoom\r\n      ? Math.max(map._animateToZoom, map.getZoom())\r\n      : map.getZoom();\r\n    var scale = map.getZoomScale(mapZoom, this._cellZoom);\r\n    var pixelCenter = map.project(center, this._cellZoom).floor();\r\n    var halfSize = map.getSize().divideBy(scale * 2);\r\n\r\n    return new leaflet__WEBPACK_IMPORTED_MODULE_0__[\"Bounds\"](\r\n      pixelCenter.subtract(halfSize),\r\n      pixelCenter.add(halfSize)\r\n    );\r\n  },\r\n\r\n  // Private method to load cells in the grid's active zoom level according to map bounds\r\n  _update: function (center) {\r\n    var map = this._map;\r\n    if (!map) {\r\n      return;\r\n    }\r\n    var zoom = Math.round(map.getZoom());\r\n\r\n    if (center === undefined) {\r\n      center = map.getCenter();\r\n    }\r\n\r\n    var pixelBounds = this._getCelldPixelBounds(center);\r\n    var cellRange = this._pxBoundsToCellRange(pixelBounds);\r\n    var cellCenter = cellRange.getCenter();\r\n    var queue = [];\r\n    var margin = this.options.keepBuffer;\r\n    var noPruneRange = new leaflet__WEBPACK_IMPORTED_MODULE_0__[\"Bounds\"](\r\n      cellRange.getBottomLeft().subtract([margin, -margin]),\r\n      cellRange.getTopRight().add([margin, -margin])\r\n    );\r\n\r\n    // Sanity check: panic if the cell range contains Infinity somewhere.\r\n    if (\r\n      !(\r\n        isFinite(cellRange.min.x) &&\r\n        isFinite(cellRange.min.y) &&\r\n        isFinite(cellRange.max.x) &&\r\n        isFinite(cellRange.max.y)\r\n      )\r\n    ) {\r\n      throw new Error('Attempted to load an infinite number of cells');\r\n    }\r\n\r\n    for (var key in this._cells) {\r\n      var c = this._cells[key].coords;\r\n      if (\r\n        c.z !== this._cellZoom ||\r\n        !noPruneRange.contains(new leaflet__WEBPACK_IMPORTED_MODULE_0__[\"Point\"](c.x, c.y))\r\n      ) {\r\n        this._cells[key].current = false;\r\n      }\r\n    }\r\n\r\n    // _update just loads more cells. If the cell zoom level differs too much\r\n    // from the map's, let _setView reset levels and prune old cells.\r\n    if (Math.abs(zoom - this._cellZoom) > 1) {\r\n      this._setView(center, zoom);\r\n      return;\r\n    }\r\n\r\n    // create a queue of coordinates to load cells from\r\n    for (var j = cellRange.min.y; j <= cellRange.max.y; j++) {\r\n      for (var i = cellRange.min.x; i <= cellRange.max.x; i++) {\r\n        var coords = new leaflet__WEBPACK_IMPORTED_MODULE_0__[\"Point\"](i, j);\r\n        coords.z = this._cellZoom;\r\n\r\n        if (!this._isValidCell(coords)) {\r\n          continue;\r\n        }\r\n\r\n        var cell = this._cells[this._cellCoordsToKey(coords)];\r\n        if (cell) {\r\n          cell.current = true;\r\n        } else {\r\n          queue.push(coords);\r\n        }\r\n      }\r\n    }\r\n\r\n    // sort cell queue to load cells in order of their distance to center\r\n    queue.sort(function (a, b) {\r\n      return a.distanceTo(cellCenter) - b.distanceTo(cellCenter);\r\n    });\r\n\r\n    if (queue.length !== 0) {\r\n      // if it's the first batch of cells to load\r\n      if (!this._loading) {\r\n        this._loading = true;\r\n      }\r\n\r\n      for (i = 0; i < queue.length; i++) {\r\n        var _key = this._cellCoordsToKey(queue[i]);\r\n        var _coords = this._keyToCellCoords(_key);\r\n        if (this._activeCells[_coords]) {\r\n          this._reuseCell(queue[i]);\r\n        } else {\r\n          this._createCell(queue[i]);\r\n        }\r\n      }\r\n    }\r\n  },\r\n\r\n  _isValidCell: function (coords) {\r\n    var crs = this._map.options.crs;\r\n\r\n    if (!crs.infinite) {\r\n      // don't load cell if it's out of bounds and not wrapped\r\n      var bounds = this._globalCellRange;\r\n      if (\r\n        (!crs.wrapLng &&\r\n          (coords.x < bounds.min.x || coords.x > bounds.max.x)) ||\r\n        (!crs.wrapLat && (coords.y < bounds.min.y || coords.y > bounds.max.y))\r\n      ) {\r\n        return false;\r\n      }\r\n    }\r\n\r\n    if (!this.options.bounds) {\r\n      return true;\r\n    }\r\n\r\n    // don't load cell if it doesn't intersect the bounds in options\r\n    var cellBounds = this._cellCoordsToBounds(coords);\r\n    return Object(leaflet__WEBPACK_IMPORTED_MODULE_0__[\"toLatLngBounds\"])(this.options.bounds).overlaps(cellBounds);\r\n  },\r\n\r\n  _keyToBounds: function (key) {\r\n    return this._cellCoordsToBounds(this._keyToCellCoords(key));\r\n  },\r\n\r\n  _cellCoordsToNwSe: function (coords) {\r\n    var map = this._map;\r\n    var cellSize = this.getCellSize();\r\n    var nwPoint = coords.scaleBy(cellSize);\r\n    var sePoint = nwPoint.add(cellSize);\r\n    var nw = map.unproject(nwPoint, coords.z);\r\n    var se = map.unproject(sePoint, coords.z);\r\n\r\n    return [nw, se];\r\n  },\r\n\r\n  // converts cell coordinates to its geographical bounds\r\n  _cellCoordsToBounds: function (coords) {\r\n    var bp = this._cellCoordsToNwSe(coords);\r\n    var bounds = new leaflet__WEBPACK_IMPORTED_MODULE_0__[\"LatLngBounds\"](bp[0], bp[1]);\r\n\r\n    if (!this.options.noWrap) {\r\n      bounds = this._map.wrapLatLngBounds(bounds);\r\n    }\r\n    return bounds;\r\n  },\r\n  // converts cell coordinates to key for the cell cache\r\n  _cellCoordsToKey: function (coords) {\r\n    return coords.x + ':' + coords.y + ':' + coords.z;\r\n  },\r\n\r\n  // converts cell cache key to coordinates\r\n  _keyToCellCoords: function (key) {\r\n    var k = key.split(':');\r\n    var coords = new leaflet__WEBPACK_IMPORTED_MODULE_0__[\"Point\"](+k[0], +k[1]);\r\n\r\n    coords.z = +k[2];\r\n    return coords;\r\n  },\r\n\r\n  _removeCell: function (key) {\r\n    var cell = this._cells[key];\r\n\r\n    if (!cell) {\r\n      return;\r\n    }\r\n\r\n    var coords = this._keyToCellCoords(key);\r\n    var wrappedCoords = this._wrapCoords(coords);\r\n    var cellBounds = this._cellCoordsToBounds(this._wrapCoords(coords));\r\n\r\n    cell.current = false;\r\n\r\n    delete this._cells[key];\r\n    this._activeCells[key] = cell;\r\n\r\n    this.cellLeave(cellBounds, wrappedCoords, key);\r\n\r\n    this.fire('cellleave', {\r\n      key: key,\r\n      coords: wrappedCoords,\r\n      bounds: cellBounds\r\n    });\r\n  },\r\n\r\n  _reuseCell: function (coords) {\r\n    var key = this._cellCoordsToKey(coords);\r\n\r\n    // save cell in cache\r\n    this._cells[key] = this._activeCells[key];\r\n    this._cells[key].current = true;\r\n\r\n    var wrappedCoords = this._wrapCoords(coords);\r\n    var cellBounds = this._cellCoordsToBounds(this._wrapCoords(coords));\r\n\r\n    this.cellEnter(cellBounds, wrappedCoords, key);\r\n\r\n    this.fire('cellenter', {\r\n      key: key,\r\n      coords: wrappedCoords,\r\n      bounds: cellBounds\r\n    });\r\n  },\r\n\r\n  _createCell: function (coords) {\r\n    var key = this._cellCoordsToKey(coords);\r\n\r\n    var wrappedCoords = this._wrapCoords(coords);\r\n    var cellBounds = this._cellCoordsToBounds(this._wrapCoords(coords));\r\n\r\n    this.createCell(cellBounds, wrappedCoords, key);\r\n\r\n    this.fire('cellcreate', {\r\n      key: key,\r\n      coords: wrappedCoords,\r\n      bounds: cellBounds\r\n    });\r\n\r\n    // save cell in cache\r\n    this._cells[key] = {\r\n      coords: coords,\r\n      current: true\r\n    };\r\n\r\n    leaflet__WEBPACK_IMPORTED_MODULE_0__[\"Util\"].requestAnimFrame(this._pruneCells, this);\r\n  },\r\n\r\n  _cellReady: function (coords, err, cell) {\r\n    var key = this._cellCoordsToKey(coords);\r\n\r\n    cell = this._cells[key];\r\n\r\n    if (!cell) {\r\n      return;\r\n    }\r\n\r\n    cell.loaded = +new Date();\r\n\r\n    cell.active = true;\r\n  },\r\n\r\n  _getCellPos: function (coords) {\r\n    return coords.scaleBy(this.getCellSize());\r\n  },\r\n\r\n  _wrapCoords: function (coords) {\r\n    var newCoords = new leaflet__WEBPACK_IMPORTED_MODULE_0__[\"Point\"](\r\n      this._wrapX ? leaflet__WEBPACK_IMPORTED_MODULE_0__[\"Util\"].wrapNum(coords.x, this._wrapX) : coords.x,\r\n      this._wrapY ? leaflet__WEBPACK_IMPORTED_MODULE_0__[\"Util\"].wrapNum(coords.y, this._wrapY) : coords.y\r\n    );\r\n    newCoords.z = coords.z;\r\n    return newCoords;\r\n  },\r\n\r\n  _pxBoundsToCellRange: function (bounds) {\r\n    var cellSize = this.getCellSize();\r\n    return new leaflet__WEBPACK_IMPORTED_MODULE_0__[\"Bounds\"](\r\n      bounds.min.unscaleBy(cellSize).floor(),\r\n      bounds.max.unscaleBy(cellSize).ceil().subtract([1, 1])\r\n    );\r\n  }\r\n});\r\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///./node_modules/esri-leaflet/src/Layers/FeatureLayer/FeatureGrid.js\n");

/***/ }),

/***/ "./node_modules/esri-leaflet/src/Layers/FeatureLayer/FeatureLayer.js":
/*!***************************************************************************!*\
  !*** ./node_modules/esri-leaflet/src/Layers/FeatureLayer/FeatureLayer.js ***!
  \***************************************************************************/
/*! exports provided: FeatureLayer, featureLayer, default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"FeatureLayer\", function() { return FeatureLayer; });\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"featureLayer\", function() { return featureLayer; });\n/* harmony import */ var leaflet__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! leaflet */ \"./node_modules/leaflet/dist/leaflet-src.js\");\n/* harmony import */ var leaflet__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(leaflet__WEBPACK_IMPORTED_MODULE_0__);\n/* harmony import */ var _FeatureManager__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./FeatureManager */ \"./node_modules/esri-leaflet/src/Layers/FeatureLayer/FeatureManager.js\");\n/* harmony import */ var _Util__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../Util */ \"./node_modules/esri-leaflet/src/Util.js\");\n\r\n\r\n\r\n\r\nvar FeatureLayer = _FeatureManager__WEBPACK_IMPORTED_MODULE_1__[\"FeatureManager\"].extend({\r\n\r\n  options: {\r\n    cacheLayers: true\r\n  },\r\n\r\n  /**\r\n   * Constructor\r\n   */\r\n  initialize: function (options) {\r\n    _FeatureManager__WEBPACK_IMPORTED_MODULE_1__[\"FeatureManager\"].prototype.initialize.call(this, options);\r\n    this._originalStyle = this.options.style;\r\n    this._layers = {};\r\n  },\r\n\r\n  /**\r\n   * Layer Interface\r\n   */\r\n\r\n  onRemove: function (map) {\r\n    for (var i in this._layers) {\r\n      map.removeLayer(this._layers[i]);\r\n      // trigger the event when the entire featureLayer is removed from the map\r\n      this.fire('removefeature', {\r\n        feature: this._layers[i].feature,\r\n        permanent: false\r\n      }, true);\r\n    }\r\n\r\n    return _FeatureManager__WEBPACK_IMPORTED_MODULE_1__[\"FeatureManager\"].prototype.onRemove.call(this, map);\r\n  },\r\n\r\n  createNewLayer: function (geojson) {\r\n    var layer = leaflet__WEBPACK_IMPORTED_MODULE_0__[\"GeoJSON\"].geometryToLayer(geojson, this.options);\r\n    // trap for GeoJSON without geometry\r\n    if (layer) {\r\n      layer.defaultOptions = layer.options;\r\n    }\r\n    return layer;\r\n  },\r\n\r\n  _updateLayer: function (layer, geojson) {\r\n    // convert the geojson coordinates into a Leaflet LatLng array/nested arrays\r\n    // pass it to setLatLngs to update layer geometries\r\n    var latlngs = [];\r\n    var coordsToLatLng = this.options.coordsToLatLng || leaflet__WEBPACK_IMPORTED_MODULE_0__[\"GeoJSON\"].coordsToLatLng;\r\n\r\n    // copy new attributes, if present\r\n    if (geojson.properties) {\r\n      layer.feature.properties = geojson.properties;\r\n    }\r\n\r\n    switch (geojson.geometry.type) {\r\n      case 'Point':\r\n        latlngs = leaflet__WEBPACK_IMPORTED_MODULE_0__[\"GeoJSON\"].coordsToLatLng(geojson.geometry.coordinates);\r\n        layer.setLatLng(latlngs);\r\n        break;\r\n      case 'LineString':\r\n        latlngs = leaflet__WEBPACK_IMPORTED_MODULE_0__[\"GeoJSON\"].coordsToLatLngs(geojson.geometry.coordinates, 0, coordsToLatLng);\r\n        layer.setLatLngs(latlngs);\r\n        break;\r\n      case 'MultiLineString':\r\n        latlngs = leaflet__WEBPACK_IMPORTED_MODULE_0__[\"GeoJSON\"].coordsToLatLngs(geojson.geometry.coordinates, 1, coordsToLatLng);\r\n        layer.setLatLngs(latlngs);\r\n        break;\r\n      case 'Polygon':\r\n        latlngs = leaflet__WEBPACK_IMPORTED_MODULE_0__[\"GeoJSON\"].coordsToLatLngs(geojson.geometry.coordinates, 1, coordsToLatLng);\r\n        layer.setLatLngs(latlngs);\r\n        break;\r\n      case 'MultiPolygon':\r\n        latlngs = leaflet__WEBPACK_IMPORTED_MODULE_0__[\"GeoJSON\"].coordsToLatLngs(geojson.geometry.coordinates, 2, coordsToLatLng);\r\n        layer.setLatLngs(latlngs);\r\n        break;\r\n    }\r\n  },\r\n\r\n  /**\r\n   * Feature Management Methods\r\n   */\r\n\r\n  createLayers: function (features) {\r\n    for (var i = features.length - 1; i >= 0; i--) {\r\n      var geojson = features[i];\r\n\r\n      var layer = this._layers[geojson.id];\r\n      var newLayer;\r\n\r\n      if (this._visibleZoom() && layer && !this._map.hasLayer(layer) && (!this.options.timeField || this._featureWithinTimeRange(geojson))) {\r\n        this._map.addLayer(layer);\r\n        this.fire('addfeature', {\r\n          feature: layer.feature\r\n        }, true);\r\n      }\r\n\r\n      // update geometry if necessary\r\n      if (layer && this.options.simplifyFactor > 0 && (layer.setLatLngs || layer.setLatLng)) {\r\n        this._updateLayer(layer, geojson);\r\n      }\r\n\r\n      if (!layer) {\r\n        newLayer = this.createNewLayer(geojson);\r\n\r\n        if (!newLayer) {\r\n          Object(_Util__WEBPACK_IMPORTED_MODULE_2__[\"warn\"])('invalid GeoJSON encountered');\r\n        } else {\r\n          newLayer.feature = geojson;\r\n\r\n          // bubble events from individual layers to the feature layer\r\n          newLayer.addEventParent(this);\r\n\r\n          if (this.options.onEachFeature) {\r\n            this.options.onEachFeature(newLayer.feature, newLayer);\r\n          }\r\n\r\n          // cache the layer\r\n          this._layers[newLayer.feature.id] = newLayer;\r\n\r\n          // style the layer\r\n          this.setFeatureStyle(newLayer.feature.id, this.options.style);\r\n\r\n          this.fire('createfeature', {\r\n            feature: newLayer.feature\r\n          }, true);\r\n\r\n          // add the layer if the current zoom level is inside the range defined for the layer, it is within the current time bounds or our layer is not time enabled\r\n          if (this._visibleZoom() && (!this.options.timeField || (this.options.timeField && this._featureWithinTimeRange(geojson)))) {\r\n            this._map.addLayer(newLayer);\r\n          }\r\n        }\r\n      }\r\n    }\r\n  },\r\n\r\n  addLayers: function (ids) {\r\n    for (var i = ids.length - 1; i >= 0; i--) {\r\n      var layer = this._layers[ids[i]];\r\n      if (layer && (!this.options.timeField || this._featureWithinTimeRange(layer.feature))) {\r\n        this._map.addLayer(layer);\r\n      }\r\n    }\r\n  },\r\n\r\n  removeLayers: function (ids, permanent) {\r\n    for (var i = ids.length - 1; i >= 0; i--) {\r\n      var id = ids[i];\r\n      var layer = this._layers[id];\r\n      if (layer) {\r\n        this.fire('removefeature', {\r\n          feature: layer.feature,\r\n          permanent: permanent\r\n        }, true);\r\n        this._map.removeLayer(layer);\r\n      }\r\n      if (layer && permanent) {\r\n        delete this._layers[id];\r\n      }\r\n    }\r\n  },\r\n\r\n  cellEnter: function (bounds, coords) {\r\n    if (this._visibleZoom() && !this._zooming && this._map) {\r\n      leaflet__WEBPACK_IMPORTED_MODULE_0__[\"Util\"].requestAnimFrame(leaflet__WEBPACK_IMPORTED_MODULE_0__[\"Util\"].bind(function () {\r\n        var cacheKey = this._cacheKey(coords);\r\n        var cellKey = this._cellCoordsToKey(coords);\r\n        var layers = this._cache[cacheKey];\r\n        if (this._activeCells[cellKey] && layers) {\r\n          this.addLayers(layers);\r\n        }\r\n      }, this));\r\n    }\r\n  },\r\n\r\n  cellLeave: function (bounds, coords) {\r\n    if (!this._zooming) {\r\n      leaflet__WEBPACK_IMPORTED_MODULE_0__[\"Util\"].requestAnimFrame(leaflet__WEBPACK_IMPORTED_MODULE_0__[\"Util\"].bind(function () {\r\n        if (this._map) {\r\n          var cacheKey = this._cacheKey(coords);\r\n          var cellKey = this._cellCoordsToKey(coords);\r\n          var layers = this._cache[cacheKey];\r\n          var mapBounds = this._map.getBounds();\r\n          if (!this._activeCells[cellKey] && layers) {\r\n            var removable = true;\r\n\r\n            for (var i = 0; i < layers.length; i++) {\r\n              var layer = this._layers[layers[i]];\r\n              if (layer && layer.getBounds && mapBounds.intersects(layer.getBounds())) {\r\n                removable = false;\r\n              }\r\n            }\r\n\r\n            if (removable) {\r\n              this.removeLayers(layers, !this.options.cacheLayers);\r\n            }\r\n\r\n            if (!this.options.cacheLayers && removable) {\r\n              delete this._cache[cacheKey];\r\n              delete this._cells[cellKey];\r\n              delete this._activeCells[cellKey];\r\n            }\r\n          }\r\n        }\r\n      }, this));\r\n    }\r\n  },\r\n\r\n  /**\r\n   * Styling Methods\r\n   */\r\n\r\n  resetStyle: function () {\r\n    this.options.style = this._originalStyle;\r\n    this.eachFeature(function (layer) {\r\n      this.resetFeatureStyle(layer.feature.id);\r\n    }, this);\r\n    return this;\r\n  },\r\n\r\n  setStyle: function (style) {\r\n    this.options.style = style;\r\n    this.eachFeature(function (layer) {\r\n      this.setFeatureStyle(layer.feature.id, style);\r\n    }, this);\r\n    return this;\r\n  },\r\n\r\n  resetFeatureStyle: function (id) {\r\n    var layer = this._layers[id];\r\n    var style = this._originalStyle || leaflet__WEBPACK_IMPORTED_MODULE_0__[\"Path\"].prototype.options;\r\n    if (layer) {\r\n      leaflet__WEBPACK_IMPORTED_MODULE_0__[\"Util\"].extend(layer.options, layer.defaultOptions);\r\n      this.setFeatureStyle(id, style);\r\n    }\r\n    return this;\r\n  },\r\n\r\n  setFeatureStyle: function (id, style) {\r\n    var layer = this._layers[id];\r\n    if (typeof style === 'function') {\r\n      style = style(layer.feature);\r\n    }\r\n    if (layer.setStyle) {\r\n      layer.setStyle(style);\r\n    }\r\n    return this;\r\n  },\r\n\r\n  /**\r\n   * Utility Methods\r\n   */\r\n\r\n  eachActiveFeature: function (fn, context) {\r\n    // figure out (roughly) which layers are in view\r\n    if (this._map) {\r\n      var activeBounds = this._map.getBounds();\r\n      for (var i in this._layers) {\r\n        if (this._currentSnapshot.indexOf(this._layers[i].feature.id) !== -1) {\r\n          // a simple point in poly test for point geometries\r\n          if (typeof this._layers[i].getLatLng === 'function' && activeBounds.contains(this._layers[i].getLatLng())) {\r\n            fn.call(context, this._layers[i]);\r\n          } else if (typeof this._layers[i].getBounds === 'function' && activeBounds.intersects(this._layers[i].getBounds())) {\r\n            // intersecting bounds check for polyline and polygon geometries\r\n            fn.call(context, this._layers[i]);\r\n          }\r\n        }\r\n      }\r\n    }\r\n    return this;\r\n  },\r\n\r\n  eachFeature: function (fn, context) {\r\n    for (var i in this._layers) {\r\n      fn.call(context, this._layers[i]);\r\n    }\r\n    return this;\r\n  },\r\n\r\n  getFeature: function (id) {\r\n    return this._layers[id];\r\n  },\r\n\r\n  bringToBack: function () {\r\n    this.eachFeature(function (layer) {\r\n      if (layer.bringToBack) {\r\n        layer.bringToBack();\r\n      }\r\n    });\r\n  },\r\n\r\n  bringToFront: function () {\r\n    this.eachFeature(function (layer) {\r\n      if (layer.bringToFront) {\r\n        layer.bringToFront();\r\n      }\r\n    });\r\n  },\r\n\r\n  redraw: function (id) {\r\n    if (id) {\r\n      this._redraw(id);\r\n    }\r\n    return this;\r\n  },\r\n\r\n  _redraw: function (id) {\r\n    var layer = this._layers[id];\r\n    var geojson = layer.feature;\r\n\r\n    // if this looks like a marker\r\n    if (layer && layer.setIcon && this.options.pointToLayer) {\r\n      // update custom symbology, if necessary\r\n      if (this.options.pointToLayer) {\r\n        var getIcon = this.options.pointToLayer(geojson, Object(leaflet__WEBPACK_IMPORTED_MODULE_0__[\"latLng\"])(geojson.geometry.coordinates[1], geojson.geometry.coordinates[0]));\r\n        var updatedIcon = getIcon.options.icon;\r\n        layer.setIcon(updatedIcon);\r\n      }\r\n    }\r\n\r\n    // looks like a vector marker (circleMarker)\r\n    if (layer && layer.setStyle && this.options.pointToLayer) {\r\n      var getStyle = this.options.pointToLayer(geojson, Object(leaflet__WEBPACK_IMPORTED_MODULE_0__[\"latLng\"])(geojson.geometry.coordinates[1], geojson.geometry.coordinates[0]));\r\n      var updatedStyle = getStyle.options;\r\n      this.setFeatureStyle(geojson.id, updatedStyle);\r\n    }\r\n\r\n    // looks like a path (polygon/polyline)\r\n    if (layer && layer.setStyle && this.options.style) {\r\n      this.resetStyle(geojson.id);\r\n    }\r\n  }\r\n});\r\n\r\nfunction featureLayer (options) {\r\n  return new FeatureLayer(options);\r\n}\r\n\r\n/* harmony default export */ __webpack_exports__[\"default\"] = (featureLayer);\r\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///./node_modules/esri-leaflet/src/Layers/FeatureLayer/FeatureLayer.js\n");

/***/ }),

/***/ "./node_modules/esri-leaflet/src/Layers/FeatureLayer/FeatureManager.js":
/*!*****************************************************************************!*\
  !*** ./node_modules/esri-leaflet/src/Layers/FeatureLayer/FeatureManager.js ***!
  \*****************************************************************************/
/*! exports provided: FeatureManager */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"FeatureManager\", function() { return FeatureManager; });\n/* harmony import */ var leaflet__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! leaflet */ \"./node_modules/leaflet/dist/leaflet-src.js\");\n/* harmony import */ var leaflet__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(leaflet__WEBPACK_IMPORTED_MODULE_0__);\n/* harmony import */ var _Services_FeatureLayerService__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../Services/FeatureLayerService */ \"./node_modules/esri-leaflet/src/Services/FeatureLayerService.js\");\n/* harmony import */ var _Util__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../Util */ \"./node_modules/esri-leaflet/src/Util.js\");\n/* harmony import */ var _FeatureGrid__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./FeatureGrid */ \"./node_modules/esri-leaflet/src/Layers/FeatureLayer/FeatureGrid.js\");\n/* harmony import */ var tiny_binary_search__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! tiny-binary-search */ \"./node_modules/tiny-binary-search/index.js\");\n\r\n\r\n\r\n\r\n\r\n\r\nvar FeatureManager = _FeatureGrid__WEBPACK_IMPORTED_MODULE_3__[\"FeatureGrid\"].extend({\r\n  /**\r\n   * Options\r\n   */\r\n\r\n  options: {\r\n    attribution: null,\r\n    where: '1=1',\r\n    fields: ['*'],\r\n    from: false,\r\n    to: false,\r\n    timeField: false,\r\n    timeFilterMode: 'server',\r\n    simplifyFactor: 0,\r\n    precision: 6,\r\n    fetchAllFeatures: false\r\n  },\r\n\r\n  /**\r\n   * Constructor\r\n   */\r\n\r\n  initialize: function (options) {\r\n    _FeatureGrid__WEBPACK_IMPORTED_MODULE_3__[\"FeatureGrid\"].prototype.initialize.call(this, options);\r\n\r\n    options = Object(_Util__WEBPACK_IMPORTED_MODULE_2__[\"getUrlParams\"])(options);\r\n    options = leaflet__WEBPACK_IMPORTED_MODULE_0__[\"Util\"].setOptions(this, options);\r\n\r\n    this.service = Object(_Services_FeatureLayerService__WEBPACK_IMPORTED_MODULE_1__[\"default\"])(options);\r\n    this.service.addEventParent(this);\r\n\r\n    // use case insensitive regex to look for common fieldnames used for indexing\r\n    if (this.options.fields[0] !== '*') {\r\n      var oidCheck = false;\r\n      for (var i = 0; i < this.options.fields.length; i++) {\r\n        if (this.options.fields[i].match(/^(OBJECTID|FID|OID|ID)$/i)) {\r\n          oidCheck = true;\r\n        }\r\n      }\r\n      if (oidCheck === false) {\r\n        Object(_Util__WEBPACK_IMPORTED_MODULE_2__[\"warn\"])(\r\n          'no known esriFieldTypeOID field detected in fields Array.  Please add an attribute field containing unique IDs to ensure the layer can be drawn correctly.'\r\n        );\r\n      }\r\n    }\r\n\r\n    if (this.options.timeField.start && this.options.timeField.end) {\r\n      this._startTimeIndex = new tiny_binary_search__WEBPACK_IMPORTED_MODULE_4__[\"default\"]();\r\n      this._endTimeIndex = new tiny_binary_search__WEBPACK_IMPORTED_MODULE_4__[\"default\"]();\r\n    } else if (this.options.timeField) {\r\n      this._timeIndex = new tiny_binary_search__WEBPACK_IMPORTED_MODULE_4__[\"default\"]();\r\n    }\r\n\r\n    this._cache = {};\r\n    this._currentSnapshot = []; // cache of what layers should be active\r\n    this._activeRequests = 0;\r\n  },\r\n\r\n  /**\r\n   * Layer Interface\r\n   */\r\n\r\n  onAdd: function (map) {\r\n    // include 'Powered by Esri' in map attribution\r\n    Object(_Util__WEBPACK_IMPORTED_MODULE_2__[\"setEsriAttribution\"])(map);\r\n\r\n    this.service.metadata(function (err, metadata) {\r\n      if (!err) {\r\n        var supportedFormats = metadata.supportedQueryFormats;\r\n\r\n        // Check if someone has requested that we don't use geoJSON, even if it's available\r\n        var forceJsonFormat = false;\r\n        if (this.service.options.isModern === false || this.options.fetchAllFeatures) {\r\n          forceJsonFormat = true;\r\n        }\r\n\r\n        // Unless we've been told otherwise, check to see whether service can emit GeoJSON natively\r\n        if (\r\n          !forceJsonFormat &&\r\n          supportedFormats &&\r\n          supportedFormats.indexOf('geoJSON') !== -1\r\n        ) {\r\n          this.service.options.isModern = true;\r\n        }\r\n\r\n        if (metadata.objectIdField) {\r\n          this.service.options.idAttribute = metadata.objectIdField;\r\n        }\r\n\r\n        // add copyright text listed in service metadata\r\n        if (\r\n          !this.options.attribution &&\r\n          map.attributionControl &&\r\n          metadata.copyrightText\r\n        ) {\r\n          this.options.attribution = metadata.copyrightText;\r\n          map.attributionControl.addAttribution(this.getAttribution());\r\n        }\r\n      }\r\n    }, this);\r\n\r\n    map.on('zoomend', this._handleZoomChange, this);\r\n\r\n    return _FeatureGrid__WEBPACK_IMPORTED_MODULE_3__[\"FeatureGrid\"].prototype.onAdd.call(this, map);\r\n  },\r\n\r\n  onRemove: function (map) {\r\n    Object(_Util__WEBPACK_IMPORTED_MODULE_2__[\"removeEsriAttribution\"])(map);\r\n    map.off('zoomend', this._handleZoomChange, this);\r\n\r\n    return _FeatureGrid__WEBPACK_IMPORTED_MODULE_3__[\"FeatureGrid\"].prototype.onRemove.call(this, map);\r\n  },\r\n\r\n  getAttribution: function () {\r\n    return this.options.attribution;\r\n  },\r\n\r\n  /**\r\n   * Feature Management\r\n   */\r\n\r\n  createCell: function (bounds, coords) {\r\n    // dont fetch features outside the scale range defined for the layer\r\n    if (this._visibleZoom()) {\r\n      this._requestFeatures(bounds, coords);\r\n    }\r\n  },\r\n\r\n  _requestFeatures: function (bounds, coords, callback, offset) {\r\n    this._activeRequests++;\r\n\r\n    // default param\r\n    offset = offset || 0;\r\n\r\n    var originalWhere = this.options.where;\r\n\r\n    // our first active request fires loading\r\n    if (this._activeRequests === 1) {\r\n      this.fire(\r\n        'loading',\r\n        {\r\n          bounds: bounds\r\n        },\r\n        true\r\n      );\r\n    }\r\n\r\n    return this._buildQuery(bounds, offset).run(function (\r\n      error,\r\n      featureCollection,\r\n      response\r\n    ) {\r\n      if (response && response.exceededTransferLimit) {\r\n        this.fire('drawlimitexceeded');\r\n      }\r\n\r\n      // the where changed while this request was being run so don't it.\r\n      if (this.options.where !== originalWhere) {\r\n        return;\r\n      }\r\n\r\n      // no error, features\r\n      if (!error && featureCollection && featureCollection.features.length) {\r\n        // schedule adding features until the next animation frame\r\n        leaflet__WEBPACK_IMPORTED_MODULE_0__[\"Util\"].requestAnimFrame(\r\n          leaflet__WEBPACK_IMPORTED_MODULE_0__[\"Util\"].bind(function () {\r\n            this._addFeatures(featureCollection.features, coords);\r\n            this._postProcessFeatures(bounds);\r\n          }, this)\r\n        );\r\n      }\r\n\r\n      // no error, no features\r\n      if (!error && featureCollection && !featureCollection.features.length) {\r\n        this._postProcessFeatures(bounds);\r\n      }\r\n\r\n      if (error) {\r\n        this._postProcessFeatures(bounds);\r\n      }\r\n\r\n      if (callback) {\r\n        callback.call(this, error, featureCollection);\r\n      }\r\n      if (response && (response.exceededTransferLimit || (response.properties && response.properties.exceededTransferLimit)) && this.options.fetchAllFeatures) {\r\n        this._requestFeatures(bounds, coords, callback, offset + featureCollection.features.length);\r\n      }\r\n    },\r\n      this);\r\n  },\r\n\r\n  _postProcessFeatures: function (bounds) {\r\n    // deincrement the request counter now that we have processed features\r\n    this._activeRequests--;\r\n\r\n    // if there are no more active requests fire a load event for this view\r\n    if (this._activeRequests <= 0) {\r\n      this.fire('load', {\r\n        bounds: bounds\r\n      });\r\n    }\r\n  },\r\n\r\n  _cacheKey: function (coords) {\r\n    return coords.z + ':' + coords.x + ':' + coords.y;\r\n  },\r\n\r\n  _addFeatures: function (features, coords) {\r\n    // coords is optional - will be false if coming from addFeatures() function\r\n    if (coords) {\r\n      var key = this._cacheKey(coords);\r\n      this._cache[key] = this._cache[key] || [];\r\n    }\r\n\r\n    for (var i = features.length - 1; i >= 0; i--) {\r\n      var id = features[i].id;\r\n\r\n      if (this._currentSnapshot.indexOf(id) === -1) {\r\n        this._currentSnapshot.push(id);\r\n      }\r\n      if (typeof key !== 'undefined' && this._cache[key].indexOf(id) === -1) {\r\n        this._cache[key].push(id);\r\n      }\r\n    }\r\n\r\n    if (this.options.timeField) {\r\n      this._buildTimeIndexes(features);\r\n    }\r\n\r\n    this.createLayers(features);\r\n  },\r\n\r\n  _buildQuery: function (bounds, offset) {\r\n    var query = this.service\r\n      .query()\r\n      .intersects(bounds)\r\n      .where(this.options.where)\r\n      .fields(this.options.fields)\r\n      .precision(this.options.precision);\r\n\r\n    if (this.options.fetchAllFeatures && !isNaN(parseInt(offset))) {\r\n      query = query.offset(offset);\r\n    }\r\n\r\n    query.params['resultType'] = 'tile';\r\n\r\n    if (this.options.requestParams) {\r\n      leaflet__WEBPACK_IMPORTED_MODULE_0__[\"Util\"].extend(query.params, this.options.requestParams);\r\n    }\r\n\r\n    if (this.options.simplifyFactor) {\r\n      query.simplify(this._map, this.options.simplifyFactor);\r\n    }\r\n\r\n    if (\r\n      this.options.timeFilterMode === 'server' &&\r\n      this.options.from &&\r\n      this.options.to\r\n    ) {\r\n      query.between(this.options.from, this.options.to);\r\n    }\r\n\r\n    return query;\r\n  },\r\n\r\n  /**\r\n   * Where Methods\r\n   */\r\n\r\n  setWhere: function (where, callback, context) {\r\n    this.options.where = where && where.length ? where : '1=1';\r\n\r\n    var oldSnapshot = [];\r\n    var newSnapshot = [];\r\n    var pendingRequests = 0;\r\n    var requestError = null;\r\n    var requestCallback = leaflet__WEBPACK_IMPORTED_MODULE_0__[\"Util\"].bind(function (error, featureCollection) {\r\n      if (error) {\r\n        requestError = error;\r\n      }\r\n\r\n      if (featureCollection) {\r\n        for (var i = featureCollection.features.length - 1; i >= 0; i--) {\r\n          newSnapshot.push(featureCollection.features[i].id);\r\n        }\r\n      }\r\n\r\n      pendingRequests--;\r\n\r\n      if (\r\n        pendingRequests <= 0 &&\r\n        this._visibleZoom() &&\r\n        where === this.options.where // the where is still the same so use this one\r\n      ) {\r\n        this._currentSnapshot = newSnapshot;\r\n        // schedule adding features for the next animation frame\r\n        leaflet__WEBPACK_IMPORTED_MODULE_0__[\"Util\"].requestAnimFrame(\r\n          leaflet__WEBPACK_IMPORTED_MODULE_0__[\"Util\"].bind(function () {\r\n            this.removeLayers(oldSnapshot);\r\n            this.addLayers(newSnapshot);\r\n            if (callback) {\r\n              callback.call(context, requestError);\r\n            }\r\n          }, this)\r\n        );\r\n      }\r\n    }, this);\r\n\r\n    for (var i = this._currentSnapshot.length - 1; i >= 0; i--) {\r\n      oldSnapshot.push(this._currentSnapshot[i]);\r\n    }\r\n\r\n    this._cache = {};\r\n\r\n    for (var key in this._cells) {\r\n      pendingRequests++;\r\n      var coords = this._keyToCellCoords(key);\r\n      var bounds = this._cellCoordsToBounds(coords);\r\n      this._requestFeatures(bounds, coords, requestCallback);\r\n    }\r\n\r\n    return this;\r\n  },\r\n\r\n  getWhere: function () {\r\n    return this.options.where;\r\n  },\r\n\r\n  /**\r\n   * Time Range Methods\r\n   */\r\n\r\n  getTimeRange: function () {\r\n    return [this.options.from, this.options.to];\r\n  },\r\n\r\n  setTimeRange: function (from, to, callback, context) {\r\n    var oldFrom = this.options.from;\r\n    var oldTo = this.options.to;\r\n    var pendingRequests = 0;\r\n    var requestError = null;\r\n    var requestCallback = leaflet__WEBPACK_IMPORTED_MODULE_0__[\"Util\"].bind(function (error) {\r\n      if (error) {\r\n        requestError = error;\r\n      }\r\n      this._filterExistingFeatures(oldFrom, oldTo, from, to);\r\n\r\n      pendingRequests--;\r\n\r\n      if (callback && pendingRequests <= 0) {\r\n        callback.call(context, requestError);\r\n      }\r\n    }, this);\r\n\r\n    this.options.from = from;\r\n    this.options.to = to;\r\n\r\n    this._filterExistingFeatures(oldFrom, oldTo, from, to);\r\n\r\n    if (this.options.timeFilterMode === 'server') {\r\n      for (var key in this._cells) {\r\n        pendingRequests++;\r\n        var coords = this._keyToCellCoords(key);\r\n        var bounds = this._cellCoordsToBounds(coords);\r\n        this._requestFeatures(bounds, coords, requestCallback);\r\n      }\r\n    }\r\n\r\n    return this;\r\n  },\r\n\r\n  refresh: function () {\r\n    this.setWhere(this.options.where);\r\n  },\r\n\r\n  _filterExistingFeatures: function (oldFrom, oldTo, newFrom, newTo) {\r\n    var layersToRemove =\r\n      oldFrom && oldTo\r\n        ? this._getFeaturesInTimeRange(oldFrom, oldTo)\r\n        : this._currentSnapshot;\r\n    var layersToAdd = this._getFeaturesInTimeRange(newFrom, newTo);\r\n\r\n    if (layersToAdd.indexOf) {\r\n      for (var i = 0; i < layersToAdd.length; i++) {\r\n        var shouldRemoveLayer = layersToRemove.indexOf(layersToAdd[i]);\r\n        if (shouldRemoveLayer >= 0) {\r\n          layersToRemove.splice(shouldRemoveLayer, 1);\r\n        }\r\n      }\r\n    }\r\n\r\n    // schedule adding features until the next animation frame\r\n    leaflet__WEBPACK_IMPORTED_MODULE_0__[\"Util\"].requestAnimFrame(\r\n      leaflet__WEBPACK_IMPORTED_MODULE_0__[\"Util\"].bind(function () {\r\n        this.removeLayers(layersToRemove);\r\n        this.addLayers(layersToAdd);\r\n      }, this)\r\n    );\r\n  },\r\n\r\n  _getFeaturesInTimeRange: function (start, end) {\r\n    var ids = [];\r\n    var search;\r\n\r\n    if (this.options.timeField.start && this.options.timeField.end) {\r\n      var startTimes = this._startTimeIndex.between(start, end);\r\n      var endTimes = this._endTimeIndex.between(start, end);\r\n      search = startTimes.concat(endTimes);\r\n    } else if (this._timeIndex) {\r\n      search = this._timeIndex.between(start, end);\r\n    } else {\r\n      Object(_Util__WEBPACK_IMPORTED_MODULE_2__[\"warn\"])(\r\n        'You must set timeField in the layer constructor in order to manipulate the start and end time filter.'\r\n      );\r\n      return [];\r\n    }\r\n\r\n    for (var i = search.length - 1; i >= 0; i--) {\r\n      ids.push(search[i].id);\r\n    }\r\n\r\n    return ids;\r\n  },\r\n\r\n  _buildTimeIndexes: function (geojson) {\r\n    var i;\r\n    var feature;\r\n    if (this.options.timeField.start && this.options.timeField.end) {\r\n      var startTimeEntries = [];\r\n      var endTimeEntries = [];\r\n      for (i = geojson.length - 1; i >= 0; i--) {\r\n        feature = geojson[i];\r\n        startTimeEntries.push({\r\n          id: feature.id,\r\n          value: new Date(feature.properties[this.options.timeField.start])\r\n        });\r\n        endTimeEntries.push({\r\n          id: feature.id,\r\n          value: new Date(feature.properties[this.options.timeField.end])\r\n        });\r\n      }\r\n      this._startTimeIndex.bulkAdd(startTimeEntries);\r\n      this._endTimeIndex.bulkAdd(endTimeEntries);\r\n    } else {\r\n      var timeEntries = [];\r\n      for (i = geojson.length - 1; i >= 0; i--) {\r\n        feature = geojson[i];\r\n        timeEntries.push({\r\n          id: feature.id,\r\n          value: new Date(feature.properties[this.options.timeField])\r\n        });\r\n      }\r\n\r\n      this._timeIndex.bulkAdd(timeEntries);\r\n    }\r\n  },\r\n\r\n  _featureWithinTimeRange: function (feature) {\r\n    if (!this.options.from || !this.options.to) {\r\n      return true;\r\n    }\r\n\r\n    var from = +this.options.from.valueOf();\r\n    var to = +this.options.to.valueOf();\r\n\r\n    if (typeof this.options.timeField === 'string') {\r\n      var date = +feature.properties[this.options.timeField];\r\n      return date >= from && date <= to;\r\n    }\r\n\r\n    if (this.options.timeField.start && this.options.timeField.end) {\r\n      var startDate = +feature.properties[this.options.timeField.start];\r\n      var endDate = +feature.properties[this.options.timeField.end];\r\n      return (\r\n        (startDate >= from && startDate <= to) ||\r\n        (endDate >= from && endDate <= to) ||\r\n        (startDate <= from && endDate >= to)\r\n      );\r\n    }\r\n  },\r\n\r\n  _visibleZoom: function () {\r\n    // check to see whether the current zoom level of the map is within the optional limit defined for the FeatureLayer\r\n    if (!this._map) {\r\n      return false;\r\n    }\r\n    var zoom = this._map.getZoom();\r\n    if (zoom > this.options.maxZoom || zoom < this.options.minZoom) {\r\n      return false;\r\n    } else {\r\n      return true;\r\n    }\r\n  },\r\n\r\n  _handleZoomChange: function () {\r\n    if (!this._visibleZoom()) {\r\n      this.removeLayers(this._currentSnapshot);\r\n    } else {\r\n      /*\r\n      for every cell in this._cells\r\n        1. Get the cache key for the coords of the cell\r\n        2. If this._cache[key] exists it will be an array of feature IDs.\r\n        3. Call this.addLayers(this._cache[key]) to instruct the feature layer to add the layers back.\r\n      */\r\n      for (var i in this._cells) {\r\n        var coords = this._cells[i].coords;\r\n        var key = this._cacheKey(coords);\r\n        if (this._cache[key]) {\r\n          this.addLayers(this._cache[key]);\r\n        }\r\n      }\r\n    }\r\n  },\r\n\r\n  /**\r\n   * Service Methods\r\n   */\r\n\r\n  authenticate: function (token) {\r\n    this.service.authenticate(token);\r\n    return this;\r\n  },\r\n\r\n  metadata: function (callback, context) {\r\n    this.service.metadata(callback, context);\r\n    return this;\r\n  },\r\n\r\n  query: function () {\r\n    return this.service.query();\r\n  },\r\n\r\n  _getMetadata: function (callback) {\r\n    if (this._metadata) {\r\n      var error;\r\n      callback(error, this._metadata);\r\n    } else {\r\n      this.metadata(\r\n        leaflet__WEBPACK_IMPORTED_MODULE_0__[\"Util\"].bind(function (error, response) {\r\n          this._metadata = response;\r\n          callback(error, this._metadata);\r\n        }, this)\r\n      );\r\n    }\r\n  },\r\n\r\n  addFeature: function (feature, callback, context) {\r\n    this.addFeatures(feature, callback, context);\r\n  },\r\n\r\n  addFeatures: function (features, callback, context) {\r\n    this._getMetadata(\r\n      leaflet__WEBPACK_IMPORTED_MODULE_0__[\"Util\"].bind(function (error, metadata) {\r\n        if (error) {\r\n          if (callback) {\r\n            callback.call(this, error, null);\r\n          }\r\n          return;\r\n        }\r\n        // GeoJSON featureCollection or simple feature\r\n        var featuresArray = features.features ? features.features : [features];\r\n\r\n        this.service.addFeatures(\r\n          features,\r\n          leaflet__WEBPACK_IMPORTED_MODULE_0__[\"Util\"].bind(function (error, response) {\r\n            if (!error) {\r\n              for (var i = featuresArray.length - 1; i >= 0; i--) {\r\n                // assign ID from result to appropriate objectid field from service metadata\r\n                featuresArray[i].properties[metadata.objectIdField] =\r\n                  featuresArray.length > 1\r\n                    ? response[i].objectId\r\n                    : response.objectId;\r\n                // we also need to update the geojson id for createLayers() to function\r\n                featuresArray[i].id =\r\n                  featuresArray.length > 1\r\n                    ? response[i].objectId\r\n                    : response.objectId;\r\n              }\r\n              this._addFeatures(featuresArray);\r\n            }\r\n\r\n            if (callback) {\r\n              callback.call(context, error, response);\r\n            }\r\n          }, this)\r\n        );\r\n      }, this)\r\n    );\r\n  },\r\n\r\n  updateFeature: function (feature, callback, context) {\r\n    this.updateFeatures(feature, callback, context);\r\n  },\r\n\r\n  updateFeatures: function (features, callback, context) {\r\n    // GeoJSON featureCollection or simple feature\r\n    var featuresArray = features.features ? features.features : [features];\r\n    this.service.updateFeatures(\r\n      features,\r\n      function (error, response) {\r\n        if (!error) {\r\n          for (var i = featuresArray.length - 1; i >= 0; i--) {\r\n            this.removeLayers([featuresArray[i].id], true);\r\n          }\r\n          this._addFeatures(featuresArray);\r\n        }\r\n\r\n        if (callback) {\r\n          callback.call(context, error, response);\r\n        }\r\n      },\r\n      this\r\n    );\r\n  },\r\n\r\n  deleteFeature: function (id, callback, context) {\r\n    this.deleteFeatures(id, callback, context);\r\n  },\r\n\r\n  deleteFeatures: function (ids, callback, context) {\r\n    return this.service.deleteFeatures(\r\n      ids,\r\n      function (error, response) {\r\n        var responseArray = response.length ? response : [response];\r\n        if (!error && responseArray.length > 0) {\r\n          for (var i = responseArray.length - 1; i >= 0; i--) {\r\n            this.removeLayers([responseArray[i].objectId], true);\r\n          }\r\n        }\r\n        if (callback) {\r\n          callback.call(context, error, response);\r\n        }\r\n      },\r\n      this\r\n    );\r\n  }\r\n});\r\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///./node_modules/esri-leaflet/src/Layers/FeatureLayer/FeatureManager.js\n");

/***/ }),

/***/ "./node_modules/esri-leaflet/src/Layers/ImageMapLayer.js":
/*!***************************************************************!*\
  !*** ./node_modules/esri-leaflet/src/Layers/ImageMapLayer.js ***!
  \***************************************************************/
/*! exports provided: ImageMapLayer, imageMapLayer, default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"ImageMapLayer\", function() { return ImageMapLayer; });\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"imageMapLayer\", function() { return imageMapLayer; });\n/* harmony import */ var leaflet__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! leaflet */ \"./node_modules/leaflet/dist/leaflet-src.js\");\n/* harmony import */ var leaflet__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(leaflet__WEBPACK_IMPORTED_MODULE_0__);\n/* harmony import */ var _RasterLayer__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./RasterLayer */ \"./node_modules/esri-leaflet/src/Layers/RasterLayer.js\");\n/* harmony import */ var _Util__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../Util */ \"./node_modules/esri-leaflet/src/Util.js\");\n/* harmony import */ var _Services_ImageService__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../Services/ImageService */ \"./node_modules/esri-leaflet/src/Services/ImageService.js\");\n\r\n\r\n\r\n\r\n\r\nvar ImageMapLayer = _RasterLayer__WEBPACK_IMPORTED_MODULE_1__[\"RasterLayer\"].extend({\r\n\r\n  options: {\r\n    updateInterval: 150,\r\n    format: 'jpgpng',\r\n    transparent: true,\r\n    f: 'image'\r\n  },\r\n\r\n  query: function () {\r\n    return this.service.query();\r\n  },\r\n\r\n  identify: function () {\r\n    return this.service.identify();\r\n  },\r\n\r\n  initialize: function (options) {\r\n    options = Object(_Util__WEBPACK_IMPORTED_MODULE_2__[\"getUrlParams\"])(options);\r\n    this.service = Object(_Services_ImageService__WEBPACK_IMPORTED_MODULE_3__[\"default\"])(options);\r\n    this.service.addEventParent(this);\r\n\r\n    leaflet__WEBPACK_IMPORTED_MODULE_0__[\"Util\"].setOptions(this, options);\r\n  },\r\n\r\n  setPixelType: function (pixelType) {\r\n    this.options.pixelType = pixelType;\r\n    this._update();\r\n    return this;\r\n  },\r\n\r\n  getPixelType: function () {\r\n    return this.options.pixelType;\r\n  },\r\n\r\n  setBandIds: function (bandIds) {\r\n    if (leaflet__WEBPACK_IMPORTED_MODULE_0__[\"Util\"].isArray(bandIds)) {\r\n      this.options.bandIds = bandIds.join(',');\r\n    } else {\r\n      this.options.bandIds = bandIds.toString();\r\n    }\r\n    this._update();\r\n    return this;\r\n  },\r\n\r\n  getBandIds: function () {\r\n    return this.options.bandIds;\r\n  },\r\n\r\n  setNoData: function (noData, noDataInterpretation) {\r\n    if (leaflet__WEBPACK_IMPORTED_MODULE_0__[\"Util\"].isArray(noData)) {\r\n      this.options.noData = noData.join(',');\r\n    } else {\r\n      this.options.noData = noData.toString();\r\n    }\r\n    if (noDataInterpretation) {\r\n      this.options.noDataInterpretation = noDataInterpretation;\r\n    }\r\n    this._update();\r\n    return this;\r\n  },\r\n\r\n  getNoData: function () {\r\n    return this.options.noData;\r\n  },\r\n\r\n  getNoDataInterpretation: function () {\r\n    return this.options.noDataInterpretation;\r\n  },\r\n\r\n  setRenderingRule: function (renderingRule) {\r\n    this.options.renderingRule = renderingRule;\r\n    this._update();\r\n  },\r\n\r\n  getRenderingRule: function () {\r\n    return this.options.renderingRule;\r\n  },\r\n\r\n  setMosaicRule: function (mosaicRule) {\r\n    this.options.mosaicRule = mosaicRule;\r\n    this._update();\r\n  },\r\n\r\n  getMosaicRule: function () {\r\n    return this.options.mosaicRule;\r\n  },\r\n\r\n  _getPopupData: function (e) {\r\n    var callback = leaflet__WEBPACK_IMPORTED_MODULE_0__[\"Util\"].bind(function (error, results, response) {\r\n      if (error) { return; } // we really can't do anything here but authenticate or requesterror will fire\r\n      setTimeout(leaflet__WEBPACK_IMPORTED_MODULE_0__[\"Util\"].bind(function () {\r\n        this._renderPopup(e.latlng, error, results, response);\r\n      }, this), 300);\r\n    }, this);\r\n\r\n    var identifyRequest = this.identify().at(e.latlng);\r\n\r\n    // set mosaic rule for identify task if it is set for layer\r\n    if (this.options.mosaicRule) {\r\n      identifyRequest.setMosaicRule(this.options.mosaicRule);\r\n      // @TODO: force return catalog items too?\r\n    }\r\n\r\n    // @TODO: set rendering rule? Not sure,\r\n    // sometimes you want raw pixel values\r\n    // if (this.options.renderingRule) {\r\n    //   identifyRequest.setRenderingRule(this.options.renderingRule);\r\n    // }\r\n\r\n    identifyRequest.run(callback);\r\n\r\n    // set the flags to show the popup\r\n    this._shouldRenderPopup = true;\r\n    this._lastClick = e.latlng;\r\n  },\r\n\r\n  _buildExportParams: function () {\r\n    var sr = parseInt(this._map.options.crs.code.split(':')[1], 10);\r\n\r\n    var params = {\r\n      bbox: this._calculateBbox(),\r\n      size: this._calculateImageSize(),\r\n      format: this.options.format,\r\n      transparent: this.options.transparent,\r\n      bboxSR: sr,\r\n      imageSR: sr\r\n    };\r\n\r\n    if (this.options.from && this.options.to) {\r\n      params.time = this.options.from.valueOf() + ',' + this.options.to.valueOf();\r\n    }\r\n\r\n    if (this.options.pixelType) {\r\n      params.pixelType = this.options.pixelType;\r\n    }\r\n\r\n    if (this.options.interpolation) {\r\n      params.interpolation = this.options.interpolation;\r\n    }\r\n\r\n    if (this.options.compressionQuality) {\r\n      params.compressionQuality = this.options.compressionQuality;\r\n    }\r\n\r\n    if (this.options.bandIds) {\r\n      params.bandIds = this.options.bandIds;\r\n    }\r\n\r\n    // 0 is falsy *and* a valid input parameter\r\n    if (this.options.noData === 0 || this.options.noData) {\r\n      params.noData = this.options.noData;\r\n    }\r\n\r\n    if (this.options.noDataInterpretation) {\r\n      params.noDataInterpretation = this.options.noDataInterpretation;\r\n    }\r\n\r\n    if (this.service.options.token) {\r\n      params.token = this.service.options.token;\r\n    }\r\n\r\n    if (this.options.renderingRule) {\r\n      params.renderingRule = JSON.stringify(this.options.renderingRule);\r\n    }\r\n\r\n    if (this.options.mosaicRule) {\r\n      params.mosaicRule = JSON.stringify(this.options.mosaicRule);\r\n    }\r\n\r\n    return params;\r\n  },\r\n\r\n  _requestExport: function (params, bounds) {\r\n    if (this.options.f === 'json') {\r\n      this.service.request('exportImage', params, function (error, response) {\r\n        if (error) { return; } // we really can't do anything here but authenticate or requesterror will fire\r\n        if (this.options.token) {\r\n          response.href += ('?token=' + this.options.token);\r\n        }\r\n        if (this.options.proxy) {\r\n          response.href = this.options.proxy + '?' + response.href;\r\n        }\r\n        this._renderImage(response.href, bounds);\r\n      }, this);\r\n    } else {\r\n      params.f = 'image';\r\n      var fullUrl = this.options.url + 'exportImage' + leaflet__WEBPACK_IMPORTED_MODULE_0__[\"Util\"].getParamString(params);\r\n      if (this.options.proxy) {\r\n        fullUrl = this.options.proxy + '?' + fullUrl;\r\n      }\r\n      this._renderImage(fullUrl, bounds);\r\n    }\r\n  }\r\n});\r\n\r\nfunction imageMapLayer (url, options) {\r\n  return new ImageMapLayer(url, options);\r\n}\r\n\r\n/* harmony default export */ __webpack_exports__[\"default\"] = (imageMapLayer);\r\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///./node_modules/esri-leaflet/src/Layers/ImageMapLayer.js\n");

/***/ }),

/***/ "./node_modules/esri-leaflet/src/Layers/RasterLayer.js":
/*!*************************************************************!*\
  !*** ./node_modules/esri-leaflet/src/Layers/RasterLayer.js ***!
  \*************************************************************/
/*! exports provided: RasterLayer */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"RasterLayer\", function() { return RasterLayer; });\n/* harmony import */ var leaflet__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! leaflet */ \"./node_modules/leaflet/dist/leaflet-src.js\");\n/* harmony import */ var leaflet__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(leaflet__WEBPACK_IMPORTED_MODULE_0__);\n/* harmony import */ var _Support__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../Support */ \"./node_modules/esri-leaflet/src/Support.js\");\n/* harmony import */ var _Util__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../Util */ \"./node_modules/esri-leaflet/src/Util.js\");\n\r\n\r\n\r\n\r\nvar Overlay = leaflet__WEBPACK_IMPORTED_MODULE_0__[\"ImageOverlay\"].extend({\r\n  onAdd: function (map) {\r\n    this._topLeft = map.getPixelBounds().min;\r\n    leaflet__WEBPACK_IMPORTED_MODULE_0__[\"ImageOverlay\"].prototype.onAdd.call(this, map);\r\n  },\r\n  _reset: function () {\r\n    if (this._map.options.crs === leaflet__WEBPACK_IMPORTED_MODULE_0__[\"CRS\"].EPSG3857) {\r\n      leaflet__WEBPACK_IMPORTED_MODULE_0__[\"ImageOverlay\"].prototype._reset.call(this);\r\n    } else {\r\n      leaflet__WEBPACK_IMPORTED_MODULE_0__[\"DomUtil\"].setPosition(this._image, this._topLeft.subtract(this._map.getPixelOrigin()));\r\n    }\r\n  }\r\n});\r\n\r\nvar RasterLayer = leaflet__WEBPACK_IMPORTED_MODULE_0__[\"Layer\"].extend({\r\n  options: {\r\n    opacity: 1,\r\n    position: 'front',\r\n    f: 'image',\r\n    useCors: _Support__WEBPACK_IMPORTED_MODULE_1__[\"cors\"],\r\n    attribution: null,\r\n    interactive: false,\r\n    alt: ''\r\n  },\r\n\r\n  onAdd: function (map) {\r\n    // include 'Powered by Esri' in map attribution\r\n    Object(_Util__WEBPACK_IMPORTED_MODULE_2__[\"setEsriAttribution\"])(map);\r\n\r\n    if (this.options.zIndex) {\r\n      this.options.position = null;\r\n    }\r\n\r\n    this._update = leaflet__WEBPACK_IMPORTED_MODULE_0__[\"Util\"].throttle(this._update, this.options.updateInterval, this);\r\n\r\n    map.on('moveend', this._update, this);\r\n\r\n    // if we had an image loaded and it matches the\r\n    // current bounds show the image otherwise remove it\r\n    if (this._currentImage && this._currentImage._bounds.equals(this._map.getBounds())) {\r\n      map.addLayer(this._currentImage);\r\n    } else if (this._currentImage) {\r\n      this._map.removeLayer(this._currentImage);\r\n      this._currentImage = null;\r\n    }\r\n\r\n    this._update();\r\n\r\n    if (this._popup) {\r\n      this._map.on('click', this._getPopupData, this);\r\n      this._map.on('dblclick', this._resetPopupState, this);\r\n    }\r\n\r\n    // add copyright text listed in service metadata\r\n    this.metadata(function (err, metadata) {\r\n      if (!err && !this.options.attribution && map.attributionControl && metadata.copyrightText) {\r\n        this.options.attribution = metadata.copyrightText;\r\n        map.attributionControl.addAttribution(this.getAttribution());\r\n      }\r\n    }, this);\r\n  },\r\n\r\n  onRemove: function (map) {\r\n    Object(_Util__WEBPACK_IMPORTED_MODULE_2__[\"removeEsriAttribution\"])(map);\r\n\r\n    if (this._currentImage) {\r\n      this._map.removeLayer(this._currentImage);\r\n    }\r\n\r\n    if (this._popup) {\r\n      this._map.off('click', this._getPopupData, this);\r\n      this._map.off('dblclick', this._resetPopupState, this);\r\n    }\r\n\r\n    this._map.off('moveend', this._update, this);\r\n  },\r\n\r\n  bindPopup: function (fn, popupOptions) {\r\n    this._shouldRenderPopup = false;\r\n    this._lastClick = false;\r\n    this._popup = Object(leaflet__WEBPACK_IMPORTED_MODULE_0__[\"popup\"])(popupOptions);\r\n    this._popupFunction = fn;\r\n    if (this._map) {\r\n      this._map.on('click', this._getPopupData, this);\r\n      this._map.on('dblclick', this._resetPopupState, this);\r\n    }\r\n    return this;\r\n  },\r\n\r\n  unbindPopup: function () {\r\n    if (this._map) {\r\n      this._map.closePopup(this._popup);\r\n      this._map.off('click', this._getPopupData, this);\r\n      this._map.off('dblclick', this._resetPopupState, this);\r\n    }\r\n    this._popup = false;\r\n    return this;\r\n  },\r\n\r\n  bringToFront: function () {\r\n    this.options.position = 'front';\r\n    if (this._currentImage) {\r\n      this._currentImage.bringToFront();\r\n      this._setAutoZIndex(Math.max);\r\n    }\r\n    return this;\r\n  },\r\n\r\n  bringToBack: function () {\r\n    this.options.position = 'back';\r\n    if (this._currentImage) {\r\n      this._currentImage.bringToBack();\r\n      this._setAutoZIndex(Math.min);\r\n    }\r\n    return this;\r\n  },\r\n\r\n  setZIndex: function (value) {\r\n    this.options.zIndex = value;\r\n    if (this._currentImage) {\r\n      this._currentImage.setZIndex(value);\r\n    }\r\n    return this;\r\n  },\r\n\r\n  _setAutoZIndex: function (compare) {\r\n    // go through all other layers of the same pane, set zIndex to max + 1 (front) or min - 1 (back)\r\n    if (!this._currentImage) {\r\n      return;\r\n    }\r\n    var layers = this._currentImage.getPane().children;\r\n    var edgeZIndex = -compare(-Infinity, Infinity); // -Infinity for max, Infinity for min\r\n    for (var i = 0, len = layers.length, zIndex; i < len; i++) {\r\n      zIndex = layers[i].style.zIndex;\r\n      if (layers[i] !== this._currentImage._image && zIndex) {\r\n        edgeZIndex = compare(edgeZIndex, +zIndex);\r\n      }\r\n    }\r\n\r\n    if (isFinite(edgeZIndex)) {\r\n      this.options.zIndex = edgeZIndex + compare(-1, 1);\r\n      this.setZIndex(this.options.zIndex);\r\n    }\r\n  },\r\n\r\n  getAttribution: function () {\r\n    return this.options.attribution;\r\n  },\r\n\r\n  getOpacity: function () {\r\n    return this.options.opacity;\r\n  },\r\n\r\n  setOpacity: function (opacity) {\r\n    this.options.opacity = opacity;\r\n    if (this._currentImage) {\r\n      this._currentImage.setOpacity(opacity);\r\n    }\r\n    return this;\r\n  },\r\n\r\n  getTimeRange: function () {\r\n    return [this.options.from, this.options.to];\r\n  },\r\n\r\n  setTimeRange: function (from, to) {\r\n    this.options.from = from;\r\n    this.options.to = to;\r\n    this._update();\r\n    return this;\r\n  },\r\n\r\n  metadata: function (callback, context) {\r\n    this.service.metadata(callback, context);\r\n    return this;\r\n  },\r\n\r\n  authenticate: function (token) {\r\n    this.service.authenticate(token);\r\n    return this;\r\n  },\r\n\r\n  redraw: function () {\r\n    this._update();\r\n  },\r\n\r\n  _renderImage: function (url, bounds, contentType) {\r\n    if (this._map) {\r\n      // if no output directory has been specified for a service, MIME data will be returned\r\n      if (contentType) {\r\n        url = 'data:' + contentType + ';base64,' + url;\r\n      }\r\n\r\n      // if server returns an inappropriate response, abort.\r\n      if (!url) return;\r\n\r\n      // create a new image overlay and add it to the map\r\n      // to start loading the image\r\n      // opacity is 0 while the image is loading\r\n      var image = new Overlay(url, bounds, {\r\n        opacity: 0,\r\n        crossOrigin: this.options.withCredentials ? 'use-credentials' : this.options.useCors,\r\n        alt: this.options.alt,\r\n        pane: this.options.pane || this.getPane(),\r\n        interactive: this.options.interactive\r\n      }).addTo(this._map);\r\n\r\n      var onOverlayError = function () {\r\n        this._map.removeLayer(image);\r\n        this.fire('error');\r\n        image.off('load', onOverlayLoad, this);\r\n      };\r\n\r\n      var onOverlayLoad = function (e) {\r\n        image.off('error', onOverlayLoad, this);\r\n        if (this._map) {\r\n          var newImage = e.target;\r\n          var oldImage = this._currentImage;\r\n\r\n          // if the bounds of this image matches the bounds that\r\n          // _renderImage was called with and we have a map with the same bounds\r\n          // hide the old image if there is one and set the opacity\r\n          // of the new image otherwise remove the new image\r\n          if (newImage._bounds.equals(bounds) && newImage._bounds.equals(this._map.getBounds())) {\r\n            this._currentImage = newImage;\r\n\r\n            if (this.options.position === 'front') {\r\n              this.bringToFront();\r\n            } else if (this.options.position === 'back') {\r\n              this.bringToBack();\r\n            }\r\n\r\n            if (this.options.zIndex) {\r\n              this.setZIndex(this.options.zIndex);\r\n            }\r\n\r\n            if (this._map && this._currentImage._map) {\r\n              this._currentImage.setOpacity(this.options.opacity);\r\n            } else {\r\n              this._currentImage._map.removeLayer(this._currentImage);\r\n            }\r\n\r\n            if (oldImage && this._map) {\r\n              this._map.removeLayer(oldImage);\r\n            }\r\n\r\n            if (oldImage && oldImage._map) {\r\n              oldImage._map.removeLayer(oldImage);\r\n            }\r\n          } else {\r\n            this._map.removeLayer(newImage);\r\n          }\r\n        }\r\n\r\n        this.fire('load', {\r\n          bounds: bounds\r\n        });\r\n      };\r\n\r\n      // If loading the image fails\r\n      image.once('error', onOverlayError, this);\r\n\r\n      // once the image loads\r\n      image.once('load', onOverlayLoad, this);\r\n    }\r\n  },\r\n\r\n  _update: function () {\r\n    if (!this._map) {\r\n      return;\r\n    }\r\n\r\n    var zoom = this._map.getZoom();\r\n    var bounds = this._map.getBounds();\r\n\r\n    if (this._animatingZoom) {\r\n      return;\r\n    }\r\n\r\n    if (this._map._panTransition && this._map._panTransition._inProgress) {\r\n      return;\r\n    }\r\n\r\n    if (zoom > this.options.maxZoom || zoom < this.options.minZoom) {\r\n      if (this._currentImage) {\r\n        this._currentImage._map.removeLayer(this._currentImage);\r\n        this._currentImage = null;\r\n      }\r\n      return;\r\n    }\r\n\r\n    var params = this._buildExportParams();\r\n    leaflet__WEBPACK_IMPORTED_MODULE_0__[\"Util\"].extend(params, this.options.requestParams);\r\n\r\n    if (params) {\r\n      this._requestExport(params, bounds);\r\n\r\n      this.fire('loading', {\r\n        bounds: bounds\r\n      });\r\n    } else if (this._currentImage) {\r\n      this._currentImage._map.removeLayer(this._currentImage);\r\n      this._currentImage = null;\r\n    }\r\n  },\r\n\r\n  _renderPopup: function (latlng, error, results, response) {\r\n    latlng = Object(leaflet__WEBPACK_IMPORTED_MODULE_0__[\"latLng\"])(latlng);\r\n    if (this._shouldRenderPopup && this._lastClick.equals(latlng)) {\r\n      // add the popup to the map where the mouse was clicked at\r\n      var content = this._popupFunction(error, results, response);\r\n      if (content) {\r\n        this._popup.setLatLng(latlng).setContent(content).openOn(this._map);\r\n      }\r\n    }\r\n  },\r\n\r\n  _resetPopupState: function (e) {\r\n    this._shouldRenderPopup = false;\r\n    this._lastClick = e.latlng;\r\n  },\r\n\r\n  _calculateBbox: function () {\r\n    var pixelBounds = this._map.getPixelBounds();\r\n\r\n    var sw = this._map.unproject(pixelBounds.getBottomLeft());\r\n    var ne = this._map.unproject(pixelBounds.getTopRight());\r\n\r\n    var neProjected = this._map.options.crs.project(ne);\r\n    var swProjected = this._map.options.crs.project(sw);\r\n\r\n    // this ensures ne/sw are switched in polar maps where north/top bottom/south is inverted\r\n    var boundsProjected = Object(leaflet__WEBPACK_IMPORTED_MODULE_0__[\"bounds\"])(neProjected, swProjected);\r\n\r\n    return [boundsProjected.getBottomLeft().x, boundsProjected.getBottomLeft().y, boundsProjected.getTopRight().x, boundsProjected.getTopRight().y].join(',');\r\n  },\r\n\r\n  _calculateImageSize: function () {\r\n    // ensure that we don't ask ArcGIS Server for a taller image than we have actual map displaying within the div\r\n    var bounds = this._map.getPixelBounds();\r\n    var size = this._map.getSize();\r\n\r\n    var sw = this._map.unproject(bounds.getBottomLeft());\r\n    var ne = this._map.unproject(bounds.getTopRight());\r\n\r\n    var top = this._map.latLngToLayerPoint(ne).y;\r\n    var bottom = this._map.latLngToLayerPoint(sw).y;\r\n\r\n    if (top > 0 || bottom < size.y) {\r\n      size.y = bottom - top;\r\n    }\r\n\r\n    return size.x + ',' + size.y;\r\n  }\r\n});\r\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///./node_modules/esri-leaflet/src/Layers/RasterLayer.js\n");

/***/ }),

/***/ "./node_modules/esri-leaflet/src/Layers/TiledMapLayer.js":
/*!***************************************************************!*\
  !*** ./node_modules/esri-leaflet/src/Layers/TiledMapLayer.js ***!
  \***************************************************************/
/*! exports provided: TiledMapLayer, tiledMapLayer, default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"TiledMapLayer\", function() { return TiledMapLayer; });\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"tiledMapLayer\", function() { return tiledMapLayer; });\n/* harmony import */ var leaflet__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! leaflet */ \"./node_modules/leaflet/dist/leaflet-src.js\");\n/* harmony import */ var leaflet__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(leaflet__WEBPACK_IMPORTED_MODULE_0__);\n/* harmony import */ var _Util__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../Util */ \"./node_modules/esri-leaflet/src/Util.js\");\n/* harmony import */ var _Services_MapService__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../Services/MapService */ \"./node_modules/esri-leaflet/src/Services/MapService.js\");\n\r\n\r\n\r\n\r\nvar TiledMapLayer = leaflet__WEBPACK_IMPORTED_MODULE_0__[\"TileLayer\"].extend({\r\n  options: {\r\n    zoomOffsetAllowance: 0.1,\r\n    errorTileUrl: 'data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAQAAAAEABAMAAACuXLVVAAAAA1BMVEUzNDVszlHHAAAAAXRSTlMAQObYZgAAAAlwSFlzAAAAAAAAAAAB6mUWpAAAADZJREFUeJztwQEBAAAAgiD/r25IQAEAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA7waBAAABw08RwAAAAABJRU5ErkJggg=='\r\n  },\r\n\r\n  statics: {\r\n    MercatorZoomLevels: {\r\n      '0': 156543.03392799999,\r\n      '1': 78271.516963999893,\r\n      '2': 39135.758482000099,\r\n      '3': 19567.879240999901,\r\n      '4': 9783.9396204999593,\r\n      '5': 4891.9698102499797,\r\n      '6': 2445.9849051249898,\r\n      '7': 1222.9924525624899,\r\n      '8': 611.49622628138002,\r\n      '9': 305.74811314055802,\r\n      '10': 152.874056570411,\r\n      '11': 76.437028285073197,\r\n      '12': 38.218514142536598,\r\n      '13': 19.109257071268299,\r\n      '14': 9.5546285356341496,\r\n      '15': 4.7773142679493699,\r\n      '16': 2.38865713397468,\r\n      '17': 1.1943285668550501,\r\n      '18': 0.59716428355981699,\r\n      '19': 0.29858214164761698,\r\n      '20': 0.14929107082381,\r\n      '21': 0.07464553541191,\r\n      '22': 0.0373227677059525,\r\n      '23': 0.0186613838529763\r\n    }\r\n  },\r\n\r\n  initialize: function (options) {\r\n    options = leaflet__WEBPACK_IMPORTED_MODULE_0__[\"Util\"].setOptions(this, options);\r\n\r\n    // set the urls\r\n    options = Object(_Util__WEBPACK_IMPORTED_MODULE_1__[\"getUrlParams\"])(options);\r\n    this.tileUrl = (options.proxy ? options.proxy + '?' : '') + options.url + 'tile/{z}/{y}/{x}' + (options.requestParams && Object.keys(options.requestParams).length > 0 ? leaflet__WEBPACK_IMPORTED_MODULE_0__[\"Util\"].getParamString(options.requestParams) : '');\r\n    // Remove subdomain in url\r\n    // https://github.com/Esri/esri-leaflet/issues/991\r\n    if (options.url.indexOf('{s}') !== -1 && options.subdomains) {\r\n      options.url = options.url.replace('{s}', options.subdomains[0]);\r\n    }\r\n    this.service = Object(_Services_MapService__WEBPACK_IMPORTED_MODULE_2__[\"default\"])(options);\r\n    this.service.addEventParent(this);\r\n\r\n    var arcgisonline = new RegExp(/tiles.arcgis(online)?\\.com/g);\r\n    if (arcgisonline.test(options.url)) {\r\n      this.tileUrl = this.tileUrl.replace('://tiles', '://tiles{s}');\r\n      options.subdomains = ['1', '2', '3', '4'];\r\n    }\r\n\r\n    if (this.options.token) {\r\n      this.tileUrl += ('?token=' + this.options.token);\r\n    }\r\n\r\n    // init layer by calling TileLayers initialize method\r\n    leaflet__WEBPACK_IMPORTED_MODULE_0__[\"TileLayer\"].prototype.initialize.call(this, this.tileUrl, options);\r\n  },\r\n\r\n  getTileUrl: function (tilePoint) {\r\n    var zoom = this._getZoomForUrl();\r\n\r\n    return leaflet__WEBPACK_IMPORTED_MODULE_0__[\"Util\"].template(this.tileUrl, leaflet__WEBPACK_IMPORTED_MODULE_0__[\"Util\"].extend({\r\n      s: this._getSubdomain(tilePoint),\r\n      x: tilePoint.x,\r\n      y: tilePoint.y,\r\n      // try lod map first, then just default to zoom level\r\n      z: (this._lodMap && this._lodMap[zoom]) ? this._lodMap[zoom] : zoom\r\n    }, this.options));\r\n  },\r\n\r\n  createTile: function (coords, done) {\r\n    var tile = document.createElement('img');\r\n\r\n    leaflet__WEBPACK_IMPORTED_MODULE_0__[\"DomEvent\"].on(tile, 'load', leaflet__WEBPACK_IMPORTED_MODULE_0__[\"Util\"].bind(this._tileOnLoad, this, done, tile));\r\n    leaflet__WEBPACK_IMPORTED_MODULE_0__[\"DomEvent\"].on(tile, 'error', leaflet__WEBPACK_IMPORTED_MODULE_0__[\"Util\"].bind(this._tileOnError, this, done, tile));\r\n\r\n    if (this.options.crossOrigin) {\r\n      tile.crossOrigin = '';\r\n    }\r\n\r\n    /*\r\n     Alt tag is set to empty string to keep screen readers from reading URL and for compliance reasons\r\n     http://www.w3.org/TR/WCAG20-TECHS/H67\r\n    */\r\n    tile.alt = '';\r\n\r\n    // if there is no lod map or an lod map with a proper zoom load the tile\r\n    // otherwise wait for the lod map to become available\r\n    if (!this._lodMap || (this._lodMap && this._lodMap[this._getZoomForUrl()])) {\r\n      tile.src = this.getTileUrl(coords);\r\n    } else {\r\n      this.once('lodmap', function () {\r\n        tile.src = this.getTileUrl(coords);\r\n      }, this);\r\n    }\r\n\r\n    return tile;\r\n  },\r\n\r\n  onAdd: function (map) {\r\n    // include 'Powered by Esri' in map attribution\r\n    Object(_Util__WEBPACK_IMPORTED_MODULE_1__[\"setEsriAttribution\"])(map);\r\n\r\n    if (!this._lodMap) {\r\n      this.metadata(function (error, metadata) {\r\n        if (!error && metadata.spatialReference) {\r\n          var sr = metadata.spatialReference.latestWkid || metadata.spatialReference.wkid;\r\n          // display the copyright text from the service using leaflet's attribution control\r\n          if (!this.options.attribution && map.attributionControl && metadata.copyrightText) {\r\n            this.options.attribution = metadata.copyrightText;\r\n            map.attributionControl.addAttribution(this.getAttribution());\r\n          }\r\n\r\n          // if the service tiles were published in web mercator using conventional LODs but missing levels, we can try and remap them\r\n          if (map.options.crs === leaflet__WEBPACK_IMPORTED_MODULE_0__[\"CRS\"].EPSG3857 && (sr === 102100 || sr === 3857)) {\r\n            this._lodMap = {};\r\n            // create the zoom level data\r\n            var arcgisLODs = metadata.tileInfo.lods;\r\n            var correctResolutions = TiledMapLayer.MercatorZoomLevels;\r\n\r\n            for (var i = 0; i < arcgisLODs.length; i++) {\r\n              var arcgisLOD = arcgisLODs[i];\r\n              for (var ci in correctResolutions) {\r\n                var correctRes = correctResolutions[ci];\r\n\r\n                if (this._withinPercentage(arcgisLOD.resolution, correctRes, this.options.zoomOffsetAllowance)) {\r\n                  this._lodMap[ci] = arcgisLOD.level;\r\n                  break;\r\n                }\r\n              }\r\n            }\r\n\r\n            this.fire('lodmap');\r\n          } else if (map.options.crs && map.options.crs.code && (map.options.crs.code.indexOf(sr) > -1)) {\r\n            // if the projection is WGS84, or the developer is using Proj4 to define a custom CRS, no action is required\r\n          } else {\r\n            // if the service was cached in a custom projection and an appropriate LOD hasn't been defined in the map, guide the developer to our Proj4 sample\r\n            Object(_Util__WEBPACK_IMPORTED_MODULE_1__[\"warn\"])('L.esri.TiledMapLayer is using a non-mercator spatial reference. Support may be available through Proj4Leaflet http://esri.github.io/esri-leaflet/examples/non-mercator-projection.html');\r\n          }\r\n        }\r\n      }, this);\r\n    }\r\n\r\n    leaflet__WEBPACK_IMPORTED_MODULE_0__[\"TileLayer\"].prototype.onAdd.call(this, map);\r\n  },\r\n\r\n  onRemove: function (map) {\r\n    Object(_Util__WEBPACK_IMPORTED_MODULE_1__[\"removeEsriAttribution\"])(map);\r\n  },\r\n\r\n  metadata: function (callback, context) {\r\n    this.service.metadata(callback, context);\r\n    return this;\r\n  },\r\n\r\n  identify: function () {\r\n    return this.service.identify();\r\n  },\r\n\r\n  find: function () {\r\n    return this.service.find();\r\n  },\r\n\r\n  query: function () {\r\n    return this.service.query();\r\n  },\r\n\r\n  authenticate: function (token) {\r\n    var tokenQs = '?token=' + token;\r\n    this.tileUrl = (this.options.token) ? this.tileUrl.replace(/\\?token=(.+)/g, tokenQs) : this.tileUrl + tokenQs;\r\n    this.options.token = token;\r\n    this.service.authenticate(token);\r\n    return this;\r\n  },\r\n\r\n  _withinPercentage: function (a, b, percentage) {\r\n    var diff = Math.abs((a / b) - 1);\r\n    return diff < percentage;\r\n  }\r\n});\r\n\r\nfunction tiledMapLayer (url, options) {\r\n  return new TiledMapLayer(url, options);\r\n}\r\n\r\n/* harmony default export */ __webpack_exports__[\"default\"] = (tiledMapLayer);\r\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///./node_modules/esri-leaflet/src/Layers/TiledMapLayer.js\n");

/***/ }),

/***/ "./node_modules/esri-leaflet/src/Options.js":
/*!**************************************************!*\
  !*** ./node_modules/esri-leaflet/src/Options.js ***!
  \**************************************************/
/*! exports provided: options, default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"options\", function() { return options; });\nvar options = {\r\n  attributionWidthOffset: 55\r\n};\r\n\r\n/* harmony default export */ __webpack_exports__[\"default\"] = (options);\r\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbIndlYnBhY2s6Ly8vLi9ub2RlX21vZHVsZXMvZXNyaS1sZWFmbGV0L3NyYy9PcHRpb25zLmpzPzQyOWIiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6IkFBQUE7QUFBQTtBQUFPO0FBQ1A7QUFDQTs7QUFFZSxzRUFBTyxFQUFDIiwiZmlsZSI6Ii4vbm9kZV9tb2R1bGVzL2VzcmktbGVhZmxldC9zcmMvT3B0aW9ucy5qcy5qcyIsInNvdXJjZXNDb250ZW50IjpbImV4cG9ydCB2YXIgb3B0aW9ucyA9IHtcclxuICBhdHRyaWJ1dGlvbldpZHRoT2Zmc2V0OiA1NVxyXG59O1xyXG5cclxuZXhwb3J0IGRlZmF1bHQgb3B0aW9ucztcclxuIl0sInNvdXJjZVJvb3QiOiIifQ==\n//# sourceURL=webpack-internal:///./node_modules/esri-leaflet/src/Options.js\n");

/***/ }),

/***/ "./node_modules/esri-leaflet/src/Request.js":
/*!**************************************************!*\
  !*** ./node_modules/esri-leaflet/src/Request.js ***!
  \**************************************************/
/*! exports provided: request, jsonp, warn, get, post, Request, default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"request\", function() { return request; });\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"jsonp\", function() { return jsonp; });\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"warn\", function() { return warn; });\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"get\", function() { return get; });\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"post\", function() { return xmlHttpPost; });\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"Request\", function() { return Request; });\n/* harmony import */ var leaflet__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! leaflet */ \"./node_modules/leaflet/dist/leaflet-src.js\");\n/* harmony import */ var leaflet__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(leaflet__WEBPACK_IMPORTED_MODULE_0__);\n/* harmony import */ var _Support__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./Support */ \"./node_modules/esri-leaflet/src/Support.js\");\n\r\n\r\n\r\nvar callbacks = 0;\r\n\r\nfunction serialize (params) {\r\n  var data = '';\r\n\r\n  params.f = params.f || 'json';\r\n\r\n  for (var key in params) {\r\n    if (params.hasOwnProperty(key)) {\r\n      var param = params[key];\r\n      var type = Object.prototype.toString.call(param);\r\n      var value;\r\n\r\n      if (data.length) {\r\n        data += '&';\r\n      }\r\n\r\n      if (type === '[object Array]') {\r\n        value = (Object.prototype.toString.call(param[0]) === '[object Object]') ? JSON.stringify(param) : param.join(',');\r\n      } else if (type === '[object Object]') {\r\n        value = JSON.stringify(param);\r\n      } else if (type === '[object Date]') {\r\n        value = param.valueOf();\r\n      } else {\r\n        value = param;\r\n      }\r\n\r\n      data += encodeURIComponent(key) + '=' + encodeURIComponent(value);\r\n    }\r\n  }\r\n\r\n  return data;\r\n}\r\n\r\nfunction createRequest (callback, context) {\r\n  var httpRequest = new window.XMLHttpRequest();\r\n\r\n  httpRequest.onerror = function (e) {\r\n    httpRequest.onreadystatechange = leaflet__WEBPACK_IMPORTED_MODULE_0__[\"Util\"].falseFn;\r\n\r\n    callback.call(context, {\r\n      error: {\r\n        code: 500,\r\n        message: 'XMLHttpRequest error'\r\n      }\r\n    }, null);\r\n  };\r\n\r\n  httpRequest.onreadystatechange = function () {\r\n    var response;\r\n    var error;\r\n\r\n    if (httpRequest.readyState === 4) {\r\n      try {\r\n        response = JSON.parse(httpRequest.responseText);\r\n      } catch (e) {\r\n        response = null;\r\n        error = {\r\n          code: 500,\r\n          message: 'Could not parse response as JSON. This could also be caused by a CORS or XMLHttpRequest error.'\r\n        };\r\n      }\r\n\r\n      if (!error && response.error) {\r\n        error = response.error;\r\n        response = null;\r\n      }\r\n\r\n      httpRequest.onerror = leaflet__WEBPACK_IMPORTED_MODULE_0__[\"Util\"].falseFn;\r\n\r\n      callback.call(context, error, response);\r\n    }\r\n  };\r\n\r\n  httpRequest.ontimeout = function () {\r\n    this.onerror();\r\n  };\r\n\r\n  return httpRequest;\r\n}\r\n\r\nfunction xmlHttpPost (url, params, callback, context) {\r\n  var httpRequest = createRequest(callback, context);\r\n  httpRequest.open('POST', url);\r\n\r\n  if (typeof context !== 'undefined' && context !== null) {\r\n    if (typeof context.options !== 'undefined') {\r\n      httpRequest.timeout = context.options.timeout;\r\n    }\r\n  }\r\n  httpRequest.setRequestHeader('Content-Type', 'application/x-www-form-urlencoded; charset=UTF-8');\r\n  httpRequest.send(serialize(params));\r\n\r\n  return httpRequest;\r\n}\r\n\r\nfunction xmlHttpGet (url, params, callback, context) {\r\n  var httpRequest = createRequest(callback, context);\r\n  httpRequest.open('GET', url + '?' + serialize(params), true);\r\n\r\n  if (typeof context !== 'undefined' && context !== null) {\r\n    if (typeof context.options !== 'undefined') {\r\n      httpRequest.timeout = context.options.timeout;\r\n      if (context.options.withCredentials) {\r\n        httpRequest.withCredentials = true;\r\n      }\r\n    }\r\n  }\r\n  httpRequest.send(null);\r\n\r\n  return httpRequest;\r\n}\r\n\r\n// AJAX handlers for CORS (modern browsers) or JSONP (older browsers)\r\nfunction request (url, params, callback, context) {\r\n  var paramString = serialize(params);\r\n  var httpRequest = createRequest(callback, context);\r\n  var requestLength = (url + '?' + paramString).length;\r\n\r\n  // ie10/11 require the request be opened before a timeout is applied\r\n  if (requestLength <= 2000 && _Support__WEBPACK_IMPORTED_MODULE_1__[\"Support\"].cors) {\r\n    httpRequest.open('GET', url + '?' + paramString);\r\n  } else if (requestLength > 2000 && _Support__WEBPACK_IMPORTED_MODULE_1__[\"Support\"].cors) {\r\n    httpRequest.open('POST', url);\r\n    httpRequest.setRequestHeader('Content-Type', 'application/x-www-form-urlencoded; charset=UTF-8');\r\n  }\r\n\r\n  if (typeof context !== 'undefined' && context !== null) {\r\n    if (typeof context.options !== 'undefined') {\r\n      httpRequest.timeout = context.options.timeout;\r\n      if (context.options.withCredentials) {\r\n        httpRequest.withCredentials = true;\r\n      }\r\n    }\r\n  }\r\n\r\n  // request is less than 2000 characters and the browser supports CORS, make GET request with XMLHttpRequest\r\n  if (requestLength <= 2000 && _Support__WEBPACK_IMPORTED_MODULE_1__[\"Support\"].cors) {\r\n    httpRequest.send(null);\r\n\r\n  // request is more than 2000 characters and the browser supports CORS, make POST request with XMLHttpRequest\r\n  } else if (requestLength > 2000 && _Support__WEBPACK_IMPORTED_MODULE_1__[\"Support\"].cors) {\r\n    httpRequest.send(paramString);\r\n\r\n  // request is less  than 2000 characters and the browser does not support CORS, make a JSONP request\r\n  } else if (requestLength <= 2000 && !_Support__WEBPACK_IMPORTED_MODULE_1__[\"Support\"].cors) {\r\n    return jsonp(url, params, callback, context);\r\n\r\n  // request is longer then 2000 characters and the browser does not support CORS, log a warning\r\n  } else {\r\n    warn('a request to ' + url + ' was longer then 2000 characters and this browser cannot make a cross-domain post request. Please use a proxy http://esri.github.io/esri-leaflet/api-reference/request.html');\r\n    return;\r\n  }\r\n\r\n  return httpRequest;\r\n}\r\n\r\nfunction jsonp (url, params, callback, context) {\r\n  window._EsriLeafletCallbacks = window._EsriLeafletCallbacks || {};\r\n  var callbackId = 'c' + callbacks;\r\n  params.callback = 'window._EsriLeafletCallbacks.' + callbackId;\r\n\r\n  window._EsriLeafletCallbacks[callbackId] = function (response) {\r\n    if (window._EsriLeafletCallbacks[callbackId] !== true) {\r\n      var error;\r\n      var responseType = Object.prototype.toString.call(response);\r\n\r\n      if (!(responseType === '[object Object]' || responseType === '[object Array]')) {\r\n        error = {\r\n          error: {\r\n            code: 500,\r\n            message: 'Expected array or object as JSONP response'\r\n          }\r\n        };\r\n        response = null;\r\n      }\r\n\r\n      if (!error && response.error) {\r\n        error = response;\r\n        response = null;\r\n      }\r\n\r\n      callback.call(context, error, response);\r\n      window._EsriLeafletCallbacks[callbackId] = true;\r\n    }\r\n  };\r\n\r\n  var script = leaflet__WEBPACK_IMPORTED_MODULE_0__[\"DomUtil\"].create('script', null, document.body);\r\n  script.type = 'text/javascript';\r\n  script.src = url + '?' + serialize(params);\r\n  script.id = callbackId;\r\n  script.onerror = function (error) {\r\n    if (error && window._EsriLeafletCallbacks[callbackId] !== true) {\r\n      // Can't get true error code: it can be 404, or 401, or 500\r\n      var err = {\r\n        error: {\r\n          code: 500,\r\n          message: 'An unknown error occurred'\r\n        }\r\n      };\r\n\r\n      callback.call(context, err);\r\n      window._EsriLeafletCallbacks[callbackId] = true;\r\n    }\r\n  };\r\n  leaflet__WEBPACK_IMPORTED_MODULE_0__[\"DomUtil\"].addClass(script, 'esri-leaflet-jsonp');\r\n\r\n  callbacks++;\r\n\r\n  return {\r\n    id: callbackId,\r\n    url: script.src,\r\n    abort: function () {\r\n      window._EsriLeafletCallbacks._callback[callbackId]({\r\n        code: 0,\r\n        message: 'Request aborted.'\r\n      });\r\n    }\r\n  };\r\n}\r\n\r\nvar get = ((_Support__WEBPACK_IMPORTED_MODULE_1__[\"Support\"].cors) ? xmlHttpGet : jsonp);\r\nget.CORS = xmlHttpGet;\r\nget.JSONP = jsonp;\r\n\r\nfunction warn () {\r\n  if (console && console.warn) {\r\n    console.warn.apply(console, arguments);\r\n  }\r\n}\r\n\r\n// choose the correct AJAX handler depending on CORS support\r\n\r\n\r\n// always use XMLHttpRequest for posts\r\n\r\n\r\n// export the Request object to call the different handlers for debugging\r\nvar Request = {\r\n  request: request,\r\n  get: get,\r\n  post: xmlHttpPost\r\n};\r\n\r\n/* harmony default export */ __webpack_exports__[\"default\"] = (Request);\r\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///./node_modules/esri-leaflet/src/Request.js\n");

/***/ }),

/***/ "./node_modules/esri-leaflet/src/Services/FeatureLayerService.js":
/*!***********************************************************************!*\
  !*** ./node_modules/esri-leaflet/src/Services/FeatureLayerService.js ***!
  \***********************************************************************/
/*! exports provided: FeatureLayerService, featureLayerService, default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"FeatureLayerService\", function() { return FeatureLayerService; });\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"featureLayerService\", function() { return featureLayerService; });\n/* harmony import */ var _Service__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./Service */ \"./node_modules/esri-leaflet/src/Services/Service.js\");\n/* harmony import */ var _Tasks_Query__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../Tasks/Query */ \"./node_modules/esri-leaflet/src/Tasks/Query.js\");\n/* harmony import */ var _Util__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../Util */ \"./node_modules/esri-leaflet/src/Util.js\");\n\r\n\r\n\r\n\r\nvar FeatureLayerService = _Service__WEBPACK_IMPORTED_MODULE_0__[\"Service\"].extend({\r\n\r\n  options: {\r\n    idAttribute: 'OBJECTID'\r\n  },\r\n\r\n  query: function () {\r\n    return Object(_Tasks_Query__WEBPACK_IMPORTED_MODULE_1__[\"default\"])(this);\r\n  },\r\n\r\n  addFeature: function (feature, callback, context) {\r\n    this.addFeatures(feature, callback, context);\r\n  },\r\n\r\n  addFeatures: function (features, callback, context) {\r\n    var featuresArray = features.features ? features.features : [features];\r\n    for (var i = featuresArray.length - 1; i >= 0; i--) {\r\n      delete featuresArray[i].id;\r\n    }\r\n    features = Object(_Util__WEBPACK_IMPORTED_MODULE_2__[\"geojsonToArcGIS\"])(features);\r\n    features = featuresArray.length > 1 ? features : [features];\r\n    return this.post('addFeatures', {\r\n      features: features\r\n    }, function (error, response) {\r\n      // For compatibility reason with former addFeature function,\r\n      // we return the object in the array and not the array itself\r\n      var result = (response && response.addResults) ? response.addResults.length > 1 ? response.addResults : response.addResults[0] : undefined;\r\n      if (callback) {\r\n        callback.call(context, error || response.addResults[0].error, result);\r\n      }\r\n    }, context);\r\n  },\r\n\r\n  updateFeature: function (feature, callback, context) {\r\n    this.updateFeatures(feature, callback, context);\r\n  },\r\n\r\n  updateFeatures: function (features, callback, context) {\r\n    var featuresArray = features.features ? features.features : [features];\r\n    features = Object(_Util__WEBPACK_IMPORTED_MODULE_2__[\"geojsonToArcGIS\"])(features, this.options.idAttribute);\r\n    features = featuresArray.length > 1 ? features : [features];\r\n\r\n    return this.post('updateFeatures', {\r\n      features: features\r\n    }, function (error, response) {\r\n      // For compatibility reason with former updateFeature function,\r\n      // we return the object in the array and not the array itself\r\n      var result = (response && response.updateResults) ? response.updateResults.length > 1 ? response.updateResults : response.updateResults[0] : undefined;\r\n      if (callback) {\r\n        callback.call(context, error || response.updateResults[0].error, result);\r\n      }\r\n    }, context);\r\n  },\r\n\r\n  deleteFeature: function (id, callback, context) {\r\n    this.deleteFeatures(id, callback, context);\r\n  },\r\n\r\n  deleteFeatures: function (ids, callback, context) {\r\n    return this.post('deleteFeatures', {\r\n      objectIds: ids\r\n    }, function (error, response) {\r\n      // For compatibility reason with former deleteFeature function,\r\n      // we return the object in the array and not the array itself\r\n      var result = (response && response.deleteResults) ? response.deleteResults.length > 1 ? response.deleteResults : response.deleteResults[0] : undefined;\r\n      if (callback) {\r\n        callback.call(context, error || response.deleteResults[0].error, result);\r\n      }\r\n    }, context);\r\n  }\r\n});\r\n\r\nfunction featureLayerService (options) {\r\n  return new FeatureLayerService(options);\r\n}\r\n\r\n/* harmony default export */ __webpack_exports__[\"default\"] = (featureLayerService);\r\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///./node_modules/esri-leaflet/src/Services/FeatureLayerService.js\n");

/***/ }),

/***/ "./node_modules/esri-leaflet/src/Services/ImageService.js":
/*!****************************************************************!*\
  !*** ./node_modules/esri-leaflet/src/Services/ImageService.js ***!
  \****************************************************************/
/*! exports provided: ImageService, imageService, default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"ImageService\", function() { return ImageService; });\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"imageService\", function() { return imageService; });\n/* harmony import */ var _Service__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./Service */ \"./node_modules/esri-leaflet/src/Services/Service.js\");\n/* harmony import */ var _Tasks_IdentifyImage__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../Tasks/IdentifyImage */ \"./node_modules/esri-leaflet/src/Tasks/IdentifyImage.js\");\n/* harmony import */ var _Tasks_Query__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../Tasks/Query */ \"./node_modules/esri-leaflet/src/Tasks/Query.js\");\n\r\n\r\n\r\n\r\nvar ImageService = _Service__WEBPACK_IMPORTED_MODULE_0__[\"Service\"].extend({\r\n\r\n  query: function () {\r\n    return Object(_Tasks_Query__WEBPACK_IMPORTED_MODULE_2__[\"default\"])(this);\r\n  },\r\n\r\n  identify: function () {\r\n    return Object(_Tasks_IdentifyImage__WEBPACK_IMPORTED_MODULE_1__[\"default\"])(this);\r\n  }\r\n});\r\n\r\nfunction imageService (options) {\r\n  return new ImageService(options);\r\n}\r\n\r\n/* harmony default export */ __webpack_exports__[\"default\"] = (imageService);\r\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbIndlYnBhY2s6Ly8vLi9ub2RlX21vZHVsZXMvZXNyaS1sZWFmbGV0L3NyYy9TZXJ2aWNlcy9JbWFnZVNlcnZpY2UuanM/MzNmNSJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiQUFBQTtBQUFBO0FBQUE7QUFBQTtBQUFBO0FBQUE7QUFBb0M7QUFDZTtBQUNoQjs7QUFFNUIsbUJBQW1CLGdEQUFPOztBQUVqQztBQUNBLFdBQVcsNERBQUs7QUFDaEIsR0FBRzs7QUFFSDtBQUNBLFdBQVcsb0VBQWE7QUFDeEI7QUFDQSxDQUFDOztBQUVNO0FBQ1A7QUFDQTs7QUFFZSwyRUFBWSxFQUFDIiwiZmlsZSI6Ii4vbm9kZV9tb2R1bGVzL2VzcmktbGVhZmxldC9zcmMvU2VydmljZXMvSW1hZ2VTZXJ2aWNlLmpzLmpzIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IHsgU2VydmljZSB9IGZyb20gJy4vU2VydmljZSc7XHJcbmltcG9ydCBpZGVudGlmeUltYWdlIGZyb20gJy4uL1Rhc2tzL0lkZW50aWZ5SW1hZ2UnO1xyXG5pbXBvcnQgcXVlcnkgZnJvbSAnLi4vVGFza3MvUXVlcnknO1xyXG5cclxuZXhwb3J0IHZhciBJbWFnZVNlcnZpY2UgPSBTZXJ2aWNlLmV4dGVuZCh7XHJcblxyXG4gIHF1ZXJ5OiBmdW5jdGlvbiAoKSB7XHJcbiAgICByZXR1cm4gcXVlcnkodGhpcyk7XHJcbiAgfSxcclxuXHJcbiAgaWRlbnRpZnk6IGZ1bmN0aW9uICgpIHtcclxuICAgIHJldHVybiBpZGVudGlmeUltYWdlKHRoaXMpO1xyXG4gIH1cclxufSk7XHJcblxyXG5leHBvcnQgZnVuY3Rpb24gaW1hZ2VTZXJ2aWNlIChvcHRpb25zKSB7XHJcbiAgcmV0dXJuIG5ldyBJbWFnZVNlcnZpY2Uob3B0aW9ucyk7XHJcbn1cclxuXHJcbmV4cG9ydCBkZWZhdWx0IGltYWdlU2VydmljZTtcclxuIl0sInNvdXJjZVJvb3QiOiIifQ==\n//# sourceURL=webpack-internal:///./node_modules/esri-leaflet/src/Services/ImageService.js\n");

/***/ }),

/***/ "./node_modules/esri-leaflet/src/Services/MapService.js":
/*!**************************************************************!*\
  !*** ./node_modules/esri-leaflet/src/Services/MapService.js ***!
  \**************************************************************/
/*! exports provided: MapService, mapService, default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"MapService\", function() { return MapService; });\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"mapService\", function() { return mapService; });\n/* harmony import */ var _Service__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./Service */ \"./node_modules/esri-leaflet/src/Services/Service.js\");\n/* harmony import */ var _Tasks_IdentifyFeatures__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../Tasks/IdentifyFeatures */ \"./node_modules/esri-leaflet/src/Tasks/IdentifyFeatures.js\");\n/* harmony import */ var _Tasks_Query__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../Tasks/Query */ \"./node_modules/esri-leaflet/src/Tasks/Query.js\");\n/* harmony import */ var _Tasks_Find__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../Tasks/Find */ \"./node_modules/esri-leaflet/src/Tasks/Find.js\");\n\r\n\r\n\r\n\r\n\r\nvar MapService = _Service__WEBPACK_IMPORTED_MODULE_0__[\"Service\"].extend({\r\n\r\n  identify: function () {\r\n    return Object(_Tasks_IdentifyFeatures__WEBPACK_IMPORTED_MODULE_1__[\"default\"])(this);\r\n  },\r\n\r\n  find: function () {\r\n    return Object(_Tasks_Find__WEBPACK_IMPORTED_MODULE_3__[\"default\"])(this);\r\n  },\r\n\r\n  query: function () {\r\n    return Object(_Tasks_Query__WEBPACK_IMPORTED_MODULE_2__[\"default\"])(this);\r\n  }\r\n\r\n});\r\n\r\nfunction mapService (options) {\r\n  return new MapService(options);\r\n}\r\n\r\n/* harmony default export */ __webpack_exports__[\"default\"] = (mapService);\r\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbIndlYnBhY2s6Ly8vLi9ub2RlX21vZHVsZXMvZXNyaS1sZWFmbGV0L3NyYy9TZXJ2aWNlcy9NYXBTZXJ2aWNlLmpzP2MzYzEiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6IkFBQUE7QUFBQTtBQUFBO0FBQUE7QUFBQTtBQUFBO0FBQUE7QUFBb0M7QUFDcUI7QUFDdEI7QUFDRjs7QUFFMUIsaUJBQWlCLGdEQUFPOztBQUUvQjtBQUNBLFdBQVcsdUVBQWdCO0FBQzNCLEdBQUc7O0FBRUg7QUFDQSxXQUFXLDJEQUFJO0FBQ2YsR0FBRzs7QUFFSDtBQUNBLFdBQVcsNERBQUs7QUFDaEI7O0FBRUEsQ0FBQzs7QUFFTTtBQUNQO0FBQ0E7O0FBRWUseUVBQVUsRUFBQyIsImZpbGUiOiIuL25vZGVfbW9kdWxlcy9lc3JpLWxlYWZsZXQvc3JjL1NlcnZpY2VzL01hcFNlcnZpY2UuanMuanMiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgeyBTZXJ2aWNlIH0gZnJvbSAnLi9TZXJ2aWNlJztcclxuaW1wb3J0IGlkZW50aWZ5RmVhdHVyZXMgZnJvbSAnLi4vVGFza3MvSWRlbnRpZnlGZWF0dXJlcyc7XHJcbmltcG9ydCBxdWVyeSBmcm9tICcuLi9UYXNrcy9RdWVyeSc7XHJcbmltcG9ydCBmaW5kIGZyb20gJy4uL1Rhc2tzL0ZpbmQnO1xyXG5cclxuZXhwb3J0IHZhciBNYXBTZXJ2aWNlID0gU2VydmljZS5leHRlbmQoe1xyXG5cclxuICBpZGVudGlmeTogZnVuY3Rpb24gKCkge1xyXG4gICAgcmV0dXJuIGlkZW50aWZ5RmVhdHVyZXModGhpcyk7XHJcbiAgfSxcclxuXHJcbiAgZmluZDogZnVuY3Rpb24gKCkge1xyXG4gICAgcmV0dXJuIGZpbmQodGhpcyk7XHJcbiAgfSxcclxuXHJcbiAgcXVlcnk6IGZ1bmN0aW9uICgpIHtcclxuICAgIHJldHVybiBxdWVyeSh0aGlzKTtcclxuICB9XHJcblxyXG59KTtcclxuXHJcbmV4cG9ydCBmdW5jdGlvbiBtYXBTZXJ2aWNlIChvcHRpb25zKSB7XHJcbiAgcmV0dXJuIG5ldyBNYXBTZXJ2aWNlKG9wdGlvbnMpO1xyXG59XHJcblxyXG5leHBvcnQgZGVmYXVsdCBtYXBTZXJ2aWNlO1xyXG4iXSwic291cmNlUm9vdCI6IiJ9\n//# sourceURL=webpack-internal:///./node_modules/esri-leaflet/src/Services/MapService.js\n");

/***/ }),

/***/ "./node_modules/esri-leaflet/src/Services/Service.js":
/*!***********************************************************!*\
  !*** ./node_modules/esri-leaflet/src/Services/Service.js ***!
  \***********************************************************/
/*! exports provided: Service, service, default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"Service\", function() { return Service; });\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"service\", function() { return service; });\n/* harmony import */ var leaflet__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! leaflet */ \"./node_modules/leaflet/dist/leaflet-src.js\");\n/* harmony import */ var leaflet__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(leaflet__WEBPACK_IMPORTED_MODULE_0__);\n/* harmony import */ var _Support__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../Support */ \"./node_modules/esri-leaflet/src/Support.js\");\n/* harmony import */ var _Util__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../Util */ \"./node_modules/esri-leaflet/src/Util.js\");\n/* harmony import */ var _Request__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../Request */ \"./node_modules/esri-leaflet/src/Request.js\");\n\r\n\r\n\r\n\r\n\r\nvar Service = leaflet__WEBPACK_IMPORTED_MODULE_0__[\"Evented\"].extend({\r\n\r\n  options: {\r\n    proxy: false,\r\n    useCors: _Support__WEBPACK_IMPORTED_MODULE_1__[\"cors\"],\r\n    timeout: 0\r\n  },\r\n\r\n  initialize: function (options) {\r\n    options = options || {};\r\n    this._requestQueue = [];\r\n    this._authenticating = false;\r\n    leaflet__WEBPACK_IMPORTED_MODULE_0__[\"Util\"].setOptions(this, options);\r\n    this.options.url = Object(_Util__WEBPACK_IMPORTED_MODULE_2__[\"cleanUrl\"])(this.options.url);\r\n  },\r\n\r\n  get: function (path, params, callback, context) {\r\n    return this._request('get', path, params, callback, context);\r\n  },\r\n\r\n  post: function (path, params, callback, context) {\r\n    return this._request('post', path, params, callback, context);\r\n  },\r\n\r\n  request: function (path, params, callback, context) {\r\n    return this._request('request', path, params, callback, context);\r\n  },\r\n\r\n  metadata: function (callback, context) {\r\n    return this._request('get', '', {}, callback, context);\r\n  },\r\n\r\n  authenticate: function (token) {\r\n    this._authenticating = false;\r\n    this.options.token = token;\r\n    this._runQueue();\r\n    return this;\r\n  },\r\n\r\n  getTimeout: function () {\r\n    return this.options.timeout;\r\n  },\r\n\r\n  setTimeout: function (timeout) {\r\n    this.options.timeout = timeout;\r\n  },\r\n\r\n  _request: function (method, path, params, callback, context) {\r\n    this.fire('requeststart', {\r\n      url: this.options.url + path,\r\n      params: params,\r\n      method: method\r\n    }, true);\r\n\r\n    var wrappedCallback = this._createServiceCallback(method, path, params, callback, context);\r\n\r\n    if (this.options.token) {\r\n      params.token = this.options.token;\r\n    }\r\n    if (this.options.requestParams) {\r\n      leaflet__WEBPACK_IMPORTED_MODULE_0__[\"Util\"].extend(params, this.options.requestParams);\r\n    }\r\n    if (this._authenticating) {\r\n      this._requestQueue.push([method, path, params, callback, context]);\r\n      return;\r\n    } else {\r\n      var url = (this.options.proxy) ? this.options.proxy + '?' + this.options.url + path : this.options.url + path;\r\n\r\n      if ((method === 'get' || method === 'request') && !this.options.useCors) {\r\n        return _Request__WEBPACK_IMPORTED_MODULE_3__[\"default\"].get.JSONP(url, params, wrappedCallback, context);\r\n      } else {\r\n        return _Request__WEBPACK_IMPORTED_MODULE_3__[\"default\"][method](url, params, wrappedCallback, context);\r\n      }\r\n    }\r\n  },\r\n\r\n  _createServiceCallback: function (method, path, params, callback, context) {\r\n    return leaflet__WEBPACK_IMPORTED_MODULE_0__[\"Util\"].bind(function (error, response) {\r\n      if (error && (error.code === 499 || error.code === 498)) {\r\n        this._authenticating = true;\r\n\r\n        this._requestQueue.push([method, path, params, callback, context]);\r\n\r\n        // fire an event for users to handle and re-authenticate\r\n        this.fire('authenticationrequired', {\r\n          authenticate: leaflet__WEBPACK_IMPORTED_MODULE_0__[\"Util\"].bind(this.authenticate, this)\r\n        }, true);\r\n\r\n        // if the user has access to a callback they can handle the auth error\r\n        error.authenticate = leaflet__WEBPACK_IMPORTED_MODULE_0__[\"Util\"].bind(this.authenticate, this);\r\n      }\r\n\r\n      callback.call(context, error, response);\r\n\r\n      if (error) {\r\n        this.fire('requesterror', {\r\n          url: this.options.url + path,\r\n          params: params,\r\n          message: error.message,\r\n          code: error.code,\r\n          method: method\r\n        }, true);\r\n      } else {\r\n        this.fire('requestsuccess', {\r\n          url: this.options.url + path,\r\n          params: params,\r\n          response: response,\r\n          method: method\r\n        }, true);\r\n      }\r\n\r\n      this.fire('requestend', {\r\n        url: this.options.url + path,\r\n        params: params,\r\n        method: method\r\n      }, true);\r\n    }, this);\r\n  },\r\n\r\n  _runQueue: function () {\r\n    for (var i = this._requestQueue.length - 1; i >= 0; i--) {\r\n      var request = this._requestQueue[i];\r\n      var method = request.shift();\r\n      this[method].apply(this, request);\r\n    }\r\n    this._requestQueue = [];\r\n  }\r\n});\r\n\r\nfunction service (options) {\r\n  options = Object(_Util__WEBPACK_IMPORTED_MODULE_2__[\"getUrlParams\"])(options);\r\n  return new Service(options);\r\n}\r\n\r\n/* harmony default export */ __webpack_exports__[\"default\"] = (service);\r\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///./node_modules/esri-leaflet/src/Services/Service.js\n");

/***/ }),

/***/ "./node_modules/esri-leaflet/src/Support.js":
/*!**************************************************!*\
  !*** ./node_modules/esri-leaflet/src/Support.js ***!
  \**************************************************/
/*! exports provided: cors, pointerEvents, Support, default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"cors\", function() { return cors; });\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"pointerEvents\", function() { return pointerEvents; });\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"Support\", function() { return Support; });\nvar cors = ((window.XMLHttpRequest && 'withCredentials' in new window.XMLHttpRequest()));\r\nvar pointerEvents = document.documentElement.style.pointerEvents === '';\r\n\r\nvar Support = {\r\n  cors: cors,\r\n  pointerEvents: pointerEvents\r\n};\r\n\r\n/* harmony default export */ __webpack_exports__[\"default\"] = (Support);\r\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbIndlYnBhY2s6Ly8vLi9ub2RlX21vZHVsZXMvZXNyaS1sZWFmbGV0L3NyYy9TdXBwb3J0LmpzPzI3ZDYiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6IkFBQUE7QUFBQTtBQUFBO0FBQUE7QUFBTztBQUNBOztBQUVBO0FBQ1A7QUFDQTtBQUNBOztBQUVlLHNFQUFPLEVBQUMiLCJmaWxlIjoiLi9ub2RlX21vZHVsZXMvZXNyaS1sZWFmbGV0L3NyYy9TdXBwb3J0LmpzLmpzIiwic291cmNlc0NvbnRlbnQiOlsiZXhwb3J0IHZhciBjb3JzID0gKCh3aW5kb3cuWE1MSHR0cFJlcXVlc3QgJiYgJ3dpdGhDcmVkZW50aWFscycgaW4gbmV3IHdpbmRvdy5YTUxIdHRwUmVxdWVzdCgpKSk7XHJcbmV4cG9ydCB2YXIgcG9pbnRlckV2ZW50cyA9IGRvY3VtZW50LmRvY3VtZW50RWxlbWVudC5zdHlsZS5wb2ludGVyRXZlbnRzID09PSAnJztcclxuXHJcbmV4cG9ydCB2YXIgU3VwcG9ydCA9IHtcclxuICBjb3JzOiBjb3JzLFxyXG4gIHBvaW50ZXJFdmVudHM6IHBvaW50ZXJFdmVudHNcclxufTtcclxuXHJcbmV4cG9ydCBkZWZhdWx0IFN1cHBvcnQ7XHJcbiJdLCJzb3VyY2VSb290IjoiIn0=\n//# sourceURL=webpack-internal:///./node_modules/esri-leaflet/src/Support.js\n");

/***/ }),

/***/ "./node_modules/esri-leaflet/src/Tasks/Find.js":
/*!*****************************************************!*\
  !*** ./node_modules/esri-leaflet/src/Tasks/Find.js ***!
  \*****************************************************/
/*! exports provided: Find, find, default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"Find\", function() { return Find; });\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"find\", function() { return find; });\n/* harmony import */ var _Task__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./Task */ \"./node_modules/esri-leaflet/src/Tasks/Task.js\");\n/* harmony import */ var _Util__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../Util */ \"./node_modules/esri-leaflet/src/Util.js\");\n\r\n\r\n\r\nvar Find = _Task__WEBPACK_IMPORTED_MODULE_0__[\"Task\"].extend({\r\n  setters: {\r\n    // method name > param name\r\n    'contains': 'contains',\r\n    'text': 'searchText',\r\n    'fields': 'searchFields', // denote an array or single string\r\n    'spatialReference': 'sr',\r\n    'sr': 'sr',\r\n    'layers': 'layers',\r\n    'returnGeometry': 'returnGeometry',\r\n    'maxAllowableOffset': 'maxAllowableOffset',\r\n    'precision': 'geometryPrecision',\r\n    'dynamicLayers': 'dynamicLayers',\r\n    'returnZ': 'returnZ',\r\n    'returnM': 'returnM',\r\n    'gdbVersion': 'gdbVersion',\r\n    // skipped implementing this (for now) because the REST service implementation isnt consistent between operations\r\n    // 'transform': 'datumTransformations',\r\n    'token': 'token'\r\n  },\r\n\r\n  path: 'find',\r\n\r\n  params: {\r\n    sr: 4326,\r\n    contains: true,\r\n    returnGeometry: true,\r\n    returnZ: true,\r\n    returnM: false\r\n  },\r\n\r\n  layerDefs: function (id, where) {\r\n    this.params.layerDefs = (this.params.layerDefs) ? this.params.layerDefs + ';' : '';\r\n    this.params.layerDefs += ([id, where]).join(':');\r\n    return this;\r\n  },\r\n\r\n  simplify: function (map, factor) {\r\n    var mapWidth = Math.abs(map.getBounds().getWest() - map.getBounds().getEast());\r\n    this.params.maxAllowableOffset = (mapWidth / map.getSize().y) * factor;\r\n    return this;\r\n  },\r\n\r\n  run: function (callback, context) {\r\n    return this.request(function (error, response) {\r\n      callback.call(context, error, (response && Object(_Util__WEBPACK_IMPORTED_MODULE_1__[\"responseToFeatureCollection\"])(response)), response);\r\n    }, context);\r\n  }\r\n});\r\n\r\nfunction find (options) {\r\n  return new Find(options);\r\n}\r\n\r\n/* harmony default export */ __webpack_exports__[\"default\"] = (find);\r\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///./node_modules/esri-leaflet/src/Tasks/Find.js\n");

/***/ }),

/***/ "./node_modules/esri-leaflet/src/Tasks/Identify.js":
/*!*********************************************************!*\
  !*** ./node_modules/esri-leaflet/src/Tasks/Identify.js ***!
  \*********************************************************/
/*! exports provided: Identify, identify, default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"Identify\", function() { return Identify; });\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"identify\", function() { return identify; });\n/* harmony import */ var _Task__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./Task */ \"./node_modules/esri-leaflet/src/Tasks/Task.js\");\n\r\n\r\nvar Identify = _Task__WEBPACK_IMPORTED_MODULE_0__[\"Task\"].extend({\r\n  path: 'identify',\r\n\r\n  between: function (start, end) {\r\n    this.params.time = [start.valueOf(), end.valueOf()];\r\n    return this;\r\n  }\r\n});\r\n\r\nfunction identify (options) {\r\n  return new Identify(options);\r\n}\r\n\r\n/* harmony default export */ __webpack_exports__[\"default\"] = (identify);\r\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbIndlYnBhY2s6Ly8vLi9ub2RlX21vZHVsZXMvZXNyaS1sZWFmbGV0L3NyYy9UYXNrcy9JZGVudGlmeS5qcz84N2RhIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiJBQUFBO0FBQUE7QUFBQTtBQUFBO0FBQThCOztBQUV2QixlQUFlLDBDQUFJO0FBQzFCOztBQUVBO0FBQ0E7QUFDQTtBQUNBO0FBQ0EsQ0FBQzs7QUFFTTtBQUNQO0FBQ0E7O0FBRWUsdUVBQVEsRUFBQyIsImZpbGUiOiIuL25vZGVfbW9kdWxlcy9lc3JpLWxlYWZsZXQvc3JjL1Rhc2tzL0lkZW50aWZ5LmpzLmpzIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IHsgVGFzayB9IGZyb20gJy4vVGFzayc7XHJcblxyXG5leHBvcnQgdmFyIElkZW50aWZ5ID0gVGFzay5leHRlbmQoe1xyXG4gIHBhdGg6ICdpZGVudGlmeScsXHJcblxyXG4gIGJldHdlZW46IGZ1bmN0aW9uIChzdGFydCwgZW5kKSB7XHJcbiAgICB0aGlzLnBhcmFtcy50aW1lID0gW3N0YXJ0LnZhbHVlT2YoKSwgZW5kLnZhbHVlT2YoKV07XHJcbiAgICByZXR1cm4gdGhpcztcclxuICB9XHJcbn0pO1xyXG5cclxuZXhwb3J0IGZ1bmN0aW9uIGlkZW50aWZ5IChvcHRpb25zKSB7XHJcbiAgcmV0dXJuIG5ldyBJZGVudGlmeShvcHRpb25zKTtcclxufVxyXG5cclxuZXhwb3J0IGRlZmF1bHQgaWRlbnRpZnk7XHJcbiJdLCJzb3VyY2VSb290IjoiIn0=\n//# sourceURL=webpack-internal:///./node_modules/esri-leaflet/src/Tasks/Identify.js\n");

/***/ }),

/***/ "./node_modules/esri-leaflet/src/Tasks/IdentifyFeatures.js":
/*!*****************************************************************!*\
  !*** ./node_modules/esri-leaflet/src/Tasks/IdentifyFeatures.js ***!
  \*****************************************************************/
/*! exports provided: IdentifyFeatures, identifyFeatures, default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"IdentifyFeatures\", function() { return IdentifyFeatures; });\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"identifyFeatures\", function() { return identifyFeatures; });\n/* harmony import */ var leaflet__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! leaflet */ \"./node_modules/leaflet/dist/leaflet-src.js\");\n/* harmony import */ var leaflet__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(leaflet__WEBPACK_IMPORTED_MODULE_0__);\n/* harmony import */ var _Identify__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./Identify */ \"./node_modules/esri-leaflet/src/Tasks/Identify.js\");\n/* harmony import */ var _Util__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../Util */ \"./node_modules/esri-leaflet/src/Util.js\");\n\r\n\r\n\r\n\r\nvar IdentifyFeatures = _Identify__WEBPACK_IMPORTED_MODULE_1__[\"Identify\"].extend({\r\n  setters: {\r\n    'layers': 'layers',\r\n    'precision': 'geometryPrecision',\r\n    'tolerance': 'tolerance',\r\n    // skipped implementing this (for now) because the REST service implementation isnt consistent between operations.\r\n    // 'transform': 'datumTransformations'\r\n    'returnGeometry': 'returnGeometry'\r\n  },\r\n\r\n  params: {\r\n    sr: 4326,\r\n    layers: 'all',\r\n    tolerance: 3,\r\n    returnGeometry: true\r\n  },\r\n\r\n  on: function (map) {\r\n    var extent = Object(_Util__WEBPACK_IMPORTED_MODULE_2__[\"boundsToExtent\"])(map.getBounds());\r\n    var size = map.getSize();\r\n    this.params.imageDisplay = [size.x, size.y, 96];\r\n    this.params.mapExtent = [extent.xmin, extent.ymin, extent.xmax, extent.ymax];\r\n    return this;\r\n  },\r\n\r\n  at: function (geometry) {\r\n    // cast lat, long pairs in raw array form manually\r\n    if (geometry.length === 2) {\r\n      geometry = Object(leaflet__WEBPACK_IMPORTED_MODULE_0__[\"latLng\"])(geometry);\r\n    }\r\n    this._setGeometryParams(geometry);\r\n    return this;\r\n  },\r\n\r\n  layerDef: function (id, where) {\r\n    this.params.layerDefs = (this.params.layerDefs) ? this.params.layerDefs + ';' : '';\r\n    this.params.layerDefs += ([id, where]).join(':');\r\n    return this;\r\n  },\r\n\r\n  simplify: function (map, factor) {\r\n    var mapWidth = Math.abs(map.getBounds().getWest() - map.getBounds().getEast());\r\n    this.params.maxAllowableOffset = (mapWidth / map.getSize().y) * factor;\r\n    return this;\r\n  },\r\n\r\n  run: function (callback, context) {\r\n    return this.request(function (error, response) {\r\n      // immediately invoke with an error\r\n      if (error) {\r\n        callback.call(context, error, undefined, response);\r\n        return;\r\n\r\n      // ok no error lets just assume we have features...\r\n      } else {\r\n        var featureCollection = Object(_Util__WEBPACK_IMPORTED_MODULE_2__[\"responseToFeatureCollection\"])(response);\r\n        response.results = response.results.reverse();\r\n        for (var i = 0; i < featureCollection.features.length; i++) {\r\n          var feature = featureCollection.features[i];\r\n          feature.layerId = response.results[i].layerId;\r\n        }\r\n        callback.call(context, undefined, featureCollection, response);\r\n      }\r\n    });\r\n  },\r\n\r\n  _setGeometryParams: function (geometry) {\r\n    var converted = Object(_Util__WEBPACK_IMPORTED_MODULE_2__[\"_setGeometry\"])(geometry);\r\n    this.params.geometry = converted.geometry;\r\n    this.params.geometryType = converted.geometryType;\r\n  }\r\n});\r\n\r\nfunction identifyFeatures (options) {\r\n  return new IdentifyFeatures(options);\r\n}\r\n\r\n/* harmony default export */ __webpack_exports__[\"default\"] = (identifyFeatures);\r\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///./node_modules/esri-leaflet/src/Tasks/IdentifyFeatures.js\n");

/***/ }),

/***/ "./node_modules/esri-leaflet/src/Tasks/IdentifyImage.js":
/*!**************************************************************!*\
  !*** ./node_modules/esri-leaflet/src/Tasks/IdentifyImage.js ***!
  \**************************************************************/
/*! exports provided: IdentifyImage, identifyImage, default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"IdentifyImage\", function() { return IdentifyImage; });\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"identifyImage\", function() { return identifyImage; });\n/* harmony import */ var leaflet__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! leaflet */ \"./node_modules/leaflet/dist/leaflet-src.js\");\n/* harmony import */ var leaflet__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(leaflet__WEBPACK_IMPORTED_MODULE_0__);\n/* harmony import */ var _Identify__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./Identify */ \"./node_modules/esri-leaflet/src/Tasks/Identify.js\");\n/* harmony import */ var _Util__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../Util */ \"./node_modules/esri-leaflet/src/Util.js\");\n\r\n\r\n\r\n\r\nvar IdentifyImage = _Identify__WEBPACK_IMPORTED_MODULE_1__[\"Identify\"].extend({\r\n  setters: {\r\n    'setMosaicRule': 'mosaicRule',\r\n    'setRenderingRule': 'renderingRule',\r\n    'setPixelSize': 'pixelSize',\r\n    'returnCatalogItems': 'returnCatalogItems',\r\n    'returnGeometry': 'returnGeometry'\r\n  },\r\n\r\n  params: {\r\n    returnGeometry: false\r\n  },\r\n\r\n  at: function (latlng) {\r\n    latlng = Object(leaflet__WEBPACK_IMPORTED_MODULE_0__[\"latLng\"])(latlng);\r\n    this.params.geometry = JSON.stringify({\r\n      x: latlng.lng,\r\n      y: latlng.lat,\r\n      spatialReference: {\r\n        wkid: 4326\r\n      }\r\n    });\r\n    this.params.geometryType = 'esriGeometryPoint';\r\n    return this;\r\n  },\r\n\r\n  getMosaicRule: function () {\r\n    return this.params.mosaicRule;\r\n  },\r\n\r\n  getRenderingRule: function () {\r\n    return this.params.renderingRule;\r\n  },\r\n\r\n  getPixelSize: function () {\r\n    return this.params.pixelSize;\r\n  },\r\n\r\n  run: function (callback, context) {\r\n    return this.request(function (error, response) {\r\n      callback.call(context, error, (response && this._responseToGeoJSON(response)), response);\r\n    }, this);\r\n  },\r\n\r\n  // get pixel data and return as geoJSON point\r\n  // populate catalog items (if any)\r\n  // merging in any catalogItemVisibilities as a propery of each feature\r\n  _responseToGeoJSON: function (response) {\r\n    var location = response.location;\r\n    var catalogItems = response.catalogItems;\r\n    var catalogItemVisibilities = response.catalogItemVisibilities;\r\n    var geoJSON = {\r\n      'pixel': {\r\n        'type': 'Feature',\r\n        'geometry': {\r\n          'type': 'Point',\r\n          'coordinates': [location.x, location.y]\r\n        },\r\n        'crs': {\r\n          'type': 'EPSG',\r\n          'properties': {\r\n            'code': location.spatialReference.wkid\r\n          }\r\n        },\r\n        'properties': {\r\n          'OBJECTID': response.objectId,\r\n          'name': response.name,\r\n          'value': response.value\r\n        },\r\n        'id': response.objectId\r\n      }\r\n    };\r\n\r\n    if (response.properties && response.properties.Values) {\r\n      geoJSON.pixel.properties.values = response.properties.Values;\r\n    }\r\n\r\n    if (catalogItems && catalogItems.features) {\r\n      geoJSON.catalogItems = Object(_Util__WEBPACK_IMPORTED_MODULE_2__[\"responseToFeatureCollection\"])(catalogItems);\r\n      if (catalogItemVisibilities && catalogItemVisibilities.length === geoJSON.catalogItems.features.length) {\r\n        for (var i = catalogItemVisibilities.length - 1; i >= 0; i--) {\r\n          geoJSON.catalogItems.features[i].properties.catalogItemVisibility = catalogItemVisibilities[i];\r\n        }\r\n      }\r\n    }\r\n    return geoJSON;\r\n  }\r\n\r\n});\r\n\r\nfunction identifyImage (params) {\r\n  return new IdentifyImage(params);\r\n}\r\n\r\n/* harmony default export */ __webpack_exports__[\"default\"] = (identifyImage);\r\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///./node_modules/esri-leaflet/src/Tasks/IdentifyImage.js\n");

/***/ }),

/***/ "./node_modules/esri-leaflet/src/Tasks/Query.js":
/*!******************************************************!*\
  !*** ./node_modules/esri-leaflet/src/Tasks/Query.js ***!
  \******************************************************/
/*! exports provided: Query, query, default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"Query\", function() { return Query; });\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"query\", function() { return query; });\n/* harmony import */ var leaflet__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! leaflet */ \"./node_modules/leaflet/dist/leaflet-src.js\");\n/* harmony import */ var leaflet__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(leaflet__WEBPACK_IMPORTED_MODULE_0__);\n/* harmony import */ var _Task__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./Task */ \"./node_modules/esri-leaflet/src/Tasks/Task.js\");\n/* harmony import */ var _Util__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../Util */ \"./node_modules/esri-leaflet/src/Util.js\");\n\r\n\r\n\r\n\r\nvar Query = _Task__WEBPACK_IMPORTED_MODULE_1__[\"Task\"].extend({\r\n  setters: {\r\n    'offset': 'resultOffset',\r\n    'limit': 'resultRecordCount',\r\n    'fields': 'outFields',\r\n    'precision': 'geometryPrecision',\r\n    'featureIds': 'objectIds',\r\n    'returnGeometry': 'returnGeometry',\r\n    'returnM': 'returnM',\r\n    'transform': 'datumTransformation',\r\n    'token': 'token'\r\n  },\r\n\r\n  path: 'query',\r\n\r\n  params: {\r\n    returnGeometry: true,\r\n    where: '1=1',\r\n    outSR: 4326,\r\n    outFields: '*'\r\n  },\r\n\r\n  // Returns a feature if its shape is wholly contained within the search geometry. Valid for all shape type combinations.\r\n  within: function (geometry) {\r\n    this._setGeometryParams(geometry);\r\n    this.params.spatialRel = 'esriSpatialRelContains'; // to the REST api this reads geometry **contains** layer\r\n    return this;\r\n  },\r\n\r\n  // Returns a feature if any spatial relationship is found. Applies to all shape type combinations.\r\n  intersects: function (geometry) {\r\n    this._setGeometryParams(geometry);\r\n    this.params.spatialRel = 'esriSpatialRelIntersects';\r\n    return this;\r\n  },\r\n\r\n  // Returns a feature if its shape wholly contains the search geometry. Valid for all shape type combinations.\r\n  contains: function (geometry) {\r\n    this._setGeometryParams(geometry);\r\n    this.params.spatialRel = 'esriSpatialRelWithin'; // to the REST api this reads geometry **within** layer\r\n    return this;\r\n  },\r\n\r\n  // Returns a feature if the intersection of the interiors of the two shapes is not empty and has a lower dimension than the maximum dimension of the two shapes. Two lines that share an endpoint in common do not cross. Valid for Line/Line, Line/Area, Multi-point/Area, and Multi-point/Line shape type combinations.\r\n  crosses: function (geometry) {\r\n    this._setGeometryParams(geometry);\r\n    this.params.spatialRel = 'esriSpatialRelCrosses';\r\n    return this;\r\n  },\r\n\r\n  // Returns a feature if the two shapes share a common boundary. However, the intersection of the interiors of the two shapes must be empty. In the Point/Line case, the point may touch an endpoint only of the line. Applies to all combinations except Point/Point.\r\n  touches: function (geometry) {\r\n    this._setGeometryParams(geometry);\r\n    this.params.spatialRel = 'esriSpatialRelTouches';\r\n    return this;\r\n  },\r\n\r\n  // Returns a feature if the intersection of the two shapes results in an object of the same dimension, but different from both of the shapes. Applies to Area/Area, Line/Line, and Multi-point/Multi-point shape type combinations.\r\n  overlaps: function (geometry) {\r\n    this._setGeometryParams(geometry);\r\n    this.params.spatialRel = 'esriSpatialRelOverlaps';\r\n    return this;\r\n  },\r\n\r\n  // Returns a feature if the envelope of the two shapes intersects.\r\n  bboxIntersects: function (geometry) {\r\n    this._setGeometryParams(geometry);\r\n    this.params.spatialRel = 'esriSpatialRelEnvelopeIntersects';\r\n    return this;\r\n  },\r\n\r\n  // if someone can help decipher the ArcObjects explanation and translate to plain speak, we should mention this method in the doc\r\n  indexIntersects: function (geometry) {\r\n    this._setGeometryParams(geometry);\r\n    this.params.spatialRel = 'esriSpatialRelIndexIntersects'; // Returns a feature if the envelope of the query geometry intersects the index entry for the target geometry\r\n    return this;\r\n  },\r\n\r\n  // only valid for Feature Services running on ArcGIS Server 10.3+ or ArcGIS Online\r\n  nearby: function (latlng, radius) {\r\n    latlng = Object(leaflet__WEBPACK_IMPORTED_MODULE_0__[\"latLng\"])(latlng);\r\n    this.params.geometry = [latlng.lng, latlng.lat];\r\n    this.params.geometryType = 'esriGeometryPoint';\r\n    this.params.spatialRel = 'esriSpatialRelIntersects';\r\n    this.params.units = 'esriSRUnit_Meter';\r\n    this.params.distance = radius;\r\n    this.params.inSR = 4326;\r\n    return this;\r\n  },\r\n\r\n  where: function (string) {\r\n    // instead of converting double-quotes to single quotes, pass as is, and provide a more informative message if a 400 is encountered\r\n    this.params.where = string;\r\n    return this;\r\n  },\r\n\r\n  between: function (start, end) {\r\n    this.params.time = [start.valueOf(), end.valueOf()];\r\n    return this;\r\n  },\r\n\r\n  simplify: function (map, factor) {\r\n    var mapWidth = Math.abs(map.getBounds().getWest() - map.getBounds().getEast());\r\n    this.params.maxAllowableOffset = (mapWidth / map.getSize().y) * factor;\r\n    return this;\r\n  },\r\n\r\n  orderBy: function (fieldName, order) {\r\n    order = order || 'ASC';\r\n    this.params.orderByFields = (this.params.orderByFields) ? this.params.orderByFields + ',' : '';\r\n    this.params.orderByFields += ([fieldName, order]).join(' ');\r\n    return this;\r\n  },\r\n\r\n  run: function (callback, context) {\r\n    this._cleanParams();\r\n\r\n    // services hosted on ArcGIS Online and ArcGIS Server 10.3.1+ support requesting geojson directly\r\n    if (this.options.isModern || (Object(_Util__WEBPACK_IMPORTED_MODULE_2__[\"isArcgisOnline\"])(this.options.url) && this.options.isModern === undefined)) {\r\n      this.params.f = 'geojson';\r\n\r\n      return this.request(function (error, response) {\r\n        this._trapSQLerrors(error);\r\n        callback.call(context, error, response, response);\r\n      }, this);\r\n\r\n      // otherwise convert it in the callback then pass it on\r\n    } else {\r\n      return this.request(function (error, response) {\r\n        this._trapSQLerrors(error);\r\n        callback.call(context, error, (response && Object(_Util__WEBPACK_IMPORTED_MODULE_2__[\"responseToFeatureCollection\"])(response)), response);\r\n      }, this);\r\n    }\r\n  },\r\n\r\n  count: function (callback, context) {\r\n    this._cleanParams();\r\n    this.params.returnCountOnly = true;\r\n    return this.request(function (error, response) {\r\n      callback.call(this, error, (response && response.count), response);\r\n    }, context);\r\n  },\r\n\r\n  ids: function (callback, context) {\r\n    this._cleanParams();\r\n    this.params.returnIdsOnly = true;\r\n    return this.request(function (error, response) {\r\n      callback.call(this, error, (response && response.objectIds), response);\r\n    }, context);\r\n  },\r\n\r\n  // only valid for Feature Services running on ArcGIS Server 10.3+ or ArcGIS Online\r\n  bounds: function (callback, context) {\r\n    this._cleanParams();\r\n    this.params.returnExtentOnly = true;\r\n    return this.request(function (error, response) {\r\n      if (response && response.extent && Object(_Util__WEBPACK_IMPORTED_MODULE_2__[\"extentToBounds\"])(response.extent)) {\r\n        callback.call(context, error, Object(_Util__WEBPACK_IMPORTED_MODULE_2__[\"extentToBounds\"])(response.extent), response);\r\n      } else {\r\n        error = {\r\n          message: 'Invalid Bounds'\r\n        };\r\n        callback.call(context, error, null, response);\r\n      }\r\n    }, context);\r\n  },\r\n\r\n  distinct: function () {\r\n    // geometry must be omitted for queries requesting distinct values\r\n    this.params.returnGeometry = false;\r\n    this.params.returnDistinctValues = true;\r\n    return this;\r\n  },\r\n\r\n  // only valid for image services\r\n  pixelSize: function (rawPoint) {\r\n    var castPoint = Object(leaflet__WEBPACK_IMPORTED_MODULE_0__[\"point\"])(rawPoint);\r\n    this.params.pixelSize = [castPoint.x, castPoint.y];\r\n    return this;\r\n  },\r\n\r\n  // only valid for map services\r\n  layer: function (layer) {\r\n    this.path = layer + '/query';\r\n    return this;\r\n  },\r\n\r\n  _trapSQLerrors: function (error) {\r\n    if (error) {\r\n      if (error.code === '400') {\r\n        Object(_Util__WEBPACK_IMPORTED_MODULE_2__[\"warn\"])('one common syntax error in query requests is encasing string values in double quotes instead of single quotes');\r\n      }\r\n    }\r\n  },\r\n\r\n  _cleanParams: function () {\r\n    delete this.params.returnIdsOnly;\r\n    delete this.params.returnExtentOnly;\r\n    delete this.params.returnCountOnly;\r\n  },\r\n\r\n  _setGeometryParams: function (geometry) {\r\n    this.params.inSR = 4326;\r\n    var converted = Object(_Util__WEBPACK_IMPORTED_MODULE_2__[\"_setGeometry\"])(geometry);\r\n    this.params.geometry = converted.geometry;\r\n    this.params.geometryType = converted.geometryType;\r\n  }\r\n\r\n});\r\n\r\nfunction query (options) {\r\n  return new Query(options);\r\n}\r\n\r\n/* harmony default export */ __webpack_exports__[\"default\"] = (query);\r\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///./node_modules/esri-leaflet/src/Tasks/Query.js\n");

/***/ }),

/***/ "./node_modules/esri-leaflet/src/Tasks/Task.js":
/*!*****************************************************!*\
  !*** ./node_modules/esri-leaflet/src/Tasks/Task.js ***!
  \*****************************************************/
/*! exports provided: Task, task, default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"Task\", function() { return Task; });\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"task\", function() { return task; });\n/* harmony import */ var leaflet__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! leaflet */ \"./node_modules/leaflet/dist/leaflet-src.js\");\n/* harmony import */ var leaflet__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(leaflet__WEBPACK_IMPORTED_MODULE_0__);\n/* harmony import */ var _Support__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../Support */ \"./node_modules/esri-leaflet/src/Support.js\");\n/* harmony import */ var _Util__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../Util */ \"./node_modules/esri-leaflet/src/Util.js\");\n/* harmony import */ var _Request__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../Request */ \"./node_modules/esri-leaflet/src/Request.js\");\n\r\n\r\n\r\n\r\n\r\nvar Task = leaflet__WEBPACK_IMPORTED_MODULE_0__[\"Class\"].extend({\r\n\r\n  options: {\r\n    proxy: false,\r\n    useCors: _Support__WEBPACK_IMPORTED_MODULE_1__[\"cors\"]\r\n  },\r\n\r\n  // Generate a method for each methodName:paramName in the setters for this task.\r\n  generateSetter: function (param, context) {\r\n    return leaflet__WEBPACK_IMPORTED_MODULE_0__[\"Util\"].bind(function (value) {\r\n      this.params[param] = value;\r\n      return this;\r\n    }, context);\r\n  },\r\n\r\n  initialize: function (endpoint) {\r\n    // endpoint can be either a url (and options) for an ArcGIS Rest Service or an instance of EsriLeaflet.Service\r\n    if (endpoint.request && endpoint.options) {\r\n      this._service = endpoint;\r\n      leaflet__WEBPACK_IMPORTED_MODULE_0__[\"Util\"].setOptions(this, endpoint.options);\r\n    } else {\r\n      leaflet__WEBPACK_IMPORTED_MODULE_0__[\"Util\"].setOptions(this, endpoint);\r\n      this.options.url = Object(_Util__WEBPACK_IMPORTED_MODULE_2__[\"cleanUrl\"])(endpoint.url);\r\n    }\r\n\r\n    // clone default params into this object\r\n    this.params = leaflet__WEBPACK_IMPORTED_MODULE_0__[\"Util\"].extend({}, this.params || {});\r\n\r\n    // generate setter methods based on the setters object implimented a child class\r\n    if (this.setters) {\r\n      for (var setter in this.setters) {\r\n        var param = this.setters[setter];\r\n        this[setter] = this.generateSetter(param, this);\r\n      }\r\n    }\r\n  },\r\n\r\n  token: function (token) {\r\n    if (this._service) {\r\n      this._service.authenticate(token);\r\n    } else {\r\n      this.params.token = token;\r\n    }\r\n    return this;\r\n  },\r\n\r\n  // ArcGIS Server Find/Identify 10.5+\r\n  format: function (boolean) {\r\n    // use double negative to expose a more intuitive positive method name\r\n    this.params.returnUnformattedValues = !boolean;\r\n    return this;\r\n  },\r\n\r\n  request: function (callback, context) {\r\n    if (this.options.requestParams) {\r\n      leaflet__WEBPACK_IMPORTED_MODULE_0__[\"Util\"].extend(this.params, this.options.requestParams);\r\n    }\r\n    if (this._service) {\r\n      return this._service.request(this.path, this.params, callback, context);\r\n    }\r\n\r\n    return this._request('request', this.path, this.params, callback, context);\r\n  },\r\n\r\n  _request: function (method, path, params, callback, context) {\r\n    var url = (this.options.proxy) ? this.options.proxy + '?' + this.options.url + path : this.options.url + path;\r\n\r\n    if ((method === 'get' || method === 'request') && !this.options.useCors) {\r\n      return _Request__WEBPACK_IMPORTED_MODULE_3__[\"default\"].get.JSONP(url, params, callback, context);\r\n    }\r\n\r\n    return _Request__WEBPACK_IMPORTED_MODULE_3__[\"default\"][method](url, params, callback, context);\r\n  }\r\n});\r\n\r\nfunction task (options) {\r\n  options = Object(_Util__WEBPACK_IMPORTED_MODULE_2__[\"getUrlParams\"])(options);\r\n  return new Task(options);\r\n}\r\n\r\n/* harmony default export */ __webpack_exports__[\"default\"] = (task);\r\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///./node_modules/esri-leaflet/src/Tasks/Task.js\n");

/***/ }),

/***/ "./node_modules/esri-leaflet/src/Util.js":
/*!***********************************************!*\
  !*** ./node_modules/esri-leaflet/src/Util.js ***!
  \***********************************************/
/*! exports provided: geojsonToArcGIS, arcgisToGeoJSON, extentToBounds, boundsToExtent, _findIdAttributeFromResponse, _findIdAttributeFromFeature, responseToFeatureCollection, cleanUrl, getUrlParams, isArcgisOnline, geojsonTypeToArcGIS, calcAttributionWidth, setEsriAttribution, removeEsriAttribution, _setGeometry, _getAttributionData, _updateMapAttribution, warn, EsriUtil, default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"geojsonToArcGIS\", function() { return geojsonToArcGIS; });\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"arcgisToGeoJSON\", function() { return arcgisToGeoJSON; });\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"extentToBounds\", function() { return extentToBounds; });\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"boundsToExtent\", function() { return boundsToExtent; });\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"_findIdAttributeFromResponse\", function() { return _findIdAttributeFromResponse; });\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"_findIdAttributeFromFeature\", function() { return _findIdAttributeFromFeature; });\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"responseToFeatureCollection\", function() { return responseToFeatureCollection; });\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"cleanUrl\", function() { return cleanUrl; });\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"getUrlParams\", function() { return getUrlParams; });\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"isArcgisOnline\", function() { return isArcgisOnline; });\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"geojsonTypeToArcGIS\", function() { return geojsonTypeToArcGIS; });\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"calcAttributionWidth\", function() { return calcAttributionWidth; });\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"setEsriAttribution\", function() { return setEsriAttribution; });\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"removeEsriAttribution\", function() { return removeEsriAttribution; });\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"_setGeometry\", function() { return _setGeometry; });\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"_getAttributionData\", function() { return _getAttributionData; });\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"_updateMapAttribution\", function() { return _updateMapAttribution; });\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"EsriUtil\", function() { return EsriUtil; });\n/* harmony import */ var leaflet__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! leaflet */ \"./node_modules/leaflet/dist/leaflet-src.js\");\n/* harmony import */ var leaflet__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(leaflet__WEBPACK_IMPORTED_MODULE_0__);\n/* harmony import */ var _Request__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./Request */ \"./node_modules/esri-leaflet/src/Request.js\");\n/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, \"warn\", function() { return _Request__WEBPACK_IMPORTED_MODULE_1__[\"warn\"]; });\n\n/* harmony import */ var _Options__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./Options */ \"./node_modules/esri-leaflet/src/Options.js\");\n/* harmony import */ var _Support__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./Support */ \"./node_modules/esri-leaflet/src/Support.js\");\n/* harmony import */ var _terraformer_arcgis__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @terraformer/arcgis */ \"./node_modules/@terraformer/arcgis/dist/t-arcgis.esm.js\");\n\r\n\r\n\r\n\r\n\r\n\r\n\r\nvar BASE_LEAFLET_ATTRIBUTION_STRING = '<a href=\"http://leafletjs.com\" title=\"A JS library for interactive maps\">Leaflet</a>';\r\nvar POWERED_BY_ESRI_ATTRIBUTION_STRING = 'Powered by <a href=\"https://www.esri.com\">Esri</a>';\r\n\r\nfunction geojsonToArcGIS (geojson, idAttr) {\r\n  return Object(_terraformer_arcgis__WEBPACK_IMPORTED_MODULE_4__[\"geojsonToArcGIS\"])(geojson, idAttr);\r\n}\r\n\r\nfunction arcgisToGeoJSON (arcgis, idAttr) {\r\n  return Object(_terraformer_arcgis__WEBPACK_IMPORTED_MODULE_4__[\"arcgisToGeoJSON\"])(arcgis, idAttr);\r\n}\r\n\r\n// convert an extent (ArcGIS) to LatLngBounds (Leaflet)\r\nfunction extentToBounds (extent) {\r\n  // \"NaN\" coordinates from ArcGIS Server indicate a null geometry\r\n  if (extent.xmin !== 'NaN' && extent.ymin !== 'NaN' && extent.xmax !== 'NaN' && extent.ymax !== 'NaN') {\r\n    var sw = Object(leaflet__WEBPACK_IMPORTED_MODULE_0__[\"latLng\"])(extent.ymin, extent.xmin);\r\n    var ne = Object(leaflet__WEBPACK_IMPORTED_MODULE_0__[\"latLng\"])(extent.ymax, extent.xmax);\r\n    return Object(leaflet__WEBPACK_IMPORTED_MODULE_0__[\"latLngBounds\"])(sw, ne);\r\n  } else {\r\n    return null;\r\n  }\r\n}\r\n\r\n// convert an LatLngBounds (Leaflet) to extent (ArcGIS)\r\nfunction boundsToExtent (bounds) {\r\n  bounds = Object(leaflet__WEBPACK_IMPORTED_MODULE_0__[\"latLngBounds\"])(bounds);\r\n  return {\r\n    'xmin': bounds.getSouthWest().lng,\r\n    'ymin': bounds.getSouthWest().lat,\r\n    'xmax': bounds.getNorthEast().lng,\r\n    'ymax': bounds.getNorthEast().lat,\r\n    'spatialReference': {\r\n      'wkid': 4326\r\n    }\r\n  };\r\n}\r\n\r\nvar knownFieldNames = /^(OBJECTID|FID|OID|ID)$/i;\r\n\r\n// Attempts to find the ID Field from response\r\nfunction _findIdAttributeFromResponse (response) {\r\n  var result;\r\n\r\n  if (response.objectIdFieldName) {\r\n    // Find Id Field directly\r\n    result = response.objectIdFieldName;\r\n  } else if (response.fields) {\r\n    // Find ID Field based on field type\r\n    for (var j = 0; j <= response.fields.length - 1; j++) {\r\n      if (response.fields[j].type === 'esriFieldTypeOID') {\r\n        result = response.fields[j].name;\r\n        break;\r\n      }\r\n    }\r\n    if (!result) {\r\n      // If no field was marked as being the esriFieldTypeOID try well known field names\r\n      for (j = 0; j <= response.fields.length - 1; j++) {\r\n        if (response.fields[j].name.match(knownFieldNames)) {\r\n          result = response.fields[j].name;\r\n          break;\r\n        }\r\n      }\r\n    }\r\n  }\r\n  return result;\r\n}\r\n\r\n// This is the 'last' resort, find the Id field from the specified feature\r\nfunction _findIdAttributeFromFeature (feature) {\r\n  for (var key in feature.attributes) {\r\n    if (key.match(knownFieldNames)) {\r\n      return key;\r\n    }\r\n  }\r\n}\r\n\r\nfunction responseToFeatureCollection (response, idAttribute) {\r\n  var objectIdField;\r\n  var features = response.features || response.results;\r\n  var count = features && features.length;\r\n\r\n  if (idAttribute) {\r\n    objectIdField = idAttribute;\r\n  } else {\r\n    objectIdField = _findIdAttributeFromResponse(response);\r\n  }\r\n\r\n  var featureCollection = {\r\n    type: 'FeatureCollection',\r\n    features: []\r\n  };\r\n\r\n  if (count) {\r\n    for (var i = features.length - 1; i >= 0; i--) {\r\n      var feature = arcgisToGeoJSON(features[i], objectIdField || _findIdAttributeFromFeature(features[i]));\r\n      featureCollection.features.push(feature);\r\n    }\r\n  }\r\n\r\n  return featureCollection;\r\n}\r\n\r\n  // trim url whitespace and add a trailing slash if needed\r\nfunction cleanUrl (url) {\r\n  // trim leading and trailing spaces, but not spaces inside the url\r\n  url = leaflet__WEBPACK_IMPORTED_MODULE_0__[\"Util\"].trim(url);\r\n\r\n  // add a trailing slash to the url if the user omitted it\r\n  if (url[url.length - 1] !== '/') {\r\n    url += '/';\r\n  }\r\n\r\n  return url;\r\n}\r\n\r\n/* Extract url params if any and store them in requestParams attribute.\r\n   Return the options params updated */\r\nfunction getUrlParams (options) {\r\n  if (options.url.indexOf('?') !== -1) {\r\n    options.requestParams = options.requestParams || {};\r\n    var queryString = options.url.substring(options.url.indexOf('?') + 1);\r\n    options.url = options.url.split('?')[0];\r\n    options.requestParams = JSON.parse('{\"' + decodeURI(queryString).replace(/\"/g, '\\\\\"').replace(/&/g, '\",\"').replace(/=/g, '\":\"') + '\"}');\r\n  }\r\n  options.url = cleanUrl(options.url.split('?')[0]);\r\n  return options;\r\n}\r\n\r\nfunction isArcgisOnline (url) {\r\n  /* hosted feature services support geojson as an output format\r\n  utility.arcgis.com services are proxied from a variety of ArcGIS Server vintages, and may not */\r\n  return (/^(?!.*utility\\.arcgis\\.com).*\\.arcgis\\.com.*FeatureServer/i).test(url);\r\n}\r\n\r\nfunction geojsonTypeToArcGIS (geoJsonType) {\r\n  var arcgisGeometryType;\r\n  switch (geoJsonType) {\r\n    case 'Point':\r\n      arcgisGeometryType = 'esriGeometryPoint';\r\n      break;\r\n    case 'MultiPoint':\r\n      arcgisGeometryType = 'esriGeometryMultipoint';\r\n      break;\r\n    case 'LineString':\r\n      arcgisGeometryType = 'esriGeometryPolyline';\r\n      break;\r\n    case 'MultiLineString':\r\n      arcgisGeometryType = 'esriGeometryPolyline';\r\n      break;\r\n    case 'Polygon':\r\n      arcgisGeometryType = 'esriGeometryPolygon';\r\n      break;\r\n    case 'MultiPolygon':\r\n      arcgisGeometryType = 'esriGeometryPolygon';\r\n      break;\r\n  }\r\n\r\n  return arcgisGeometryType;\r\n}\r\n\r\nfunction calcAttributionWidth (map) {\r\n  // either crop at 55px or user defined buffer\r\n  return (map.getSize().x - _Options__WEBPACK_IMPORTED_MODULE_2__[\"options\"].attributionWidthOffset) + 'px';\r\n}\r\n\r\nfunction setEsriAttribution (map) {\r\n  if (!map.attributionControl) {\r\n    return;\r\n  }\r\n\r\n  if (!map.attributionControl._esriAttributionLayerCount) {\r\n    map.attributionControl._esriAttributionLayerCount = 0;\r\n  }\r\n\r\n  if (map.attributionControl._esriAttributionLayerCount === 0) {\r\n    // Dynamically creating the CSS rules, only run this once per page load:\r\n    if (!map.attributionControl._esriAttributionAddedOnce) {\r\n      var hoverAttributionStyle = document.createElement('style');\r\n      hoverAttributionStyle.type = 'text/css';\r\n      hoverAttributionStyle.innerHTML = '.esri-truncated-attribution:hover {' +\r\n        'white-space: normal;' +\r\n      '}';\r\n      document.getElementsByTagName('head')[0].appendChild(hoverAttributionStyle);\r\n\r\n      // define a new css class in JS to trim attribution into a single line\r\n      var attributionStyle = document.createElement('style');\r\n      attributionStyle.type = 'text/css';\r\n      attributionStyle.innerHTML = '.esri-truncated-attribution {' +\r\n        'vertical-align: -3px;' +\r\n        'white-space: nowrap;' +\r\n        'overflow: hidden;' +\r\n        'text-overflow: ellipsis;' +\r\n        'display: inline-block;' +\r\n        'transition: 0s white-space;' +\r\n        'transition-delay: 1s;' +\r\n        'max-width: ' + calcAttributionWidth(map) + ';' +\r\n      '}';\r\n      document.getElementsByTagName('head')[0].appendChild(attributionStyle);\r\n\r\n      // update the width used to truncate when the map itself is resized\r\n      map.on('resize', function (e) {\r\n        if (map.attributionControl) {\r\n          map.attributionControl._container.style.maxWidth = calcAttributionWidth(e.target);\r\n        }\r\n      });\r\n\r\n      map.attributionControl._esriAttributionAddedOnce = true;\r\n    }\r\n\r\n    map.attributionControl.setPrefix(BASE_LEAFLET_ATTRIBUTION_STRING + ' | ' + POWERED_BY_ESRI_ATTRIBUTION_STRING);\r\n    leaflet__WEBPACK_IMPORTED_MODULE_0__[\"DomUtil\"].addClass(map.attributionControl._container, 'esri-truncated-attribution:hover');\r\n    leaflet__WEBPACK_IMPORTED_MODULE_0__[\"DomUtil\"].addClass(map.attributionControl._container, 'esri-truncated-attribution');\r\n  }\r\n\r\n  // Track the number of esri-leaflet layers that are on the map so we can know when we can remove the attribution (below in removeEsriAttribution)\r\n  map.attributionControl._esriAttributionLayerCount = map.attributionControl._esriAttributionLayerCount + 1;\r\n}\r\n\r\nfunction removeEsriAttribution (map) {\r\n  if (!map.attributionControl) {\r\n    return;\r\n  }\r\n\r\n  // Only remove the attribution if we're about to remove the LAST esri-leaflet layer (_esriAttributionLayerCount)\r\n  if (map.attributionControl._esriAttributionLayerCount && map.attributionControl._esriAttributionLayerCount === 1) {\r\n    map.attributionControl.setPrefix(BASE_LEAFLET_ATTRIBUTION_STRING);\r\n    leaflet__WEBPACK_IMPORTED_MODULE_0__[\"DomUtil\"].removeClass(map.attributionControl._container, 'esri-truncated-attribution:hover');\r\n    leaflet__WEBPACK_IMPORTED_MODULE_0__[\"DomUtil\"].removeClass(map.attributionControl._container, 'esri-truncated-attribution');\r\n  }\r\n  map.attributionControl._esriAttributionLayerCount = map.attributionControl._esriAttributionLayerCount - 1;\r\n}\r\n\r\nfunction _setGeometry (geometry) {\r\n  var params = {\r\n    geometry: null,\r\n    geometryType: null\r\n  };\r\n\r\n  // convert bounds to extent and finish\r\n  if (geometry instanceof leaflet__WEBPACK_IMPORTED_MODULE_0__[\"LatLngBounds\"]) {\r\n    // set geometry + geometryType\r\n    params.geometry = boundsToExtent(geometry);\r\n    params.geometryType = 'esriGeometryEnvelope';\r\n    return params;\r\n  }\r\n\r\n  // convert L.Marker > L.LatLng\r\n  if (geometry.getLatLng) {\r\n    geometry = geometry.getLatLng();\r\n  }\r\n\r\n  // convert L.LatLng to a geojson point and continue;\r\n  if (geometry instanceof leaflet__WEBPACK_IMPORTED_MODULE_0__[\"LatLng\"]) {\r\n    geometry = {\r\n      type: 'Point',\r\n      coordinates: [geometry.lng, geometry.lat]\r\n    };\r\n  }\r\n\r\n  // handle L.GeoJSON, pull out the first geometry\r\n  if (geometry instanceof leaflet__WEBPACK_IMPORTED_MODULE_0__[\"GeoJSON\"]) {\r\n    // reassign geometry to the GeoJSON value  (we are assuming that only one feature is present)\r\n    geometry = geometry.getLayers()[0].feature.geometry;\r\n    params.geometry = geojsonToArcGIS(geometry);\r\n    params.geometryType = geojsonTypeToArcGIS(geometry.type);\r\n  }\r\n\r\n  // Handle L.Polyline and L.Polygon\r\n  if (geometry.toGeoJSON) {\r\n    geometry = geometry.toGeoJSON();\r\n  }\r\n\r\n  // handle GeoJSON feature by pulling out the geometry\r\n  if (geometry.type === 'Feature') {\r\n    // get the geometry of the geojson feature\r\n    geometry = geometry.geometry;\r\n  }\r\n\r\n  // confirm that our GeoJSON is a point, line or polygon\r\n  if (geometry.type === 'Point' || geometry.type === 'LineString' || geometry.type === 'Polygon' || geometry.type === 'MultiPolygon') {\r\n    params.geometry = geojsonToArcGIS(geometry);\r\n    params.geometryType = geojsonTypeToArcGIS(geometry.type);\r\n    return params;\r\n  }\r\n\r\n  // warn the user if we havn't found an appropriate object\r\n  Object(_Request__WEBPACK_IMPORTED_MODULE_1__[\"warn\"])('invalid geometry passed to spatial query. Should be L.LatLng, L.LatLngBounds, L.Marker or a GeoJSON Point, Line, Polygon or MultiPolygon object');\r\n\r\n  return;\r\n}\r\n\r\nfunction _getAttributionData (url, map) {\r\n  if (_Support__WEBPACK_IMPORTED_MODULE_3__[\"Support\"].cors) {\r\n    Object(_Request__WEBPACK_IMPORTED_MODULE_1__[\"request\"])(url, {}, leaflet__WEBPACK_IMPORTED_MODULE_0__[\"Util\"].bind(function (error, attributions) {\r\n      if (error) { return; }\r\n      map._esriAttributions = [];\r\n      for (var c = 0; c < attributions.contributors.length; c++) {\r\n        var contributor = attributions.contributors[c];\r\n\r\n        for (var i = 0; i < contributor.coverageAreas.length; i++) {\r\n          var coverageArea = contributor.coverageAreas[i];\r\n          var southWest = Object(leaflet__WEBPACK_IMPORTED_MODULE_0__[\"latLng\"])(coverageArea.bbox[0], coverageArea.bbox[1]);\r\n          var northEast = Object(leaflet__WEBPACK_IMPORTED_MODULE_0__[\"latLng\"])(coverageArea.bbox[2], coverageArea.bbox[3]);\r\n          map._esriAttributions.push({\r\n            attribution: contributor.attribution,\r\n            score: coverageArea.score,\r\n            bounds: Object(leaflet__WEBPACK_IMPORTED_MODULE_0__[\"latLngBounds\"])(southWest, northEast),\r\n            minZoom: coverageArea.zoomMin,\r\n            maxZoom: coverageArea.zoomMax\r\n          });\r\n        }\r\n      }\r\n\r\n      map._esriAttributions.sort(function (a, b) {\r\n        return b.score - a.score;\r\n      });\r\n\r\n      // pass the same argument as the map's 'moveend' event\r\n      var obj = { target: map };\r\n      _updateMapAttribution(obj);\r\n    }, this));\r\n  }\r\n}\r\n\r\nfunction _updateMapAttribution (evt) {\r\n  var map = evt.target;\r\n  var oldAttributions = map._esriAttributions;\r\n\r\n  if (!map || !map.attributionControl) return;\r\n\r\n  var attributionElement = map.attributionControl._container.querySelector('.esri-dynamic-attribution');\r\n\r\n  if (attributionElement && oldAttributions) {\r\n    var newAttributions = '';\r\n    var bounds = map.getBounds();\r\n    var wrappedBounds = Object(leaflet__WEBPACK_IMPORTED_MODULE_0__[\"latLngBounds\"])(\r\n      bounds.getSouthWest().wrap(),\r\n      bounds.getNorthEast().wrap()\r\n    );\r\n    var zoom = map.getZoom();\r\n\r\n    for (var i = 0; i < oldAttributions.length; i++) {\r\n      var attribution = oldAttributions[i];\r\n      var text = attribution.attribution;\r\n\r\n      if (!newAttributions.match(text) && attribution.bounds.intersects(wrappedBounds) && zoom >= attribution.minZoom && zoom <= attribution.maxZoom) {\r\n        newAttributions += (', ' + text);\r\n      }\r\n    }\r\n\r\n    newAttributions = newAttributions.substr(2);\r\n    attributionElement.innerHTML = newAttributions;\r\n    attributionElement.style.maxWidth = calcAttributionWidth(map);\r\n\r\n    map.fire('attributionupdated', {\r\n      attribution: newAttributions\r\n    });\r\n  }\r\n}\r\n\r\n// for backwards compatibility\r\n\r\n\r\nvar EsriUtil = {\r\n  warn: _Request__WEBPACK_IMPORTED_MODULE_1__[\"warn\"],\r\n  cleanUrl: cleanUrl,\r\n  getUrlParams: getUrlParams,\r\n  isArcgisOnline: isArcgisOnline,\r\n  geojsonTypeToArcGIS: geojsonTypeToArcGIS,\r\n  responseToFeatureCollection: responseToFeatureCollection,\r\n  geojsonToArcGIS: geojsonToArcGIS,\r\n  arcgisToGeoJSON: arcgisToGeoJSON,\r\n  boundsToExtent: boundsToExtent,\r\n  extentToBounds: extentToBounds,\r\n  calcAttributionWidth: calcAttributionWidth,\r\n  setEsriAttribution: setEsriAttribution,\r\n  _setGeometry: _setGeometry,\r\n  _getAttributionData: _getAttributionData,\r\n  _updateMapAttribution: _updateMapAttribution,\r\n  _findIdAttributeFromFeature: _findIdAttributeFromFeature,\r\n  _findIdAttributeFromResponse: _findIdAttributeFromResponse\r\n};\r\n\r\n/* harmony default export */ __webpack_exports__[\"default\"] = (EsriUtil);\r\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///./node_modules/esri-leaflet/src/Util.js\n");

/***/ }),

/***/ "./node_modules/leaflet/dist/leaflet-src.js":
/*!**************************************************!*\
  !*** ./node_modules/leaflet/dist/leaflet-src.js ***!
  \**************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

eval("/* @preserve\n * Leaflet 1.7.1, a JS library for interactive maps. http://leafletjs.com\n * (c) 2010-2019 Vladimir Agafonkin, (c) 2010-2011 CloudMade\n */\n\n(function (global, factory) {\n   true ? factory(exports) :\n  undefined;\n}(this, (function (exports) { 'use strict';\n\n  var version = \"1.7.1\";\n\n  /*\r\n   * @namespace Util\r\n   *\r\n   * Various utility functions, used by Leaflet internally.\r\n   */\r\n\r\n  // @function extend(dest: Object, src?: Object): Object\r\n  // Merges the properties of the `src` object (or multiple objects) into `dest` object and returns the latter. Has an `L.extend` shortcut.\r\n  function extend(dest) {\r\n  \tvar i, j, len, src;\r\n\r\n  \tfor (j = 1, len = arguments.length; j < len; j++) {\r\n  \t\tsrc = arguments[j];\r\n  \t\tfor (i in src) {\r\n  \t\t\tdest[i] = src[i];\r\n  \t\t}\r\n  \t}\r\n  \treturn dest;\r\n  }\r\n\r\n  // @function create(proto: Object, properties?: Object): Object\r\n  // Compatibility polyfill for [Object.create](https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/Object/create)\r\n  var create = Object.create || (function () {\r\n  \tfunction F() {}\r\n  \treturn function (proto) {\r\n  \t\tF.prototype = proto;\r\n  \t\treturn new F();\r\n  \t};\r\n  })();\r\n\r\n  // @function bind(fn: Function, …): Function\r\n  // Returns a new function bound to the arguments passed, like [Function.prototype.bind](https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/Function/bind).\r\n  // Has a `L.bind()` shortcut.\r\n  function bind(fn, obj) {\r\n  \tvar slice = Array.prototype.slice;\r\n\r\n  \tif (fn.bind) {\r\n  \t\treturn fn.bind.apply(fn, slice.call(arguments, 1));\r\n  \t}\r\n\r\n  \tvar args = slice.call(arguments, 2);\r\n\r\n  \treturn function () {\r\n  \t\treturn fn.apply(obj, args.length ? args.concat(slice.call(arguments)) : arguments);\r\n  \t};\r\n  }\r\n\r\n  // @property lastId: Number\r\n  // Last unique ID used by [`stamp()`](#util-stamp)\r\n  var lastId = 0;\r\n\r\n  // @function stamp(obj: Object): Number\r\n  // Returns the unique ID of an object, assigning it one if it doesn't have it.\r\n  function stamp(obj) {\r\n  \t/*eslint-disable */\r\n  \tobj._leaflet_id = obj._leaflet_id || ++lastId;\r\n  \treturn obj._leaflet_id;\r\n  \t/* eslint-enable */\r\n  }\r\n\r\n  // @function throttle(fn: Function, time: Number, context: Object): Function\r\n  // Returns a function which executes function `fn` with the given scope `context`\r\n  // (so that the `this` keyword refers to `context` inside `fn`'s code). The function\r\n  // `fn` will be called no more than one time per given amount of `time`. The arguments\r\n  // received by the bound function will be any arguments passed when binding the\r\n  // function, followed by any arguments passed when invoking the bound function.\r\n  // Has an `L.throttle` shortcut.\r\n  function throttle(fn, time, context) {\r\n  \tvar lock, args, wrapperFn, later;\r\n\r\n  \tlater = function () {\r\n  \t\t// reset lock and call if queued\r\n  \t\tlock = false;\r\n  \t\tif (args) {\r\n  \t\t\twrapperFn.apply(context, args);\r\n  \t\t\targs = false;\r\n  \t\t}\r\n  \t};\r\n\r\n  \twrapperFn = function () {\r\n  \t\tif (lock) {\r\n  \t\t\t// called too soon, queue to call later\r\n  \t\t\targs = arguments;\r\n\r\n  \t\t} else {\r\n  \t\t\t// call and lock until later\r\n  \t\t\tfn.apply(context, arguments);\r\n  \t\t\tsetTimeout(later, time);\r\n  \t\t\tlock = true;\r\n  \t\t}\r\n  \t};\r\n\r\n  \treturn wrapperFn;\r\n  }\r\n\r\n  // @function wrapNum(num: Number, range: Number[], includeMax?: Boolean): Number\r\n  // Returns the number `num` modulo `range` in such a way so it lies within\r\n  // `range[0]` and `range[1]`. The returned value will be always smaller than\r\n  // `range[1]` unless `includeMax` is set to `true`.\r\n  function wrapNum(x, range, includeMax) {\r\n  \tvar max = range[1],\r\n  \t    min = range[0],\r\n  \t    d = max - min;\r\n  \treturn x === max && includeMax ? x : ((x - min) % d + d) % d + min;\r\n  }\r\n\r\n  // @function falseFn(): Function\r\n  // Returns a function which always returns `false`.\r\n  function falseFn() { return false; }\r\n\r\n  // @function formatNum(num: Number, digits?: Number): Number\r\n  // Returns the number `num` rounded to `digits` decimals, or to 6 decimals by default.\r\n  function formatNum(num, digits) {\r\n  \tvar pow = Math.pow(10, (digits === undefined ? 6 : digits));\r\n  \treturn Math.round(num * pow) / pow;\r\n  }\r\n\r\n  // @function trim(str: String): String\r\n  // Compatibility polyfill for [String.prototype.trim](https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/String/Trim)\r\n  function trim(str) {\r\n  \treturn str.trim ? str.trim() : str.replace(/^\\s+|\\s+$/g, '');\r\n  }\r\n\r\n  // @function splitWords(str: String): String[]\r\n  // Trims and splits the string on whitespace and returns the array of parts.\r\n  function splitWords(str) {\r\n  \treturn trim(str).split(/\\s+/);\r\n  }\r\n\r\n  // @function setOptions(obj: Object, options: Object): Object\r\n  // Merges the given properties to the `options` of the `obj` object, returning the resulting options. See `Class options`. Has an `L.setOptions` shortcut.\r\n  function setOptions(obj, options) {\r\n  \tif (!Object.prototype.hasOwnProperty.call(obj, 'options')) {\r\n  \t\tobj.options = obj.options ? create(obj.options) : {};\r\n  \t}\r\n  \tfor (var i in options) {\r\n  \t\tobj.options[i] = options[i];\r\n  \t}\r\n  \treturn obj.options;\r\n  }\r\n\r\n  // @function getParamString(obj: Object, existingUrl?: String, uppercase?: Boolean): String\r\n  // Converts an object into a parameter URL string, e.g. `{a: \"foo\", b: \"bar\"}`\r\n  // translates to `'?a=foo&b=bar'`. If `existingUrl` is set, the parameters will\r\n  // be appended at the end. If `uppercase` is `true`, the parameter names will\r\n  // be uppercased (e.g. `'?A=foo&B=bar'`)\r\n  function getParamString(obj, existingUrl, uppercase) {\r\n  \tvar params = [];\r\n  \tfor (var i in obj) {\r\n  \t\tparams.push(encodeURIComponent(uppercase ? i.toUpperCase() : i) + '=' + encodeURIComponent(obj[i]));\r\n  \t}\r\n  \treturn ((!existingUrl || existingUrl.indexOf('?') === -1) ? '?' : '&') + params.join('&');\r\n  }\r\n\r\n  var templateRe = /\\{ *([\\w_-]+) *\\}/g;\r\n\r\n  // @function template(str: String, data: Object): String\r\n  // Simple templating facility, accepts a template string of the form `'Hello {a}, {b}'`\r\n  // and a data object like `{a: 'foo', b: 'bar'}`, returns evaluated string\r\n  // `('Hello foo, bar')`. You can also specify functions instead of strings for\r\n  // data values — they will be evaluated passing `data` as an argument.\r\n  function template(str, data) {\r\n  \treturn str.replace(templateRe, function (str, key) {\r\n  \t\tvar value = data[key];\r\n\r\n  \t\tif (value === undefined) {\r\n  \t\t\tthrow new Error('No value provided for variable ' + str);\r\n\r\n  \t\t} else if (typeof value === 'function') {\r\n  \t\t\tvalue = value(data);\r\n  \t\t}\r\n  \t\treturn value;\r\n  \t});\r\n  }\r\n\r\n  // @function isArray(obj): Boolean\r\n  // Compatibility polyfill for [Array.isArray](https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/Array/isArray)\r\n  var isArray = Array.isArray || function (obj) {\r\n  \treturn (Object.prototype.toString.call(obj) === '[object Array]');\r\n  };\r\n\r\n  // @function indexOf(array: Array, el: Object): Number\r\n  // Compatibility polyfill for [Array.prototype.indexOf](https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/Array/indexOf)\r\n  function indexOf(array, el) {\r\n  \tfor (var i = 0; i < array.length; i++) {\r\n  \t\tif (array[i] === el) { return i; }\r\n  \t}\r\n  \treturn -1;\r\n  }\r\n\r\n  // @property emptyImageUrl: String\r\n  // Data URI string containing a base64-encoded empty GIF image.\r\n  // Used as a hack to free memory from unused images on WebKit-powered\r\n  // mobile devices (by setting image `src` to this string).\r\n  var emptyImageUrl = 'data:image/gif;base64,R0lGODlhAQABAAD/ACwAAAAAAQABAAACADs=';\r\n\r\n  // inspired by http://paulirish.com/2011/requestanimationframe-for-smart-animating/\r\n\r\n  function getPrefixed(name) {\r\n  \treturn window['webkit' + name] || window['moz' + name] || window['ms' + name];\r\n  }\r\n\r\n  var lastTime = 0;\r\n\r\n  // fallback for IE 7-8\r\n  function timeoutDefer(fn) {\r\n  \tvar time = +new Date(),\r\n  \t    timeToCall = Math.max(0, 16 - (time - lastTime));\r\n\r\n  \tlastTime = time + timeToCall;\r\n  \treturn window.setTimeout(fn, timeToCall);\r\n  }\r\n\r\n  var requestFn = window.requestAnimationFrame || getPrefixed('RequestAnimationFrame') || timeoutDefer;\r\n  var cancelFn = window.cancelAnimationFrame || getPrefixed('CancelAnimationFrame') ||\r\n  \t\tgetPrefixed('CancelRequestAnimationFrame') || function (id) { window.clearTimeout(id); };\r\n\r\n  // @function requestAnimFrame(fn: Function, context?: Object, immediate?: Boolean): Number\r\n  // Schedules `fn` to be executed when the browser repaints. `fn` is bound to\r\n  // `context` if given. When `immediate` is set, `fn` is called immediately if\r\n  // the browser doesn't have native support for\r\n  // [`window.requestAnimationFrame`](https://developer.mozilla.org/docs/Web/API/window/requestAnimationFrame),\r\n  // otherwise it's delayed. Returns a request ID that can be used to cancel the request.\r\n  function requestAnimFrame(fn, context, immediate) {\r\n  \tif (immediate && requestFn === timeoutDefer) {\r\n  \t\tfn.call(context);\r\n  \t} else {\r\n  \t\treturn requestFn.call(window, bind(fn, context));\r\n  \t}\r\n  }\r\n\r\n  // @function cancelAnimFrame(id: Number): undefined\r\n  // Cancels a previous `requestAnimFrame`. See also [window.cancelAnimationFrame](https://developer.mozilla.org/docs/Web/API/window/cancelAnimationFrame).\r\n  function cancelAnimFrame(id) {\r\n  \tif (id) {\r\n  \t\tcancelFn.call(window, id);\r\n  \t}\r\n  }\n\n  var Util = ({\n    extend: extend,\n    create: create,\n    bind: bind,\n    lastId: lastId,\n    stamp: stamp,\n    throttle: throttle,\n    wrapNum: wrapNum,\n    falseFn: falseFn,\n    formatNum: formatNum,\n    trim: trim,\n    splitWords: splitWords,\n    setOptions: setOptions,\n    getParamString: getParamString,\n    template: template,\n    isArray: isArray,\n    indexOf: indexOf,\n    emptyImageUrl: emptyImageUrl,\n    requestFn: requestFn,\n    cancelFn: cancelFn,\n    requestAnimFrame: requestAnimFrame,\n    cancelAnimFrame: cancelAnimFrame\n  });\n\n  // @class Class\r\n  // @aka L.Class\r\n\r\n  // @section\r\n  // @uninheritable\r\n\r\n  // Thanks to John Resig and Dean Edwards for inspiration!\r\n\r\n  function Class() {}\r\n\r\n  Class.extend = function (props) {\r\n\r\n  \t// @function extend(props: Object): Function\r\n  \t// [Extends the current class](#class-inheritance) given the properties to be included.\r\n  \t// Returns a Javascript function that is a class constructor (to be called with `new`).\r\n  \tvar NewClass = function () {\r\n\r\n  \t\t// call the constructor\r\n  \t\tif (this.initialize) {\r\n  \t\t\tthis.initialize.apply(this, arguments);\r\n  \t\t}\r\n\r\n  \t\t// call all constructor hooks\r\n  \t\tthis.callInitHooks();\r\n  \t};\r\n\r\n  \tvar parentProto = NewClass.__super__ = this.prototype;\r\n\r\n  \tvar proto = create(parentProto);\r\n  \tproto.constructor = NewClass;\r\n\r\n  \tNewClass.prototype = proto;\r\n\r\n  \t// inherit parent's statics\r\n  \tfor (var i in this) {\r\n  \t\tif (Object.prototype.hasOwnProperty.call(this, i) && i !== 'prototype' && i !== '__super__') {\r\n  \t\t\tNewClass[i] = this[i];\r\n  \t\t}\r\n  \t}\r\n\r\n  \t// mix static properties into the class\r\n  \tif (props.statics) {\r\n  \t\textend(NewClass, props.statics);\r\n  \t\tdelete props.statics;\r\n  \t}\r\n\r\n  \t// mix includes into the prototype\r\n  \tif (props.includes) {\r\n  \t\tcheckDeprecatedMixinEvents(props.includes);\r\n  \t\textend.apply(null, [proto].concat(props.includes));\r\n  \t\tdelete props.includes;\r\n  \t}\r\n\r\n  \t// merge options\r\n  \tif (proto.options) {\r\n  \t\tprops.options = extend(create(proto.options), props.options);\r\n  \t}\r\n\r\n  \t// mix given properties into the prototype\r\n  \textend(proto, props);\r\n\r\n  \tproto._initHooks = [];\r\n\r\n  \t// add method for calling all hooks\r\n  \tproto.callInitHooks = function () {\r\n\r\n  \t\tif (this._initHooksCalled) { return; }\r\n\r\n  \t\tif (parentProto.callInitHooks) {\r\n  \t\t\tparentProto.callInitHooks.call(this);\r\n  \t\t}\r\n\r\n  \t\tthis._initHooksCalled = true;\r\n\r\n  \t\tfor (var i = 0, len = proto._initHooks.length; i < len; i++) {\r\n  \t\t\tproto._initHooks[i].call(this);\r\n  \t\t}\r\n  \t};\r\n\r\n  \treturn NewClass;\r\n  };\r\n\r\n\r\n  // @function include(properties: Object): this\r\n  // [Includes a mixin](#class-includes) into the current class.\r\n  Class.include = function (props) {\r\n  \textend(this.prototype, props);\r\n  \treturn this;\r\n  };\r\n\r\n  // @function mergeOptions(options: Object): this\r\n  // [Merges `options`](#class-options) into the defaults of the class.\r\n  Class.mergeOptions = function (options) {\r\n  \textend(this.prototype.options, options);\r\n  \treturn this;\r\n  };\r\n\r\n  // @function addInitHook(fn: Function): this\r\n  // Adds a [constructor hook](#class-constructor-hooks) to the class.\r\n  Class.addInitHook = function (fn) { // (Function) || (String, args...)\r\n  \tvar args = Array.prototype.slice.call(arguments, 1);\r\n\r\n  \tvar init = typeof fn === 'function' ? fn : function () {\r\n  \t\tthis[fn].apply(this, args);\r\n  \t};\r\n\r\n  \tthis.prototype._initHooks = this.prototype._initHooks || [];\r\n  \tthis.prototype._initHooks.push(init);\r\n  \treturn this;\r\n  };\r\n\r\n  function checkDeprecatedMixinEvents(includes) {\r\n  \tif (typeof L === 'undefined' || !L || !L.Mixin) { return; }\r\n\r\n  \tincludes = isArray(includes) ? includes : [includes];\r\n\r\n  \tfor (var i = 0; i < includes.length; i++) {\r\n  \t\tif (includes[i] === L.Mixin.Events) {\r\n  \t\t\tconsole.warn('Deprecated include of L.Mixin.Events: ' +\r\n  \t\t\t\t'this property will be removed in future releases, ' +\r\n  \t\t\t\t'please inherit from L.Evented instead.', new Error().stack);\r\n  \t\t}\r\n  \t}\r\n  }\n\n  /*\r\n   * @class Evented\r\n   * @aka L.Evented\r\n   * @inherits Class\r\n   *\r\n   * A set of methods shared between event-powered classes (like `Map` and `Marker`). Generally, events allow you to execute some function when something happens with an object (e.g. the user clicks on the map, causing the map to fire `'click'` event).\r\n   *\r\n   * @example\r\n   *\r\n   * ```js\r\n   * map.on('click', function(e) {\r\n   * \talert(e.latlng);\r\n   * } );\r\n   * ```\r\n   *\r\n   * Leaflet deals with event listeners by reference, so if you want to add a listener and then remove it, define it as a function:\r\n   *\r\n   * ```js\r\n   * function onClick(e) { ... }\r\n   *\r\n   * map.on('click', onClick);\r\n   * map.off('click', onClick);\r\n   * ```\r\n   */\r\n\r\n  var Events = {\r\n  \t/* @method on(type: String, fn: Function, context?: Object): this\r\n  \t * Adds a listener function (`fn`) to a particular event type of the object. You can optionally specify the context of the listener (object the this keyword will point to). You can also pass several space-separated types (e.g. `'click dblclick'`).\r\n  \t *\r\n  \t * @alternative\r\n  \t * @method on(eventMap: Object): this\r\n  \t * Adds a set of type/listener pairs, e.g. `{click: onClick, mousemove: onMouseMove}`\r\n  \t */\r\n  \ton: function (types, fn, context) {\r\n\r\n  \t\t// types can be a map of types/handlers\r\n  \t\tif (typeof types === 'object') {\r\n  \t\t\tfor (var type in types) {\r\n  \t\t\t\t// we don't process space-separated events here for performance;\r\n  \t\t\t\t// it's a hot path since Layer uses the on(obj) syntax\r\n  \t\t\t\tthis._on(type, types[type], fn);\r\n  \t\t\t}\r\n\r\n  \t\t} else {\r\n  \t\t\t// types can be a string of space-separated words\r\n  \t\t\ttypes = splitWords(types);\r\n\r\n  \t\t\tfor (var i = 0, len = types.length; i < len; i++) {\r\n  \t\t\t\tthis._on(types[i], fn, context);\r\n  \t\t\t}\r\n  \t\t}\r\n\r\n  \t\treturn this;\r\n  \t},\r\n\r\n  \t/* @method off(type: String, fn?: Function, context?: Object): this\r\n  \t * Removes a previously added listener function. If no function is specified, it will remove all the listeners of that particular event from the object. Note that if you passed a custom context to `on`, you must pass the same context to `off` in order to remove the listener.\r\n  \t *\r\n  \t * @alternative\r\n  \t * @method off(eventMap: Object): this\r\n  \t * Removes a set of type/listener pairs.\r\n  \t *\r\n  \t * @alternative\r\n  \t * @method off: this\r\n  \t * Removes all listeners to all events on the object. This includes implicitly attached events.\r\n  \t */\r\n  \toff: function (types, fn, context) {\r\n\r\n  \t\tif (!types) {\r\n  \t\t\t// clear all listeners if called without arguments\r\n  \t\t\tdelete this._events;\r\n\r\n  \t\t} else if (typeof types === 'object') {\r\n  \t\t\tfor (var type in types) {\r\n  \t\t\t\tthis._off(type, types[type], fn);\r\n  \t\t\t}\r\n\r\n  \t\t} else {\r\n  \t\t\ttypes = splitWords(types);\r\n\r\n  \t\t\tfor (var i = 0, len = types.length; i < len; i++) {\r\n  \t\t\t\tthis._off(types[i], fn, context);\r\n  \t\t\t}\r\n  \t\t}\r\n\r\n  \t\treturn this;\r\n  \t},\r\n\r\n  \t// attach listener (without syntactic sugar now)\r\n  \t_on: function (type, fn, context) {\r\n  \t\tthis._events = this._events || {};\r\n\r\n  \t\t/* get/init listeners for type */\r\n  \t\tvar typeListeners = this._events[type];\r\n  \t\tif (!typeListeners) {\r\n  \t\t\ttypeListeners = [];\r\n  \t\t\tthis._events[type] = typeListeners;\r\n  \t\t}\r\n\r\n  \t\tif (context === this) {\r\n  \t\t\t// Less memory footprint.\r\n  \t\t\tcontext = undefined;\r\n  \t\t}\r\n  \t\tvar newListener = {fn: fn, ctx: context},\r\n  \t\t    listeners = typeListeners;\r\n\r\n  \t\t// check if fn already there\r\n  \t\tfor (var i = 0, len = listeners.length; i < len; i++) {\r\n  \t\t\tif (listeners[i].fn === fn && listeners[i].ctx === context) {\r\n  \t\t\t\treturn;\r\n  \t\t\t}\r\n  \t\t}\r\n\r\n  \t\tlisteners.push(newListener);\r\n  \t},\r\n\r\n  \t_off: function (type, fn, context) {\r\n  \t\tvar listeners,\r\n  \t\t    i,\r\n  \t\t    len;\r\n\r\n  \t\tif (!this._events) { return; }\r\n\r\n  \t\tlisteners = this._events[type];\r\n\r\n  \t\tif (!listeners) {\r\n  \t\t\treturn;\r\n  \t\t}\r\n\r\n  \t\tif (!fn) {\r\n  \t\t\t// Set all removed listeners to noop so they are not called if remove happens in fire\r\n  \t\t\tfor (i = 0, len = listeners.length; i < len; i++) {\r\n  \t\t\t\tlisteners[i].fn = falseFn;\r\n  \t\t\t}\r\n  \t\t\t// clear all listeners for a type if function isn't specified\r\n  \t\t\tdelete this._events[type];\r\n  \t\t\treturn;\r\n  \t\t}\r\n\r\n  \t\tif (context === this) {\r\n  \t\t\tcontext = undefined;\r\n  \t\t}\r\n\r\n  \t\tif (listeners) {\r\n\r\n  \t\t\t// find fn and remove it\r\n  \t\t\tfor (i = 0, len = listeners.length; i < len; i++) {\r\n  \t\t\t\tvar l = listeners[i];\r\n  \t\t\t\tif (l.ctx !== context) { continue; }\r\n  \t\t\t\tif (l.fn === fn) {\r\n\r\n  \t\t\t\t\t// set the removed listener to noop so that's not called if remove happens in fire\r\n  \t\t\t\t\tl.fn = falseFn;\r\n\r\n  \t\t\t\t\tif (this._firingCount) {\r\n  \t\t\t\t\t\t/* copy array in case events are being fired */\r\n  \t\t\t\t\t\tthis._events[type] = listeners = listeners.slice();\r\n  \t\t\t\t\t}\r\n  \t\t\t\t\tlisteners.splice(i, 1);\r\n\r\n  \t\t\t\t\treturn;\r\n  \t\t\t\t}\r\n  \t\t\t}\r\n  \t\t}\r\n  \t},\r\n\r\n  \t// @method fire(type: String, data?: Object, propagate?: Boolean): this\r\n  \t// Fires an event of the specified type. You can optionally provide an data\r\n  \t// object — the first argument of the listener function will contain its\r\n  \t// properties. The event can optionally be propagated to event parents.\r\n  \tfire: function (type, data, propagate) {\r\n  \t\tif (!this.listens(type, propagate)) { return this; }\r\n\r\n  \t\tvar event = extend({}, data, {\r\n  \t\t\ttype: type,\r\n  \t\t\ttarget: this,\r\n  \t\t\tsourceTarget: data && data.sourceTarget || this\r\n  \t\t});\r\n\r\n  \t\tif (this._events) {\r\n  \t\t\tvar listeners = this._events[type];\r\n\r\n  \t\t\tif (listeners) {\r\n  \t\t\t\tthis._firingCount = (this._firingCount + 1) || 1;\r\n  \t\t\t\tfor (var i = 0, len = listeners.length; i < len; i++) {\r\n  \t\t\t\t\tvar l = listeners[i];\r\n  \t\t\t\t\tl.fn.call(l.ctx || this, event);\r\n  \t\t\t\t}\r\n\r\n  \t\t\t\tthis._firingCount--;\r\n  \t\t\t}\r\n  \t\t}\r\n\r\n  \t\tif (propagate) {\r\n  \t\t\t// propagate the event to parents (set with addEventParent)\r\n  \t\t\tthis._propagateEvent(event);\r\n  \t\t}\r\n\r\n  \t\treturn this;\r\n  \t},\r\n\r\n  \t// @method listens(type: String): Boolean\r\n  \t// Returns `true` if a particular event type has any listeners attached to it.\r\n  \tlistens: function (type, propagate) {\r\n  \t\tvar listeners = this._events && this._events[type];\r\n  \t\tif (listeners && listeners.length) { return true; }\r\n\r\n  \t\tif (propagate) {\r\n  \t\t\t// also check parents for listeners if event propagates\r\n  \t\t\tfor (var id in this._eventParents) {\r\n  \t\t\t\tif (this._eventParents[id].listens(type, propagate)) { return true; }\r\n  \t\t\t}\r\n  \t\t}\r\n  \t\treturn false;\r\n  \t},\r\n\r\n  \t// @method once(…): this\r\n  \t// Behaves as [`on(…)`](#evented-on), except the listener will only get fired once and then removed.\r\n  \tonce: function (types, fn, context) {\r\n\r\n  \t\tif (typeof types === 'object') {\r\n  \t\t\tfor (var type in types) {\r\n  \t\t\t\tthis.once(type, types[type], fn);\r\n  \t\t\t}\r\n  \t\t\treturn this;\r\n  \t\t}\r\n\r\n  \t\tvar handler = bind(function () {\r\n  \t\t\tthis\r\n  \t\t\t    .off(types, fn, context)\r\n  \t\t\t    .off(types, handler, context);\r\n  \t\t}, this);\r\n\r\n  \t\t// add a listener that's executed once and removed after that\r\n  \t\treturn this\r\n  \t\t    .on(types, fn, context)\r\n  \t\t    .on(types, handler, context);\r\n  \t},\r\n\r\n  \t// @method addEventParent(obj: Evented): this\r\n  \t// Adds an event parent - an `Evented` that will receive propagated events\r\n  \taddEventParent: function (obj) {\r\n  \t\tthis._eventParents = this._eventParents || {};\r\n  \t\tthis._eventParents[stamp(obj)] = obj;\r\n  \t\treturn this;\r\n  \t},\r\n\r\n  \t// @method removeEventParent(obj: Evented): this\r\n  \t// Removes an event parent, so it will stop receiving propagated events\r\n  \tremoveEventParent: function (obj) {\r\n  \t\tif (this._eventParents) {\r\n  \t\t\tdelete this._eventParents[stamp(obj)];\r\n  \t\t}\r\n  \t\treturn this;\r\n  \t},\r\n\r\n  \t_propagateEvent: function (e) {\r\n  \t\tfor (var id in this._eventParents) {\r\n  \t\t\tthis._eventParents[id].fire(e.type, extend({\r\n  \t\t\t\tlayer: e.target,\r\n  \t\t\t\tpropagatedFrom: e.target\r\n  \t\t\t}, e), true);\r\n  \t\t}\r\n  \t}\r\n  };\r\n\r\n  // aliases; we should ditch those eventually\r\n\r\n  // @method addEventListener(…): this\r\n  // Alias to [`on(…)`](#evented-on)\r\n  Events.addEventListener = Events.on;\r\n\r\n  // @method removeEventListener(…): this\r\n  // Alias to [`off(…)`](#evented-off)\r\n\r\n  // @method clearAllEventListeners(…): this\r\n  // Alias to [`off()`](#evented-off)\r\n  Events.removeEventListener = Events.clearAllEventListeners = Events.off;\r\n\r\n  // @method addOneTimeEventListener(…): this\r\n  // Alias to [`once(…)`](#evented-once)\r\n  Events.addOneTimeEventListener = Events.once;\r\n\r\n  // @method fireEvent(…): this\r\n  // Alias to [`fire(…)`](#evented-fire)\r\n  Events.fireEvent = Events.fire;\r\n\r\n  // @method hasEventListeners(…): Boolean\r\n  // Alias to [`listens(…)`](#evented-listens)\r\n  Events.hasEventListeners = Events.listens;\r\n\r\n  var Evented = Class.extend(Events);\n\n  /*\r\n   * @class Point\r\n   * @aka L.Point\r\n   *\r\n   * Represents a point with `x` and `y` coordinates in pixels.\r\n   *\r\n   * @example\r\n   *\r\n   * ```js\r\n   * var point = L.point(200, 300);\r\n   * ```\r\n   *\r\n   * All Leaflet methods and options that accept `Point` objects also accept them in a simple Array form (unless noted otherwise), so these lines are equivalent:\r\n   *\r\n   * ```js\r\n   * map.panBy([200, 300]);\r\n   * map.panBy(L.point(200, 300));\r\n   * ```\r\n   *\r\n   * Note that `Point` does not inherit from Leaflet's `Class` object,\r\n   * which means new classes can't inherit from it, and new methods\r\n   * can't be added to it with the `include` function.\r\n   */\r\n\r\n  function Point(x, y, round) {\r\n  \t// @property x: Number; The `x` coordinate of the point\r\n  \tthis.x = (round ? Math.round(x) : x);\r\n  \t// @property y: Number; The `y` coordinate of the point\r\n  \tthis.y = (round ? Math.round(y) : y);\r\n  }\r\n\r\n  var trunc = Math.trunc || function (v) {\r\n  \treturn v > 0 ? Math.floor(v) : Math.ceil(v);\r\n  };\r\n\r\n  Point.prototype = {\r\n\r\n  \t// @method clone(): Point\r\n  \t// Returns a copy of the current point.\r\n  \tclone: function () {\r\n  \t\treturn new Point(this.x, this.y);\r\n  \t},\r\n\r\n  \t// @method add(otherPoint: Point): Point\r\n  \t// Returns the result of addition of the current and the given points.\r\n  \tadd: function (point) {\r\n  \t\t// non-destructive, returns a new point\r\n  \t\treturn this.clone()._add(toPoint(point));\r\n  \t},\r\n\r\n  \t_add: function (point) {\r\n  \t\t// destructive, used directly for performance in situations where it's safe to modify existing point\r\n  \t\tthis.x += point.x;\r\n  \t\tthis.y += point.y;\r\n  \t\treturn this;\r\n  \t},\r\n\r\n  \t// @method subtract(otherPoint: Point): Point\r\n  \t// Returns the result of subtraction of the given point from the current.\r\n  \tsubtract: function (point) {\r\n  \t\treturn this.clone()._subtract(toPoint(point));\r\n  \t},\r\n\r\n  \t_subtract: function (point) {\r\n  \t\tthis.x -= point.x;\r\n  \t\tthis.y -= point.y;\r\n  \t\treturn this;\r\n  \t},\r\n\r\n  \t// @method divideBy(num: Number): Point\r\n  \t// Returns the result of division of the current point by the given number.\r\n  \tdivideBy: function (num) {\r\n  \t\treturn this.clone()._divideBy(num);\r\n  \t},\r\n\r\n  \t_divideBy: function (num) {\r\n  \t\tthis.x /= num;\r\n  \t\tthis.y /= num;\r\n  \t\treturn this;\r\n  \t},\r\n\r\n  \t// @method multiplyBy(num: Number): Point\r\n  \t// Returns the result of multiplication of the current point by the given number.\r\n  \tmultiplyBy: function (num) {\r\n  \t\treturn this.clone()._multiplyBy(num);\r\n  \t},\r\n\r\n  \t_multiplyBy: function (num) {\r\n  \t\tthis.x *= num;\r\n  \t\tthis.y *= num;\r\n  \t\treturn this;\r\n  \t},\r\n\r\n  \t// @method scaleBy(scale: Point): Point\r\n  \t// Multiply each coordinate of the current point by each coordinate of\r\n  \t// `scale`. In linear algebra terms, multiply the point by the\r\n  \t// [scaling matrix](https://en.wikipedia.org/wiki/Scaling_%28geometry%29#Matrix_representation)\r\n  \t// defined by `scale`.\r\n  \tscaleBy: function (point) {\r\n  \t\treturn new Point(this.x * point.x, this.y * point.y);\r\n  \t},\r\n\r\n  \t// @method unscaleBy(scale: Point): Point\r\n  \t// Inverse of `scaleBy`. Divide each coordinate of the current point by\r\n  \t// each coordinate of `scale`.\r\n  \tunscaleBy: function (point) {\r\n  \t\treturn new Point(this.x / point.x, this.y / point.y);\r\n  \t},\r\n\r\n  \t// @method round(): Point\r\n  \t// Returns a copy of the current point with rounded coordinates.\r\n  \tround: function () {\r\n  \t\treturn this.clone()._round();\r\n  \t},\r\n\r\n  \t_round: function () {\r\n  \t\tthis.x = Math.round(this.x);\r\n  \t\tthis.y = Math.round(this.y);\r\n  \t\treturn this;\r\n  \t},\r\n\r\n  \t// @method floor(): Point\r\n  \t// Returns a copy of the current point with floored coordinates (rounded down).\r\n  \tfloor: function () {\r\n  \t\treturn this.clone()._floor();\r\n  \t},\r\n\r\n  \t_floor: function () {\r\n  \t\tthis.x = Math.floor(this.x);\r\n  \t\tthis.y = Math.floor(this.y);\r\n  \t\treturn this;\r\n  \t},\r\n\r\n  \t// @method ceil(): Point\r\n  \t// Returns a copy of the current point with ceiled coordinates (rounded up).\r\n  \tceil: function () {\r\n  \t\treturn this.clone()._ceil();\r\n  \t},\r\n\r\n  \t_ceil: function () {\r\n  \t\tthis.x = Math.ceil(this.x);\r\n  \t\tthis.y = Math.ceil(this.y);\r\n  \t\treturn this;\r\n  \t},\r\n\r\n  \t// @method trunc(): Point\r\n  \t// Returns a copy of the current point with truncated coordinates (rounded towards zero).\r\n  \ttrunc: function () {\r\n  \t\treturn this.clone()._trunc();\r\n  \t},\r\n\r\n  \t_trunc: function () {\r\n  \t\tthis.x = trunc(this.x);\r\n  \t\tthis.y = trunc(this.y);\r\n  \t\treturn this;\r\n  \t},\r\n\r\n  \t// @method distanceTo(otherPoint: Point): Number\r\n  \t// Returns the cartesian distance between the current and the given points.\r\n  \tdistanceTo: function (point) {\r\n  \t\tpoint = toPoint(point);\r\n\r\n  \t\tvar x = point.x - this.x,\r\n  \t\t    y = point.y - this.y;\r\n\r\n  \t\treturn Math.sqrt(x * x + y * y);\r\n  \t},\r\n\r\n  \t// @method equals(otherPoint: Point): Boolean\r\n  \t// Returns `true` if the given point has the same coordinates.\r\n  \tequals: function (point) {\r\n  \t\tpoint = toPoint(point);\r\n\r\n  \t\treturn point.x === this.x &&\r\n  \t\t       point.y === this.y;\r\n  \t},\r\n\r\n  \t// @method contains(otherPoint: Point): Boolean\r\n  \t// Returns `true` if both coordinates of the given point are less than the corresponding current point coordinates (in absolute values).\r\n  \tcontains: function (point) {\r\n  \t\tpoint = toPoint(point);\r\n\r\n  \t\treturn Math.abs(point.x) <= Math.abs(this.x) &&\r\n  \t\t       Math.abs(point.y) <= Math.abs(this.y);\r\n  \t},\r\n\r\n  \t// @method toString(): String\r\n  \t// Returns a string representation of the point for debugging purposes.\r\n  \ttoString: function () {\r\n  \t\treturn 'Point(' +\r\n  \t\t        formatNum(this.x) + ', ' +\r\n  \t\t        formatNum(this.y) + ')';\r\n  \t}\r\n  };\r\n\r\n  // @factory L.point(x: Number, y: Number, round?: Boolean)\r\n  // Creates a Point object with the given `x` and `y` coordinates. If optional `round` is set to true, rounds the `x` and `y` values.\r\n\r\n  // @alternative\r\n  // @factory L.point(coords: Number[])\r\n  // Expects an array of the form `[x, y]` instead.\r\n\r\n  // @alternative\r\n  // @factory L.point(coords: Object)\r\n  // Expects a plain object of the form `{x: Number, y: Number}` instead.\r\n  function toPoint(x, y, round) {\r\n  \tif (x instanceof Point) {\r\n  \t\treturn x;\r\n  \t}\r\n  \tif (isArray(x)) {\r\n  \t\treturn new Point(x[0], x[1]);\r\n  \t}\r\n  \tif (x === undefined || x === null) {\r\n  \t\treturn x;\r\n  \t}\r\n  \tif (typeof x === 'object' && 'x' in x && 'y' in x) {\r\n  \t\treturn new Point(x.x, x.y);\r\n  \t}\r\n  \treturn new Point(x, y, round);\r\n  }\n\n  /*\r\n   * @class Bounds\r\n   * @aka L.Bounds\r\n   *\r\n   * Represents a rectangular area in pixel coordinates.\r\n   *\r\n   * @example\r\n   *\r\n   * ```js\r\n   * var p1 = L.point(10, 10),\r\n   * p2 = L.point(40, 60),\r\n   * bounds = L.bounds(p1, p2);\r\n   * ```\r\n   *\r\n   * All Leaflet methods that accept `Bounds` objects also accept them in a simple Array form (unless noted otherwise), so the bounds example above can be passed like this:\r\n   *\r\n   * ```js\r\n   * otherBounds.intersects([[10, 10], [40, 60]]);\r\n   * ```\r\n   *\r\n   * Note that `Bounds` does not inherit from Leaflet's `Class` object,\r\n   * which means new classes can't inherit from it, and new methods\r\n   * can't be added to it with the `include` function.\r\n   */\r\n\r\n  function Bounds(a, b) {\r\n  \tif (!a) { return; }\r\n\r\n  \tvar points = b ? [a, b] : a;\r\n\r\n  \tfor (var i = 0, len = points.length; i < len; i++) {\r\n  \t\tthis.extend(points[i]);\r\n  \t}\r\n  }\r\n\r\n  Bounds.prototype = {\r\n  \t// @method extend(point: Point): this\r\n  \t// Extends the bounds to contain the given point.\r\n  \textend: function (point) { // (Point)\r\n  \t\tpoint = toPoint(point);\r\n\r\n  \t\t// @property min: Point\r\n  \t\t// The top left corner of the rectangle.\r\n  \t\t// @property max: Point\r\n  \t\t// The bottom right corner of the rectangle.\r\n  \t\tif (!this.min && !this.max) {\r\n  \t\t\tthis.min = point.clone();\r\n  \t\t\tthis.max = point.clone();\r\n  \t\t} else {\r\n  \t\t\tthis.min.x = Math.min(point.x, this.min.x);\r\n  \t\t\tthis.max.x = Math.max(point.x, this.max.x);\r\n  \t\t\tthis.min.y = Math.min(point.y, this.min.y);\r\n  \t\t\tthis.max.y = Math.max(point.y, this.max.y);\r\n  \t\t}\r\n  \t\treturn this;\r\n  \t},\r\n\r\n  \t// @method getCenter(round?: Boolean): Point\r\n  \t// Returns the center point of the bounds.\r\n  \tgetCenter: function (round) {\r\n  \t\treturn new Point(\r\n  \t\t        (this.min.x + this.max.x) / 2,\r\n  \t\t        (this.min.y + this.max.y) / 2, round);\r\n  \t},\r\n\r\n  \t// @method getBottomLeft(): Point\r\n  \t// Returns the bottom-left point of the bounds.\r\n  \tgetBottomLeft: function () {\r\n  \t\treturn new Point(this.min.x, this.max.y);\r\n  \t},\r\n\r\n  \t// @method getTopRight(): Point\r\n  \t// Returns the top-right point of the bounds.\r\n  \tgetTopRight: function () { // -> Point\r\n  \t\treturn new Point(this.max.x, this.min.y);\r\n  \t},\r\n\r\n  \t// @method getTopLeft(): Point\r\n  \t// Returns the top-left point of the bounds (i.e. [`this.min`](#bounds-min)).\r\n  \tgetTopLeft: function () {\r\n  \t\treturn this.min; // left, top\r\n  \t},\r\n\r\n  \t// @method getBottomRight(): Point\r\n  \t// Returns the bottom-right point of the bounds (i.e. [`this.max`](#bounds-max)).\r\n  \tgetBottomRight: function () {\r\n  \t\treturn this.max; // right, bottom\r\n  \t},\r\n\r\n  \t// @method getSize(): Point\r\n  \t// Returns the size of the given bounds\r\n  \tgetSize: function () {\r\n  \t\treturn this.max.subtract(this.min);\r\n  \t},\r\n\r\n  \t// @method contains(otherBounds: Bounds): Boolean\r\n  \t// Returns `true` if the rectangle contains the given one.\r\n  \t// @alternative\r\n  \t// @method contains(point: Point): Boolean\r\n  \t// Returns `true` if the rectangle contains the given point.\r\n  \tcontains: function (obj) {\r\n  \t\tvar min, max;\r\n\r\n  \t\tif (typeof obj[0] === 'number' || obj instanceof Point) {\r\n  \t\t\tobj = toPoint(obj);\r\n  \t\t} else {\r\n  \t\t\tobj = toBounds(obj);\r\n  \t\t}\r\n\r\n  \t\tif (obj instanceof Bounds) {\r\n  \t\t\tmin = obj.min;\r\n  \t\t\tmax = obj.max;\r\n  \t\t} else {\r\n  \t\t\tmin = max = obj;\r\n  \t\t}\r\n\r\n  \t\treturn (min.x >= this.min.x) &&\r\n  \t\t       (max.x <= this.max.x) &&\r\n  \t\t       (min.y >= this.min.y) &&\r\n  \t\t       (max.y <= this.max.y);\r\n  \t},\r\n\r\n  \t// @method intersects(otherBounds: Bounds): Boolean\r\n  \t// Returns `true` if the rectangle intersects the given bounds. Two bounds\r\n  \t// intersect if they have at least one point in common.\r\n  \tintersects: function (bounds) { // (Bounds) -> Boolean\r\n  \t\tbounds = toBounds(bounds);\r\n\r\n  \t\tvar min = this.min,\r\n  \t\t    max = this.max,\r\n  \t\t    min2 = bounds.min,\r\n  \t\t    max2 = bounds.max,\r\n  \t\t    xIntersects = (max2.x >= min.x) && (min2.x <= max.x),\r\n  \t\t    yIntersects = (max2.y >= min.y) && (min2.y <= max.y);\r\n\r\n  \t\treturn xIntersects && yIntersects;\r\n  \t},\r\n\r\n  \t// @method overlaps(otherBounds: Bounds): Boolean\r\n  \t// Returns `true` if the rectangle overlaps the given bounds. Two bounds\r\n  \t// overlap if their intersection is an area.\r\n  \toverlaps: function (bounds) { // (Bounds) -> Boolean\r\n  \t\tbounds = toBounds(bounds);\r\n\r\n  \t\tvar min = this.min,\r\n  \t\t    max = this.max,\r\n  \t\t    min2 = bounds.min,\r\n  \t\t    max2 = bounds.max,\r\n  \t\t    xOverlaps = (max2.x > min.x) && (min2.x < max.x),\r\n  \t\t    yOverlaps = (max2.y > min.y) && (min2.y < max.y);\r\n\r\n  \t\treturn xOverlaps && yOverlaps;\r\n  \t},\r\n\r\n  \tisValid: function () {\r\n  \t\treturn !!(this.min && this.max);\r\n  \t}\r\n  };\r\n\r\n\r\n  // @factory L.bounds(corner1: Point, corner2: Point)\r\n  // Creates a Bounds object from two corners coordinate pairs.\r\n  // @alternative\r\n  // @factory L.bounds(points: Point[])\r\n  // Creates a Bounds object from the given array of points.\r\n  function toBounds(a, b) {\r\n  \tif (!a || a instanceof Bounds) {\r\n  \t\treturn a;\r\n  \t}\r\n  \treturn new Bounds(a, b);\r\n  }\n\n  /*\r\n   * @class LatLngBounds\r\n   * @aka L.LatLngBounds\r\n   *\r\n   * Represents a rectangular geographical area on a map.\r\n   *\r\n   * @example\r\n   *\r\n   * ```js\r\n   * var corner1 = L.latLng(40.712, -74.227),\r\n   * corner2 = L.latLng(40.774, -74.125),\r\n   * bounds = L.latLngBounds(corner1, corner2);\r\n   * ```\r\n   *\r\n   * All Leaflet methods that accept LatLngBounds objects also accept them in a simple Array form (unless noted otherwise), so the bounds example above can be passed like this:\r\n   *\r\n   * ```js\r\n   * map.fitBounds([\r\n   * \t[40.712, -74.227],\r\n   * \t[40.774, -74.125]\r\n   * ]);\r\n   * ```\r\n   *\r\n   * Caution: if the area crosses the antimeridian (often confused with the International Date Line), you must specify corners _outside_ the [-180, 180] degrees longitude range.\r\n   *\r\n   * Note that `LatLngBounds` does not inherit from Leaflet's `Class` object,\r\n   * which means new classes can't inherit from it, and new methods\r\n   * can't be added to it with the `include` function.\r\n   */\r\n\r\n  function LatLngBounds(corner1, corner2) { // (LatLng, LatLng) or (LatLng[])\r\n  \tif (!corner1) { return; }\r\n\r\n  \tvar latlngs = corner2 ? [corner1, corner2] : corner1;\r\n\r\n  \tfor (var i = 0, len = latlngs.length; i < len; i++) {\r\n  \t\tthis.extend(latlngs[i]);\r\n  \t}\r\n  }\r\n\r\n  LatLngBounds.prototype = {\r\n\r\n  \t// @method extend(latlng: LatLng): this\r\n  \t// Extend the bounds to contain the given point\r\n\r\n  \t// @alternative\r\n  \t// @method extend(otherBounds: LatLngBounds): this\r\n  \t// Extend the bounds to contain the given bounds\r\n  \textend: function (obj) {\r\n  \t\tvar sw = this._southWest,\r\n  \t\t    ne = this._northEast,\r\n  \t\t    sw2, ne2;\r\n\r\n  \t\tif (obj instanceof LatLng) {\r\n  \t\t\tsw2 = obj;\r\n  \t\t\tne2 = obj;\r\n\r\n  \t\t} else if (obj instanceof LatLngBounds) {\r\n  \t\t\tsw2 = obj._southWest;\r\n  \t\t\tne2 = obj._northEast;\r\n\r\n  \t\t\tif (!sw2 || !ne2) { return this; }\r\n\r\n  \t\t} else {\r\n  \t\t\treturn obj ? this.extend(toLatLng(obj) || toLatLngBounds(obj)) : this;\r\n  \t\t}\r\n\r\n  \t\tif (!sw && !ne) {\r\n  \t\t\tthis._southWest = new LatLng(sw2.lat, sw2.lng);\r\n  \t\t\tthis._northEast = new LatLng(ne2.lat, ne2.lng);\r\n  \t\t} else {\r\n  \t\t\tsw.lat = Math.min(sw2.lat, sw.lat);\r\n  \t\t\tsw.lng = Math.min(sw2.lng, sw.lng);\r\n  \t\t\tne.lat = Math.max(ne2.lat, ne.lat);\r\n  \t\t\tne.lng = Math.max(ne2.lng, ne.lng);\r\n  \t\t}\r\n\r\n  \t\treturn this;\r\n  \t},\r\n\r\n  \t// @method pad(bufferRatio: Number): LatLngBounds\r\n  \t// Returns bounds created by extending or retracting the current bounds by a given ratio in each direction.\r\n  \t// For example, a ratio of 0.5 extends the bounds by 50% in each direction.\r\n  \t// Negative values will retract the bounds.\r\n  \tpad: function (bufferRatio) {\r\n  \t\tvar sw = this._southWest,\r\n  \t\t    ne = this._northEast,\r\n  \t\t    heightBuffer = Math.abs(sw.lat - ne.lat) * bufferRatio,\r\n  \t\t    widthBuffer = Math.abs(sw.lng - ne.lng) * bufferRatio;\r\n\r\n  \t\treturn new LatLngBounds(\r\n  \t\t        new LatLng(sw.lat - heightBuffer, sw.lng - widthBuffer),\r\n  \t\t        new LatLng(ne.lat + heightBuffer, ne.lng + widthBuffer));\r\n  \t},\r\n\r\n  \t// @method getCenter(): LatLng\r\n  \t// Returns the center point of the bounds.\r\n  \tgetCenter: function () {\r\n  \t\treturn new LatLng(\r\n  \t\t        (this._southWest.lat + this._northEast.lat) / 2,\r\n  \t\t        (this._southWest.lng + this._northEast.lng) / 2);\r\n  \t},\r\n\r\n  \t// @method getSouthWest(): LatLng\r\n  \t// Returns the south-west point of the bounds.\r\n  \tgetSouthWest: function () {\r\n  \t\treturn this._southWest;\r\n  \t},\r\n\r\n  \t// @method getNorthEast(): LatLng\r\n  \t// Returns the north-east point of the bounds.\r\n  \tgetNorthEast: function () {\r\n  \t\treturn this._northEast;\r\n  \t},\r\n\r\n  \t// @method getNorthWest(): LatLng\r\n  \t// Returns the north-west point of the bounds.\r\n  \tgetNorthWest: function () {\r\n  \t\treturn new LatLng(this.getNorth(), this.getWest());\r\n  \t},\r\n\r\n  \t// @method getSouthEast(): LatLng\r\n  \t// Returns the south-east point of the bounds.\r\n  \tgetSouthEast: function () {\r\n  \t\treturn new LatLng(this.getSouth(), this.getEast());\r\n  \t},\r\n\r\n  \t// @method getWest(): Number\r\n  \t// Returns the west longitude of the bounds\r\n  \tgetWest: function () {\r\n  \t\treturn this._southWest.lng;\r\n  \t},\r\n\r\n  \t// @method getSouth(): Number\r\n  \t// Returns the south latitude of the bounds\r\n  \tgetSouth: function () {\r\n  \t\treturn this._southWest.lat;\r\n  \t},\r\n\r\n  \t// @method getEast(): Number\r\n  \t// Returns the east longitude of the bounds\r\n  \tgetEast: function () {\r\n  \t\treturn this._northEast.lng;\r\n  \t},\r\n\r\n  \t// @method getNorth(): Number\r\n  \t// Returns the north latitude of the bounds\r\n  \tgetNorth: function () {\r\n  \t\treturn this._northEast.lat;\r\n  \t},\r\n\r\n  \t// @method contains(otherBounds: LatLngBounds): Boolean\r\n  \t// Returns `true` if the rectangle contains the given one.\r\n\r\n  \t// @alternative\r\n  \t// @method contains (latlng: LatLng): Boolean\r\n  \t// Returns `true` if the rectangle contains the given point.\r\n  \tcontains: function (obj) { // (LatLngBounds) or (LatLng) -> Boolean\r\n  \t\tif (typeof obj[0] === 'number' || obj instanceof LatLng || 'lat' in obj) {\r\n  \t\t\tobj = toLatLng(obj);\r\n  \t\t} else {\r\n  \t\t\tobj = toLatLngBounds(obj);\r\n  \t\t}\r\n\r\n  \t\tvar sw = this._southWest,\r\n  \t\t    ne = this._northEast,\r\n  \t\t    sw2, ne2;\r\n\r\n  \t\tif (obj instanceof LatLngBounds) {\r\n  \t\t\tsw2 = obj.getSouthWest();\r\n  \t\t\tne2 = obj.getNorthEast();\r\n  \t\t} else {\r\n  \t\t\tsw2 = ne2 = obj;\r\n  \t\t}\r\n\r\n  \t\treturn (sw2.lat >= sw.lat) && (ne2.lat <= ne.lat) &&\r\n  \t\t       (sw2.lng >= sw.lng) && (ne2.lng <= ne.lng);\r\n  \t},\r\n\r\n  \t// @method intersects(otherBounds: LatLngBounds): Boolean\r\n  \t// Returns `true` if the rectangle intersects the given bounds. Two bounds intersect if they have at least one point in common.\r\n  \tintersects: function (bounds) {\r\n  \t\tbounds = toLatLngBounds(bounds);\r\n\r\n  \t\tvar sw = this._southWest,\r\n  \t\t    ne = this._northEast,\r\n  \t\t    sw2 = bounds.getSouthWest(),\r\n  \t\t    ne2 = bounds.getNorthEast(),\r\n\r\n  \t\t    latIntersects = (ne2.lat >= sw.lat) && (sw2.lat <= ne.lat),\r\n  \t\t    lngIntersects = (ne2.lng >= sw.lng) && (sw2.lng <= ne.lng);\r\n\r\n  \t\treturn latIntersects && lngIntersects;\r\n  \t},\r\n\r\n  \t// @method overlaps(otherBounds: LatLngBounds): Boolean\r\n  \t// Returns `true` if the rectangle overlaps the given bounds. Two bounds overlap if their intersection is an area.\r\n  \toverlaps: function (bounds) {\r\n  \t\tbounds = toLatLngBounds(bounds);\r\n\r\n  \t\tvar sw = this._southWest,\r\n  \t\t    ne = this._northEast,\r\n  \t\t    sw2 = bounds.getSouthWest(),\r\n  \t\t    ne2 = bounds.getNorthEast(),\r\n\r\n  \t\t    latOverlaps = (ne2.lat > sw.lat) && (sw2.lat < ne.lat),\r\n  \t\t    lngOverlaps = (ne2.lng > sw.lng) && (sw2.lng < ne.lng);\r\n\r\n  \t\treturn latOverlaps && lngOverlaps;\r\n  \t},\r\n\r\n  \t// @method toBBoxString(): String\r\n  \t// Returns a string with bounding box coordinates in a 'southwest_lng,southwest_lat,northeast_lng,northeast_lat' format. Useful for sending requests to web services that return geo data.\r\n  \ttoBBoxString: function () {\r\n  \t\treturn [this.getWest(), this.getSouth(), this.getEast(), this.getNorth()].join(',');\r\n  \t},\r\n\r\n  \t// @method equals(otherBounds: LatLngBounds, maxMargin?: Number): Boolean\r\n  \t// Returns `true` if the rectangle is equivalent (within a small margin of error) to the given bounds. The margin of error can be overridden by setting `maxMargin` to a small number.\r\n  \tequals: function (bounds, maxMargin) {\r\n  \t\tif (!bounds) { return false; }\r\n\r\n  \t\tbounds = toLatLngBounds(bounds);\r\n\r\n  \t\treturn this._southWest.equals(bounds.getSouthWest(), maxMargin) &&\r\n  \t\t       this._northEast.equals(bounds.getNorthEast(), maxMargin);\r\n  \t},\r\n\r\n  \t// @method isValid(): Boolean\r\n  \t// Returns `true` if the bounds are properly initialized.\r\n  \tisValid: function () {\r\n  \t\treturn !!(this._southWest && this._northEast);\r\n  \t}\r\n  };\r\n\r\n  // TODO International date line?\r\n\r\n  // @factory L.latLngBounds(corner1: LatLng, corner2: LatLng)\r\n  // Creates a `LatLngBounds` object by defining two diagonally opposite corners of the rectangle.\r\n\r\n  // @alternative\r\n  // @factory L.latLngBounds(latlngs: LatLng[])\r\n  // Creates a `LatLngBounds` object defined by the geographical points it contains. Very useful for zooming the map to fit a particular set of locations with [`fitBounds`](#map-fitbounds).\r\n  function toLatLngBounds(a, b) {\r\n  \tif (a instanceof LatLngBounds) {\r\n  \t\treturn a;\r\n  \t}\r\n  \treturn new LatLngBounds(a, b);\r\n  }\n\n  /* @class LatLng\r\n   * @aka L.LatLng\r\n   *\r\n   * Represents a geographical point with a certain latitude and longitude.\r\n   *\r\n   * @example\r\n   *\r\n   * ```\r\n   * var latlng = L.latLng(50.5, 30.5);\r\n   * ```\r\n   *\r\n   * All Leaflet methods that accept LatLng objects also accept them in a simple Array form and simple object form (unless noted otherwise), so these lines are equivalent:\r\n   *\r\n   * ```\r\n   * map.panTo([50, 30]);\r\n   * map.panTo({lon: 30, lat: 50});\r\n   * map.panTo({lat: 50, lng: 30});\r\n   * map.panTo(L.latLng(50, 30));\r\n   * ```\r\n   *\r\n   * Note that `LatLng` does not inherit from Leaflet's `Class` object,\r\n   * which means new classes can't inherit from it, and new methods\r\n   * can't be added to it with the `include` function.\r\n   */\r\n\r\n  function LatLng(lat, lng, alt) {\r\n  \tif (isNaN(lat) || isNaN(lng)) {\r\n  \t\tthrow new Error('Invalid LatLng object: (' + lat + ', ' + lng + ')');\r\n  \t}\r\n\r\n  \t// @property lat: Number\r\n  \t// Latitude in degrees\r\n  \tthis.lat = +lat;\r\n\r\n  \t// @property lng: Number\r\n  \t// Longitude in degrees\r\n  \tthis.lng = +lng;\r\n\r\n  \t// @property alt: Number\r\n  \t// Altitude in meters (optional)\r\n  \tif (alt !== undefined) {\r\n  \t\tthis.alt = +alt;\r\n  \t}\r\n  }\r\n\r\n  LatLng.prototype = {\r\n  \t// @method equals(otherLatLng: LatLng, maxMargin?: Number): Boolean\r\n  \t// Returns `true` if the given `LatLng` point is at the same position (within a small margin of error). The margin of error can be overridden by setting `maxMargin` to a small number.\r\n  \tequals: function (obj, maxMargin) {\r\n  \t\tif (!obj) { return false; }\r\n\r\n  \t\tobj = toLatLng(obj);\r\n\r\n  \t\tvar margin = Math.max(\r\n  \t\t        Math.abs(this.lat - obj.lat),\r\n  \t\t        Math.abs(this.lng - obj.lng));\r\n\r\n  \t\treturn margin <= (maxMargin === undefined ? 1.0E-9 : maxMargin);\r\n  \t},\r\n\r\n  \t// @method toString(): String\r\n  \t// Returns a string representation of the point (for debugging purposes).\r\n  \ttoString: function (precision) {\r\n  \t\treturn 'LatLng(' +\r\n  \t\t        formatNum(this.lat, precision) + ', ' +\r\n  \t\t        formatNum(this.lng, precision) + ')';\r\n  \t},\r\n\r\n  \t// @method distanceTo(otherLatLng: LatLng): Number\r\n  \t// Returns the distance (in meters) to the given `LatLng` calculated using the [Spherical Law of Cosines](https://en.wikipedia.org/wiki/Spherical_law_of_cosines).\r\n  \tdistanceTo: function (other) {\r\n  \t\treturn Earth.distance(this, toLatLng(other));\r\n  \t},\r\n\r\n  \t// @method wrap(): LatLng\r\n  \t// Returns a new `LatLng` object with the longitude wrapped so it's always between -180 and +180 degrees.\r\n  \twrap: function () {\r\n  \t\treturn Earth.wrapLatLng(this);\r\n  \t},\r\n\r\n  \t// @method toBounds(sizeInMeters: Number): LatLngBounds\r\n  \t// Returns a new `LatLngBounds` object in which each boundary is `sizeInMeters/2` meters apart from the `LatLng`.\r\n  \ttoBounds: function (sizeInMeters) {\r\n  \t\tvar latAccuracy = 180 * sizeInMeters / 40075017,\r\n  \t\t    lngAccuracy = latAccuracy / Math.cos((Math.PI / 180) * this.lat);\r\n\r\n  \t\treturn toLatLngBounds(\r\n  \t\t        [this.lat - latAccuracy, this.lng - lngAccuracy],\r\n  \t\t        [this.lat + latAccuracy, this.lng + lngAccuracy]);\r\n  \t},\r\n\r\n  \tclone: function () {\r\n  \t\treturn new LatLng(this.lat, this.lng, this.alt);\r\n  \t}\r\n  };\r\n\r\n\r\n\r\n  // @factory L.latLng(latitude: Number, longitude: Number, altitude?: Number): LatLng\r\n  // Creates an object representing a geographical point with the given latitude and longitude (and optionally altitude).\r\n\r\n  // @alternative\r\n  // @factory L.latLng(coords: Array): LatLng\r\n  // Expects an array of the form `[Number, Number]` or `[Number, Number, Number]` instead.\r\n\r\n  // @alternative\r\n  // @factory L.latLng(coords: Object): LatLng\r\n  // Expects an plain object of the form `{lat: Number, lng: Number}` or `{lat: Number, lng: Number, alt: Number}` instead.\r\n\r\n  function toLatLng(a, b, c) {\r\n  \tif (a instanceof LatLng) {\r\n  \t\treturn a;\r\n  \t}\r\n  \tif (isArray(a) && typeof a[0] !== 'object') {\r\n  \t\tif (a.length === 3) {\r\n  \t\t\treturn new LatLng(a[0], a[1], a[2]);\r\n  \t\t}\r\n  \t\tif (a.length === 2) {\r\n  \t\t\treturn new LatLng(a[0], a[1]);\r\n  \t\t}\r\n  \t\treturn null;\r\n  \t}\r\n  \tif (a === undefined || a === null) {\r\n  \t\treturn a;\r\n  \t}\r\n  \tif (typeof a === 'object' && 'lat' in a) {\r\n  \t\treturn new LatLng(a.lat, 'lng' in a ? a.lng : a.lon, a.alt);\r\n  \t}\r\n  \tif (b === undefined) {\r\n  \t\treturn null;\r\n  \t}\r\n  \treturn new LatLng(a, b, c);\r\n  }\n\n  /*\r\n   * @namespace CRS\r\n   * @crs L.CRS.Base\r\n   * Object that defines coordinate reference systems for projecting\r\n   * geographical points into pixel (screen) coordinates and back (and to\r\n   * coordinates in other units for [WMS](https://en.wikipedia.org/wiki/Web_Map_Service) services). See\r\n   * [spatial reference system](http://en.wikipedia.org/wiki/Coordinate_reference_system).\r\n   *\r\n   * Leaflet defines the most usual CRSs by default. If you want to use a\r\n   * CRS not defined by default, take a look at the\r\n   * [Proj4Leaflet](https://github.com/kartena/Proj4Leaflet) plugin.\r\n   *\r\n   * Note that the CRS instances do not inherit from Leaflet's `Class` object,\r\n   * and can't be instantiated. Also, new classes can't inherit from them,\r\n   * and methods can't be added to them with the `include` function.\r\n   */\r\n\r\n  var CRS = {\r\n  \t// @method latLngToPoint(latlng: LatLng, zoom: Number): Point\r\n  \t// Projects geographical coordinates into pixel coordinates for a given zoom.\r\n  \tlatLngToPoint: function (latlng, zoom) {\r\n  \t\tvar projectedPoint = this.projection.project(latlng),\r\n  \t\t    scale = this.scale(zoom);\r\n\r\n  \t\treturn this.transformation._transform(projectedPoint, scale);\r\n  \t},\r\n\r\n  \t// @method pointToLatLng(point: Point, zoom: Number): LatLng\r\n  \t// The inverse of `latLngToPoint`. Projects pixel coordinates on a given\r\n  \t// zoom into geographical coordinates.\r\n  \tpointToLatLng: function (point, zoom) {\r\n  \t\tvar scale = this.scale(zoom),\r\n  \t\t    untransformedPoint = this.transformation.untransform(point, scale);\r\n\r\n  \t\treturn this.projection.unproject(untransformedPoint);\r\n  \t},\r\n\r\n  \t// @method project(latlng: LatLng): Point\r\n  \t// Projects geographical coordinates into coordinates in units accepted for\r\n  \t// this CRS (e.g. meters for EPSG:3857, for passing it to WMS services).\r\n  \tproject: function (latlng) {\r\n  \t\treturn this.projection.project(latlng);\r\n  \t},\r\n\r\n  \t// @method unproject(point: Point): LatLng\r\n  \t// Given a projected coordinate returns the corresponding LatLng.\r\n  \t// The inverse of `project`.\r\n  \tunproject: function (point) {\r\n  \t\treturn this.projection.unproject(point);\r\n  \t},\r\n\r\n  \t// @method scale(zoom: Number): Number\r\n  \t// Returns the scale used when transforming projected coordinates into\r\n  \t// pixel coordinates for a particular zoom. For example, it returns\r\n  \t// `256 * 2^zoom` for Mercator-based CRS.\r\n  \tscale: function (zoom) {\r\n  \t\treturn 256 * Math.pow(2, zoom);\r\n  \t},\r\n\r\n  \t// @method zoom(scale: Number): Number\r\n  \t// Inverse of `scale()`, returns the zoom level corresponding to a scale\r\n  \t// factor of `scale`.\r\n  \tzoom: function (scale) {\r\n  \t\treturn Math.log(scale / 256) / Math.LN2;\r\n  \t},\r\n\r\n  \t// @method getProjectedBounds(zoom: Number): Bounds\r\n  \t// Returns the projection's bounds scaled and transformed for the provided `zoom`.\r\n  \tgetProjectedBounds: function (zoom) {\r\n  \t\tif (this.infinite) { return null; }\r\n\r\n  \t\tvar b = this.projection.bounds,\r\n  \t\t    s = this.scale(zoom),\r\n  \t\t    min = this.transformation.transform(b.min, s),\r\n  \t\t    max = this.transformation.transform(b.max, s);\r\n\r\n  \t\treturn new Bounds(min, max);\r\n  \t},\r\n\r\n  \t// @method distance(latlng1: LatLng, latlng2: LatLng): Number\r\n  \t// Returns the distance between two geographical coordinates.\r\n\r\n  \t// @property code: String\r\n  \t// Standard code name of the CRS passed into WMS services (e.g. `'EPSG:3857'`)\r\n  \t//\r\n  \t// @property wrapLng: Number[]\r\n  \t// An array of two numbers defining whether the longitude (horizontal) coordinate\r\n  \t// axis wraps around a given range and how. Defaults to `[-180, 180]` in most\r\n  \t// geographical CRSs. If `undefined`, the longitude axis does not wrap around.\r\n  \t//\r\n  \t// @property wrapLat: Number[]\r\n  \t// Like `wrapLng`, but for the latitude (vertical) axis.\r\n\r\n  \t// wrapLng: [min, max],\r\n  \t// wrapLat: [min, max],\r\n\r\n  \t// @property infinite: Boolean\r\n  \t// If true, the coordinate space will be unbounded (infinite in both axes)\r\n  \tinfinite: false,\r\n\r\n  \t// @method wrapLatLng(latlng: LatLng): LatLng\r\n  \t// Returns a `LatLng` where lat and lng has been wrapped according to the\r\n  \t// CRS's `wrapLat` and `wrapLng` properties, if they are outside the CRS's bounds.\r\n  \twrapLatLng: function (latlng) {\r\n  \t\tvar lng = this.wrapLng ? wrapNum(latlng.lng, this.wrapLng, true) : latlng.lng,\r\n  \t\t    lat = this.wrapLat ? wrapNum(latlng.lat, this.wrapLat, true) : latlng.lat,\r\n  \t\t    alt = latlng.alt;\r\n\r\n  \t\treturn new LatLng(lat, lng, alt);\r\n  \t},\r\n\r\n  \t// @method wrapLatLngBounds(bounds: LatLngBounds): LatLngBounds\r\n  \t// Returns a `LatLngBounds` with the same size as the given one, ensuring\r\n  \t// that its center is within the CRS's bounds.\r\n  \t// Only accepts actual `L.LatLngBounds` instances, not arrays.\r\n  \twrapLatLngBounds: function (bounds) {\r\n  \t\tvar center = bounds.getCenter(),\r\n  \t\t    newCenter = this.wrapLatLng(center),\r\n  \t\t    latShift = center.lat - newCenter.lat,\r\n  \t\t    lngShift = center.lng - newCenter.lng;\r\n\r\n  \t\tif (latShift === 0 && lngShift === 0) {\r\n  \t\t\treturn bounds;\r\n  \t\t}\r\n\r\n  \t\tvar sw = bounds.getSouthWest(),\r\n  \t\t    ne = bounds.getNorthEast(),\r\n  \t\t    newSw = new LatLng(sw.lat - latShift, sw.lng - lngShift),\r\n  \t\t    newNe = new LatLng(ne.lat - latShift, ne.lng - lngShift);\r\n\r\n  \t\treturn new LatLngBounds(newSw, newNe);\r\n  \t}\r\n  };\n\n  /*\n   * @namespace CRS\n   * @crs L.CRS.Earth\n   *\n   * Serves as the base for CRS that are global such that they cover the earth.\n   * Can only be used as the base for other CRS and cannot be used directly,\n   * since it does not have a `code`, `projection` or `transformation`. `distance()` returns\n   * meters.\n   */\n\n  var Earth = extend({}, CRS, {\n  \twrapLng: [-180, 180],\n\n  \t// Mean Earth Radius, as recommended for use by\n  \t// the International Union of Geodesy and Geophysics,\n  \t// see http://rosettacode.org/wiki/Haversine_formula\n  \tR: 6371000,\n\n  \t// distance between two geographical points using spherical law of cosines approximation\n  \tdistance: function (latlng1, latlng2) {\n  \t\tvar rad = Math.PI / 180,\n  \t\t    lat1 = latlng1.lat * rad,\n  \t\t    lat2 = latlng2.lat * rad,\n  \t\t    sinDLat = Math.sin((latlng2.lat - latlng1.lat) * rad / 2),\n  \t\t    sinDLon = Math.sin((latlng2.lng - latlng1.lng) * rad / 2),\n  \t\t    a = sinDLat * sinDLat + Math.cos(lat1) * Math.cos(lat2) * sinDLon * sinDLon,\n  \t\t    c = 2 * Math.atan2(Math.sqrt(a), Math.sqrt(1 - a));\n  \t\treturn this.R * c;\n  \t}\n  });\n\n  /*\r\n   * @namespace Projection\r\n   * @projection L.Projection.SphericalMercator\r\n   *\r\n   * Spherical Mercator projection — the most common projection for online maps,\r\n   * used by almost all free and commercial tile providers. Assumes that Earth is\r\n   * a sphere. Used by the `EPSG:3857` CRS.\r\n   */\r\n\r\n  var earthRadius = 6378137;\r\n\r\n  var SphericalMercator = {\r\n\r\n  \tR: earthRadius,\r\n  \tMAX_LATITUDE: 85.0511287798,\r\n\r\n  \tproject: function (latlng) {\r\n  \t\tvar d = Math.PI / 180,\r\n  \t\t    max = this.MAX_LATITUDE,\r\n  \t\t    lat = Math.max(Math.min(max, latlng.lat), -max),\r\n  \t\t    sin = Math.sin(lat * d);\r\n\r\n  \t\treturn new Point(\r\n  \t\t\tthis.R * latlng.lng * d,\r\n  \t\t\tthis.R * Math.log((1 + sin) / (1 - sin)) / 2);\r\n  \t},\r\n\r\n  \tunproject: function (point) {\r\n  \t\tvar d = 180 / Math.PI;\r\n\r\n  \t\treturn new LatLng(\r\n  \t\t\t(2 * Math.atan(Math.exp(point.y / this.R)) - (Math.PI / 2)) * d,\r\n  \t\t\tpoint.x * d / this.R);\r\n  \t},\r\n\r\n  \tbounds: (function () {\r\n  \t\tvar d = earthRadius * Math.PI;\r\n  \t\treturn new Bounds([-d, -d], [d, d]);\r\n  \t})()\r\n  };\n\n  /*\r\n   * @class Transformation\r\n   * @aka L.Transformation\r\n   *\r\n   * Represents an affine transformation: a set of coefficients `a`, `b`, `c`, `d`\r\n   * for transforming a point of a form `(x, y)` into `(a*x + b, c*y + d)` and doing\r\n   * the reverse. Used by Leaflet in its projections code.\r\n   *\r\n   * @example\r\n   *\r\n   * ```js\r\n   * var transformation = L.transformation(2, 5, -1, 10),\r\n   * \tp = L.point(1, 2),\r\n   * \tp2 = transformation.transform(p), //  L.point(7, 8)\r\n   * \tp3 = transformation.untransform(p2); //  L.point(1, 2)\r\n   * ```\r\n   */\r\n\r\n\r\n  // factory new L.Transformation(a: Number, b: Number, c: Number, d: Number)\r\n  // Creates a `Transformation` object with the given coefficients.\r\n  function Transformation(a, b, c, d) {\r\n  \tif (isArray(a)) {\r\n  \t\t// use array properties\r\n  \t\tthis._a = a[0];\r\n  \t\tthis._b = a[1];\r\n  \t\tthis._c = a[2];\r\n  \t\tthis._d = a[3];\r\n  \t\treturn;\r\n  \t}\r\n  \tthis._a = a;\r\n  \tthis._b = b;\r\n  \tthis._c = c;\r\n  \tthis._d = d;\r\n  }\r\n\r\n  Transformation.prototype = {\r\n  \t// @method transform(point: Point, scale?: Number): Point\r\n  \t// Returns a transformed point, optionally multiplied by the given scale.\r\n  \t// Only accepts actual `L.Point` instances, not arrays.\r\n  \ttransform: function (point, scale) { // (Point, Number) -> Point\r\n  \t\treturn this._transform(point.clone(), scale);\r\n  \t},\r\n\r\n  \t// destructive transform (faster)\r\n  \t_transform: function (point, scale) {\r\n  \t\tscale = scale || 1;\r\n  \t\tpoint.x = scale * (this._a * point.x + this._b);\r\n  \t\tpoint.y = scale * (this._c * point.y + this._d);\r\n  \t\treturn point;\r\n  \t},\r\n\r\n  \t// @method untransform(point: Point, scale?: Number): Point\r\n  \t// Returns the reverse transformation of the given point, optionally divided\r\n  \t// by the given scale. Only accepts actual `L.Point` instances, not arrays.\r\n  \tuntransform: function (point, scale) {\r\n  \t\tscale = scale || 1;\r\n  \t\treturn new Point(\r\n  \t\t        (point.x / scale - this._b) / this._a,\r\n  \t\t        (point.y / scale - this._d) / this._c);\r\n  \t}\r\n  };\r\n\r\n  // factory L.transformation(a: Number, b: Number, c: Number, d: Number)\r\n\r\n  // @factory L.transformation(a: Number, b: Number, c: Number, d: Number)\r\n  // Instantiates a Transformation object with the given coefficients.\r\n\r\n  // @alternative\r\n  // @factory L.transformation(coefficients: Array): Transformation\r\n  // Expects an coefficients array of the form\r\n  // `[a: Number, b: Number, c: Number, d: Number]`.\r\n\r\n  function toTransformation(a, b, c, d) {\r\n  \treturn new Transformation(a, b, c, d);\r\n  }\n\n  /*\r\n   * @namespace CRS\r\n   * @crs L.CRS.EPSG3857\r\n   *\r\n   * The most common CRS for online maps, used by almost all free and commercial\r\n   * tile providers. Uses Spherical Mercator projection. Set in by default in\r\n   * Map's `crs` option.\r\n   */\r\n\r\n  var EPSG3857 = extend({}, Earth, {\r\n  \tcode: 'EPSG:3857',\r\n  \tprojection: SphericalMercator,\r\n\r\n  \ttransformation: (function () {\r\n  \t\tvar scale = 0.5 / (Math.PI * SphericalMercator.R);\r\n  \t\treturn toTransformation(scale, 0.5, -scale, 0.5);\r\n  \t}())\r\n  });\r\n\r\n  var EPSG900913 = extend({}, EPSG3857, {\r\n  \tcode: 'EPSG:900913'\r\n  });\n\n  // @namespace SVG; @section\n  // There are several static functions which can be called without instantiating L.SVG:\n\n  // @function create(name: String): SVGElement\n  // Returns a instance of [SVGElement](https://developer.mozilla.org/docs/Web/API/SVGElement),\n  // corresponding to the class name passed. For example, using 'line' will return\n  // an instance of [SVGLineElement](https://developer.mozilla.org/docs/Web/API/SVGLineElement).\n  function svgCreate(name) {\n  \treturn document.createElementNS('http://www.w3.org/2000/svg', name);\n  }\n\n  // @function pointsToPath(rings: Point[], closed: Boolean): String\n  // Generates a SVG path string for multiple rings, with each ring turning\n  // into \"M..L..L..\" instructions\n  function pointsToPath(rings, closed) {\n  \tvar str = '',\n  \ti, j, len, len2, points, p;\n\n  \tfor (i = 0, len = rings.length; i < len; i++) {\n  \t\tpoints = rings[i];\n\n  \t\tfor (j = 0, len2 = points.length; j < len2; j++) {\n  \t\t\tp = points[j];\n  \t\t\tstr += (j ? 'L' : 'M') + p.x + ' ' + p.y;\n  \t\t}\n\n  \t\t// closes the ring for polygons; \"x\" is VML syntax\n  \t\tstr += closed ? (svg ? 'z' : 'x') : '';\n  \t}\n\n  \t// SVG complains about empty path strings\n  \treturn str || 'M0 0';\n  }\n\n  /*\r\n   * @namespace Browser\r\n   * @aka L.Browser\r\n   *\r\n   * A namespace with static properties for browser/feature detection used by Leaflet internally.\r\n   *\r\n   * @example\r\n   *\r\n   * ```js\r\n   * if (L.Browser.ielt9) {\r\n   *   alert('Upgrade your browser, dude!');\r\n   * }\r\n   * ```\r\n   */\r\n\r\n  var style$1 = document.documentElement.style;\r\n\r\n  // @property ie: Boolean; `true` for all Internet Explorer versions (not Edge).\r\n  var ie = 'ActiveXObject' in window;\r\n\r\n  // @property ielt9: Boolean; `true` for Internet Explorer versions less than 9.\r\n  var ielt9 = ie && !document.addEventListener;\r\n\r\n  // @property edge: Boolean; `true` for the Edge web browser.\r\n  var edge = 'msLaunchUri' in navigator && !('documentMode' in document);\r\n\r\n  // @property webkit: Boolean;\r\n  // `true` for webkit-based browsers like Chrome and Safari (including mobile versions).\r\n  var webkit = userAgentContains('webkit');\r\n\r\n  // @property android: Boolean\r\n  // `true` for any browser running on an Android platform.\r\n  var android = userAgentContains('android');\r\n\r\n  // @property android23: Boolean; `true` for browsers running on Android 2 or Android 3.\r\n  var android23 = userAgentContains('android 2') || userAgentContains('android 3');\r\n\r\n  /* See https://stackoverflow.com/a/17961266 for details on detecting stock Android */\r\n  var webkitVer = parseInt(/WebKit\\/([0-9]+)|$/.exec(navigator.userAgent)[1], 10); // also matches AppleWebKit\r\n  // @property androidStock: Boolean; `true` for the Android stock browser (i.e. not Chrome)\r\n  var androidStock = android && userAgentContains('Google') && webkitVer < 537 && !('AudioNode' in window);\r\n\r\n  // @property opera: Boolean; `true` for the Opera browser\r\n  var opera = !!window.opera;\r\n\r\n  // @property chrome: Boolean; `true` for the Chrome browser.\r\n  var chrome = !edge && userAgentContains('chrome');\r\n\r\n  // @property gecko: Boolean; `true` for gecko-based browsers like Firefox.\r\n  var gecko = userAgentContains('gecko') && !webkit && !opera && !ie;\r\n\r\n  // @property safari: Boolean; `true` for the Safari browser.\r\n  var safari = !chrome && userAgentContains('safari');\r\n\r\n  var phantom = userAgentContains('phantom');\r\n\r\n  // @property opera12: Boolean\r\n  // `true` for the Opera browser supporting CSS transforms (version 12 or later).\r\n  var opera12 = 'OTransition' in style$1;\r\n\r\n  // @property win: Boolean; `true` when the browser is running in a Windows platform\r\n  var win = navigator.platform.indexOf('Win') === 0;\r\n\r\n  // @property ie3d: Boolean; `true` for all Internet Explorer versions supporting CSS transforms.\r\n  var ie3d = ie && ('transition' in style$1);\r\n\r\n  // @property webkit3d: Boolean; `true` for webkit-based browsers supporting CSS transforms.\r\n  var webkit3d = ('WebKitCSSMatrix' in window) && ('m11' in new window.WebKitCSSMatrix()) && !android23;\r\n\r\n  // @property gecko3d: Boolean; `true` for gecko-based browsers supporting CSS transforms.\r\n  var gecko3d = 'MozPerspective' in style$1;\r\n\r\n  // @property any3d: Boolean\r\n  // `true` for all browsers supporting CSS transforms.\r\n  var any3d = !window.L_DISABLE_3D && (ie3d || webkit3d || gecko3d) && !opera12 && !phantom;\r\n\r\n  // @property mobile: Boolean; `true` for all browsers running in a mobile device.\r\n  var mobile = typeof orientation !== 'undefined' || userAgentContains('mobile');\r\n\r\n  // @property mobileWebkit: Boolean; `true` for all webkit-based browsers in a mobile device.\r\n  var mobileWebkit = mobile && webkit;\r\n\r\n  // @property mobileWebkit3d: Boolean\r\n  // `true` for all webkit-based browsers in a mobile device supporting CSS transforms.\r\n  var mobileWebkit3d = mobile && webkit3d;\r\n\r\n  // @property msPointer: Boolean\r\n  // `true` for browsers implementing the Microsoft touch events model (notably IE10).\r\n  var msPointer = !window.PointerEvent && window.MSPointerEvent;\r\n\r\n  // @property pointer: Boolean\r\n  // `true` for all browsers supporting [pointer events](https://msdn.microsoft.com/en-us/library/dn433244%28v=vs.85%29.aspx).\r\n  var pointer = !!(window.PointerEvent || msPointer);\r\n\r\n  // @property touch: Boolean\r\n  // `true` for all browsers supporting [touch events](https://developer.mozilla.org/docs/Web/API/Touch_events).\r\n  // This does not necessarily mean that the browser is running in a computer with\r\n  // a touchscreen, it only means that the browser is capable of understanding\r\n  // touch events.\r\n  var touch = !window.L_NO_TOUCH && (pointer || 'ontouchstart' in window ||\r\n  \t\t(window.DocumentTouch && document instanceof window.DocumentTouch));\r\n\r\n  // @property mobileOpera: Boolean; `true` for the Opera browser in a mobile device.\r\n  var mobileOpera = mobile && opera;\r\n\r\n  // @property mobileGecko: Boolean\r\n  // `true` for gecko-based browsers running in a mobile device.\r\n  var mobileGecko = mobile && gecko;\r\n\r\n  // @property retina: Boolean\r\n  // `true` for browsers on a high-resolution \"retina\" screen or on any screen when browser's display zoom is more than 100%.\r\n  var retina = (window.devicePixelRatio || (window.screen.deviceXDPI / window.screen.logicalXDPI)) > 1;\r\n\r\n  // @property passiveEvents: Boolean\r\n  // `true` for browsers that support passive events.\r\n  var passiveEvents = (function () {\r\n  \tvar supportsPassiveOption = false;\r\n  \ttry {\r\n  \t\tvar opts = Object.defineProperty({}, 'passive', {\r\n  \t\t\tget: function () { // eslint-disable-line getter-return\r\n  \t\t\t\tsupportsPassiveOption = true;\r\n  \t\t\t}\r\n  \t\t});\r\n  \t\twindow.addEventListener('testPassiveEventSupport', falseFn, opts);\r\n  \t\twindow.removeEventListener('testPassiveEventSupport', falseFn, opts);\r\n  \t} catch (e) {\r\n  \t\t// Errors can safely be ignored since this is only a browser support test.\r\n  \t}\r\n  \treturn supportsPassiveOption;\r\n  }());\r\n\r\n  // @property canvas: Boolean\r\n  // `true` when the browser supports [`<canvas>`](https://developer.mozilla.org/docs/Web/API/Canvas_API).\r\n  var canvas = (function () {\r\n  \treturn !!document.createElement('canvas').getContext;\r\n  }());\r\n\r\n  // @property svg: Boolean\r\n  // `true` when the browser supports [SVG](https://developer.mozilla.org/docs/Web/SVG).\r\n  var svg = !!(document.createElementNS && svgCreate('svg').createSVGRect);\r\n\r\n  // @property vml: Boolean\r\n  // `true` if the browser supports [VML](https://en.wikipedia.org/wiki/Vector_Markup_Language).\r\n  var vml = !svg && (function () {\r\n  \ttry {\r\n  \t\tvar div = document.createElement('div');\r\n  \t\tdiv.innerHTML = '<v:shape adj=\"1\"/>';\r\n\r\n  \t\tvar shape = div.firstChild;\r\n  \t\tshape.style.behavior = 'url(#default#VML)';\r\n\r\n  \t\treturn shape && (typeof shape.adj === 'object');\r\n\r\n  \t} catch (e) {\r\n  \t\treturn false;\r\n  \t}\r\n  }());\r\n\r\n\r\n  function userAgentContains(str) {\r\n  \treturn navigator.userAgent.toLowerCase().indexOf(str) >= 0;\r\n  }\n\n  var Browser = ({\n    ie: ie,\n    ielt9: ielt9,\n    edge: edge,\n    webkit: webkit,\n    android: android,\n    android23: android23,\n    androidStock: androidStock,\n    opera: opera,\n    chrome: chrome,\n    gecko: gecko,\n    safari: safari,\n    phantom: phantom,\n    opera12: opera12,\n    win: win,\n    ie3d: ie3d,\n    webkit3d: webkit3d,\n    gecko3d: gecko3d,\n    any3d: any3d,\n    mobile: mobile,\n    mobileWebkit: mobileWebkit,\n    mobileWebkit3d: mobileWebkit3d,\n    msPointer: msPointer,\n    pointer: pointer,\n    touch: touch,\n    mobileOpera: mobileOpera,\n    mobileGecko: mobileGecko,\n    retina: retina,\n    passiveEvents: passiveEvents,\n    canvas: canvas,\n    svg: svg,\n    vml: vml\n  });\n\n  /*\n   * Extends L.DomEvent to provide touch support for Internet Explorer and Windows-based devices.\n   */\n\n\n  var POINTER_DOWN =   msPointer ? 'MSPointerDown'   : 'pointerdown';\n  var POINTER_MOVE =   msPointer ? 'MSPointerMove'   : 'pointermove';\n  var POINTER_UP =     msPointer ? 'MSPointerUp'     : 'pointerup';\n  var POINTER_CANCEL = msPointer ? 'MSPointerCancel' : 'pointercancel';\n\n  var _pointers = {};\n  var _pointerDocListener = false;\n\n  // Provides a touch events wrapper for (ms)pointer events.\n  // ref http://www.w3.org/TR/pointerevents/ https://www.w3.org/Bugs/Public/show_bug.cgi?id=22890\n\n  function addPointerListener(obj, type, handler, id) {\n  \tif (type === 'touchstart') {\n  \t\t_addPointerStart(obj, handler, id);\n\n  \t} else if (type === 'touchmove') {\n  \t\t_addPointerMove(obj, handler, id);\n\n  \t} else if (type === 'touchend') {\n  \t\t_addPointerEnd(obj, handler, id);\n  \t}\n\n  \treturn this;\n  }\n\n  function removePointerListener(obj, type, id) {\n  \tvar handler = obj['_leaflet_' + type + id];\n\n  \tif (type === 'touchstart') {\n  \t\tobj.removeEventListener(POINTER_DOWN, handler, false);\n\n  \t} else if (type === 'touchmove') {\n  \t\tobj.removeEventListener(POINTER_MOVE, handler, false);\n\n  \t} else if (type === 'touchend') {\n  \t\tobj.removeEventListener(POINTER_UP, handler, false);\n  \t\tobj.removeEventListener(POINTER_CANCEL, handler, false);\n  \t}\n\n  \treturn this;\n  }\n\n  function _addPointerStart(obj, handler, id) {\n  \tvar onDown = bind(function (e) {\n  \t\t// IE10 specific: MsTouch needs preventDefault. See #2000\n  \t\tif (e.MSPOINTER_TYPE_TOUCH && e.pointerType === e.MSPOINTER_TYPE_TOUCH) {\n  \t\t\tpreventDefault(e);\n  \t\t}\n\n  \t\t_handlePointer(e, handler);\n  \t});\n\n  \tobj['_leaflet_touchstart' + id] = onDown;\n  \tobj.addEventListener(POINTER_DOWN, onDown, false);\n\n  \t// need to keep track of what pointers and how many are active to provide e.touches emulation\n  \tif (!_pointerDocListener) {\n  \t\t// we listen document as any drags that end by moving the touch off the screen get fired there\n  \t\tdocument.addEventListener(POINTER_DOWN, _globalPointerDown, true);\n  \t\tdocument.addEventListener(POINTER_MOVE, _globalPointerMove, true);\n  \t\tdocument.addEventListener(POINTER_UP, _globalPointerUp, true);\n  \t\tdocument.addEventListener(POINTER_CANCEL, _globalPointerUp, true);\n\n  \t\t_pointerDocListener = true;\n  \t}\n  }\n\n  function _globalPointerDown(e) {\n  \t_pointers[e.pointerId] = e;\n  }\n\n  function _globalPointerMove(e) {\n  \tif (_pointers[e.pointerId]) {\n  \t\t_pointers[e.pointerId] = e;\n  \t}\n  }\n\n  function _globalPointerUp(e) {\n  \tdelete _pointers[e.pointerId];\n  }\n\n  function _handlePointer(e, handler) {\n  \te.touches = [];\n  \tfor (var i in _pointers) {\n  \t\te.touches.push(_pointers[i]);\n  \t}\n  \te.changedTouches = [e];\n\n  \thandler(e);\n  }\n\n  function _addPointerMove(obj, handler, id) {\n  \tvar onMove = function (e) {\n  \t\t// don't fire touch moves when mouse isn't down\n  \t\tif ((e.pointerType === (e.MSPOINTER_TYPE_MOUSE || 'mouse')) && e.buttons === 0) {\n  \t\t\treturn;\n  \t\t}\n\n  \t\t_handlePointer(e, handler);\n  \t};\n\n  \tobj['_leaflet_touchmove' + id] = onMove;\n  \tobj.addEventListener(POINTER_MOVE, onMove, false);\n  }\n\n  function _addPointerEnd(obj, handler, id) {\n  \tvar onUp = function (e) {\n  \t\t_handlePointer(e, handler);\n  \t};\n\n  \tobj['_leaflet_touchend' + id] = onUp;\n  \tobj.addEventListener(POINTER_UP, onUp, false);\n  \tobj.addEventListener(POINTER_CANCEL, onUp, false);\n  }\n\n  /*\r\n   * Extends the event handling code with double tap support for mobile browsers.\r\n   */\r\n\r\n  var _touchstart = msPointer ? 'MSPointerDown' : pointer ? 'pointerdown' : 'touchstart';\r\n  var _touchend = msPointer ? 'MSPointerUp' : pointer ? 'pointerup' : 'touchend';\r\n  var _pre = '_leaflet_';\r\n\r\n  // inspired by Zepto touch code by Thomas Fuchs\r\n  function addDoubleTapListener(obj, handler, id) {\r\n  \tvar last, touch$$1,\r\n  \t    doubleTap = false,\r\n  \t    delay = 250;\r\n\r\n  \tfunction onTouchStart(e) {\r\n\r\n  \t\tif (pointer) {\r\n  \t\t\tif (!e.isPrimary) { return; }\r\n  \t\t\tif (e.pointerType === 'mouse') { return; } // mouse fires native dblclick\r\n  \t\t} else if (e.touches.length > 1) {\r\n  \t\t\treturn;\r\n  \t\t}\r\n\r\n  \t\tvar now = Date.now(),\r\n  \t\t    delta = now - (last || now);\r\n\r\n  \t\ttouch$$1 = e.touches ? e.touches[0] : e;\r\n  \t\tdoubleTap = (delta > 0 && delta <= delay);\r\n  \t\tlast = now;\r\n  \t}\r\n\r\n  \tfunction onTouchEnd(e) {\r\n  \t\tif (doubleTap && !touch$$1.cancelBubble) {\r\n  \t\t\tif (pointer) {\r\n  \t\t\t\tif (e.pointerType === 'mouse') { return; }\r\n  \t\t\t\t// work around .type being readonly with MSPointer* events\r\n  \t\t\t\tvar newTouch = {},\r\n  \t\t\t\t    prop, i;\r\n\r\n  \t\t\t\tfor (i in touch$$1) {\r\n  \t\t\t\t\tprop = touch$$1[i];\r\n  \t\t\t\t\tnewTouch[i] = prop && prop.bind ? prop.bind(touch$$1) : prop;\r\n  \t\t\t\t}\r\n  \t\t\t\ttouch$$1 = newTouch;\r\n  \t\t\t}\r\n  \t\t\ttouch$$1.type = 'dblclick';\r\n  \t\t\ttouch$$1.button = 0;\r\n  \t\t\thandler(touch$$1);\r\n  \t\t\tlast = null;\r\n  \t\t}\r\n  \t}\r\n\r\n  \tobj[_pre + _touchstart + id] = onTouchStart;\r\n  \tobj[_pre + _touchend + id] = onTouchEnd;\r\n  \tobj[_pre + 'dblclick' + id] = handler;\r\n\r\n  \tobj.addEventListener(_touchstart, onTouchStart, passiveEvents ? {passive: false} : false);\r\n  \tobj.addEventListener(_touchend, onTouchEnd, passiveEvents ? {passive: false} : false);\r\n\r\n  \t// On some platforms (notably, chrome<55 on win10 + touchscreen + mouse),\r\n  \t// the browser doesn't fire touchend/pointerup events but does fire\r\n  \t// native dblclicks. See #4127.\r\n  \t// Edge 14 also fires native dblclicks, but only for pointerType mouse, see #5180.\r\n  \tobj.addEventListener('dblclick', handler, false);\r\n\r\n  \treturn this;\r\n  }\r\n\r\n  function removeDoubleTapListener(obj, id) {\r\n  \tvar touchstart = obj[_pre + _touchstart + id],\r\n  \t    touchend = obj[_pre + _touchend + id],\r\n  \t    dblclick = obj[_pre + 'dblclick' + id];\r\n\r\n  \tobj.removeEventListener(_touchstart, touchstart, passiveEvents ? {passive: false} : false);\r\n  \tobj.removeEventListener(_touchend, touchend, passiveEvents ? {passive: false} : false);\r\n  \tobj.removeEventListener('dblclick', dblclick, false);\r\n\r\n  \treturn this;\r\n  }\n\n  /*\r\n   * @namespace DomUtil\r\n   *\r\n   * Utility functions to work with the [DOM](https://developer.mozilla.org/docs/Web/API/Document_Object_Model)\r\n   * tree, used by Leaflet internally.\r\n   *\r\n   * Most functions expecting or returning a `HTMLElement` also work for\r\n   * SVG elements. The only difference is that classes refer to CSS classes\r\n   * in HTML and SVG classes in SVG.\r\n   */\r\n\r\n\r\n  // @property TRANSFORM: String\r\n  // Vendor-prefixed transform style name (e.g. `'webkitTransform'` for WebKit).\r\n  var TRANSFORM = testProp(\r\n  \t['transform', 'webkitTransform', 'OTransform', 'MozTransform', 'msTransform']);\r\n\r\n  // webkitTransition comes first because some browser versions that drop vendor prefix don't do\r\n  // the same for the transitionend event, in particular the Android 4.1 stock browser\r\n\r\n  // @property TRANSITION: String\r\n  // Vendor-prefixed transition style name.\r\n  var TRANSITION = testProp(\r\n  \t['webkitTransition', 'transition', 'OTransition', 'MozTransition', 'msTransition']);\r\n\r\n  // @property TRANSITION_END: String\r\n  // Vendor-prefixed transitionend event name.\r\n  var TRANSITION_END =\r\n  \tTRANSITION === 'webkitTransition' || TRANSITION === 'OTransition' ? TRANSITION + 'End' : 'transitionend';\r\n\r\n\r\n  // @function get(id: String|HTMLElement): HTMLElement\r\n  // Returns an element given its DOM id, or returns the element itself\r\n  // if it was passed directly.\r\n  function get(id) {\r\n  \treturn typeof id === 'string' ? document.getElementById(id) : id;\r\n  }\r\n\r\n  // @function getStyle(el: HTMLElement, styleAttrib: String): String\r\n  // Returns the value for a certain style attribute on an element,\r\n  // including computed values or values set through CSS.\r\n  function getStyle(el, style) {\r\n  \tvar value = el.style[style] || (el.currentStyle && el.currentStyle[style]);\r\n\r\n  \tif ((!value || value === 'auto') && document.defaultView) {\r\n  \t\tvar css = document.defaultView.getComputedStyle(el, null);\r\n  \t\tvalue = css ? css[style] : null;\r\n  \t}\r\n  \treturn value === 'auto' ? null : value;\r\n  }\r\n\r\n  // @function create(tagName: String, className?: String, container?: HTMLElement): HTMLElement\r\n  // Creates an HTML element with `tagName`, sets its class to `className`, and optionally appends it to `container` element.\r\n  function create$1(tagName, className, container) {\r\n  \tvar el = document.createElement(tagName);\r\n  \tel.className = className || '';\r\n\r\n  \tif (container) {\r\n  \t\tcontainer.appendChild(el);\r\n  \t}\r\n  \treturn el;\r\n  }\r\n\r\n  // @function remove(el: HTMLElement)\r\n  // Removes `el` from its parent element\r\n  function remove(el) {\r\n  \tvar parent = el.parentNode;\r\n  \tif (parent) {\r\n  \t\tparent.removeChild(el);\r\n  \t}\r\n  }\r\n\r\n  // @function empty(el: HTMLElement)\r\n  // Removes all of `el`'s children elements from `el`\r\n  function empty(el) {\r\n  \twhile (el.firstChild) {\r\n  \t\tel.removeChild(el.firstChild);\r\n  \t}\r\n  }\r\n\r\n  // @function toFront(el: HTMLElement)\r\n  // Makes `el` the last child of its parent, so it renders in front of the other children.\r\n  function toFront(el) {\r\n  \tvar parent = el.parentNode;\r\n  \tif (parent && parent.lastChild !== el) {\r\n  \t\tparent.appendChild(el);\r\n  \t}\r\n  }\r\n\r\n  // @function toBack(el: HTMLElement)\r\n  // Makes `el` the first child of its parent, so it renders behind the other children.\r\n  function toBack(el) {\r\n  \tvar parent = el.parentNode;\r\n  \tif (parent && parent.firstChild !== el) {\r\n  \t\tparent.insertBefore(el, parent.firstChild);\r\n  \t}\r\n  }\r\n\r\n  // @function hasClass(el: HTMLElement, name: String): Boolean\r\n  // Returns `true` if the element's class attribute contains `name`.\r\n  function hasClass(el, name) {\r\n  \tif (el.classList !== undefined) {\r\n  \t\treturn el.classList.contains(name);\r\n  \t}\r\n  \tvar className = getClass(el);\r\n  \treturn className.length > 0 && new RegExp('(^|\\\\s)' + name + '(\\\\s|$)').test(className);\r\n  }\r\n\r\n  // @function addClass(el: HTMLElement, name: String)\r\n  // Adds `name` to the element's class attribute.\r\n  function addClass(el, name) {\r\n  \tif (el.classList !== undefined) {\r\n  \t\tvar classes = splitWords(name);\r\n  \t\tfor (var i = 0, len = classes.length; i < len; i++) {\r\n  \t\t\tel.classList.add(classes[i]);\r\n  \t\t}\r\n  \t} else if (!hasClass(el, name)) {\r\n  \t\tvar className = getClass(el);\r\n  \t\tsetClass(el, (className ? className + ' ' : '') + name);\r\n  \t}\r\n  }\r\n\r\n  // @function removeClass(el: HTMLElement, name: String)\r\n  // Removes `name` from the element's class attribute.\r\n  function removeClass(el, name) {\r\n  \tif (el.classList !== undefined) {\r\n  \t\tel.classList.remove(name);\r\n  \t} else {\r\n  \t\tsetClass(el, trim((' ' + getClass(el) + ' ').replace(' ' + name + ' ', ' ')));\r\n  \t}\r\n  }\r\n\r\n  // @function setClass(el: HTMLElement, name: String)\r\n  // Sets the element's class.\r\n  function setClass(el, name) {\r\n  \tif (el.className.baseVal === undefined) {\r\n  \t\tel.className = name;\r\n  \t} else {\r\n  \t\t// in case of SVG element\r\n  \t\tel.className.baseVal = name;\r\n  \t}\r\n  }\r\n\r\n  // @function getClass(el: HTMLElement): String\r\n  // Returns the element's class.\r\n  function getClass(el) {\r\n  \t// Check if the element is an SVGElementInstance and use the correspondingElement instead\r\n  \t// (Required for linked SVG elements in IE11.)\r\n  \tif (el.correspondingElement) {\r\n  \t\tel = el.correspondingElement;\r\n  \t}\r\n  \treturn el.className.baseVal === undefined ? el.className : el.className.baseVal;\r\n  }\r\n\r\n  // @function setOpacity(el: HTMLElement, opacity: Number)\r\n  // Set the opacity of an element (including old IE support).\r\n  // `opacity` must be a number from `0` to `1`.\r\n  function setOpacity(el, value) {\r\n  \tif ('opacity' in el.style) {\r\n  \t\tel.style.opacity = value;\r\n  \t} else if ('filter' in el.style) {\r\n  \t\t_setOpacityIE(el, value);\r\n  \t}\r\n  }\r\n\r\n  function _setOpacityIE(el, value) {\r\n  \tvar filter = false,\r\n  \t    filterName = 'DXImageTransform.Microsoft.Alpha';\r\n\r\n  \t// filters collection throws an error if we try to retrieve a filter that doesn't exist\r\n  \ttry {\r\n  \t\tfilter = el.filters.item(filterName);\r\n  \t} catch (e) {\r\n  \t\t// don't set opacity to 1 if we haven't already set an opacity,\r\n  \t\t// it isn't needed and breaks transparent pngs.\r\n  \t\tif (value === 1) { return; }\r\n  \t}\r\n\r\n  \tvalue = Math.round(value * 100);\r\n\r\n  \tif (filter) {\r\n  \t\tfilter.Enabled = (value !== 100);\r\n  \t\tfilter.Opacity = value;\r\n  \t} else {\r\n  \t\tel.style.filter += ' progid:' + filterName + '(opacity=' + value + ')';\r\n  \t}\r\n  }\r\n\r\n  // @function testProp(props: String[]): String|false\r\n  // Goes through the array of style names and returns the first name\r\n  // that is a valid style name for an element. If no such name is found,\r\n  // it returns false. Useful for vendor-prefixed styles like `transform`.\r\n  function testProp(props) {\r\n  \tvar style = document.documentElement.style;\r\n\r\n  \tfor (var i = 0; i < props.length; i++) {\r\n  \t\tif (props[i] in style) {\r\n  \t\t\treturn props[i];\r\n  \t\t}\r\n  \t}\r\n  \treturn false;\r\n  }\r\n\r\n  // @function setTransform(el: HTMLElement, offset: Point, scale?: Number)\r\n  // Resets the 3D CSS transform of `el` so it is translated by `offset` pixels\r\n  // and optionally scaled by `scale`. Does not have an effect if the\r\n  // browser doesn't support 3D CSS transforms.\r\n  function setTransform(el, offset, scale) {\r\n  \tvar pos = offset || new Point(0, 0);\r\n\r\n  \tel.style[TRANSFORM] =\r\n  \t\t(ie3d ?\r\n  \t\t\t'translate(' + pos.x + 'px,' + pos.y + 'px)' :\r\n  \t\t\t'translate3d(' + pos.x + 'px,' + pos.y + 'px,0)') +\r\n  \t\t(scale ? ' scale(' + scale + ')' : '');\r\n  }\r\n\r\n  // @function setPosition(el: HTMLElement, position: Point)\r\n  // Sets the position of `el` to coordinates specified by `position`,\r\n  // using CSS translate or top/left positioning depending on the browser\r\n  // (used by Leaflet internally to position its layers).\r\n  function setPosition(el, point) {\r\n\r\n  \t/*eslint-disable */\r\n  \tel._leaflet_pos = point;\r\n  \t/* eslint-enable */\r\n\r\n  \tif (any3d) {\r\n  \t\tsetTransform(el, point);\r\n  \t} else {\r\n  \t\tel.style.left = point.x + 'px';\r\n  \t\tel.style.top = point.y + 'px';\r\n  \t}\r\n  }\r\n\r\n  // @function getPosition(el: HTMLElement): Point\r\n  // Returns the coordinates of an element previously positioned with setPosition.\r\n  function getPosition(el) {\r\n  \t// this method is only used for elements previously positioned using setPosition,\r\n  \t// so it's safe to cache the position for performance\r\n\r\n  \treturn el._leaflet_pos || new Point(0, 0);\r\n  }\r\n\r\n  // @function disableTextSelection()\r\n  // Prevents the user from generating `selectstart` DOM events, usually generated\r\n  // when the user drags the mouse through a page with text. Used internally\r\n  // by Leaflet to override the behaviour of any click-and-drag interaction on\r\n  // the map. Affects drag interactions on the whole document.\r\n\r\n  // @function enableTextSelection()\r\n  // Cancels the effects of a previous [`L.DomUtil.disableTextSelection`](#domutil-disabletextselection).\r\n  var disableTextSelection;\r\n  var enableTextSelection;\r\n  var _userSelect;\r\n  if ('onselectstart' in document) {\r\n  \tdisableTextSelection = function () {\r\n  \t\ton(window, 'selectstart', preventDefault);\r\n  \t};\r\n  \tenableTextSelection = function () {\r\n  \t\toff(window, 'selectstart', preventDefault);\r\n  \t};\r\n  } else {\r\n  \tvar userSelectProperty = testProp(\r\n  \t\t['userSelect', 'WebkitUserSelect', 'OUserSelect', 'MozUserSelect', 'msUserSelect']);\r\n\r\n  \tdisableTextSelection = function () {\r\n  \t\tif (userSelectProperty) {\r\n  \t\t\tvar style = document.documentElement.style;\r\n  \t\t\t_userSelect = style[userSelectProperty];\r\n  \t\t\tstyle[userSelectProperty] = 'none';\r\n  \t\t}\r\n  \t};\r\n  \tenableTextSelection = function () {\r\n  \t\tif (userSelectProperty) {\r\n  \t\t\tdocument.documentElement.style[userSelectProperty] = _userSelect;\r\n  \t\t\t_userSelect = undefined;\r\n  \t\t}\r\n  \t};\r\n  }\r\n\r\n  // @function disableImageDrag()\r\n  // As [`L.DomUtil.disableTextSelection`](#domutil-disabletextselection), but\r\n  // for `dragstart` DOM events, usually generated when the user drags an image.\r\n  function disableImageDrag() {\r\n  \ton(window, 'dragstart', preventDefault);\r\n  }\r\n\r\n  // @function enableImageDrag()\r\n  // Cancels the effects of a previous [`L.DomUtil.disableImageDrag`](#domutil-disabletextselection).\r\n  function enableImageDrag() {\r\n  \toff(window, 'dragstart', preventDefault);\r\n  }\r\n\r\n  var _outlineElement, _outlineStyle;\r\n  // @function preventOutline(el: HTMLElement)\r\n  // Makes the [outline](https://developer.mozilla.org/docs/Web/CSS/outline)\r\n  // of the element `el` invisible. Used internally by Leaflet to prevent\r\n  // focusable elements from displaying an outline when the user performs a\r\n  // drag interaction on them.\r\n  function preventOutline(element) {\r\n  \twhile (element.tabIndex === -1) {\r\n  \t\telement = element.parentNode;\r\n  \t}\r\n  \tif (!element.style) { return; }\r\n  \trestoreOutline();\r\n  \t_outlineElement = element;\r\n  \t_outlineStyle = element.style.outline;\r\n  \telement.style.outline = 'none';\r\n  \ton(window, 'keydown', restoreOutline);\r\n  }\r\n\r\n  // @function restoreOutline()\r\n  // Cancels the effects of a previous [`L.DomUtil.preventOutline`]().\r\n  function restoreOutline() {\r\n  \tif (!_outlineElement) { return; }\r\n  \t_outlineElement.style.outline = _outlineStyle;\r\n  \t_outlineElement = undefined;\r\n  \t_outlineStyle = undefined;\r\n  \toff(window, 'keydown', restoreOutline);\r\n  }\r\n\r\n  // @function getSizedParentNode(el: HTMLElement): HTMLElement\r\n  // Finds the closest parent node which size (width and height) is not null.\r\n  function getSizedParentNode(element) {\r\n  \tdo {\r\n  \t\telement = element.parentNode;\r\n  \t} while ((!element.offsetWidth || !element.offsetHeight) && element !== document.body);\r\n  \treturn element;\r\n  }\r\n\r\n  // @function getScale(el: HTMLElement): Object\r\n  // Computes the CSS scale currently applied on the element.\r\n  // Returns an object with `x` and `y` members as horizontal and vertical scales respectively,\r\n  // and `boundingClientRect` as the result of [`getBoundingClientRect()`](https://developer.mozilla.org/en-US/docs/Web/API/Element/getBoundingClientRect).\r\n  function getScale(element) {\r\n  \tvar rect = element.getBoundingClientRect(); // Read-only in old browsers.\r\n\r\n  \treturn {\r\n  \t\tx: rect.width / element.offsetWidth || 1,\r\n  \t\ty: rect.height / element.offsetHeight || 1,\r\n  \t\tboundingClientRect: rect\r\n  \t};\r\n  }\n\n  var DomUtil = ({\n    TRANSFORM: TRANSFORM,\n    TRANSITION: TRANSITION,\n    TRANSITION_END: TRANSITION_END,\n    get: get,\n    getStyle: getStyle,\n    create: create$1,\n    remove: remove,\n    empty: empty,\n    toFront: toFront,\n    toBack: toBack,\n    hasClass: hasClass,\n    addClass: addClass,\n    removeClass: removeClass,\n    setClass: setClass,\n    getClass: getClass,\n    setOpacity: setOpacity,\n    testProp: testProp,\n    setTransform: setTransform,\n    setPosition: setPosition,\n    getPosition: getPosition,\n    disableTextSelection: disableTextSelection,\n    enableTextSelection: enableTextSelection,\n    disableImageDrag: disableImageDrag,\n    enableImageDrag: enableImageDrag,\n    preventOutline: preventOutline,\n    restoreOutline: restoreOutline,\n    getSizedParentNode: getSizedParentNode,\n    getScale: getScale\n  });\n\n  /*\r\n   * @namespace DomEvent\r\n   * Utility functions to work with the [DOM events](https://developer.mozilla.org/docs/Web/API/Event), used by Leaflet internally.\r\n   */\r\n\r\n  // Inspired by John Resig, Dean Edwards and YUI addEvent implementations.\r\n\r\n  // @function on(el: HTMLElement, types: String, fn: Function, context?: Object): this\r\n  // Adds a listener function (`fn`) to a particular DOM event type of the\r\n  // element `el`. You can optionally specify the context of the listener\r\n  // (object the `this` keyword will point to). You can also pass several\r\n  // space-separated types (e.g. `'click dblclick'`).\r\n\r\n  // @alternative\r\n  // @function on(el: HTMLElement, eventMap: Object, context?: Object): this\r\n  // Adds a set of type/listener pairs, e.g. `{click: onClick, mousemove: onMouseMove}`\r\n  function on(obj, types, fn, context) {\r\n\r\n  \tif (typeof types === 'object') {\r\n  \t\tfor (var type in types) {\r\n  \t\t\taddOne(obj, type, types[type], fn);\r\n  \t\t}\r\n  \t} else {\r\n  \t\ttypes = splitWords(types);\r\n\r\n  \t\tfor (var i = 0, len = types.length; i < len; i++) {\r\n  \t\t\taddOne(obj, types[i], fn, context);\r\n  \t\t}\r\n  \t}\r\n\r\n  \treturn this;\r\n  }\r\n\r\n  var eventsKey = '_leaflet_events';\r\n\r\n  // @function off(el: HTMLElement, types: String, fn: Function, context?: Object): this\r\n  // Removes a previously added listener function.\r\n  // Note that if you passed a custom context to on, you must pass the same\r\n  // context to `off` in order to remove the listener.\r\n\r\n  // @alternative\r\n  // @function off(el: HTMLElement, eventMap: Object, context?: Object): this\r\n  // Removes a set of type/listener pairs, e.g. `{click: onClick, mousemove: onMouseMove}`\r\n  function off(obj, types, fn, context) {\r\n\r\n  \tif (typeof types === 'object') {\r\n  \t\tfor (var type in types) {\r\n  \t\t\tremoveOne(obj, type, types[type], fn);\r\n  \t\t}\r\n  \t} else if (types) {\r\n  \t\ttypes = splitWords(types);\r\n\r\n  \t\tfor (var i = 0, len = types.length; i < len; i++) {\r\n  \t\t\tremoveOne(obj, types[i], fn, context);\r\n  \t\t}\r\n  \t} else {\r\n  \t\tfor (var j in obj[eventsKey]) {\r\n  \t\t\tremoveOne(obj, j, obj[eventsKey][j]);\r\n  \t\t}\r\n  \t\tdelete obj[eventsKey];\r\n  \t}\r\n\r\n  \treturn this;\r\n  }\r\n\r\n  function browserFiresNativeDblClick() {\r\n  \t// See https://github.com/w3c/pointerevents/issues/171\r\n  \tif (pointer) {\r\n  \t\treturn !(edge || safari);\r\n  \t}\r\n  }\r\n\r\n  var mouseSubst = {\r\n  \tmouseenter: 'mouseover',\r\n  \tmouseleave: 'mouseout',\r\n  \twheel: !('onwheel' in window) && 'mousewheel'\r\n  };\r\n\r\n  function addOne(obj, type, fn, context) {\r\n  \tvar id = type + stamp(fn) + (context ? '_' + stamp(context) : '');\r\n\r\n  \tif (obj[eventsKey] && obj[eventsKey][id]) { return this; }\r\n\r\n  \tvar handler = function (e) {\r\n  \t\treturn fn.call(context || obj, e || window.event);\r\n  \t};\r\n\r\n  \tvar originalHandler = handler;\r\n\r\n  \tif (pointer && type.indexOf('touch') === 0) {\r\n  \t\t// Needs DomEvent.Pointer.js\r\n  \t\taddPointerListener(obj, type, handler, id);\r\n\r\n  \t} else if (touch && (type === 'dblclick') && !browserFiresNativeDblClick()) {\r\n  \t\taddDoubleTapListener(obj, handler, id);\r\n\r\n  \t} else if ('addEventListener' in obj) {\r\n\r\n  \t\tif (type === 'touchstart' || type === 'touchmove' || type === 'wheel' ||  type === 'mousewheel') {\r\n  \t\t\tobj.addEventListener(mouseSubst[type] || type, handler, passiveEvents ? {passive: false} : false);\r\n\r\n  \t\t} else if (type === 'mouseenter' || type === 'mouseleave') {\r\n  \t\t\thandler = function (e) {\r\n  \t\t\t\te = e || window.event;\r\n  \t\t\t\tif (isExternalTarget(obj, e)) {\r\n  \t\t\t\t\toriginalHandler(e);\r\n  \t\t\t\t}\r\n  \t\t\t};\r\n  \t\t\tobj.addEventListener(mouseSubst[type], handler, false);\r\n\r\n  \t\t} else {\r\n  \t\t\tobj.addEventListener(type, originalHandler, false);\r\n  \t\t}\r\n\r\n  \t} else if ('attachEvent' in obj) {\r\n  \t\tobj.attachEvent('on' + type, handler);\r\n  \t}\r\n\r\n  \tobj[eventsKey] = obj[eventsKey] || {};\r\n  \tobj[eventsKey][id] = handler;\r\n  }\r\n\r\n  function removeOne(obj, type, fn, context) {\r\n\r\n  \tvar id = type + stamp(fn) + (context ? '_' + stamp(context) : ''),\r\n  \t    handler = obj[eventsKey] && obj[eventsKey][id];\r\n\r\n  \tif (!handler) { return this; }\r\n\r\n  \tif (pointer && type.indexOf('touch') === 0) {\r\n  \t\tremovePointerListener(obj, type, id);\r\n\r\n  \t} else if (touch && (type === 'dblclick') && !browserFiresNativeDblClick()) {\r\n  \t\tremoveDoubleTapListener(obj, id);\r\n\r\n  \t} else if ('removeEventListener' in obj) {\r\n\r\n  \t\tobj.removeEventListener(mouseSubst[type] || type, handler, false);\r\n\r\n  \t} else if ('detachEvent' in obj) {\r\n  \t\tobj.detachEvent('on' + type, handler);\r\n  \t}\r\n\r\n  \tobj[eventsKey][id] = null;\r\n  }\r\n\r\n  // @function stopPropagation(ev: DOMEvent): this\r\n  // Stop the given event from propagation to parent elements. Used inside the listener functions:\r\n  // ```js\r\n  // L.DomEvent.on(div, 'click', function (ev) {\r\n  // \tL.DomEvent.stopPropagation(ev);\r\n  // });\r\n  // ```\r\n  function stopPropagation(e) {\r\n\r\n  \tif (e.stopPropagation) {\r\n  \t\te.stopPropagation();\r\n  \t} else if (e.originalEvent) {  // In case of Leaflet event.\r\n  \t\te.originalEvent._stopped = true;\r\n  \t} else {\r\n  \t\te.cancelBubble = true;\r\n  \t}\r\n  \tskipped(e);\r\n\r\n  \treturn this;\r\n  }\r\n\r\n  // @function disableScrollPropagation(el: HTMLElement): this\r\n  // Adds `stopPropagation` to the element's `'wheel'` events (plus browser variants).\r\n  function disableScrollPropagation(el) {\r\n  \taddOne(el, 'wheel', stopPropagation);\r\n  \treturn this;\r\n  }\r\n\r\n  // @function disableClickPropagation(el: HTMLElement): this\r\n  // Adds `stopPropagation` to the element's `'click'`, `'doubleclick'`,\r\n  // `'mousedown'` and `'touchstart'` events (plus browser variants).\r\n  function disableClickPropagation(el) {\r\n  \ton(el, 'mousedown touchstart dblclick', stopPropagation);\r\n  \taddOne(el, 'click', fakeStop);\r\n  \treturn this;\r\n  }\r\n\r\n  // @function preventDefault(ev: DOMEvent): this\r\n  // Prevents the default action of the DOM Event `ev` from happening (such as\r\n  // following a link in the href of the a element, or doing a POST request\r\n  // with page reload when a `<form>` is submitted).\r\n  // Use it inside listener functions.\r\n  function preventDefault(e) {\r\n  \tif (e.preventDefault) {\r\n  \t\te.preventDefault();\r\n  \t} else {\r\n  \t\te.returnValue = false;\r\n  \t}\r\n  \treturn this;\r\n  }\r\n\r\n  // @function stop(ev: DOMEvent): this\r\n  // Does `stopPropagation` and `preventDefault` at the same time.\r\n  function stop(e) {\r\n  \tpreventDefault(e);\r\n  \tstopPropagation(e);\r\n  \treturn this;\r\n  }\r\n\r\n  // @function getMousePosition(ev: DOMEvent, container?: HTMLElement): Point\r\n  // Gets normalized mouse position from a DOM event relative to the\r\n  // `container` (border excluded) or to the whole page if not specified.\r\n  function getMousePosition(e, container) {\r\n  \tif (!container) {\r\n  \t\treturn new Point(e.clientX, e.clientY);\r\n  \t}\r\n\r\n  \tvar scale = getScale(container),\r\n  \t    offset = scale.boundingClientRect; // left and top  values are in page scale (like the event clientX/Y)\r\n\r\n  \treturn new Point(\r\n  \t\t// offset.left/top values are in page scale (like clientX/Y),\r\n  \t\t// whereas clientLeft/Top (border width) values are the original values (before CSS scale applies).\r\n  \t\t(e.clientX - offset.left) / scale.x - container.clientLeft,\r\n  \t\t(e.clientY - offset.top) / scale.y - container.clientTop\r\n  \t);\r\n  }\r\n\r\n  // Chrome on Win scrolls double the pixels as in other platforms (see #4538),\r\n  // and Firefox scrolls device pixels, not CSS pixels\r\n  var wheelPxFactor =\r\n  \t(win && chrome) ? 2 * window.devicePixelRatio :\r\n  \tgecko ? window.devicePixelRatio : 1;\r\n\r\n  // @function getWheelDelta(ev: DOMEvent): Number\r\n  // Gets normalized wheel delta from a wheel DOM event, in vertical\r\n  // pixels scrolled (negative if scrolling down).\r\n  // Events from pointing devices without precise scrolling are mapped to\r\n  // a best guess of 60 pixels.\r\n  function getWheelDelta(e) {\r\n  \treturn (edge) ? e.wheelDeltaY / 2 : // Don't trust window-geometry-based delta\r\n  \t       (e.deltaY && e.deltaMode === 0) ? -e.deltaY / wheelPxFactor : // Pixels\r\n  \t       (e.deltaY && e.deltaMode === 1) ? -e.deltaY * 20 : // Lines\r\n  \t       (e.deltaY && e.deltaMode === 2) ? -e.deltaY * 60 : // Pages\r\n  \t       (e.deltaX || e.deltaZ) ? 0 :\t// Skip horizontal/depth wheel events\r\n  \t       e.wheelDelta ? (e.wheelDeltaY || e.wheelDelta) / 2 : // Legacy IE pixels\r\n  \t       (e.detail && Math.abs(e.detail) < 32765) ? -e.detail * 20 : // Legacy Moz lines\r\n  \t       e.detail ? e.detail / -32765 * 60 : // Legacy Moz pages\r\n  \t       0;\r\n  }\r\n\r\n  var skipEvents = {};\r\n\r\n  function fakeStop(e) {\r\n  \t// fakes stopPropagation by setting a special event flag, checked/reset with skipped(e)\r\n  \tskipEvents[e.type] = true;\r\n  }\r\n\r\n  function skipped(e) {\r\n  \tvar events = skipEvents[e.type];\r\n  \t// reset when checking, as it's only used in map container and propagates outside of the map\r\n  \tskipEvents[e.type] = false;\r\n  \treturn events;\r\n  }\r\n\r\n  // check if element really left/entered the event target (for mouseenter/mouseleave)\r\n  function isExternalTarget(el, e) {\r\n\r\n  \tvar related = e.relatedTarget;\r\n\r\n  \tif (!related) { return true; }\r\n\r\n  \ttry {\r\n  \t\twhile (related && (related !== el)) {\r\n  \t\t\trelated = related.parentNode;\r\n  \t\t}\r\n  \t} catch (err) {\r\n  \t\treturn false;\r\n  \t}\r\n  \treturn (related !== el);\r\n  }\n\n  var DomEvent = ({\n    on: on,\n    off: off,\n    stopPropagation: stopPropagation,\n    disableScrollPropagation: disableScrollPropagation,\n    disableClickPropagation: disableClickPropagation,\n    preventDefault: preventDefault,\n    stop: stop,\n    getMousePosition: getMousePosition,\n    getWheelDelta: getWheelDelta,\n    fakeStop: fakeStop,\n    skipped: skipped,\n    isExternalTarget: isExternalTarget,\n    addListener: on,\n    removeListener: off\n  });\n\n  /*\n   * @class PosAnimation\n   * @aka L.PosAnimation\n   * @inherits Evented\n   * Used internally for panning animations, utilizing CSS3 Transitions for modern browsers and a timer fallback for IE6-9.\n   *\n   * @example\n   * ```js\n   * var fx = new L.PosAnimation();\n   * fx.run(el, [300, 500], 0.5);\n   * ```\n   *\n   * @constructor L.PosAnimation()\n   * Creates a `PosAnimation` object.\n   *\n   */\n\n  var PosAnimation = Evented.extend({\n\n  \t// @method run(el: HTMLElement, newPos: Point, duration?: Number, easeLinearity?: Number)\n  \t// Run an animation of a given element to a new position, optionally setting\n  \t// duration in seconds (`0.25` by default) and easing linearity factor (3rd\n  \t// argument of the [cubic bezier curve](http://cubic-bezier.com/#0,0,.5,1),\n  \t// `0.5` by default).\n  \trun: function (el, newPos, duration, easeLinearity) {\n  \t\tthis.stop();\n\n  \t\tthis._el = el;\n  \t\tthis._inProgress = true;\n  \t\tthis._duration = duration || 0.25;\n  \t\tthis._easeOutPower = 1 / Math.max(easeLinearity || 0.5, 0.2);\n\n  \t\tthis._startPos = getPosition(el);\n  \t\tthis._offset = newPos.subtract(this._startPos);\n  \t\tthis._startTime = +new Date();\n\n  \t\t// @event start: Event\n  \t\t// Fired when the animation starts\n  \t\tthis.fire('start');\n\n  \t\tthis._animate();\n  \t},\n\n  \t// @method stop()\n  \t// Stops the animation (if currently running).\n  \tstop: function () {\n  \t\tif (!this._inProgress) { return; }\n\n  \t\tthis._step(true);\n  \t\tthis._complete();\n  \t},\n\n  \t_animate: function () {\n  \t\t// animation loop\n  \t\tthis._animId = requestAnimFrame(this._animate, this);\n  \t\tthis._step();\n  \t},\n\n  \t_step: function (round) {\n  \t\tvar elapsed = (+new Date()) - this._startTime,\n  \t\t    duration = this._duration * 1000;\n\n  \t\tif (elapsed < duration) {\n  \t\t\tthis._runFrame(this._easeOut(elapsed / duration), round);\n  \t\t} else {\n  \t\t\tthis._runFrame(1);\n  \t\t\tthis._complete();\n  \t\t}\n  \t},\n\n  \t_runFrame: function (progress, round) {\n  \t\tvar pos = this._startPos.add(this._offset.multiplyBy(progress));\n  \t\tif (round) {\n  \t\t\tpos._round();\n  \t\t}\n  \t\tsetPosition(this._el, pos);\n\n  \t\t// @event step: Event\n  \t\t// Fired continuously during the animation.\n  \t\tthis.fire('step');\n  \t},\n\n  \t_complete: function () {\n  \t\tcancelAnimFrame(this._animId);\n\n  \t\tthis._inProgress = false;\n  \t\t// @event end: Event\n  \t\t// Fired when the animation ends.\n  \t\tthis.fire('end');\n  \t},\n\n  \t_easeOut: function (t) {\n  \t\treturn 1 - Math.pow(1 - t, this._easeOutPower);\n  \t}\n  });\n\n  /*\r\n   * @class Map\r\n   * @aka L.Map\r\n   * @inherits Evented\r\n   *\r\n   * The central class of the API — it is used to create a map on a page and manipulate it.\r\n   *\r\n   * @example\r\n   *\r\n   * ```js\r\n   * // initialize the map on the \"map\" div with a given center and zoom\r\n   * var map = L.map('map', {\r\n   * \tcenter: [51.505, -0.09],\r\n   * \tzoom: 13\r\n   * });\r\n   * ```\r\n   *\r\n   */\r\n\r\n  var Map = Evented.extend({\r\n\r\n  \toptions: {\r\n  \t\t// @section Map State Options\r\n  \t\t// @option crs: CRS = L.CRS.EPSG3857\r\n  \t\t// The [Coordinate Reference System](#crs) to use. Don't change this if you're not\r\n  \t\t// sure what it means.\r\n  \t\tcrs: EPSG3857,\r\n\r\n  \t\t// @option center: LatLng = undefined\r\n  \t\t// Initial geographic center of the map\r\n  \t\tcenter: undefined,\r\n\r\n  \t\t// @option zoom: Number = undefined\r\n  \t\t// Initial map zoom level\r\n  \t\tzoom: undefined,\r\n\r\n  \t\t// @option minZoom: Number = *\r\n  \t\t// Minimum zoom level of the map.\r\n  \t\t// If not specified and at least one `GridLayer` or `TileLayer` is in the map,\r\n  \t\t// the lowest of their `minZoom` options will be used instead.\r\n  \t\tminZoom: undefined,\r\n\r\n  \t\t// @option maxZoom: Number = *\r\n  \t\t// Maximum zoom level of the map.\r\n  \t\t// If not specified and at least one `GridLayer` or `TileLayer` is in the map,\r\n  \t\t// the highest of their `maxZoom` options will be used instead.\r\n  \t\tmaxZoom: undefined,\r\n\r\n  \t\t// @option layers: Layer[] = []\r\n  \t\t// Array of layers that will be added to the map initially\r\n  \t\tlayers: [],\r\n\r\n  \t\t// @option maxBounds: LatLngBounds = null\r\n  \t\t// When this option is set, the map restricts the view to the given\r\n  \t\t// geographical bounds, bouncing the user back if the user tries to pan\r\n  \t\t// outside the view. To set the restriction dynamically, use\r\n  \t\t// [`setMaxBounds`](#map-setmaxbounds) method.\r\n  \t\tmaxBounds: undefined,\r\n\r\n  \t\t// @option renderer: Renderer = *\r\n  \t\t// The default method for drawing vector layers on the map. `L.SVG`\r\n  \t\t// or `L.Canvas` by default depending on browser support.\r\n  \t\trenderer: undefined,\r\n\r\n\r\n  \t\t// @section Animation Options\r\n  \t\t// @option zoomAnimation: Boolean = true\r\n  \t\t// Whether the map zoom animation is enabled. By default it's enabled\r\n  \t\t// in all browsers that support CSS3 Transitions except Android.\r\n  \t\tzoomAnimation: true,\r\n\r\n  \t\t// @option zoomAnimationThreshold: Number = 4\r\n  \t\t// Won't animate zoom if the zoom difference exceeds this value.\r\n  \t\tzoomAnimationThreshold: 4,\r\n\r\n  \t\t// @option fadeAnimation: Boolean = true\r\n  \t\t// Whether the tile fade animation is enabled. By default it's enabled\r\n  \t\t// in all browsers that support CSS3 Transitions except Android.\r\n  \t\tfadeAnimation: true,\r\n\r\n  \t\t// @option markerZoomAnimation: Boolean = true\r\n  \t\t// Whether markers animate their zoom with the zoom animation, if disabled\r\n  \t\t// they will disappear for the length of the animation. By default it's\r\n  \t\t// enabled in all browsers that support CSS3 Transitions except Android.\r\n  \t\tmarkerZoomAnimation: true,\r\n\r\n  \t\t// @option transform3DLimit: Number = 2^23\r\n  \t\t// Defines the maximum size of a CSS translation transform. The default\r\n  \t\t// value should not be changed unless a web browser positions layers in\r\n  \t\t// the wrong place after doing a large `panBy`.\r\n  \t\ttransform3DLimit: 8388608, // Precision limit of a 32-bit float\r\n\r\n  \t\t// @section Interaction Options\r\n  \t\t// @option zoomSnap: Number = 1\r\n  \t\t// Forces the map's zoom level to always be a multiple of this, particularly\r\n  \t\t// right after a [`fitBounds()`](#map-fitbounds) or a pinch-zoom.\r\n  \t\t// By default, the zoom level snaps to the nearest integer; lower values\r\n  \t\t// (e.g. `0.5` or `0.1`) allow for greater granularity. A value of `0`\r\n  \t\t// means the zoom level will not be snapped after `fitBounds` or a pinch-zoom.\r\n  \t\tzoomSnap: 1,\r\n\r\n  \t\t// @option zoomDelta: Number = 1\r\n  \t\t// Controls how much the map's zoom level will change after a\r\n  \t\t// [`zoomIn()`](#map-zoomin), [`zoomOut()`](#map-zoomout), pressing `+`\r\n  \t\t// or `-` on the keyboard, or using the [zoom controls](#control-zoom).\r\n  \t\t// Values smaller than `1` (e.g. `0.5`) allow for greater granularity.\r\n  \t\tzoomDelta: 1,\r\n\r\n  \t\t// @option trackResize: Boolean = true\r\n  \t\t// Whether the map automatically handles browser window resize to update itself.\r\n  \t\ttrackResize: true\r\n  \t},\r\n\r\n  \tinitialize: function (id, options) { // (HTMLElement or String, Object)\r\n  \t\toptions = setOptions(this, options);\r\n\r\n  \t\t// Make sure to assign internal flags at the beginning,\r\n  \t\t// to avoid inconsistent state in some edge cases.\r\n  \t\tthis._handlers = [];\r\n  \t\tthis._layers = {};\r\n  \t\tthis._zoomBoundLayers = {};\r\n  \t\tthis._sizeChanged = true;\r\n\r\n  \t\tthis._initContainer(id);\r\n  \t\tthis._initLayout();\r\n\r\n  \t\t// hack for https://github.com/Leaflet/Leaflet/issues/1980\r\n  \t\tthis._onResize = bind(this._onResize, this);\r\n\r\n  \t\tthis._initEvents();\r\n\r\n  \t\tif (options.maxBounds) {\r\n  \t\t\tthis.setMaxBounds(options.maxBounds);\r\n  \t\t}\r\n\r\n  \t\tif (options.zoom !== undefined) {\r\n  \t\t\tthis._zoom = this._limitZoom(options.zoom);\r\n  \t\t}\r\n\r\n  \t\tif (options.center && options.zoom !== undefined) {\r\n  \t\t\tthis.setView(toLatLng(options.center), options.zoom, {reset: true});\r\n  \t\t}\r\n\r\n  \t\tthis.callInitHooks();\r\n\r\n  \t\t// don't animate on browsers without hardware-accelerated transitions or old Android/Opera\r\n  \t\tthis._zoomAnimated = TRANSITION && any3d && !mobileOpera &&\r\n  \t\t\t\tthis.options.zoomAnimation;\r\n\r\n  \t\t// zoom transitions run with the same duration for all layers, so if one of transitionend events\r\n  \t\t// happens after starting zoom animation (propagating to the map pane), we know that it ended globally\r\n  \t\tif (this._zoomAnimated) {\r\n  \t\t\tthis._createAnimProxy();\r\n  \t\t\ton(this._proxy, TRANSITION_END, this._catchTransitionEnd, this);\r\n  \t\t}\r\n\r\n  \t\tthis._addLayers(this.options.layers);\r\n  \t},\r\n\r\n\r\n  \t// @section Methods for modifying map state\r\n\r\n  \t// @method setView(center: LatLng, zoom: Number, options?: Zoom/pan options): this\r\n  \t// Sets the view of the map (geographical center and zoom) with the given\r\n  \t// animation options.\r\n  \tsetView: function (center, zoom, options) {\r\n\r\n  \t\tzoom = zoom === undefined ? this._zoom : this._limitZoom(zoom);\r\n  \t\tcenter = this._limitCenter(toLatLng(center), zoom, this.options.maxBounds);\r\n  \t\toptions = options || {};\r\n\r\n  \t\tthis._stop();\r\n\r\n  \t\tif (this._loaded && !options.reset && options !== true) {\r\n\r\n  \t\t\tif (options.animate !== undefined) {\r\n  \t\t\t\toptions.zoom = extend({animate: options.animate}, options.zoom);\r\n  \t\t\t\toptions.pan = extend({animate: options.animate, duration: options.duration}, options.pan);\r\n  \t\t\t}\r\n\r\n  \t\t\t// try animating pan or zoom\r\n  \t\t\tvar moved = (this._zoom !== zoom) ?\r\n  \t\t\t\tthis._tryAnimatedZoom && this._tryAnimatedZoom(center, zoom, options.zoom) :\r\n  \t\t\t\tthis._tryAnimatedPan(center, options.pan);\r\n\r\n  \t\t\tif (moved) {\r\n  \t\t\t\t// prevent resize handler call, the view will refresh after animation anyway\r\n  \t\t\t\tclearTimeout(this._sizeTimer);\r\n  \t\t\t\treturn this;\r\n  \t\t\t}\r\n  \t\t}\r\n\r\n  \t\t// animation didn't start, just reset the map view\r\n  \t\tthis._resetView(center, zoom);\r\n\r\n  \t\treturn this;\r\n  \t},\r\n\r\n  \t// @method setZoom(zoom: Number, options?: Zoom/pan options): this\r\n  \t// Sets the zoom of the map.\r\n  \tsetZoom: function (zoom, options) {\r\n  \t\tif (!this._loaded) {\r\n  \t\t\tthis._zoom = zoom;\r\n  \t\t\treturn this;\r\n  \t\t}\r\n  \t\treturn this.setView(this.getCenter(), zoom, {zoom: options});\r\n  \t},\r\n\r\n  \t// @method zoomIn(delta?: Number, options?: Zoom options): this\r\n  \t// Increases the zoom of the map by `delta` ([`zoomDelta`](#map-zoomdelta) by default).\r\n  \tzoomIn: function (delta, options) {\r\n  \t\tdelta = delta || (any3d ? this.options.zoomDelta : 1);\r\n  \t\treturn this.setZoom(this._zoom + delta, options);\r\n  \t},\r\n\r\n  \t// @method zoomOut(delta?: Number, options?: Zoom options): this\r\n  \t// Decreases the zoom of the map by `delta` ([`zoomDelta`](#map-zoomdelta) by default).\r\n  \tzoomOut: function (delta, options) {\r\n  \t\tdelta = delta || (any3d ? this.options.zoomDelta : 1);\r\n  \t\treturn this.setZoom(this._zoom - delta, options);\r\n  \t},\r\n\r\n  \t// @method setZoomAround(latlng: LatLng, zoom: Number, options: Zoom options): this\r\n  \t// Zooms the map while keeping a specified geographical point on the map\r\n  \t// stationary (e.g. used internally for scroll zoom and double-click zoom).\r\n  \t// @alternative\r\n  \t// @method setZoomAround(offset: Point, zoom: Number, options: Zoom options): this\r\n  \t// Zooms the map while keeping a specified pixel on the map (relative to the top-left corner) stationary.\r\n  \tsetZoomAround: function (latlng, zoom, options) {\r\n  \t\tvar scale = this.getZoomScale(zoom),\r\n  \t\t    viewHalf = this.getSize().divideBy(2),\r\n  \t\t    containerPoint = latlng instanceof Point ? latlng : this.latLngToContainerPoint(latlng),\r\n\r\n  \t\t    centerOffset = containerPoint.subtract(viewHalf).multiplyBy(1 - 1 / scale),\r\n  \t\t    newCenter = this.containerPointToLatLng(viewHalf.add(centerOffset));\r\n\r\n  \t\treturn this.setView(newCenter, zoom, {zoom: options});\r\n  \t},\r\n\r\n  \t_getBoundsCenterZoom: function (bounds, options) {\r\n\r\n  \t\toptions = options || {};\r\n  \t\tbounds = bounds.getBounds ? bounds.getBounds() : toLatLngBounds(bounds);\r\n\r\n  \t\tvar paddingTL = toPoint(options.paddingTopLeft || options.padding || [0, 0]),\r\n  \t\t    paddingBR = toPoint(options.paddingBottomRight || options.padding || [0, 0]),\r\n\r\n  \t\t    zoom = this.getBoundsZoom(bounds, false, paddingTL.add(paddingBR));\r\n\r\n  \t\tzoom = (typeof options.maxZoom === 'number') ? Math.min(options.maxZoom, zoom) : zoom;\r\n\r\n  \t\tif (zoom === Infinity) {\r\n  \t\t\treturn {\r\n  \t\t\t\tcenter: bounds.getCenter(),\r\n  \t\t\t\tzoom: zoom\r\n  \t\t\t};\r\n  \t\t}\r\n\r\n  \t\tvar paddingOffset = paddingBR.subtract(paddingTL).divideBy(2),\r\n\r\n  \t\t    swPoint = this.project(bounds.getSouthWest(), zoom),\r\n  \t\t    nePoint = this.project(bounds.getNorthEast(), zoom),\r\n  \t\t    center = this.unproject(swPoint.add(nePoint).divideBy(2).add(paddingOffset), zoom);\r\n\r\n  \t\treturn {\r\n  \t\t\tcenter: center,\r\n  \t\t\tzoom: zoom\r\n  \t\t};\r\n  \t},\r\n\r\n  \t// @method fitBounds(bounds: LatLngBounds, options?: fitBounds options): this\r\n  \t// Sets a map view that contains the given geographical bounds with the\r\n  \t// maximum zoom level possible.\r\n  \tfitBounds: function (bounds, options) {\r\n\r\n  \t\tbounds = toLatLngBounds(bounds);\r\n\r\n  \t\tif (!bounds.isValid()) {\r\n  \t\t\tthrow new Error('Bounds are not valid.');\r\n  \t\t}\r\n\r\n  \t\tvar target = this._getBoundsCenterZoom(bounds, options);\r\n  \t\treturn this.setView(target.center, target.zoom, options);\r\n  \t},\r\n\r\n  \t// @method fitWorld(options?: fitBounds options): this\r\n  \t// Sets a map view that mostly contains the whole world with the maximum\r\n  \t// zoom level possible.\r\n  \tfitWorld: function (options) {\r\n  \t\treturn this.fitBounds([[-90, -180], [90, 180]], options);\r\n  \t},\r\n\r\n  \t// @method panTo(latlng: LatLng, options?: Pan options): this\r\n  \t// Pans the map to a given center.\r\n  \tpanTo: function (center, options) { // (LatLng)\r\n  \t\treturn this.setView(center, this._zoom, {pan: options});\r\n  \t},\r\n\r\n  \t// @method panBy(offset: Point, options?: Pan options): this\r\n  \t// Pans the map by a given number of pixels (animated).\r\n  \tpanBy: function (offset, options) {\r\n  \t\toffset = toPoint(offset).round();\r\n  \t\toptions = options || {};\r\n\r\n  \t\tif (!offset.x && !offset.y) {\r\n  \t\t\treturn this.fire('moveend');\r\n  \t\t}\r\n  \t\t// If we pan too far, Chrome gets issues with tiles\r\n  \t\t// and makes them disappear or appear in the wrong place (slightly offset) #2602\r\n  \t\tif (options.animate !== true && !this.getSize().contains(offset)) {\r\n  \t\t\tthis._resetView(this.unproject(this.project(this.getCenter()).add(offset)), this.getZoom());\r\n  \t\t\treturn this;\r\n  \t\t}\r\n\r\n  \t\tif (!this._panAnim) {\r\n  \t\t\tthis._panAnim = new PosAnimation();\r\n\r\n  \t\t\tthis._panAnim.on({\r\n  \t\t\t\t'step': this._onPanTransitionStep,\r\n  \t\t\t\t'end': this._onPanTransitionEnd\r\n  \t\t\t}, this);\r\n  \t\t}\r\n\r\n  \t\t// don't fire movestart if animating inertia\r\n  \t\tif (!options.noMoveStart) {\r\n  \t\t\tthis.fire('movestart');\r\n  \t\t}\r\n\r\n  \t\t// animate pan unless animate: false specified\r\n  \t\tif (options.animate !== false) {\r\n  \t\t\taddClass(this._mapPane, 'leaflet-pan-anim');\r\n\r\n  \t\t\tvar newPos = this._getMapPanePos().subtract(offset).round();\r\n  \t\t\tthis._panAnim.run(this._mapPane, newPos, options.duration || 0.25, options.easeLinearity);\r\n  \t\t} else {\r\n  \t\t\tthis._rawPanBy(offset);\r\n  \t\t\tthis.fire('move').fire('moveend');\r\n  \t\t}\r\n\r\n  \t\treturn this;\r\n  \t},\r\n\r\n  \t// @method flyTo(latlng: LatLng, zoom?: Number, options?: Zoom/pan options): this\r\n  \t// Sets the view of the map (geographical center and zoom) performing a smooth\r\n  \t// pan-zoom animation.\r\n  \tflyTo: function (targetCenter, targetZoom, options) {\r\n\r\n  \t\toptions = options || {};\r\n  \t\tif (options.animate === false || !any3d) {\r\n  \t\t\treturn this.setView(targetCenter, targetZoom, options);\r\n  \t\t}\r\n\r\n  \t\tthis._stop();\r\n\r\n  \t\tvar from = this.project(this.getCenter()),\r\n  \t\t    to = this.project(targetCenter),\r\n  \t\t    size = this.getSize(),\r\n  \t\t    startZoom = this._zoom;\r\n\r\n  \t\ttargetCenter = toLatLng(targetCenter);\r\n  \t\ttargetZoom = targetZoom === undefined ? startZoom : targetZoom;\r\n\r\n  \t\tvar w0 = Math.max(size.x, size.y),\r\n  \t\t    w1 = w0 * this.getZoomScale(startZoom, targetZoom),\r\n  \t\t    u1 = (to.distanceTo(from)) || 1,\r\n  \t\t    rho = 1.42,\r\n  \t\t    rho2 = rho * rho;\r\n\r\n  \t\tfunction r(i) {\r\n  \t\t\tvar s1 = i ? -1 : 1,\r\n  \t\t\t    s2 = i ? w1 : w0,\r\n  \t\t\t    t1 = w1 * w1 - w0 * w0 + s1 * rho2 * rho2 * u1 * u1,\r\n  \t\t\t    b1 = 2 * s2 * rho2 * u1,\r\n  \t\t\t    b = t1 / b1,\r\n  \t\t\t    sq = Math.sqrt(b * b + 1) - b;\r\n\r\n  \t\t\t    // workaround for floating point precision bug when sq = 0, log = -Infinite,\r\n  \t\t\t    // thus triggering an infinite loop in flyTo\r\n  \t\t\t    var log = sq < 0.000000001 ? -18 : Math.log(sq);\r\n\r\n  \t\t\treturn log;\r\n  \t\t}\r\n\r\n  \t\tfunction sinh(n) { return (Math.exp(n) - Math.exp(-n)) / 2; }\r\n  \t\tfunction cosh(n) { return (Math.exp(n) + Math.exp(-n)) / 2; }\r\n  \t\tfunction tanh(n) { return sinh(n) / cosh(n); }\r\n\r\n  \t\tvar r0 = r(0);\r\n\r\n  \t\tfunction w(s) { return w0 * (cosh(r0) / cosh(r0 + rho * s)); }\r\n  \t\tfunction u(s) { return w0 * (cosh(r0) * tanh(r0 + rho * s) - sinh(r0)) / rho2; }\r\n\r\n  \t\tfunction easeOut(t) { return 1 - Math.pow(1 - t, 1.5); }\r\n\r\n  \t\tvar start = Date.now(),\r\n  \t\t    S = (r(1) - r0) / rho,\r\n  \t\t    duration = options.duration ? 1000 * options.duration : 1000 * S * 0.8;\r\n\r\n  \t\tfunction frame() {\r\n  \t\t\tvar t = (Date.now() - start) / duration,\r\n  \t\t\t    s = easeOut(t) * S;\r\n\r\n  \t\t\tif (t <= 1) {\r\n  \t\t\t\tthis._flyToFrame = requestAnimFrame(frame, this);\r\n\r\n  \t\t\t\tthis._move(\r\n  \t\t\t\t\tthis.unproject(from.add(to.subtract(from).multiplyBy(u(s) / u1)), startZoom),\r\n  \t\t\t\t\tthis.getScaleZoom(w0 / w(s), startZoom),\r\n  \t\t\t\t\t{flyTo: true});\r\n\r\n  \t\t\t} else {\r\n  \t\t\t\tthis\r\n  \t\t\t\t\t._move(targetCenter, targetZoom)\r\n  \t\t\t\t\t._moveEnd(true);\r\n  \t\t\t}\r\n  \t\t}\r\n\r\n  \t\tthis._moveStart(true, options.noMoveStart);\r\n\r\n  \t\tframe.call(this);\r\n  \t\treturn this;\r\n  \t},\r\n\r\n  \t// @method flyToBounds(bounds: LatLngBounds, options?: fitBounds options): this\r\n  \t// Sets the view of the map with a smooth animation like [`flyTo`](#map-flyto),\r\n  \t// but takes a bounds parameter like [`fitBounds`](#map-fitbounds).\r\n  \tflyToBounds: function (bounds, options) {\r\n  \t\tvar target = this._getBoundsCenterZoom(bounds, options);\r\n  \t\treturn this.flyTo(target.center, target.zoom, options);\r\n  \t},\r\n\r\n  \t// @method setMaxBounds(bounds: LatLngBounds): this\r\n  \t// Restricts the map view to the given bounds (see the [maxBounds](#map-maxbounds) option).\r\n  \tsetMaxBounds: function (bounds) {\r\n  \t\tbounds = toLatLngBounds(bounds);\r\n\r\n  \t\tif (!bounds.isValid()) {\r\n  \t\t\tthis.options.maxBounds = null;\r\n  \t\t\treturn this.off('moveend', this._panInsideMaxBounds);\r\n  \t\t} else if (this.options.maxBounds) {\r\n  \t\t\tthis.off('moveend', this._panInsideMaxBounds);\r\n  \t\t}\r\n\r\n  \t\tthis.options.maxBounds = bounds;\r\n\r\n  \t\tif (this._loaded) {\r\n  \t\t\tthis._panInsideMaxBounds();\r\n  \t\t}\r\n\r\n  \t\treturn this.on('moveend', this._panInsideMaxBounds);\r\n  \t},\r\n\r\n  \t// @method setMinZoom(zoom: Number): this\r\n  \t// Sets the lower limit for the available zoom levels (see the [minZoom](#map-minzoom) option).\r\n  \tsetMinZoom: function (zoom) {\r\n  \t\tvar oldZoom = this.options.minZoom;\r\n  \t\tthis.options.minZoom = zoom;\r\n\r\n  \t\tif (this._loaded && oldZoom !== zoom) {\r\n  \t\t\tthis.fire('zoomlevelschange');\r\n\r\n  \t\t\tif (this.getZoom() < this.options.minZoom) {\r\n  \t\t\t\treturn this.setZoom(zoom);\r\n  \t\t\t}\r\n  \t\t}\r\n\r\n  \t\treturn this;\r\n  \t},\r\n\r\n  \t// @method setMaxZoom(zoom: Number): this\r\n  \t// Sets the upper limit for the available zoom levels (see the [maxZoom](#map-maxzoom) option).\r\n  \tsetMaxZoom: function (zoom) {\r\n  \t\tvar oldZoom = this.options.maxZoom;\r\n  \t\tthis.options.maxZoom = zoom;\r\n\r\n  \t\tif (this._loaded && oldZoom !== zoom) {\r\n  \t\t\tthis.fire('zoomlevelschange');\r\n\r\n  \t\t\tif (this.getZoom() > this.options.maxZoom) {\r\n  \t\t\t\treturn this.setZoom(zoom);\r\n  \t\t\t}\r\n  \t\t}\r\n\r\n  \t\treturn this;\r\n  \t},\r\n\r\n  \t// @method panInsideBounds(bounds: LatLngBounds, options?: Pan options): this\r\n  \t// Pans the map to the closest view that would lie inside the given bounds (if it's not already), controlling the animation using the options specific, if any.\r\n  \tpanInsideBounds: function (bounds, options) {\r\n  \t\tthis._enforcingBounds = true;\r\n  \t\tvar center = this.getCenter(),\r\n  \t\t    newCenter = this._limitCenter(center, this._zoom, toLatLngBounds(bounds));\r\n\r\n  \t\tif (!center.equals(newCenter)) {\r\n  \t\t\tthis.panTo(newCenter, options);\r\n  \t\t}\r\n\r\n  \t\tthis._enforcingBounds = false;\r\n  \t\treturn this;\r\n  \t},\r\n\r\n  \t// @method panInside(latlng: LatLng, options?: options): this\r\n  \t// Pans the map the minimum amount to make the `latlng` visible. Use\r\n  \t// `padding`, `paddingTopLeft` and `paddingTopRight` options to fit\r\n  \t// the display to more restricted bounds, like [`fitBounds`](#map-fitbounds).\r\n  \t// If `latlng` is already within the (optionally padded) display bounds,\r\n  \t// the map will not be panned.\r\n  \tpanInside: function (latlng, options) {\r\n  \t\toptions = options || {};\r\n\r\n  \t\tvar paddingTL = toPoint(options.paddingTopLeft || options.padding || [0, 0]),\r\n  \t\t    paddingBR = toPoint(options.paddingBottomRight || options.padding || [0, 0]),\r\n  \t\t    center = this.getCenter(),\r\n  \t\t    pixelCenter = this.project(center),\r\n  \t\t    pixelPoint = this.project(latlng),\r\n  \t\t    pixelBounds = this.getPixelBounds(),\r\n  \t\t    halfPixelBounds = pixelBounds.getSize().divideBy(2),\r\n  \t\t    paddedBounds = toBounds([pixelBounds.min.add(paddingTL), pixelBounds.max.subtract(paddingBR)]);\r\n\r\n  \t\tif (!paddedBounds.contains(pixelPoint)) {\r\n  \t\t\tthis._enforcingBounds = true;\r\n  \t\t\tvar diff = pixelCenter.subtract(pixelPoint),\r\n  \t\t\t    newCenter = toPoint(pixelPoint.x + diff.x, pixelPoint.y + diff.y);\r\n\r\n  \t\t\tif (pixelPoint.x < paddedBounds.min.x || pixelPoint.x > paddedBounds.max.x) {\r\n  \t\t\t\tnewCenter.x = pixelCenter.x - diff.x;\r\n  \t\t\t\tif (diff.x > 0) {\r\n  \t\t\t\t\tnewCenter.x += halfPixelBounds.x - paddingTL.x;\r\n  \t\t\t\t} else {\r\n  \t\t\t\t\tnewCenter.x -= halfPixelBounds.x - paddingBR.x;\r\n  \t\t\t\t}\r\n  \t\t\t}\r\n  \t\t\tif (pixelPoint.y < paddedBounds.min.y || pixelPoint.y > paddedBounds.max.y) {\r\n  \t\t\t\tnewCenter.y = pixelCenter.y - diff.y;\r\n  \t\t\t\tif (diff.y > 0) {\r\n  \t\t\t\t\tnewCenter.y += halfPixelBounds.y - paddingTL.y;\r\n  \t\t\t\t} else {\r\n  \t\t\t\t\tnewCenter.y -= halfPixelBounds.y - paddingBR.y;\r\n  \t\t\t\t}\r\n  \t\t\t}\r\n  \t\t\tthis.panTo(this.unproject(newCenter), options);\r\n  \t\t\tthis._enforcingBounds = false;\r\n  \t\t}\r\n  \t\treturn this;\r\n  \t},\r\n\r\n  \t// @method invalidateSize(options: Zoom/pan options): this\r\n  \t// Checks if the map container size changed and updates the map if so —\r\n  \t// call it after you've changed the map size dynamically, also animating\r\n  \t// pan by default. If `options.pan` is `false`, panning will not occur.\r\n  \t// If `options.debounceMoveend` is `true`, it will delay `moveend` event so\r\n  \t// that it doesn't happen often even if the method is called many\r\n  \t// times in a row.\r\n\r\n  \t// @alternative\r\n  \t// @method invalidateSize(animate: Boolean): this\r\n  \t// Checks if the map container size changed and updates the map if so —\r\n  \t// call it after you've changed the map size dynamically, also animating\r\n  \t// pan by default.\r\n  \tinvalidateSize: function (options) {\r\n  \t\tif (!this._loaded) { return this; }\r\n\r\n  \t\toptions = extend({\r\n  \t\t\tanimate: false,\r\n  \t\t\tpan: true\r\n  \t\t}, options === true ? {animate: true} : options);\r\n\r\n  \t\tvar oldSize = this.getSize();\r\n  \t\tthis._sizeChanged = true;\r\n  \t\tthis._lastCenter = null;\r\n\r\n  \t\tvar newSize = this.getSize(),\r\n  \t\t    oldCenter = oldSize.divideBy(2).round(),\r\n  \t\t    newCenter = newSize.divideBy(2).round(),\r\n  \t\t    offset = oldCenter.subtract(newCenter);\r\n\r\n  \t\tif (!offset.x && !offset.y) { return this; }\r\n\r\n  \t\tif (options.animate && options.pan) {\r\n  \t\t\tthis.panBy(offset);\r\n\r\n  \t\t} else {\r\n  \t\t\tif (options.pan) {\r\n  \t\t\t\tthis._rawPanBy(offset);\r\n  \t\t\t}\r\n\r\n  \t\t\tthis.fire('move');\r\n\r\n  \t\t\tif (options.debounceMoveend) {\r\n  \t\t\t\tclearTimeout(this._sizeTimer);\r\n  \t\t\t\tthis._sizeTimer = setTimeout(bind(this.fire, this, 'moveend'), 200);\r\n  \t\t\t} else {\r\n  \t\t\t\tthis.fire('moveend');\r\n  \t\t\t}\r\n  \t\t}\r\n\r\n  \t\t// @section Map state change events\r\n  \t\t// @event resize: ResizeEvent\r\n  \t\t// Fired when the map is resized.\r\n  \t\treturn this.fire('resize', {\r\n  \t\t\toldSize: oldSize,\r\n  \t\t\tnewSize: newSize\r\n  \t\t});\r\n  \t},\r\n\r\n  \t// @section Methods for modifying map state\r\n  \t// @method stop(): this\r\n  \t// Stops the currently running `panTo` or `flyTo` animation, if any.\r\n  \tstop: function () {\r\n  \t\tthis.setZoom(this._limitZoom(this._zoom));\r\n  \t\tif (!this.options.zoomSnap) {\r\n  \t\t\tthis.fire('viewreset');\r\n  \t\t}\r\n  \t\treturn this._stop();\r\n  \t},\r\n\r\n  \t// @section Geolocation methods\r\n  \t// @method locate(options?: Locate options): this\r\n  \t// Tries to locate the user using the Geolocation API, firing a [`locationfound`](#map-locationfound)\r\n  \t// event with location data on success or a [`locationerror`](#map-locationerror) event on failure,\r\n  \t// and optionally sets the map view to the user's location with respect to\r\n  \t// detection accuracy (or to the world view if geolocation failed).\r\n  \t// Note that, if your page doesn't use HTTPS, this method will fail in\r\n  \t// modern browsers ([Chrome 50 and newer](https://sites.google.com/a/chromium.org/dev/Home/chromium-security/deprecating-powerful-features-on-insecure-origins))\r\n  \t// See `Locate options` for more details.\r\n  \tlocate: function (options) {\r\n\r\n  \t\toptions = this._locateOptions = extend({\r\n  \t\t\ttimeout: 10000,\r\n  \t\t\twatch: false\r\n  \t\t\t// setView: false\r\n  \t\t\t// maxZoom: <Number>\r\n  \t\t\t// maximumAge: 0\r\n  \t\t\t// enableHighAccuracy: false\r\n  \t\t}, options);\r\n\r\n  \t\tif (!('geolocation' in navigator)) {\r\n  \t\t\tthis._handleGeolocationError({\r\n  \t\t\t\tcode: 0,\r\n  \t\t\t\tmessage: 'Geolocation not supported.'\r\n  \t\t\t});\r\n  \t\t\treturn this;\r\n  \t\t}\r\n\r\n  \t\tvar onResponse = bind(this._handleGeolocationResponse, this),\r\n  \t\t    onError = bind(this._handleGeolocationError, this);\r\n\r\n  \t\tif (options.watch) {\r\n  \t\t\tthis._locationWatchId =\r\n  \t\t\t        navigator.geolocation.watchPosition(onResponse, onError, options);\r\n  \t\t} else {\r\n  \t\t\tnavigator.geolocation.getCurrentPosition(onResponse, onError, options);\r\n  \t\t}\r\n  \t\treturn this;\r\n  \t},\r\n\r\n  \t// @method stopLocate(): this\r\n  \t// Stops watching location previously initiated by `map.locate({watch: true})`\r\n  \t// and aborts resetting the map view if map.locate was called with\r\n  \t// `{setView: true}`.\r\n  \tstopLocate: function () {\r\n  \t\tif (navigator.geolocation && navigator.geolocation.clearWatch) {\r\n  \t\t\tnavigator.geolocation.clearWatch(this._locationWatchId);\r\n  \t\t}\r\n  \t\tif (this._locateOptions) {\r\n  \t\t\tthis._locateOptions.setView = false;\r\n  \t\t}\r\n  \t\treturn this;\r\n  \t},\r\n\r\n  \t_handleGeolocationError: function (error) {\r\n  \t\tvar c = error.code,\r\n  \t\t    message = error.message ||\r\n  \t\t            (c === 1 ? 'permission denied' :\r\n  \t\t            (c === 2 ? 'position unavailable' : 'timeout'));\r\n\r\n  \t\tif (this._locateOptions.setView && !this._loaded) {\r\n  \t\t\tthis.fitWorld();\r\n  \t\t}\r\n\r\n  \t\t// @section Location events\r\n  \t\t// @event locationerror: ErrorEvent\r\n  \t\t// Fired when geolocation (using the [`locate`](#map-locate) method) failed.\r\n  \t\tthis.fire('locationerror', {\r\n  \t\t\tcode: c,\r\n  \t\t\tmessage: 'Geolocation error: ' + message + '.'\r\n  \t\t});\r\n  \t},\r\n\r\n  \t_handleGeolocationResponse: function (pos) {\r\n  \t\tvar lat = pos.coords.latitude,\r\n  \t\t    lng = pos.coords.longitude,\r\n  \t\t    latlng = new LatLng(lat, lng),\r\n  \t\t    bounds = latlng.toBounds(pos.coords.accuracy * 2),\r\n  \t\t    options = this._locateOptions;\r\n\r\n  \t\tif (options.setView) {\r\n  \t\t\tvar zoom = this.getBoundsZoom(bounds);\r\n  \t\t\tthis.setView(latlng, options.maxZoom ? Math.min(zoom, options.maxZoom) : zoom);\r\n  \t\t}\r\n\r\n  \t\tvar data = {\r\n  \t\t\tlatlng: latlng,\r\n  \t\t\tbounds: bounds,\r\n  \t\t\ttimestamp: pos.timestamp\r\n  \t\t};\r\n\r\n  \t\tfor (var i in pos.coords) {\r\n  \t\t\tif (typeof pos.coords[i] === 'number') {\r\n  \t\t\t\tdata[i] = pos.coords[i];\r\n  \t\t\t}\r\n  \t\t}\r\n\r\n  \t\t// @event locationfound: LocationEvent\r\n  \t\t// Fired when geolocation (using the [`locate`](#map-locate) method)\r\n  \t\t// went successfully.\r\n  \t\tthis.fire('locationfound', data);\r\n  \t},\r\n\r\n  \t// TODO Appropriate docs section?\r\n  \t// @section Other Methods\r\n  \t// @method addHandler(name: String, HandlerClass: Function): this\r\n  \t// Adds a new `Handler` to the map, given its name and constructor function.\r\n  \taddHandler: function (name, HandlerClass) {\r\n  \t\tif (!HandlerClass) { return this; }\r\n\r\n  \t\tvar handler = this[name] = new HandlerClass(this);\r\n\r\n  \t\tthis._handlers.push(handler);\r\n\r\n  \t\tif (this.options[name]) {\r\n  \t\t\thandler.enable();\r\n  \t\t}\r\n\r\n  \t\treturn this;\r\n  \t},\r\n\r\n  \t// @method remove(): this\r\n  \t// Destroys the map and clears all related event listeners.\r\n  \tremove: function () {\r\n\r\n  \t\tthis._initEvents(true);\r\n  \t\tthis.off('moveend', this._panInsideMaxBounds);\r\n\r\n  \t\tif (this._containerId !== this._container._leaflet_id) {\r\n  \t\t\tthrow new Error('Map container is being reused by another instance');\r\n  \t\t}\r\n\r\n  \t\ttry {\r\n  \t\t\t// throws error in IE6-8\r\n  \t\t\tdelete this._container._leaflet_id;\r\n  \t\t\tdelete this._containerId;\r\n  \t\t} catch (e) {\r\n  \t\t\t/*eslint-disable */\r\n  \t\t\tthis._container._leaflet_id = undefined;\r\n  \t\t\t/* eslint-enable */\r\n  \t\t\tthis._containerId = undefined;\r\n  \t\t}\r\n\r\n  \t\tif (this._locationWatchId !== undefined) {\r\n  \t\t\tthis.stopLocate();\r\n  \t\t}\r\n\r\n  \t\tthis._stop();\r\n\r\n  \t\tremove(this._mapPane);\r\n\r\n  \t\tif (this._clearControlPos) {\r\n  \t\t\tthis._clearControlPos();\r\n  \t\t}\r\n  \t\tif (this._resizeRequest) {\r\n  \t\t\tcancelAnimFrame(this._resizeRequest);\r\n  \t\t\tthis._resizeRequest = null;\r\n  \t\t}\r\n\r\n  \t\tthis._clearHandlers();\r\n\r\n  \t\tif (this._loaded) {\r\n  \t\t\t// @section Map state change events\r\n  \t\t\t// @event unload: Event\r\n  \t\t\t// Fired when the map is destroyed with [remove](#map-remove) method.\r\n  \t\t\tthis.fire('unload');\r\n  \t\t}\r\n\r\n  \t\tvar i;\r\n  \t\tfor (i in this._layers) {\r\n  \t\t\tthis._layers[i].remove();\r\n  \t\t}\r\n  \t\tfor (i in this._panes) {\r\n  \t\t\tremove(this._panes[i]);\r\n  \t\t}\r\n\r\n  \t\tthis._layers = [];\r\n  \t\tthis._panes = [];\r\n  \t\tdelete this._mapPane;\r\n  \t\tdelete this._renderer;\r\n\r\n  \t\treturn this;\r\n  \t},\r\n\r\n  \t// @section Other Methods\r\n  \t// @method createPane(name: String, container?: HTMLElement): HTMLElement\r\n  \t// Creates a new [map pane](#map-pane) with the given name if it doesn't exist already,\r\n  \t// then returns it. The pane is created as a child of `container`, or\r\n  \t// as a child of the main map pane if not set.\r\n  \tcreatePane: function (name, container) {\r\n  \t\tvar className = 'leaflet-pane' + (name ? ' leaflet-' + name.replace('Pane', '') + '-pane' : ''),\r\n  \t\t    pane = create$1('div', className, container || this._mapPane);\r\n\r\n  \t\tif (name) {\r\n  \t\t\tthis._panes[name] = pane;\r\n  \t\t}\r\n  \t\treturn pane;\r\n  \t},\r\n\r\n  \t// @section Methods for Getting Map State\r\n\r\n  \t// @method getCenter(): LatLng\r\n  \t// Returns the geographical center of the map view\r\n  \tgetCenter: function () {\r\n  \t\tthis._checkIfLoaded();\r\n\r\n  \t\tif (this._lastCenter && !this._moved()) {\r\n  \t\t\treturn this._lastCenter;\r\n  \t\t}\r\n  \t\treturn this.layerPointToLatLng(this._getCenterLayerPoint());\r\n  \t},\r\n\r\n  \t// @method getZoom(): Number\r\n  \t// Returns the current zoom level of the map view\r\n  \tgetZoom: function () {\r\n  \t\treturn this._zoom;\r\n  \t},\r\n\r\n  \t// @method getBounds(): LatLngBounds\r\n  \t// Returns the geographical bounds visible in the current map view\r\n  \tgetBounds: function () {\r\n  \t\tvar bounds = this.getPixelBounds(),\r\n  \t\t    sw = this.unproject(bounds.getBottomLeft()),\r\n  \t\t    ne = this.unproject(bounds.getTopRight());\r\n\r\n  \t\treturn new LatLngBounds(sw, ne);\r\n  \t},\r\n\r\n  \t// @method getMinZoom(): Number\r\n  \t// Returns the minimum zoom level of the map (if set in the `minZoom` option of the map or of any layers), or `0` by default.\r\n  \tgetMinZoom: function () {\r\n  \t\treturn this.options.minZoom === undefined ? this._layersMinZoom || 0 : this.options.minZoom;\r\n  \t},\r\n\r\n  \t// @method getMaxZoom(): Number\r\n  \t// Returns the maximum zoom level of the map (if set in the `maxZoom` option of the map or of any layers).\r\n  \tgetMaxZoom: function () {\r\n  \t\treturn this.options.maxZoom === undefined ?\r\n  \t\t\t(this._layersMaxZoom === undefined ? Infinity : this._layersMaxZoom) :\r\n  \t\t\tthis.options.maxZoom;\r\n  \t},\r\n\r\n  \t// @method getBoundsZoom(bounds: LatLngBounds, inside?: Boolean, padding?: Point): Number\r\n  \t// Returns the maximum zoom level on which the given bounds fit to the map\r\n  \t// view in its entirety. If `inside` (optional) is set to `true`, the method\r\n  \t// instead returns the minimum zoom level on which the map view fits into\r\n  \t// the given bounds in its entirety.\r\n  \tgetBoundsZoom: function (bounds, inside, padding) { // (LatLngBounds[, Boolean, Point]) -> Number\r\n  \t\tbounds = toLatLngBounds(bounds);\r\n  \t\tpadding = toPoint(padding || [0, 0]);\r\n\r\n  \t\tvar zoom = this.getZoom() || 0,\r\n  \t\t    min = this.getMinZoom(),\r\n  \t\t    max = this.getMaxZoom(),\r\n  \t\t    nw = bounds.getNorthWest(),\r\n  \t\t    se = bounds.getSouthEast(),\r\n  \t\t    size = this.getSize().subtract(padding),\r\n  \t\t    boundsSize = toBounds(this.project(se, zoom), this.project(nw, zoom)).getSize(),\r\n  \t\t    snap = any3d ? this.options.zoomSnap : 1,\r\n  \t\t    scalex = size.x / boundsSize.x,\r\n  \t\t    scaley = size.y / boundsSize.y,\r\n  \t\t    scale = inside ? Math.max(scalex, scaley) : Math.min(scalex, scaley);\r\n\r\n  \t\tzoom = this.getScaleZoom(scale, zoom);\r\n\r\n  \t\tif (snap) {\r\n  \t\t\tzoom = Math.round(zoom / (snap / 100)) * (snap / 100); // don't jump if within 1% of a snap level\r\n  \t\t\tzoom = inside ? Math.ceil(zoom / snap) * snap : Math.floor(zoom / snap) * snap;\r\n  \t\t}\r\n\r\n  \t\treturn Math.max(min, Math.min(max, zoom));\r\n  \t},\r\n\r\n  \t// @method getSize(): Point\r\n  \t// Returns the current size of the map container (in pixels).\r\n  \tgetSize: function () {\r\n  \t\tif (!this._size || this._sizeChanged) {\r\n  \t\t\tthis._size = new Point(\r\n  \t\t\t\tthis._container.clientWidth || 0,\r\n  \t\t\t\tthis._container.clientHeight || 0);\r\n\r\n  \t\t\tthis._sizeChanged = false;\r\n  \t\t}\r\n  \t\treturn this._size.clone();\r\n  \t},\r\n\r\n  \t// @method getPixelBounds(): Bounds\r\n  \t// Returns the bounds of the current map view in projected pixel\r\n  \t// coordinates (sometimes useful in layer and overlay implementations).\r\n  \tgetPixelBounds: function (center, zoom) {\r\n  \t\tvar topLeftPoint = this._getTopLeftPoint(center, zoom);\r\n  \t\treturn new Bounds(topLeftPoint, topLeftPoint.add(this.getSize()));\r\n  \t},\r\n\r\n  \t// TODO: Check semantics - isn't the pixel origin the 0,0 coord relative to\r\n  \t// the map pane? \"left point of the map layer\" can be confusing, specially\r\n  \t// since there can be negative offsets.\r\n  \t// @method getPixelOrigin(): Point\r\n  \t// Returns the projected pixel coordinates of the top left point of\r\n  \t// the map layer (useful in custom layer and overlay implementations).\r\n  \tgetPixelOrigin: function () {\r\n  \t\tthis._checkIfLoaded();\r\n  \t\treturn this._pixelOrigin;\r\n  \t},\r\n\r\n  \t// @method getPixelWorldBounds(zoom?: Number): Bounds\r\n  \t// Returns the world's bounds in pixel coordinates for zoom level `zoom`.\r\n  \t// If `zoom` is omitted, the map's current zoom level is used.\r\n  \tgetPixelWorldBounds: function (zoom) {\r\n  \t\treturn this.options.crs.getProjectedBounds(zoom === undefined ? this.getZoom() : zoom);\r\n  \t},\r\n\r\n  \t// @section Other Methods\r\n\r\n  \t// @method getPane(pane: String|HTMLElement): HTMLElement\r\n  \t// Returns a [map pane](#map-pane), given its name or its HTML element (its identity).\r\n  \tgetPane: function (pane) {\r\n  \t\treturn typeof pane === 'string' ? this._panes[pane] : pane;\r\n  \t},\r\n\r\n  \t// @method getPanes(): Object\r\n  \t// Returns a plain object containing the names of all [panes](#map-pane) as keys and\r\n  \t// the panes as values.\r\n  \tgetPanes: function () {\r\n  \t\treturn this._panes;\r\n  \t},\r\n\r\n  \t// @method getContainer: HTMLElement\r\n  \t// Returns the HTML element that contains the map.\r\n  \tgetContainer: function () {\r\n  \t\treturn this._container;\r\n  \t},\r\n\r\n\r\n  \t// @section Conversion Methods\r\n\r\n  \t// @method getZoomScale(toZoom: Number, fromZoom: Number): Number\r\n  \t// Returns the scale factor to be applied to a map transition from zoom level\r\n  \t// `fromZoom` to `toZoom`. Used internally to help with zoom animations.\r\n  \tgetZoomScale: function (toZoom, fromZoom) {\r\n  \t\t// TODO replace with universal implementation after refactoring projections\r\n  \t\tvar crs = this.options.crs;\r\n  \t\tfromZoom = fromZoom === undefined ? this._zoom : fromZoom;\r\n  \t\treturn crs.scale(toZoom) / crs.scale(fromZoom);\r\n  \t},\r\n\r\n  \t// @method getScaleZoom(scale: Number, fromZoom: Number): Number\r\n  \t// Returns the zoom level that the map would end up at, if it is at `fromZoom`\r\n  \t// level and everything is scaled by a factor of `scale`. Inverse of\r\n  \t// [`getZoomScale`](#map-getZoomScale).\r\n  \tgetScaleZoom: function (scale, fromZoom) {\r\n  \t\tvar crs = this.options.crs;\r\n  \t\tfromZoom = fromZoom === undefined ? this._zoom : fromZoom;\r\n  \t\tvar zoom = crs.zoom(scale * crs.scale(fromZoom));\r\n  \t\treturn isNaN(zoom) ? Infinity : zoom;\r\n  \t},\r\n\r\n  \t// @method project(latlng: LatLng, zoom: Number): Point\r\n  \t// Projects a geographical coordinate `LatLng` according to the projection\r\n  \t// of the map's CRS, then scales it according to `zoom` and the CRS's\r\n  \t// `Transformation`. The result is pixel coordinate relative to\r\n  \t// the CRS origin.\r\n  \tproject: function (latlng, zoom) {\r\n  \t\tzoom = zoom === undefined ? this._zoom : zoom;\r\n  \t\treturn this.options.crs.latLngToPoint(toLatLng(latlng), zoom);\r\n  \t},\r\n\r\n  \t// @method unproject(point: Point, zoom: Number): LatLng\r\n  \t// Inverse of [`project`](#map-project).\r\n  \tunproject: function (point, zoom) {\r\n  \t\tzoom = zoom === undefined ? this._zoom : zoom;\r\n  \t\treturn this.options.crs.pointToLatLng(toPoint(point), zoom);\r\n  \t},\r\n\r\n  \t// @method layerPointToLatLng(point: Point): LatLng\r\n  \t// Given a pixel coordinate relative to the [origin pixel](#map-getpixelorigin),\r\n  \t// returns the corresponding geographical coordinate (for the current zoom level).\r\n  \tlayerPointToLatLng: function (point) {\r\n  \t\tvar projectedPoint = toPoint(point).add(this.getPixelOrigin());\r\n  \t\treturn this.unproject(projectedPoint);\r\n  \t},\r\n\r\n  \t// @method latLngToLayerPoint(latlng: LatLng): Point\r\n  \t// Given a geographical coordinate, returns the corresponding pixel coordinate\r\n  \t// relative to the [origin pixel](#map-getpixelorigin).\r\n  \tlatLngToLayerPoint: function (latlng) {\r\n  \t\tvar projectedPoint = this.project(toLatLng(latlng))._round();\r\n  \t\treturn projectedPoint._subtract(this.getPixelOrigin());\r\n  \t},\r\n\r\n  \t// @method wrapLatLng(latlng: LatLng): LatLng\r\n  \t// Returns a `LatLng` where `lat` and `lng` has been wrapped according to the\r\n  \t// map's CRS's `wrapLat` and `wrapLng` properties, if they are outside the\r\n  \t// CRS's bounds.\r\n  \t// By default this means longitude is wrapped around the dateline so its\r\n  \t// value is between -180 and +180 degrees.\r\n  \twrapLatLng: function (latlng) {\r\n  \t\treturn this.options.crs.wrapLatLng(toLatLng(latlng));\r\n  \t},\r\n\r\n  \t// @method wrapLatLngBounds(bounds: LatLngBounds): LatLngBounds\r\n  \t// Returns a `LatLngBounds` with the same size as the given one, ensuring that\r\n  \t// its center is within the CRS's bounds.\r\n  \t// By default this means the center longitude is wrapped around the dateline so its\r\n  \t// value is between -180 and +180 degrees, and the majority of the bounds\r\n  \t// overlaps the CRS's bounds.\r\n  \twrapLatLngBounds: function (latlng) {\r\n  \t\treturn this.options.crs.wrapLatLngBounds(toLatLngBounds(latlng));\r\n  \t},\r\n\r\n  \t// @method distance(latlng1: LatLng, latlng2: LatLng): Number\r\n  \t// Returns the distance between two geographical coordinates according to\r\n  \t// the map's CRS. By default this measures distance in meters.\r\n  \tdistance: function (latlng1, latlng2) {\r\n  \t\treturn this.options.crs.distance(toLatLng(latlng1), toLatLng(latlng2));\r\n  \t},\r\n\r\n  \t// @method containerPointToLayerPoint(point: Point): Point\r\n  \t// Given a pixel coordinate relative to the map container, returns the corresponding\r\n  \t// pixel coordinate relative to the [origin pixel](#map-getpixelorigin).\r\n  \tcontainerPointToLayerPoint: function (point) { // (Point)\r\n  \t\treturn toPoint(point).subtract(this._getMapPanePos());\r\n  \t},\r\n\r\n  \t// @method layerPointToContainerPoint(point: Point): Point\r\n  \t// Given a pixel coordinate relative to the [origin pixel](#map-getpixelorigin),\r\n  \t// returns the corresponding pixel coordinate relative to the map container.\r\n  \tlayerPointToContainerPoint: function (point) { // (Point)\r\n  \t\treturn toPoint(point).add(this._getMapPanePos());\r\n  \t},\r\n\r\n  \t// @method containerPointToLatLng(point: Point): LatLng\r\n  \t// Given a pixel coordinate relative to the map container, returns\r\n  \t// the corresponding geographical coordinate (for the current zoom level).\r\n  \tcontainerPointToLatLng: function (point) {\r\n  \t\tvar layerPoint = this.containerPointToLayerPoint(toPoint(point));\r\n  \t\treturn this.layerPointToLatLng(layerPoint);\r\n  \t},\r\n\r\n  \t// @method latLngToContainerPoint(latlng: LatLng): Point\r\n  \t// Given a geographical coordinate, returns the corresponding pixel coordinate\r\n  \t// relative to the map container.\r\n  \tlatLngToContainerPoint: function (latlng) {\r\n  \t\treturn this.layerPointToContainerPoint(this.latLngToLayerPoint(toLatLng(latlng)));\r\n  \t},\r\n\r\n  \t// @method mouseEventToContainerPoint(ev: MouseEvent): Point\r\n  \t// Given a MouseEvent object, returns the pixel coordinate relative to the\r\n  \t// map container where the event took place.\r\n  \tmouseEventToContainerPoint: function (e) {\r\n  \t\treturn getMousePosition(e, this._container);\r\n  \t},\r\n\r\n  \t// @method mouseEventToLayerPoint(ev: MouseEvent): Point\r\n  \t// Given a MouseEvent object, returns the pixel coordinate relative to\r\n  \t// the [origin pixel](#map-getpixelorigin) where the event took place.\r\n  \tmouseEventToLayerPoint: function (e) {\r\n  \t\treturn this.containerPointToLayerPoint(this.mouseEventToContainerPoint(e));\r\n  \t},\r\n\r\n  \t// @method mouseEventToLatLng(ev: MouseEvent): LatLng\r\n  \t// Given a MouseEvent object, returns geographical coordinate where the\r\n  \t// event took place.\r\n  \tmouseEventToLatLng: function (e) { // (MouseEvent)\r\n  \t\treturn this.layerPointToLatLng(this.mouseEventToLayerPoint(e));\r\n  \t},\r\n\r\n\r\n  \t// map initialization methods\r\n\r\n  \t_initContainer: function (id) {\r\n  \t\tvar container = this._container = get(id);\r\n\r\n  \t\tif (!container) {\r\n  \t\t\tthrow new Error('Map container not found.');\r\n  \t\t} else if (container._leaflet_id) {\r\n  \t\t\tthrow new Error('Map container is already initialized.');\r\n  \t\t}\r\n\r\n  \t\ton(container, 'scroll', this._onScroll, this);\r\n  \t\tthis._containerId = stamp(container);\r\n  \t},\r\n\r\n  \t_initLayout: function () {\r\n  \t\tvar container = this._container;\r\n\r\n  \t\tthis._fadeAnimated = this.options.fadeAnimation && any3d;\r\n\r\n  \t\taddClass(container, 'leaflet-container' +\r\n  \t\t\t(touch ? ' leaflet-touch' : '') +\r\n  \t\t\t(retina ? ' leaflet-retina' : '') +\r\n  \t\t\t(ielt9 ? ' leaflet-oldie' : '') +\r\n  \t\t\t(safari ? ' leaflet-safari' : '') +\r\n  \t\t\t(this._fadeAnimated ? ' leaflet-fade-anim' : ''));\r\n\r\n  \t\tvar position = getStyle(container, 'position');\r\n\r\n  \t\tif (position !== 'absolute' && position !== 'relative' && position !== 'fixed') {\r\n  \t\t\tcontainer.style.position = 'relative';\r\n  \t\t}\r\n\r\n  \t\tthis._initPanes();\r\n\r\n  \t\tif (this._initControlPos) {\r\n  \t\t\tthis._initControlPos();\r\n  \t\t}\r\n  \t},\r\n\r\n  \t_initPanes: function () {\r\n  \t\tvar panes = this._panes = {};\r\n  \t\tthis._paneRenderers = {};\r\n\r\n  \t\t// @section\r\n  \t\t//\r\n  \t\t// Panes are DOM elements used to control the ordering of layers on the map. You\r\n  \t\t// can access panes with [`map.getPane`](#map-getpane) or\r\n  \t\t// [`map.getPanes`](#map-getpanes) methods. New panes can be created with the\r\n  \t\t// [`map.createPane`](#map-createpane) method.\r\n  \t\t//\r\n  \t\t// Every map has the following default panes that differ only in zIndex.\r\n  \t\t//\r\n  \t\t// @pane mapPane: HTMLElement = 'auto'\r\n  \t\t// Pane that contains all other map panes\r\n\r\n  \t\tthis._mapPane = this.createPane('mapPane', this._container);\r\n  \t\tsetPosition(this._mapPane, new Point(0, 0));\r\n\r\n  \t\t// @pane tilePane: HTMLElement = 200\r\n  \t\t// Pane for `GridLayer`s and `TileLayer`s\r\n  \t\tthis.createPane('tilePane');\r\n  \t\t// @pane overlayPane: HTMLElement = 400\r\n  \t\t// Pane for overlay shadows (e.g. `Marker` shadows)\r\n  \t\tthis.createPane('shadowPane');\r\n  \t\t// @pane shadowPane: HTMLElement = 500\r\n  \t\t// Pane for vectors (`Path`s, like `Polyline`s and `Polygon`s), `ImageOverlay`s and `VideoOverlay`s\r\n  \t\tthis.createPane('overlayPane');\r\n  \t\t// @pane markerPane: HTMLElement = 600\r\n  \t\t// Pane for `Icon`s of `Marker`s\r\n  \t\tthis.createPane('markerPane');\r\n  \t\t// @pane tooltipPane: HTMLElement = 650\r\n  \t\t// Pane for `Tooltip`s.\r\n  \t\tthis.createPane('tooltipPane');\r\n  \t\t// @pane popupPane: HTMLElement = 700\r\n  \t\t// Pane for `Popup`s.\r\n  \t\tthis.createPane('popupPane');\r\n\r\n  \t\tif (!this.options.markerZoomAnimation) {\r\n  \t\t\taddClass(panes.markerPane, 'leaflet-zoom-hide');\r\n  \t\t\taddClass(panes.shadowPane, 'leaflet-zoom-hide');\r\n  \t\t}\r\n  \t},\r\n\r\n\r\n  \t// private methods that modify map state\r\n\r\n  \t// @section Map state change events\r\n  \t_resetView: function (center, zoom) {\r\n  \t\tsetPosition(this._mapPane, new Point(0, 0));\r\n\r\n  \t\tvar loading = !this._loaded;\r\n  \t\tthis._loaded = true;\r\n  \t\tzoom = this._limitZoom(zoom);\r\n\r\n  \t\tthis.fire('viewprereset');\r\n\r\n  \t\tvar zoomChanged = this._zoom !== zoom;\r\n  \t\tthis\r\n  \t\t\t._moveStart(zoomChanged, false)\r\n  \t\t\t._move(center, zoom)\r\n  \t\t\t._moveEnd(zoomChanged);\r\n\r\n  \t\t// @event viewreset: Event\r\n  \t\t// Fired when the map needs to redraw its content (this usually happens\r\n  \t\t// on map zoom or load). Very useful for creating custom overlays.\r\n  \t\tthis.fire('viewreset');\r\n\r\n  \t\t// @event load: Event\r\n  \t\t// Fired when the map is initialized (when its center and zoom are set\r\n  \t\t// for the first time).\r\n  \t\tif (loading) {\r\n  \t\t\tthis.fire('load');\r\n  \t\t}\r\n  \t},\r\n\r\n  \t_moveStart: function (zoomChanged, noMoveStart) {\r\n  \t\t// @event zoomstart: Event\r\n  \t\t// Fired when the map zoom is about to change (e.g. before zoom animation).\r\n  \t\t// @event movestart: Event\r\n  \t\t// Fired when the view of the map starts changing (e.g. user starts dragging the map).\r\n  \t\tif (zoomChanged) {\r\n  \t\t\tthis.fire('zoomstart');\r\n  \t\t}\r\n  \t\tif (!noMoveStart) {\r\n  \t\t\tthis.fire('movestart');\r\n  \t\t}\r\n  \t\treturn this;\r\n  \t},\r\n\r\n  \t_move: function (center, zoom, data) {\r\n  \t\tif (zoom === undefined) {\r\n  \t\t\tzoom = this._zoom;\r\n  \t\t}\r\n  \t\tvar zoomChanged = this._zoom !== zoom;\r\n\r\n  \t\tthis._zoom = zoom;\r\n  \t\tthis._lastCenter = center;\r\n  \t\tthis._pixelOrigin = this._getNewPixelOrigin(center);\r\n\r\n  \t\t// @event zoom: Event\r\n  \t\t// Fired repeatedly during any change in zoom level, including zoom\r\n  \t\t// and fly animations.\r\n  \t\tif (zoomChanged || (data && data.pinch)) {\t// Always fire 'zoom' if pinching because #3530\r\n  \t\t\tthis.fire('zoom', data);\r\n  \t\t}\r\n\r\n  \t\t// @event move: Event\r\n  \t\t// Fired repeatedly during any movement of the map, including pan and\r\n  \t\t// fly animations.\r\n  \t\treturn this.fire('move', data);\r\n  \t},\r\n\r\n  \t_moveEnd: function (zoomChanged) {\r\n  \t\t// @event zoomend: Event\r\n  \t\t// Fired when the map has changed, after any animations.\r\n  \t\tif (zoomChanged) {\r\n  \t\t\tthis.fire('zoomend');\r\n  \t\t}\r\n\r\n  \t\t// @event moveend: Event\r\n  \t\t// Fired when the center of the map stops changing (e.g. user stopped\r\n  \t\t// dragging the map).\r\n  \t\treturn this.fire('moveend');\r\n  \t},\r\n\r\n  \t_stop: function () {\r\n  \t\tcancelAnimFrame(this._flyToFrame);\r\n  \t\tif (this._panAnim) {\r\n  \t\t\tthis._panAnim.stop();\r\n  \t\t}\r\n  \t\treturn this;\r\n  \t},\r\n\r\n  \t_rawPanBy: function (offset) {\r\n  \t\tsetPosition(this._mapPane, this._getMapPanePos().subtract(offset));\r\n  \t},\r\n\r\n  \t_getZoomSpan: function () {\r\n  \t\treturn this.getMaxZoom() - this.getMinZoom();\r\n  \t},\r\n\r\n  \t_panInsideMaxBounds: function () {\r\n  \t\tif (!this._enforcingBounds) {\r\n  \t\t\tthis.panInsideBounds(this.options.maxBounds);\r\n  \t\t}\r\n  \t},\r\n\r\n  \t_checkIfLoaded: function () {\r\n  \t\tif (!this._loaded) {\r\n  \t\t\tthrow new Error('Set map center and zoom first.');\r\n  \t\t}\r\n  \t},\r\n\r\n  \t// DOM event handling\r\n\r\n  \t// @section Interaction events\r\n  \t_initEvents: function (remove$$1) {\r\n  \t\tthis._targets = {};\r\n  \t\tthis._targets[stamp(this._container)] = this;\r\n\r\n  \t\tvar onOff = remove$$1 ? off : on;\r\n\r\n  \t\t// @event click: MouseEvent\r\n  \t\t// Fired when the user clicks (or taps) the map.\r\n  \t\t// @event dblclick: MouseEvent\r\n  \t\t// Fired when the user double-clicks (or double-taps) the map.\r\n  \t\t// @event mousedown: MouseEvent\r\n  \t\t// Fired when the user pushes the mouse button on the map.\r\n  \t\t// @event mouseup: MouseEvent\r\n  \t\t// Fired when the user releases the mouse button on the map.\r\n  \t\t// @event mouseover: MouseEvent\r\n  \t\t// Fired when the mouse enters the map.\r\n  \t\t// @event mouseout: MouseEvent\r\n  \t\t// Fired when the mouse leaves the map.\r\n  \t\t// @event mousemove: MouseEvent\r\n  \t\t// Fired while the mouse moves over the map.\r\n  \t\t// @event contextmenu: MouseEvent\r\n  \t\t// Fired when the user pushes the right mouse button on the map, prevents\r\n  \t\t// default browser context menu from showing if there are listeners on\r\n  \t\t// this event. Also fired on mobile when the user holds a single touch\r\n  \t\t// for a second (also called long press).\r\n  \t\t// @event keypress: KeyboardEvent\r\n  \t\t// Fired when the user presses a key from the keyboard that produces a character value while the map is focused.\r\n  \t\t// @event keydown: KeyboardEvent\r\n  \t\t// Fired when the user presses a key from the keyboard while the map is focused. Unlike the `keypress` event,\r\n  \t\t// the `keydown` event is fired for keys that produce a character value and for keys\r\n  \t\t// that do not produce a character value.\r\n  \t\t// @event keyup: KeyboardEvent\r\n  \t\t// Fired when the user releases a key from the keyboard while the map is focused.\r\n  \t\tonOff(this._container, 'click dblclick mousedown mouseup ' +\r\n  \t\t\t'mouseover mouseout mousemove contextmenu keypress keydown keyup', this._handleDOMEvent, this);\r\n\r\n  \t\tif (this.options.trackResize) {\r\n  \t\t\tonOff(window, 'resize', this._onResize, this);\r\n  \t\t}\r\n\r\n  \t\tif (any3d && this.options.transform3DLimit) {\r\n  \t\t\t(remove$$1 ? this.off : this.on).call(this, 'moveend', this._onMoveEnd);\r\n  \t\t}\r\n  \t},\r\n\r\n  \t_onResize: function () {\r\n  \t\tcancelAnimFrame(this._resizeRequest);\r\n  \t\tthis._resizeRequest = requestAnimFrame(\r\n  \t\t        function () { this.invalidateSize({debounceMoveend: true}); }, this);\r\n  \t},\r\n\r\n  \t_onScroll: function () {\r\n  \t\tthis._container.scrollTop  = 0;\r\n  \t\tthis._container.scrollLeft = 0;\r\n  \t},\r\n\r\n  \t_onMoveEnd: function () {\r\n  \t\tvar pos = this._getMapPanePos();\r\n  \t\tif (Math.max(Math.abs(pos.x), Math.abs(pos.y)) >= this.options.transform3DLimit) {\r\n  \t\t\t// https://bugzilla.mozilla.org/show_bug.cgi?id=1203873 but Webkit also have\r\n  \t\t\t// a pixel offset on very high values, see: http://jsfiddle.net/dg6r5hhb/\r\n  \t\t\tthis._resetView(this.getCenter(), this.getZoom());\r\n  \t\t}\r\n  \t},\r\n\r\n  \t_findEventTargets: function (e, type) {\r\n  \t\tvar targets = [],\r\n  \t\t    target,\r\n  \t\t    isHover = type === 'mouseout' || type === 'mouseover',\r\n  \t\t    src = e.target || e.srcElement,\r\n  \t\t    dragging = false;\r\n\r\n  \t\twhile (src) {\r\n  \t\t\ttarget = this._targets[stamp(src)];\r\n  \t\t\tif (target && (type === 'click' || type === 'preclick') && !e._simulated && this._draggableMoved(target)) {\r\n  \t\t\t\t// Prevent firing click after you just dragged an object.\r\n  \t\t\t\tdragging = true;\r\n  \t\t\t\tbreak;\r\n  \t\t\t}\r\n  \t\t\tif (target && target.listens(type, true)) {\r\n  \t\t\t\tif (isHover && !isExternalTarget(src, e)) { break; }\r\n  \t\t\t\ttargets.push(target);\r\n  \t\t\t\tif (isHover) { break; }\r\n  \t\t\t}\r\n  \t\t\tif (src === this._container) { break; }\r\n  \t\t\tsrc = src.parentNode;\r\n  \t\t}\r\n  \t\tif (!targets.length && !dragging && !isHover && isExternalTarget(src, e)) {\r\n  \t\t\ttargets = [this];\r\n  \t\t}\r\n  \t\treturn targets;\r\n  \t},\r\n\r\n  \t_handleDOMEvent: function (e) {\r\n  \t\tif (!this._loaded || skipped(e)) { return; }\r\n\r\n  \t\tvar type = e.type;\r\n\r\n  \t\tif (type === 'mousedown' || type === 'keypress' || type === 'keyup' || type === 'keydown') {\r\n  \t\t\t// prevents outline when clicking on keyboard-focusable element\r\n  \t\t\tpreventOutline(e.target || e.srcElement);\r\n  \t\t}\r\n\r\n  \t\tthis._fireDOMEvent(e, type);\r\n  \t},\r\n\r\n  \t_mouseEvents: ['click', 'dblclick', 'mouseover', 'mouseout', 'contextmenu'],\r\n\r\n  \t_fireDOMEvent: function (e, type, targets) {\r\n\r\n  \t\tif (e.type === 'click') {\r\n  \t\t\t// Fire a synthetic 'preclick' event which propagates up (mainly for closing popups).\r\n  \t\t\t// @event preclick: MouseEvent\r\n  \t\t\t// Fired before mouse click on the map (sometimes useful when you\r\n  \t\t\t// want something to happen on click before any existing click\r\n  \t\t\t// handlers start running).\r\n  \t\t\tvar synth = extend({}, e);\r\n  \t\t\tsynth.type = 'preclick';\r\n  \t\t\tthis._fireDOMEvent(synth, synth.type, targets);\r\n  \t\t}\r\n\r\n  \t\tif (e._stopped) { return; }\r\n\r\n  \t\t// Find the layer the event is propagating from and its parents.\r\n  \t\ttargets = (targets || []).concat(this._findEventTargets(e, type));\r\n\r\n  \t\tif (!targets.length) { return; }\r\n\r\n  \t\tvar target = targets[0];\r\n  \t\tif (type === 'contextmenu' && target.listens(type, true)) {\r\n  \t\t\tpreventDefault(e);\r\n  \t\t}\r\n\r\n  \t\tvar data = {\r\n  \t\t\toriginalEvent: e\r\n  \t\t};\r\n\r\n  \t\tif (e.type !== 'keypress' && e.type !== 'keydown' && e.type !== 'keyup') {\r\n  \t\t\tvar isMarker = target.getLatLng && (!target._radius || target._radius <= 10);\r\n  \t\t\tdata.containerPoint = isMarker ?\r\n  \t\t\t\tthis.latLngToContainerPoint(target.getLatLng()) : this.mouseEventToContainerPoint(e);\r\n  \t\t\tdata.layerPoint = this.containerPointToLayerPoint(data.containerPoint);\r\n  \t\t\tdata.latlng = isMarker ? target.getLatLng() : this.layerPointToLatLng(data.layerPoint);\r\n  \t\t}\r\n\r\n  \t\tfor (var i = 0; i < targets.length; i++) {\r\n  \t\t\ttargets[i].fire(type, data, true);\r\n  \t\t\tif (data.originalEvent._stopped ||\r\n  \t\t\t\t(targets[i].options.bubblingMouseEvents === false && indexOf(this._mouseEvents, type) !== -1)) { return; }\r\n  \t\t}\r\n  \t},\r\n\r\n  \t_draggableMoved: function (obj) {\r\n  \t\tobj = obj.dragging && obj.dragging.enabled() ? obj : this;\r\n  \t\treturn (obj.dragging && obj.dragging.moved()) || (this.boxZoom && this.boxZoom.moved());\r\n  \t},\r\n\r\n  \t_clearHandlers: function () {\r\n  \t\tfor (var i = 0, len = this._handlers.length; i < len; i++) {\r\n  \t\t\tthis._handlers[i].disable();\r\n  \t\t}\r\n  \t},\r\n\r\n  \t// @section Other Methods\r\n\r\n  \t// @method whenReady(fn: Function, context?: Object): this\r\n  \t// Runs the given function `fn` when the map gets initialized with\r\n  \t// a view (center and zoom) and at least one layer, or immediately\r\n  \t// if it's already initialized, optionally passing a function context.\r\n  \twhenReady: function (callback, context) {\r\n  \t\tif (this._loaded) {\r\n  \t\t\tcallback.call(context || this, {target: this});\r\n  \t\t} else {\r\n  \t\t\tthis.on('load', callback, context);\r\n  \t\t}\r\n  \t\treturn this;\r\n  \t},\r\n\r\n\r\n  \t// private methods for getting map state\r\n\r\n  \t_getMapPanePos: function () {\r\n  \t\treturn getPosition(this._mapPane) || new Point(0, 0);\r\n  \t},\r\n\r\n  \t_moved: function () {\r\n  \t\tvar pos = this._getMapPanePos();\r\n  \t\treturn pos && !pos.equals([0, 0]);\r\n  \t},\r\n\r\n  \t_getTopLeftPoint: function (center, zoom) {\r\n  \t\tvar pixelOrigin = center && zoom !== undefined ?\r\n  \t\t\tthis._getNewPixelOrigin(center, zoom) :\r\n  \t\t\tthis.getPixelOrigin();\r\n  \t\treturn pixelOrigin.subtract(this._getMapPanePos());\r\n  \t},\r\n\r\n  \t_getNewPixelOrigin: function (center, zoom) {\r\n  \t\tvar viewHalf = this.getSize()._divideBy(2);\r\n  \t\treturn this.project(center, zoom)._subtract(viewHalf)._add(this._getMapPanePos())._round();\r\n  \t},\r\n\r\n  \t_latLngToNewLayerPoint: function (latlng, zoom, center) {\r\n  \t\tvar topLeft = this._getNewPixelOrigin(center, zoom);\r\n  \t\treturn this.project(latlng, zoom)._subtract(topLeft);\r\n  \t},\r\n\r\n  \t_latLngBoundsToNewLayerBounds: function (latLngBounds, zoom, center) {\r\n  \t\tvar topLeft = this._getNewPixelOrigin(center, zoom);\r\n  \t\treturn toBounds([\r\n  \t\t\tthis.project(latLngBounds.getSouthWest(), zoom)._subtract(topLeft),\r\n  \t\t\tthis.project(latLngBounds.getNorthWest(), zoom)._subtract(topLeft),\r\n  \t\t\tthis.project(latLngBounds.getSouthEast(), zoom)._subtract(topLeft),\r\n  \t\t\tthis.project(latLngBounds.getNorthEast(), zoom)._subtract(topLeft)\r\n  \t\t]);\r\n  \t},\r\n\r\n  \t// layer point of the current center\r\n  \t_getCenterLayerPoint: function () {\r\n  \t\treturn this.containerPointToLayerPoint(this.getSize()._divideBy(2));\r\n  \t},\r\n\r\n  \t// offset of the specified place to the current center in pixels\r\n  \t_getCenterOffset: function (latlng) {\r\n  \t\treturn this.latLngToLayerPoint(latlng).subtract(this._getCenterLayerPoint());\r\n  \t},\r\n\r\n  \t// adjust center for view to get inside bounds\r\n  \t_limitCenter: function (center, zoom, bounds) {\r\n\r\n  \t\tif (!bounds) { return center; }\r\n\r\n  \t\tvar centerPoint = this.project(center, zoom),\r\n  \t\t    viewHalf = this.getSize().divideBy(2),\r\n  \t\t    viewBounds = new Bounds(centerPoint.subtract(viewHalf), centerPoint.add(viewHalf)),\r\n  \t\t    offset = this._getBoundsOffset(viewBounds, bounds, zoom);\r\n\r\n  \t\t// If offset is less than a pixel, ignore.\r\n  \t\t// This prevents unstable projections from getting into\r\n  \t\t// an infinite loop of tiny offsets.\r\n  \t\tif (offset.round().equals([0, 0])) {\r\n  \t\t\treturn center;\r\n  \t\t}\r\n\r\n  \t\treturn this.unproject(centerPoint.add(offset), zoom);\r\n  \t},\r\n\r\n  \t// adjust offset for view to get inside bounds\r\n  \t_limitOffset: function (offset, bounds) {\r\n  \t\tif (!bounds) { return offset; }\r\n\r\n  \t\tvar viewBounds = this.getPixelBounds(),\r\n  \t\t    newBounds = new Bounds(viewBounds.min.add(offset), viewBounds.max.add(offset));\r\n\r\n  \t\treturn offset.add(this._getBoundsOffset(newBounds, bounds));\r\n  \t},\r\n\r\n  \t// returns offset needed for pxBounds to get inside maxBounds at a specified zoom\r\n  \t_getBoundsOffset: function (pxBounds, maxBounds, zoom) {\r\n  \t\tvar projectedMaxBounds = toBounds(\r\n  \t\t        this.project(maxBounds.getNorthEast(), zoom),\r\n  \t\t        this.project(maxBounds.getSouthWest(), zoom)\r\n  \t\t    ),\r\n  \t\t    minOffset = projectedMaxBounds.min.subtract(pxBounds.min),\r\n  \t\t    maxOffset = projectedMaxBounds.max.subtract(pxBounds.max),\r\n\r\n  \t\t    dx = this._rebound(minOffset.x, -maxOffset.x),\r\n  \t\t    dy = this._rebound(minOffset.y, -maxOffset.y);\r\n\r\n  \t\treturn new Point(dx, dy);\r\n  \t},\r\n\r\n  \t_rebound: function (left, right) {\r\n  \t\treturn left + right > 0 ?\r\n  \t\t\tMath.round(left - right) / 2 :\r\n  \t\t\tMath.max(0, Math.ceil(left)) - Math.max(0, Math.floor(right));\r\n  \t},\r\n\r\n  \t_limitZoom: function (zoom) {\r\n  \t\tvar min = this.getMinZoom(),\r\n  \t\t    max = this.getMaxZoom(),\r\n  \t\t    snap = any3d ? this.options.zoomSnap : 1;\r\n  \t\tif (snap) {\r\n  \t\t\tzoom = Math.round(zoom / snap) * snap;\r\n  \t\t}\r\n  \t\treturn Math.max(min, Math.min(max, zoom));\r\n  \t},\r\n\r\n  \t_onPanTransitionStep: function () {\r\n  \t\tthis.fire('move');\r\n  \t},\r\n\r\n  \t_onPanTransitionEnd: function () {\r\n  \t\tremoveClass(this._mapPane, 'leaflet-pan-anim');\r\n  \t\tthis.fire('moveend');\r\n  \t},\r\n\r\n  \t_tryAnimatedPan: function (center, options) {\r\n  \t\t// difference between the new and current centers in pixels\r\n  \t\tvar offset = this._getCenterOffset(center)._trunc();\r\n\r\n  \t\t// don't animate too far unless animate: true specified in options\r\n  \t\tif ((options && options.animate) !== true && !this.getSize().contains(offset)) { return false; }\r\n\r\n  \t\tthis.panBy(offset, options);\r\n\r\n  \t\treturn true;\r\n  \t},\r\n\r\n  \t_createAnimProxy: function () {\r\n\r\n  \t\tvar proxy = this._proxy = create$1('div', 'leaflet-proxy leaflet-zoom-animated');\r\n  \t\tthis._panes.mapPane.appendChild(proxy);\r\n\r\n  \t\tthis.on('zoomanim', function (e) {\r\n  \t\t\tvar prop = TRANSFORM,\r\n  \t\t\t    transform = this._proxy.style[prop];\r\n\r\n  \t\t\tsetTransform(this._proxy, this.project(e.center, e.zoom), this.getZoomScale(e.zoom, 1));\r\n\r\n  \t\t\t// workaround for case when transform is the same and so transitionend event is not fired\r\n  \t\t\tif (transform === this._proxy.style[prop] && this._animatingZoom) {\r\n  \t\t\t\tthis._onZoomTransitionEnd();\r\n  \t\t\t}\r\n  \t\t}, this);\r\n\r\n  \t\tthis.on('load moveend', this._animMoveEnd, this);\r\n\r\n  \t\tthis._on('unload', this._destroyAnimProxy, this);\r\n  \t},\r\n\r\n  \t_destroyAnimProxy: function () {\r\n  \t\tremove(this._proxy);\r\n  \t\tthis.off('load moveend', this._animMoveEnd, this);\r\n  \t\tdelete this._proxy;\r\n  \t},\r\n\r\n  \t_animMoveEnd: function () {\r\n  \t\tvar c = this.getCenter(),\r\n  \t\t    z = this.getZoom();\r\n  \t\tsetTransform(this._proxy, this.project(c, z), this.getZoomScale(z, 1));\r\n  \t},\r\n\r\n  \t_catchTransitionEnd: function (e) {\r\n  \t\tif (this._animatingZoom && e.propertyName.indexOf('transform') >= 0) {\r\n  \t\t\tthis._onZoomTransitionEnd();\r\n  \t\t}\r\n  \t},\r\n\r\n  \t_nothingToAnimate: function () {\r\n  \t\treturn !this._container.getElementsByClassName('leaflet-zoom-animated').length;\r\n  \t},\r\n\r\n  \t_tryAnimatedZoom: function (center, zoom, options) {\r\n\r\n  \t\tif (this._animatingZoom) { return true; }\r\n\r\n  \t\toptions = options || {};\r\n\r\n  \t\t// don't animate if disabled, not supported or zoom difference is too large\r\n  \t\tif (!this._zoomAnimated || options.animate === false || this._nothingToAnimate() ||\r\n  \t\t        Math.abs(zoom - this._zoom) > this.options.zoomAnimationThreshold) { return false; }\r\n\r\n  \t\t// offset is the pixel coords of the zoom origin relative to the current center\r\n  \t\tvar scale = this.getZoomScale(zoom),\r\n  \t\t    offset = this._getCenterOffset(center)._divideBy(1 - 1 / scale);\r\n\r\n  \t\t// don't animate if the zoom origin isn't within one screen from the current center, unless forced\r\n  \t\tif (options.animate !== true && !this.getSize().contains(offset)) { return false; }\r\n\r\n  \t\trequestAnimFrame(function () {\r\n  \t\t\tthis\r\n  \t\t\t    ._moveStart(true, false)\r\n  \t\t\t    ._animateZoom(center, zoom, true);\r\n  \t\t}, this);\r\n\r\n  \t\treturn true;\r\n  \t},\r\n\r\n  \t_animateZoom: function (center, zoom, startAnim, noUpdate) {\r\n  \t\tif (!this._mapPane) { return; }\r\n\r\n  \t\tif (startAnim) {\r\n  \t\t\tthis._animatingZoom = true;\r\n\r\n  \t\t\t// remember what center/zoom to set after animation\r\n  \t\t\tthis._animateToCenter = center;\r\n  \t\t\tthis._animateToZoom = zoom;\r\n\r\n  \t\t\taddClass(this._mapPane, 'leaflet-zoom-anim');\r\n  \t\t}\r\n\r\n  \t\t// @section Other Events\r\n  \t\t// @event zoomanim: ZoomAnimEvent\r\n  \t\t// Fired at least once per zoom animation. For continuous zoom, like pinch zooming, fired once per frame during zoom.\r\n  \t\tthis.fire('zoomanim', {\r\n  \t\t\tcenter: center,\r\n  \t\t\tzoom: zoom,\r\n  \t\t\tnoUpdate: noUpdate\r\n  \t\t});\r\n\r\n  \t\t// Work around webkit not firing 'transitionend', see https://github.com/Leaflet/Leaflet/issues/3689, 2693\r\n  \t\tsetTimeout(bind(this._onZoomTransitionEnd, this), 250);\r\n  \t},\r\n\r\n  \t_onZoomTransitionEnd: function () {\r\n  \t\tif (!this._animatingZoom) { return; }\r\n\r\n  \t\tif (this._mapPane) {\r\n  \t\t\tremoveClass(this._mapPane, 'leaflet-zoom-anim');\r\n  \t\t}\r\n\r\n  \t\tthis._animatingZoom = false;\r\n\r\n  \t\tthis._move(this._animateToCenter, this._animateToZoom);\r\n\r\n  \t\t// This anim frame should prevent an obscure iOS webkit tile loading race condition.\r\n  \t\trequestAnimFrame(function () {\r\n  \t\t\tthis._moveEnd(true);\r\n  \t\t}, this);\r\n  \t}\r\n  });\r\n\r\n  // @section\r\n\r\n  // @factory L.map(id: String, options?: Map options)\r\n  // Instantiates a map object given the DOM ID of a `<div>` element\r\n  // and optionally an object literal with `Map options`.\r\n  //\r\n  // @alternative\r\n  // @factory L.map(el: HTMLElement, options?: Map options)\r\n  // Instantiates a map object given an instance of a `<div>` HTML element\r\n  // and optionally an object literal with `Map options`.\r\n  function createMap(id, options) {\r\n  \treturn new Map(id, options);\r\n  }\n\n  /*\r\n   * @class Control\r\n   * @aka L.Control\r\n   * @inherits Class\r\n   *\r\n   * L.Control is a base class for implementing map controls. Handles positioning.\r\n   * All other controls extend from this class.\r\n   */\r\n\r\n  var Control = Class.extend({\r\n  \t// @section\r\n  \t// @aka Control options\r\n  \toptions: {\r\n  \t\t// @option position: String = 'topright'\r\n  \t\t// The position of the control (one of the map corners). Possible values are `'topleft'`,\r\n  \t\t// `'topright'`, `'bottomleft'` or `'bottomright'`\r\n  \t\tposition: 'topright'\r\n  \t},\r\n\r\n  \tinitialize: function (options) {\r\n  \t\tsetOptions(this, options);\r\n  \t},\r\n\r\n  \t/* @section\r\n  \t * Classes extending L.Control will inherit the following methods:\r\n  \t *\r\n  \t * @method getPosition: string\r\n  \t * Returns the position of the control.\r\n  \t */\r\n  \tgetPosition: function () {\r\n  \t\treturn this.options.position;\r\n  \t},\r\n\r\n  \t// @method setPosition(position: string): this\r\n  \t// Sets the position of the control.\r\n  \tsetPosition: function (position) {\r\n  \t\tvar map = this._map;\r\n\r\n  \t\tif (map) {\r\n  \t\t\tmap.removeControl(this);\r\n  \t\t}\r\n\r\n  \t\tthis.options.position = position;\r\n\r\n  \t\tif (map) {\r\n  \t\t\tmap.addControl(this);\r\n  \t\t}\r\n\r\n  \t\treturn this;\r\n  \t},\r\n\r\n  \t// @method getContainer: HTMLElement\r\n  \t// Returns the HTMLElement that contains the control.\r\n  \tgetContainer: function () {\r\n  \t\treturn this._container;\r\n  \t},\r\n\r\n  \t// @method addTo(map: Map): this\r\n  \t// Adds the control to the given map.\r\n  \taddTo: function (map) {\r\n  \t\tthis.remove();\r\n  \t\tthis._map = map;\r\n\r\n  \t\tvar container = this._container = this.onAdd(map),\r\n  \t\t    pos = this.getPosition(),\r\n  \t\t    corner = map._controlCorners[pos];\r\n\r\n  \t\taddClass(container, 'leaflet-control');\r\n\r\n  \t\tif (pos.indexOf('bottom') !== -1) {\r\n  \t\t\tcorner.insertBefore(container, corner.firstChild);\r\n  \t\t} else {\r\n  \t\t\tcorner.appendChild(container);\r\n  \t\t}\r\n\r\n  \t\tthis._map.on('unload', this.remove, this);\r\n\r\n  \t\treturn this;\r\n  \t},\r\n\r\n  \t// @method remove: this\r\n  \t// Removes the control from the map it is currently active on.\r\n  \tremove: function () {\r\n  \t\tif (!this._map) {\r\n  \t\t\treturn this;\r\n  \t\t}\r\n\r\n  \t\tremove(this._container);\r\n\r\n  \t\tif (this.onRemove) {\r\n  \t\t\tthis.onRemove(this._map);\r\n  \t\t}\r\n\r\n  \t\tthis._map.off('unload', this.remove, this);\r\n  \t\tthis._map = null;\r\n\r\n  \t\treturn this;\r\n  \t},\r\n\r\n  \t_refocusOnMap: function (e) {\r\n  \t\t// if map exists and event is not a keyboard event\r\n  \t\tif (this._map && e && e.screenX > 0 && e.screenY > 0) {\r\n  \t\t\tthis._map.getContainer().focus();\r\n  \t\t}\r\n  \t}\r\n  });\r\n\r\n  var control = function (options) {\r\n  \treturn new Control(options);\r\n  };\r\n\r\n  /* @section Extension methods\r\n   * @uninheritable\r\n   *\r\n   * Every control should extend from `L.Control` and (re-)implement the following methods.\r\n   *\r\n   * @method onAdd(map: Map): HTMLElement\r\n   * Should return the container DOM element for the control and add listeners on relevant map events. Called on [`control.addTo(map)`](#control-addTo).\r\n   *\r\n   * @method onRemove(map: Map)\r\n   * Optional method. Should contain all clean up code that removes the listeners previously added in [`onAdd`](#control-onadd). Called on [`control.remove()`](#control-remove).\r\n   */\r\n\r\n  /* @namespace Map\r\n   * @section Methods for Layers and Controls\r\n   */\r\n  Map.include({\r\n  \t// @method addControl(control: Control): this\r\n  \t// Adds the given control to the map\r\n  \taddControl: function (control) {\r\n  \t\tcontrol.addTo(this);\r\n  \t\treturn this;\r\n  \t},\r\n\r\n  \t// @method removeControl(control: Control): this\r\n  \t// Removes the given control from the map\r\n  \tremoveControl: function (control) {\r\n  \t\tcontrol.remove();\r\n  \t\treturn this;\r\n  \t},\r\n\r\n  \t_initControlPos: function () {\r\n  \t\tvar corners = this._controlCorners = {},\r\n  \t\t    l = 'leaflet-',\r\n  \t\t    container = this._controlContainer =\r\n  \t\t            create$1('div', l + 'control-container', this._container);\r\n\r\n  \t\tfunction createCorner(vSide, hSide) {\r\n  \t\t\tvar className = l + vSide + ' ' + l + hSide;\r\n\r\n  \t\t\tcorners[vSide + hSide] = create$1('div', className, container);\r\n  \t\t}\r\n\r\n  \t\tcreateCorner('top', 'left');\r\n  \t\tcreateCorner('top', 'right');\r\n  \t\tcreateCorner('bottom', 'left');\r\n  \t\tcreateCorner('bottom', 'right');\r\n  \t},\r\n\r\n  \t_clearControlPos: function () {\r\n  \t\tfor (var i in this._controlCorners) {\r\n  \t\t\tremove(this._controlCorners[i]);\r\n  \t\t}\r\n  \t\tremove(this._controlContainer);\r\n  \t\tdelete this._controlCorners;\r\n  \t\tdelete this._controlContainer;\r\n  \t}\r\n  });\n\n  /*\r\n   * @class Control.Layers\r\n   * @aka L.Control.Layers\r\n   * @inherits Control\r\n   *\r\n   * The layers control gives users the ability to switch between different base layers and switch overlays on/off (check out the [detailed example](http://leafletjs.com/examples/layers-control/)). Extends `Control`.\r\n   *\r\n   * @example\r\n   *\r\n   * ```js\r\n   * var baseLayers = {\r\n   * \t\"Mapbox\": mapbox,\r\n   * \t\"OpenStreetMap\": osm\r\n   * };\r\n   *\r\n   * var overlays = {\r\n   * \t\"Marker\": marker,\r\n   * \t\"Roads\": roadsLayer\r\n   * };\r\n   *\r\n   * L.control.layers(baseLayers, overlays).addTo(map);\r\n   * ```\r\n   *\r\n   * The `baseLayers` and `overlays` parameters are object literals with layer names as keys and `Layer` objects as values:\r\n   *\r\n   * ```js\r\n   * {\r\n   *     \"<someName1>\": layer1,\r\n   *     \"<someName2>\": layer2\r\n   * }\r\n   * ```\r\n   *\r\n   * The layer names can contain HTML, which allows you to add additional styling to the items:\r\n   *\r\n   * ```js\r\n   * {\"<img src='my-layer-icon' /> <span class='my-layer-item'>My Layer</span>\": myLayer}\r\n   * ```\r\n   */\r\n\r\n  var Layers = Control.extend({\r\n  \t// @section\r\n  \t// @aka Control.Layers options\r\n  \toptions: {\r\n  \t\t// @option collapsed: Boolean = true\r\n  \t\t// If `true`, the control will be collapsed into an icon and expanded on mouse hover or touch.\r\n  \t\tcollapsed: true,\r\n  \t\tposition: 'topright',\r\n\r\n  \t\t// @option autoZIndex: Boolean = true\r\n  \t\t// If `true`, the control will assign zIndexes in increasing order to all of its layers so that the order is preserved when switching them on/off.\r\n  \t\tautoZIndex: true,\r\n\r\n  \t\t// @option hideSingleBase: Boolean = false\r\n  \t\t// If `true`, the base layers in the control will be hidden when there is only one.\r\n  \t\thideSingleBase: false,\r\n\r\n  \t\t// @option sortLayers: Boolean = false\r\n  \t\t// Whether to sort the layers. When `false`, layers will keep the order\r\n  \t\t// in which they were added to the control.\r\n  \t\tsortLayers: false,\r\n\r\n  \t\t// @option sortFunction: Function = *\r\n  \t\t// A [compare function](https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/Array/sort)\r\n  \t\t// that will be used for sorting the layers, when `sortLayers` is `true`.\r\n  \t\t// The function receives both the `L.Layer` instances and their names, as in\r\n  \t\t// `sortFunction(layerA, layerB, nameA, nameB)`.\r\n  \t\t// By default, it sorts layers alphabetically by their name.\r\n  \t\tsortFunction: function (layerA, layerB, nameA, nameB) {\r\n  \t\t\treturn nameA < nameB ? -1 : (nameB < nameA ? 1 : 0);\r\n  \t\t}\r\n  \t},\r\n\r\n  \tinitialize: function (baseLayers, overlays, options) {\r\n  \t\tsetOptions(this, options);\r\n\r\n  \t\tthis._layerControlInputs = [];\r\n  \t\tthis._layers = [];\r\n  \t\tthis._lastZIndex = 0;\r\n  \t\tthis._handlingClick = false;\r\n\r\n  \t\tfor (var i in baseLayers) {\r\n  \t\t\tthis._addLayer(baseLayers[i], i);\r\n  \t\t}\r\n\r\n  \t\tfor (i in overlays) {\r\n  \t\t\tthis._addLayer(overlays[i], i, true);\r\n  \t\t}\r\n  \t},\r\n\r\n  \tonAdd: function (map) {\r\n  \t\tthis._initLayout();\r\n  \t\tthis._update();\r\n\r\n  \t\tthis._map = map;\r\n  \t\tmap.on('zoomend', this._checkDisabledLayers, this);\r\n\r\n  \t\tfor (var i = 0; i < this._layers.length; i++) {\r\n  \t\t\tthis._layers[i].layer.on('add remove', this._onLayerChange, this);\r\n  \t\t}\r\n\r\n  \t\treturn this._container;\r\n  \t},\r\n\r\n  \taddTo: function (map) {\r\n  \t\tControl.prototype.addTo.call(this, map);\r\n  \t\t// Trigger expand after Layers Control has been inserted into DOM so that is now has an actual height.\r\n  \t\treturn this._expandIfNotCollapsed();\r\n  \t},\r\n\r\n  \tonRemove: function () {\r\n  \t\tthis._map.off('zoomend', this._checkDisabledLayers, this);\r\n\r\n  \t\tfor (var i = 0; i < this._layers.length; i++) {\r\n  \t\t\tthis._layers[i].layer.off('add remove', this._onLayerChange, this);\r\n  \t\t}\r\n  \t},\r\n\r\n  \t// @method addBaseLayer(layer: Layer, name: String): this\r\n  \t// Adds a base layer (radio button entry) with the given name to the control.\r\n  \taddBaseLayer: function (layer, name) {\r\n  \t\tthis._addLayer(layer, name);\r\n  \t\treturn (this._map) ? this._update() : this;\r\n  \t},\r\n\r\n  \t// @method addOverlay(layer: Layer, name: String): this\r\n  \t// Adds an overlay (checkbox entry) with the given name to the control.\r\n  \taddOverlay: function (layer, name) {\r\n  \t\tthis._addLayer(layer, name, true);\r\n  \t\treturn (this._map) ? this._update() : this;\r\n  \t},\r\n\r\n  \t// @method removeLayer(layer: Layer): this\r\n  \t// Remove the given layer from the control.\r\n  \tremoveLayer: function (layer) {\r\n  \t\tlayer.off('add remove', this._onLayerChange, this);\r\n\r\n  \t\tvar obj = this._getLayer(stamp(layer));\r\n  \t\tif (obj) {\r\n  \t\t\tthis._layers.splice(this._layers.indexOf(obj), 1);\r\n  \t\t}\r\n  \t\treturn (this._map) ? this._update() : this;\r\n  \t},\r\n\r\n  \t// @method expand(): this\r\n  \t// Expand the control container if collapsed.\r\n  \texpand: function () {\r\n  \t\taddClass(this._container, 'leaflet-control-layers-expanded');\r\n  \t\tthis._section.style.height = null;\r\n  \t\tvar acceptableHeight = this._map.getSize().y - (this._container.offsetTop + 50);\r\n  \t\tif (acceptableHeight < this._section.clientHeight) {\r\n  \t\t\taddClass(this._section, 'leaflet-control-layers-scrollbar');\r\n  \t\t\tthis._section.style.height = acceptableHeight + 'px';\r\n  \t\t} else {\r\n  \t\t\tremoveClass(this._section, 'leaflet-control-layers-scrollbar');\r\n  \t\t}\r\n  \t\tthis._checkDisabledLayers();\r\n  \t\treturn this;\r\n  \t},\r\n\r\n  \t// @method collapse(): this\r\n  \t// Collapse the control container if expanded.\r\n  \tcollapse: function () {\r\n  \t\tremoveClass(this._container, 'leaflet-control-layers-expanded');\r\n  \t\treturn this;\r\n  \t},\r\n\r\n  \t_initLayout: function () {\r\n  \t\tvar className = 'leaflet-control-layers',\r\n  \t\t    container = this._container = create$1('div', className),\r\n  \t\t    collapsed = this.options.collapsed;\r\n\r\n  \t\t// makes this work on IE touch devices by stopping it from firing a mouseout event when the touch is released\r\n  \t\tcontainer.setAttribute('aria-haspopup', true);\r\n\r\n  \t\tdisableClickPropagation(container);\r\n  \t\tdisableScrollPropagation(container);\r\n\r\n  \t\tvar section = this._section = create$1('section', className + '-list');\r\n\r\n  \t\tif (collapsed) {\r\n  \t\t\tthis._map.on('click', this.collapse, this);\r\n\r\n  \t\t\tif (!android) {\r\n  \t\t\t\ton(container, {\r\n  \t\t\t\t\tmouseenter: this.expand,\r\n  \t\t\t\t\tmouseleave: this.collapse\r\n  \t\t\t\t}, this);\r\n  \t\t\t}\r\n  \t\t}\r\n\r\n  \t\tvar link = this._layersLink = create$1('a', className + '-toggle', container);\r\n  \t\tlink.href = '#';\r\n  \t\tlink.title = 'Layers';\r\n\r\n  \t\tif (touch) {\r\n  \t\t\ton(link, 'click', stop);\r\n  \t\t\ton(link, 'click', this.expand, this);\r\n  \t\t} else {\r\n  \t\t\ton(link, 'focus', this.expand, this);\r\n  \t\t}\r\n\r\n  \t\tif (!collapsed) {\r\n  \t\t\tthis.expand();\r\n  \t\t}\r\n\r\n  \t\tthis._baseLayersList = create$1('div', className + '-base', section);\r\n  \t\tthis._separator = create$1('div', className + '-separator', section);\r\n  \t\tthis._overlaysList = create$1('div', className + '-overlays', section);\r\n\r\n  \t\tcontainer.appendChild(section);\r\n  \t},\r\n\r\n  \t_getLayer: function (id) {\r\n  \t\tfor (var i = 0; i < this._layers.length; i++) {\r\n\r\n  \t\t\tif (this._layers[i] && stamp(this._layers[i].layer) === id) {\r\n  \t\t\t\treturn this._layers[i];\r\n  \t\t\t}\r\n  \t\t}\r\n  \t},\r\n\r\n  \t_addLayer: function (layer, name, overlay) {\r\n  \t\tif (this._map) {\r\n  \t\t\tlayer.on('add remove', this._onLayerChange, this);\r\n  \t\t}\r\n\r\n  \t\tthis._layers.push({\r\n  \t\t\tlayer: layer,\r\n  \t\t\tname: name,\r\n  \t\t\toverlay: overlay\r\n  \t\t});\r\n\r\n  \t\tif (this.options.sortLayers) {\r\n  \t\t\tthis._layers.sort(bind(function (a, b) {\r\n  \t\t\t\treturn this.options.sortFunction(a.layer, b.layer, a.name, b.name);\r\n  \t\t\t}, this));\r\n  \t\t}\r\n\r\n  \t\tif (this.options.autoZIndex && layer.setZIndex) {\r\n  \t\t\tthis._lastZIndex++;\r\n  \t\t\tlayer.setZIndex(this._lastZIndex);\r\n  \t\t}\r\n\r\n  \t\tthis._expandIfNotCollapsed();\r\n  \t},\r\n\r\n  \t_update: function () {\r\n  \t\tif (!this._container) { return this; }\r\n\r\n  \t\tempty(this._baseLayersList);\r\n  \t\tempty(this._overlaysList);\r\n\r\n  \t\tthis._layerControlInputs = [];\r\n  \t\tvar baseLayersPresent, overlaysPresent, i, obj, baseLayersCount = 0;\r\n\r\n  \t\tfor (i = 0; i < this._layers.length; i++) {\r\n  \t\t\tobj = this._layers[i];\r\n  \t\t\tthis._addItem(obj);\r\n  \t\t\toverlaysPresent = overlaysPresent || obj.overlay;\r\n  \t\t\tbaseLayersPresent = baseLayersPresent || !obj.overlay;\r\n  \t\t\tbaseLayersCount += !obj.overlay ? 1 : 0;\r\n  \t\t}\r\n\r\n  \t\t// Hide base layers section if there's only one layer.\r\n  \t\tif (this.options.hideSingleBase) {\r\n  \t\t\tbaseLayersPresent = baseLayersPresent && baseLayersCount > 1;\r\n  \t\t\tthis._baseLayersList.style.display = baseLayersPresent ? '' : 'none';\r\n  \t\t}\r\n\r\n  \t\tthis._separator.style.display = overlaysPresent && baseLayersPresent ? '' : 'none';\r\n\r\n  \t\treturn this;\r\n  \t},\r\n\r\n  \t_onLayerChange: function (e) {\r\n  \t\tif (!this._handlingClick) {\r\n  \t\t\tthis._update();\r\n  \t\t}\r\n\r\n  \t\tvar obj = this._getLayer(stamp(e.target));\r\n\r\n  \t\t// @namespace Map\r\n  \t\t// @section Layer events\r\n  \t\t// @event baselayerchange: LayersControlEvent\r\n  \t\t// Fired when the base layer is changed through the [layers control](#control-layers).\r\n  \t\t// @event overlayadd: LayersControlEvent\r\n  \t\t// Fired when an overlay is selected through the [layers control](#control-layers).\r\n  \t\t// @event overlayremove: LayersControlEvent\r\n  \t\t// Fired when an overlay is deselected through the [layers control](#control-layers).\r\n  \t\t// @namespace Control.Layers\r\n  \t\tvar type = obj.overlay ?\r\n  \t\t\t(e.type === 'add' ? 'overlayadd' : 'overlayremove') :\r\n  \t\t\t(e.type === 'add' ? 'baselayerchange' : null);\r\n\r\n  \t\tif (type) {\r\n  \t\t\tthis._map.fire(type, obj);\r\n  \t\t}\r\n  \t},\r\n\r\n  \t// IE7 bugs out if you create a radio dynamically, so you have to do it this hacky way (see http://bit.ly/PqYLBe)\r\n  \t_createRadioElement: function (name, checked) {\r\n\r\n  \t\tvar radioHtml = '<input type=\"radio\" class=\"leaflet-control-layers-selector\" name=\"' +\r\n  \t\t\t\tname + '\"' + (checked ? ' checked=\"checked\"' : '') + '/>';\r\n\r\n  \t\tvar radioFragment = document.createElement('div');\r\n  \t\tradioFragment.innerHTML = radioHtml;\r\n\r\n  \t\treturn radioFragment.firstChild;\r\n  \t},\r\n\r\n  \t_addItem: function (obj) {\r\n  \t\tvar label = document.createElement('label'),\r\n  \t\t    checked = this._map.hasLayer(obj.layer),\r\n  \t\t    input;\r\n\r\n  \t\tif (obj.overlay) {\r\n  \t\t\tinput = document.createElement('input');\r\n  \t\t\tinput.type = 'checkbox';\r\n  \t\t\tinput.className = 'leaflet-control-layers-selector';\r\n  \t\t\tinput.defaultChecked = checked;\r\n  \t\t} else {\r\n  \t\t\tinput = this._createRadioElement('leaflet-base-layers_' + stamp(this), checked);\r\n  \t\t}\r\n\r\n  \t\tthis._layerControlInputs.push(input);\r\n  \t\tinput.layerId = stamp(obj.layer);\r\n\r\n  \t\ton(input, 'click', this._onInputClick, this);\r\n\r\n  \t\tvar name = document.createElement('span');\r\n  \t\tname.innerHTML = ' ' + obj.name;\r\n\r\n  \t\t// Helps from preventing layer control flicker when checkboxes are disabled\r\n  \t\t// https://github.com/Leaflet/Leaflet/issues/2771\r\n  \t\tvar holder = document.createElement('div');\r\n\r\n  \t\tlabel.appendChild(holder);\r\n  \t\tholder.appendChild(input);\r\n  \t\tholder.appendChild(name);\r\n\r\n  \t\tvar container = obj.overlay ? this._overlaysList : this._baseLayersList;\r\n  \t\tcontainer.appendChild(label);\r\n\r\n  \t\tthis._checkDisabledLayers();\r\n  \t\treturn label;\r\n  \t},\r\n\r\n  \t_onInputClick: function () {\r\n  \t\tvar inputs = this._layerControlInputs,\r\n  \t\t    input, layer;\r\n  \t\tvar addedLayers = [],\r\n  \t\t    removedLayers = [];\r\n\r\n  \t\tthis._handlingClick = true;\r\n\r\n  \t\tfor (var i = inputs.length - 1; i >= 0; i--) {\r\n  \t\t\tinput = inputs[i];\r\n  \t\t\tlayer = this._getLayer(input.layerId).layer;\r\n\r\n  \t\t\tif (input.checked) {\r\n  \t\t\t\taddedLayers.push(layer);\r\n  \t\t\t} else if (!input.checked) {\r\n  \t\t\t\tremovedLayers.push(layer);\r\n  \t\t\t}\r\n  \t\t}\r\n\r\n  \t\t// Bugfix issue 2318: Should remove all old layers before readding new ones\r\n  \t\tfor (i = 0; i < removedLayers.length; i++) {\r\n  \t\t\tif (this._map.hasLayer(removedLayers[i])) {\r\n  \t\t\t\tthis._map.removeLayer(removedLayers[i]);\r\n  \t\t\t}\r\n  \t\t}\r\n  \t\tfor (i = 0; i < addedLayers.length; i++) {\r\n  \t\t\tif (!this._map.hasLayer(addedLayers[i])) {\r\n  \t\t\t\tthis._map.addLayer(addedLayers[i]);\r\n  \t\t\t}\r\n  \t\t}\r\n\r\n  \t\tthis._handlingClick = false;\r\n\r\n  \t\tthis._refocusOnMap();\r\n  \t},\r\n\r\n  \t_checkDisabledLayers: function () {\r\n  \t\tvar inputs = this._layerControlInputs,\r\n  \t\t    input,\r\n  \t\t    layer,\r\n  \t\t    zoom = this._map.getZoom();\r\n\r\n  \t\tfor (var i = inputs.length - 1; i >= 0; i--) {\r\n  \t\t\tinput = inputs[i];\r\n  \t\t\tlayer = this._getLayer(input.layerId).layer;\r\n  \t\t\tinput.disabled = (layer.options.minZoom !== undefined && zoom < layer.options.minZoom) ||\r\n  \t\t\t                 (layer.options.maxZoom !== undefined && zoom > layer.options.maxZoom);\r\n\r\n  \t\t}\r\n  \t},\r\n\r\n  \t_expandIfNotCollapsed: function () {\r\n  \t\tif (this._map && !this.options.collapsed) {\r\n  \t\t\tthis.expand();\r\n  \t\t}\r\n  \t\treturn this;\r\n  \t},\r\n\r\n  \t_expand: function () {\r\n  \t\t// Backward compatibility, remove me in 1.1.\r\n  \t\treturn this.expand();\r\n  \t},\r\n\r\n  \t_collapse: function () {\r\n  \t\t// Backward compatibility, remove me in 1.1.\r\n  \t\treturn this.collapse();\r\n  \t}\r\n\r\n  });\r\n\r\n\r\n  // @factory L.control.layers(baselayers?: Object, overlays?: Object, options?: Control.Layers options)\r\n  // Creates a layers control with the given layers. Base layers will be switched with radio buttons, while overlays will be switched with checkboxes. Note that all base layers should be passed in the base layers object, but only one should be added to the map during map instantiation.\r\n  var layers = function (baseLayers, overlays, options) {\r\n  \treturn new Layers(baseLayers, overlays, options);\r\n  };\n\n  /*\r\n   * @class Control.Zoom\r\n   * @aka L.Control.Zoom\r\n   * @inherits Control\r\n   *\r\n   * A basic zoom control with two buttons (zoom in and zoom out). It is put on the map by default unless you set its [`zoomControl` option](#map-zoomcontrol) to `false`. Extends `Control`.\r\n   */\r\n\r\n  var Zoom = Control.extend({\r\n  \t// @section\r\n  \t// @aka Control.Zoom options\r\n  \toptions: {\r\n  \t\tposition: 'topleft',\r\n\r\n  \t\t// @option zoomInText: String = '+'\r\n  \t\t// The text set on the 'zoom in' button.\r\n  \t\tzoomInText: '+',\r\n\r\n  \t\t// @option zoomInTitle: String = 'Zoom in'\r\n  \t\t// The title set on the 'zoom in' button.\r\n  \t\tzoomInTitle: 'Zoom in',\r\n\r\n  \t\t// @option zoomOutText: String = '&#x2212;'\r\n  \t\t// The text set on the 'zoom out' button.\r\n  \t\tzoomOutText: '&#x2212;',\r\n\r\n  \t\t// @option zoomOutTitle: String = 'Zoom out'\r\n  \t\t// The title set on the 'zoom out' button.\r\n  \t\tzoomOutTitle: 'Zoom out'\r\n  \t},\r\n\r\n  \tonAdd: function (map) {\r\n  \t\tvar zoomName = 'leaflet-control-zoom',\r\n  \t\t    container = create$1('div', zoomName + ' leaflet-bar'),\r\n  \t\t    options = this.options;\r\n\r\n  \t\tthis._zoomInButton  = this._createButton(options.zoomInText, options.zoomInTitle,\r\n  \t\t        zoomName + '-in',  container, this._zoomIn);\r\n  \t\tthis._zoomOutButton = this._createButton(options.zoomOutText, options.zoomOutTitle,\r\n  \t\t        zoomName + '-out', container, this._zoomOut);\r\n\r\n  \t\tthis._updateDisabled();\r\n  \t\tmap.on('zoomend zoomlevelschange', this._updateDisabled, this);\r\n\r\n  \t\treturn container;\r\n  \t},\r\n\r\n  \tonRemove: function (map) {\r\n  \t\tmap.off('zoomend zoomlevelschange', this._updateDisabled, this);\r\n  \t},\r\n\r\n  \tdisable: function () {\r\n  \t\tthis._disabled = true;\r\n  \t\tthis._updateDisabled();\r\n  \t\treturn this;\r\n  \t},\r\n\r\n  \tenable: function () {\r\n  \t\tthis._disabled = false;\r\n  \t\tthis._updateDisabled();\r\n  \t\treturn this;\r\n  \t},\r\n\r\n  \t_zoomIn: function (e) {\r\n  \t\tif (!this._disabled && this._map._zoom < this._map.getMaxZoom()) {\r\n  \t\t\tthis._map.zoomIn(this._map.options.zoomDelta * (e.shiftKey ? 3 : 1));\r\n  \t\t}\r\n  \t},\r\n\r\n  \t_zoomOut: function (e) {\r\n  \t\tif (!this._disabled && this._map._zoom > this._map.getMinZoom()) {\r\n  \t\t\tthis._map.zoomOut(this._map.options.zoomDelta * (e.shiftKey ? 3 : 1));\r\n  \t\t}\r\n  \t},\r\n\r\n  \t_createButton: function (html, title, className, container, fn) {\r\n  \t\tvar link = create$1('a', className, container);\r\n  \t\tlink.innerHTML = html;\r\n  \t\tlink.href = '#';\r\n  \t\tlink.title = title;\r\n\r\n  \t\t/*\r\n  \t\t * Will force screen readers like VoiceOver to read this as \"Zoom in - button\"\r\n  \t\t */\r\n  \t\tlink.setAttribute('role', 'button');\r\n  \t\tlink.setAttribute('aria-label', title);\r\n\r\n  \t\tdisableClickPropagation(link);\r\n  \t\ton(link, 'click', stop);\r\n  \t\ton(link, 'click', fn, this);\r\n  \t\ton(link, 'click', this._refocusOnMap, this);\r\n\r\n  \t\treturn link;\r\n  \t},\r\n\r\n  \t_updateDisabled: function () {\r\n  \t\tvar map = this._map,\r\n  \t\t    className = 'leaflet-disabled';\r\n\r\n  \t\tremoveClass(this._zoomInButton, className);\r\n  \t\tremoveClass(this._zoomOutButton, className);\r\n\r\n  \t\tif (this._disabled || map._zoom === map.getMinZoom()) {\r\n  \t\t\taddClass(this._zoomOutButton, className);\r\n  \t\t}\r\n  \t\tif (this._disabled || map._zoom === map.getMaxZoom()) {\r\n  \t\t\taddClass(this._zoomInButton, className);\r\n  \t\t}\r\n  \t}\r\n  });\r\n\r\n  // @namespace Map\r\n  // @section Control options\r\n  // @option zoomControl: Boolean = true\r\n  // Whether a [zoom control](#control-zoom) is added to the map by default.\r\n  Map.mergeOptions({\r\n  \tzoomControl: true\r\n  });\r\n\r\n  Map.addInitHook(function () {\r\n  \tif (this.options.zoomControl) {\r\n  \t\t// @section Controls\r\n  \t\t// @property zoomControl: Control.Zoom\r\n  \t\t// The default zoom control (only available if the\r\n  \t\t// [`zoomControl` option](#map-zoomcontrol) was `true` when creating the map).\r\n  \t\tthis.zoomControl = new Zoom();\r\n  \t\tthis.addControl(this.zoomControl);\r\n  \t}\r\n  });\r\n\r\n  // @namespace Control.Zoom\r\n  // @factory L.control.zoom(options: Control.Zoom options)\r\n  // Creates a zoom control\r\n  var zoom = function (options) {\r\n  \treturn new Zoom(options);\r\n  };\n\n  /*\n   * @class Control.Scale\n   * @aka L.Control.Scale\n   * @inherits Control\n   *\n   * A simple scale control that shows the scale of the current center of screen in metric (m/km) and imperial (mi/ft) systems. Extends `Control`.\n   *\n   * @example\n   *\n   * ```js\n   * L.control.scale().addTo(map);\n   * ```\n   */\n\n  var Scale = Control.extend({\n  \t// @section\n  \t// @aka Control.Scale options\n  \toptions: {\n  \t\tposition: 'bottomleft',\n\n  \t\t// @option maxWidth: Number = 100\n  \t\t// Maximum width of the control in pixels. The width is set dynamically to show round values (e.g. 100, 200, 500).\n  \t\tmaxWidth: 100,\n\n  \t\t// @option metric: Boolean = True\n  \t\t// Whether to show the metric scale line (m/km).\n  \t\tmetric: true,\n\n  \t\t// @option imperial: Boolean = True\n  \t\t// Whether to show the imperial scale line (mi/ft).\n  \t\timperial: true\n\n  \t\t// @option updateWhenIdle: Boolean = false\n  \t\t// If `true`, the control is updated on [`moveend`](#map-moveend), otherwise it's always up-to-date (updated on [`move`](#map-move)).\n  \t},\n\n  \tonAdd: function (map) {\n  \t\tvar className = 'leaflet-control-scale',\n  \t\t    container = create$1('div', className),\n  \t\t    options = this.options;\n\n  \t\tthis._addScales(options, className + '-line', container);\n\n  \t\tmap.on(options.updateWhenIdle ? 'moveend' : 'move', this._update, this);\n  \t\tmap.whenReady(this._update, this);\n\n  \t\treturn container;\n  \t},\n\n  \tonRemove: function (map) {\n  \t\tmap.off(this.options.updateWhenIdle ? 'moveend' : 'move', this._update, this);\n  \t},\n\n  \t_addScales: function (options, className, container) {\n  \t\tif (options.metric) {\n  \t\t\tthis._mScale = create$1('div', className, container);\n  \t\t}\n  \t\tif (options.imperial) {\n  \t\t\tthis._iScale = create$1('div', className, container);\n  \t\t}\n  \t},\n\n  \t_update: function () {\n  \t\tvar map = this._map,\n  \t\t    y = map.getSize().y / 2;\n\n  \t\tvar maxMeters = map.distance(\n  \t\t\tmap.containerPointToLatLng([0, y]),\n  \t\t\tmap.containerPointToLatLng([this.options.maxWidth, y]));\n\n  \t\tthis._updateScales(maxMeters);\n  \t},\n\n  \t_updateScales: function (maxMeters) {\n  \t\tif (this.options.metric && maxMeters) {\n  \t\t\tthis._updateMetric(maxMeters);\n  \t\t}\n  \t\tif (this.options.imperial && maxMeters) {\n  \t\t\tthis._updateImperial(maxMeters);\n  \t\t}\n  \t},\n\n  \t_updateMetric: function (maxMeters) {\n  \t\tvar meters = this._getRoundNum(maxMeters),\n  \t\t    label = meters < 1000 ? meters + ' m' : (meters / 1000) + ' km';\n\n  \t\tthis._updateScale(this._mScale, label, meters / maxMeters);\n  \t},\n\n  \t_updateImperial: function (maxMeters) {\n  \t\tvar maxFeet = maxMeters * 3.2808399,\n  \t\t    maxMiles, miles, feet;\n\n  \t\tif (maxFeet > 5280) {\n  \t\t\tmaxMiles = maxFeet / 5280;\n  \t\t\tmiles = this._getRoundNum(maxMiles);\n  \t\t\tthis._updateScale(this._iScale, miles + ' mi', miles / maxMiles);\n\n  \t\t} else {\n  \t\t\tfeet = this._getRoundNum(maxFeet);\n  \t\t\tthis._updateScale(this._iScale, feet + ' ft', feet / maxFeet);\n  \t\t}\n  \t},\n\n  \t_updateScale: function (scale, text, ratio) {\n  \t\tscale.style.width = Math.round(this.options.maxWidth * ratio) + 'px';\n  \t\tscale.innerHTML = text;\n  \t},\n\n  \t_getRoundNum: function (num) {\n  \t\tvar pow10 = Math.pow(10, (Math.floor(num) + '').length - 1),\n  \t\t    d = num / pow10;\n\n  \t\td = d >= 10 ? 10 :\n  \t\t    d >= 5 ? 5 :\n  \t\t    d >= 3 ? 3 :\n  \t\t    d >= 2 ? 2 : 1;\n\n  \t\treturn pow10 * d;\n  \t}\n  });\n\n\n  // @factory L.control.scale(options?: Control.Scale options)\n  // Creates an scale control with the given options.\n  var scale = function (options) {\n  \treturn new Scale(options);\n  };\n\n  /*\r\n   * @class Control.Attribution\r\n   * @aka L.Control.Attribution\r\n   * @inherits Control\r\n   *\r\n   * The attribution control allows you to display attribution data in a small text box on a map. It is put on the map by default unless you set its [`attributionControl` option](#map-attributioncontrol) to `false`, and it fetches attribution texts from layers with the [`getAttribution` method](#layer-getattribution) automatically. Extends Control.\r\n   */\r\n\r\n  var Attribution = Control.extend({\r\n  \t// @section\r\n  \t// @aka Control.Attribution options\r\n  \toptions: {\r\n  \t\tposition: 'bottomright',\r\n\r\n  \t\t// @option prefix: String = 'Leaflet'\r\n  \t\t// The HTML text shown before the attributions. Pass `false` to disable.\r\n  \t\tprefix: '<a href=\"https://leafletjs.com\" title=\"A JS library for interactive maps\">Leaflet</a>'\r\n  \t},\r\n\r\n  \tinitialize: function (options) {\r\n  \t\tsetOptions(this, options);\r\n\r\n  \t\tthis._attributions = {};\r\n  \t},\r\n\r\n  \tonAdd: function (map) {\r\n  \t\tmap.attributionControl = this;\r\n  \t\tthis._container = create$1('div', 'leaflet-control-attribution');\r\n  \t\tdisableClickPropagation(this._container);\r\n\r\n  \t\t// TODO ugly, refactor\r\n  \t\tfor (var i in map._layers) {\r\n  \t\t\tif (map._layers[i].getAttribution) {\r\n  \t\t\t\tthis.addAttribution(map._layers[i].getAttribution());\r\n  \t\t\t}\r\n  \t\t}\r\n\r\n  \t\tthis._update();\r\n\r\n  \t\treturn this._container;\r\n  \t},\r\n\r\n  \t// @method setPrefix(prefix: String): this\r\n  \t// Sets the text before the attributions.\r\n  \tsetPrefix: function (prefix) {\r\n  \t\tthis.options.prefix = prefix;\r\n  \t\tthis._update();\r\n  \t\treturn this;\r\n  \t},\r\n\r\n  \t// @method addAttribution(text: String): this\r\n  \t// Adds an attribution text (e.g. `'Vector data &copy; Mapbox'`).\r\n  \taddAttribution: function (text) {\r\n  \t\tif (!text) { return this; }\r\n\r\n  \t\tif (!this._attributions[text]) {\r\n  \t\t\tthis._attributions[text] = 0;\r\n  \t\t}\r\n  \t\tthis._attributions[text]++;\r\n\r\n  \t\tthis._update();\r\n\r\n  \t\treturn this;\r\n  \t},\r\n\r\n  \t// @method removeAttribution(text: String): this\r\n  \t// Removes an attribution text.\r\n  \tremoveAttribution: function (text) {\r\n  \t\tif (!text) { return this; }\r\n\r\n  \t\tif (this._attributions[text]) {\r\n  \t\t\tthis._attributions[text]--;\r\n  \t\t\tthis._update();\r\n  \t\t}\r\n\r\n  \t\treturn this;\r\n  \t},\r\n\r\n  \t_update: function () {\r\n  \t\tif (!this._map) { return; }\r\n\r\n  \t\tvar attribs = [];\r\n\r\n  \t\tfor (var i in this._attributions) {\r\n  \t\t\tif (this._attributions[i]) {\r\n  \t\t\t\tattribs.push(i);\r\n  \t\t\t}\r\n  \t\t}\r\n\r\n  \t\tvar prefixAndAttribs = [];\r\n\r\n  \t\tif (this.options.prefix) {\r\n  \t\t\tprefixAndAttribs.push(this.options.prefix);\r\n  \t\t}\r\n  \t\tif (attribs.length) {\r\n  \t\t\tprefixAndAttribs.push(attribs.join(', '));\r\n  \t\t}\r\n\r\n  \t\tthis._container.innerHTML = prefixAndAttribs.join(' | ');\r\n  \t}\r\n  });\r\n\r\n  // @namespace Map\r\n  // @section Control options\r\n  // @option attributionControl: Boolean = true\r\n  // Whether a [attribution control](#control-attribution) is added to the map by default.\r\n  Map.mergeOptions({\r\n  \tattributionControl: true\r\n  });\r\n\r\n  Map.addInitHook(function () {\r\n  \tif (this.options.attributionControl) {\r\n  \t\tnew Attribution().addTo(this);\r\n  \t}\r\n  });\r\n\r\n  // @namespace Control.Attribution\r\n  // @factory L.control.attribution(options: Control.Attribution options)\r\n  // Creates an attribution control.\r\n  var attribution = function (options) {\r\n  \treturn new Attribution(options);\r\n  };\n\n  Control.Layers = Layers;\n  Control.Zoom = Zoom;\n  Control.Scale = Scale;\n  Control.Attribution = Attribution;\n\n  control.layers = layers;\n  control.zoom = zoom;\n  control.scale = scale;\n  control.attribution = attribution;\n\n  /*\n  \tL.Handler is a base class for handler classes that are used internally to inject\n  \tinteraction features like dragging to classes like Map and Marker.\n  */\n\n  // @class Handler\n  // @aka L.Handler\n  // Abstract class for map interaction handlers\n\n  var Handler = Class.extend({\n  \tinitialize: function (map) {\n  \t\tthis._map = map;\n  \t},\n\n  \t// @method enable(): this\n  \t// Enables the handler\n  \tenable: function () {\n  \t\tif (this._enabled) { return this; }\n\n  \t\tthis._enabled = true;\n  \t\tthis.addHooks();\n  \t\treturn this;\n  \t},\n\n  \t// @method disable(): this\n  \t// Disables the handler\n  \tdisable: function () {\n  \t\tif (!this._enabled) { return this; }\n\n  \t\tthis._enabled = false;\n  \t\tthis.removeHooks();\n  \t\treturn this;\n  \t},\n\n  \t// @method enabled(): Boolean\n  \t// Returns `true` if the handler is enabled\n  \tenabled: function () {\n  \t\treturn !!this._enabled;\n  \t}\n\n  \t// @section Extension methods\n  \t// Classes inheriting from `Handler` must implement the two following methods:\n  \t// @method addHooks()\n  \t// Called when the handler is enabled, should add event hooks.\n  \t// @method removeHooks()\n  \t// Called when the handler is disabled, should remove the event hooks added previously.\n  });\n\n  // @section There is static function which can be called without instantiating L.Handler:\n  // @function addTo(map: Map, name: String): this\n  // Adds a new Handler to the given map with the given name.\n  Handler.addTo = function (map, name) {\n  \tmap.addHandler(name, this);\n  \treturn this;\n  };\n\n  var Mixin = {Events: Events};\n\n  /*\r\n   * @class Draggable\r\n   * @aka L.Draggable\r\n   * @inherits Evented\r\n   *\r\n   * A class for making DOM elements draggable (including touch support).\r\n   * Used internally for map and marker dragging. Only works for elements\r\n   * that were positioned with [`L.DomUtil.setPosition`](#domutil-setposition).\r\n   *\r\n   * @example\r\n   * ```js\r\n   * var draggable = new L.Draggable(elementToDrag);\r\n   * draggable.enable();\r\n   * ```\r\n   */\r\n\r\n  var START = touch ? 'touchstart mousedown' : 'mousedown';\r\n  var END = {\r\n  \tmousedown: 'mouseup',\r\n  \ttouchstart: 'touchend',\r\n  \tpointerdown: 'touchend',\r\n  \tMSPointerDown: 'touchend'\r\n  };\r\n  var MOVE = {\r\n  \tmousedown: 'mousemove',\r\n  \ttouchstart: 'touchmove',\r\n  \tpointerdown: 'touchmove',\r\n  \tMSPointerDown: 'touchmove'\r\n  };\r\n\r\n\r\n  var Draggable = Evented.extend({\r\n\r\n  \toptions: {\r\n  \t\t// @section\r\n  \t\t// @aka Draggable options\r\n  \t\t// @option clickTolerance: Number = 3\r\n  \t\t// The max number of pixels a user can shift the mouse pointer during a click\r\n  \t\t// for it to be considered a valid click (as opposed to a mouse drag).\r\n  \t\tclickTolerance: 3\r\n  \t},\r\n\r\n  \t// @constructor L.Draggable(el: HTMLElement, dragHandle?: HTMLElement, preventOutline?: Boolean, options?: Draggable options)\r\n  \t// Creates a `Draggable` object for moving `el` when you start dragging the `dragHandle` element (equals `el` itself by default).\r\n  \tinitialize: function (element, dragStartTarget, preventOutline$$1, options) {\r\n  \t\tsetOptions(this, options);\r\n\r\n  \t\tthis._element = element;\r\n  \t\tthis._dragStartTarget = dragStartTarget || element;\r\n  \t\tthis._preventOutline = preventOutline$$1;\r\n  \t},\r\n\r\n  \t// @method enable()\r\n  \t// Enables the dragging ability\r\n  \tenable: function () {\r\n  \t\tif (this._enabled) { return; }\r\n\r\n  \t\ton(this._dragStartTarget, START, this._onDown, this);\r\n\r\n  \t\tthis._enabled = true;\r\n  \t},\r\n\r\n  \t// @method disable()\r\n  \t// Disables the dragging ability\r\n  \tdisable: function () {\r\n  \t\tif (!this._enabled) { return; }\r\n\r\n  \t\t// If we're currently dragging this draggable,\r\n  \t\t// disabling it counts as first ending the drag.\r\n  \t\tif (Draggable._dragging === this) {\r\n  \t\t\tthis.finishDrag();\r\n  \t\t}\r\n\r\n  \t\toff(this._dragStartTarget, START, this._onDown, this);\r\n\r\n  \t\tthis._enabled = false;\r\n  \t\tthis._moved = false;\r\n  \t},\r\n\r\n  \t_onDown: function (e) {\r\n  \t\t// Ignore simulated events, since we handle both touch and\r\n  \t\t// mouse explicitly; otherwise we risk getting duplicates of\r\n  \t\t// touch events, see #4315.\r\n  \t\t// Also ignore the event if disabled; this happens in IE11\r\n  \t\t// under some circumstances, see #3666.\r\n  \t\tif (e._simulated || !this._enabled) { return; }\r\n\r\n  \t\tthis._moved = false;\r\n\r\n  \t\tif (hasClass(this._element, 'leaflet-zoom-anim')) { return; }\r\n\r\n  \t\tif (Draggable._dragging || e.shiftKey || ((e.which !== 1) && (e.button !== 1) && !e.touches)) { return; }\r\n  \t\tDraggable._dragging = this;  // Prevent dragging multiple objects at once.\r\n\r\n  \t\tif (this._preventOutline) {\r\n  \t\t\tpreventOutline(this._element);\r\n  \t\t}\r\n\r\n  \t\tdisableImageDrag();\r\n  \t\tdisableTextSelection();\r\n\r\n  \t\tif (this._moving) { return; }\r\n\r\n  \t\t// @event down: Event\r\n  \t\t// Fired when a drag is about to start.\r\n  \t\tthis.fire('down');\r\n\r\n  \t\tvar first = e.touches ? e.touches[0] : e,\r\n  \t\t    sizedParent = getSizedParentNode(this._element);\r\n\r\n  \t\tthis._startPoint = new Point(first.clientX, first.clientY);\r\n\r\n  \t\t// Cache the scale, so that we can continuously compensate for it during drag (_onMove).\r\n  \t\tthis._parentScale = getScale(sizedParent);\r\n\r\n  \t\ton(document, MOVE[e.type], this._onMove, this);\r\n  \t\ton(document, END[e.type], this._onUp, this);\r\n  \t},\r\n\r\n  \t_onMove: function (e) {\r\n  \t\t// Ignore simulated events, since we handle both touch and\r\n  \t\t// mouse explicitly; otherwise we risk getting duplicates of\r\n  \t\t// touch events, see #4315.\r\n  \t\t// Also ignore the event if disabled; this happens in IE11\r\n  \t\t// under some circumstances, see #3666.\r\n  \t\tif (e._simulated || !this._enabled) { return; }\r\n\r\n  \t\tif (e.touches && e.touches.length > 1) {\r\n  \t\t\tthis._moved = true;\r\n  \t\t\treturn;\r\n  \t\t}\r\n\r\n  \t\tvar first = (e.touches && e.touches.length === 1 ? e.touches[0] : e),\r\n  \t\t    offset = new Point(first.clientX, first.clientY)._subtract(this._startPoint);\r\n\r\n  \t\tif (!offset.x && !offset.y) { return; }\r\n  \t\tif (Math.abs(offset.x) + Math.abs(offset.y) < this.options.clickTolerance) { return; }\r\n\r\n  \t\t// We assume that the parent container's position, border and scale do not change for the duration of the drag.\r\n  \t\t// Therefore there is no need to account for the position and border (they are eliminated by the subtraction)\r\n  \t\t// and we can use the cached value for the scale.\r\n  \t\toffset.x /= this._parentScale.x;\r\n  \t\toffset.y /= this._parentScale.y;\r\n\r\n  \t\tpreventDefault(e);\r\n\r\n  \t\tif (!this._moved) {\r\n  \t\t\t// @event dragstart: Event\r\n  \t\t\t// Fired when a drag starts\r\n  \t\t\tthis.fire('dragstart');\r\n\r\n  \t\t\tthis._moved = true;\r\n  \t\t\tthis._startPos = getPosition(this._element).subtract(offset);\r\n\r\n  \t\t\taddClass(document.body, 'leaflet-dragging');\r\n\r\n  \t\t\tthis._lastTarget = e.target || e.srcElement;\r\n  \t\t\t// IE and Edge do not give the <use> element, so fetch it\r\n  \t\t\t// if necessary\r\n  \t\t\tif (window.SVGElementInstance && this._lastTarget instanceof window.SVGElementInstance) {\r\n  \t\t\t\tthis._lastTarget = this._lastTarget.correspondingUseElement;\r\n  \t\t\t}\r\n  \t\t\taddClass(this._lastTarget, 'leaflet-drag-target');\r\n  \t\t}\r\n\r\n  \t\tthis._newPos = this._startPos.add(offset);\r\n  \t\tthis._moving = true;\r\n\r\n  \t\tcancelAnimFrame(this._animRequest);\r\n  \t\tthis._lastEvent = e;\r\n  \t\tthis._animRequest = requestAnimFrame(this._updatePosition, this, true);\r\n  \t},\r\n\r\n  \t_updatePosition: function () {\r\n  \t\tvar e = {originalEvent: this._lastEvent};\r\n\r\n  \t\t// @event predrag: Event\r\n  \t\t// Fired continuously during dragging *before* each corresponding\r\n  \t\t// update of the element's position.\r\n  \t\tthis.fire('predrag', e);\r\n  \t\tsetPosition(this._element, this._newPos);\r\n\r\n  \t\t// @event drag: Event\r\n  \t\t// Fired continuously during dragging.\r\n  \t\tthis.fire('drag', e);\r\n  \t},\r\n\r\n  \t_onUp: function (e) {\r\n  \t\t// Ignore simulated events, since we handle both touch and\r\n  \t\t// mouse explicitly; otherwise we risk getting duplicates of\r\n  \t\t// touch events, see #4315.\r\n  \t\t// Also ignore the event if disabled; this happens in IE11\r\n  \t\t// under some circumstances, see #3666.\r\n  \t\tif (e._simulated || !this._enabled) { return; }\r\n  \t\tthis.finishDrag();\r\n  \t},\r\n\r\n  \tfinishDrag: function () {\r\n  \t\tremoveClass(document.body, 'leaflet-dragging');\r\n\r\n  \t\tif (this._lastTarget) {\r\n  \t\t\tremoveClass(this._lastTarget, 'leaflet-drag-target');\r\n  \t\t\tthis._lastTarget = null;\r\n  \t\t}\r\n\r\n  \t\tfor (var i in MOVE) {\r\n  \t\t\toff(document, MOVE[i], this._onMove, this);\r\n  \t\t\toff(document, END[i], this._onUp, this);\r\n  \t\t}\r\n\r\n  \t\tenableImageDrag();\r\n  \t\tenableTextSelection();\r\n\r\n  \t\tif (this._moved && this._moving) {\r\n  \t\t\t// ensure drag is not fired after dragend\r\n  \t\t\tcancelAnimFrame(this._animRequest);\r\n\r\n  \t\t\t// @event dragend: DragEndEvent\r\n  \t\t\t// Fired when the drag ends.\r\n  \t\t\tthis.fire('dragend', {\r\n  \t\t\t\tdistance: this._newPos.distanceTo(this._startPos)\r\n  \t\t\t});\r\n  \t\t}\r\n\r\n  \t\tthis._moving = false;\r\n  \t\tDraggable._dragging = false;\r\n  \t}\r\n\r\n  });\n\n  /*\r\n   * @namespace LineUtil\r\n   *\r\n   * Various utility functions for polyline points processing, used by Leaflet internally to make polylines lightning-fast.\r\n   */\r\n\r\n  // Simplify polyline with vertex reduction and Douglas-Peucker simplification.\r\n  // Improves rendering performance dramatically by lessening the number of points to draw.\r\n\r\n  // @function simplify(points: Point[], tolerance: Number): Point[]\r\n  // Dramatically reduces the number of points in a polyline while retaining\r\n  // its shape and returns a new array of simplified points, using the\r\n  // [Douglas-Peucker algorithm](http://en.wikipedia.org/wiki/Douglas-Peucker_algorithm).\r\n  // Used for a huge performance boost when processing/displaying Leaflet polylines for\r\n  // each zoom level and also reducing visual noise. tolerance affects the amount of\r\n  // simplification (lesser value means higher quality but slower and with more points).\r\n  // Also released as a separated micro-library [Simplify.js](http://mourner.github.com/simplify-js/).\r\n  function simplify(points, tolerance) {\r\n  \tif (!tolerance || !points.length) {\r\n  \t\treturn points.slice();\r\n  \t}\r\n\r\n  \tvar sqTolerance = tolerance * tolerance;\r\n\r\n  \t    // stage 1: vertex reduction\r\n  \t    points = _reducePoints(points, sqTolerance);\r\n\r\n  \t    // stage 2: Douglas-Peucker simplification\r\n  \t    points = _simplifyDP(points, sqTolerance);\r\n\r\n  \treturn points;\r\n  }\r\n\r\n  // @function pointToSegmentDistance(p: Point, p1: Point, p2: Point): Number\r\n  // Returns the distance between point `p` and segment `p1` to `p2`.\r\n  function pointToSegmentDistance(p, p1, p2) {\r\n  \treturn Math.sqrt(_sqClosestPointOnSegment(p, p1, p2, true));\r\n  }\r\n\r\n  // @function closestPointOnSegment(p: Point, p1: Point, p2: Point): Number\r\n  // Returns the closest point from a point `p` on a segment `p1` to `p2`.\r\n  function closestPointOnSegment(p, p1, p2) {\r\n  \treturn _sqClosestPointOnSegment(p, p1, p2);\r\n  }\r\n\r\n  // Douglas-Peucker simplification, see http://en.wikipedia.org/wiki/Douglas-Peucker_algorithm\r\n  function _simplifyDP(points, sqTolerance) {\r\n\r\n  \tvar len = points.length,\r\n  \t    ArrayConstructor = typeof Uint8Array !== undefined + '' ? Uint8Array : Array,\r\n  \t    markers = new ArrayConstructor(len);\r\n\r\n  \t    markers[0] = markers[len - 1] = 1;\r\n\r\n  \t_simplifyDPStep(points, markers, sqTolerance, 0, len - 1);\r\n\r\n  \tvar i,\r\n  \t    newPoints = [];\r\n\r\n  \tfor (i = 0; i < len; i++) {\r\n  \t\tif (markers[i]) {\r\n  \t\t\tnewPoints.push(points[i]);\r\n  \t\t}\r\n  \t}\r\n\r\n  \treturn newPoints;\r\n  }\r\n\r\n  function _simplifyDPStep(points, markers, sqTolerance, first, last) {\r\n\r\n  \tvar maxSqDist = 0,\r\n  \tindex, i, sqDist;\r\n\r\n  \tfor (i = first + 1; i <= last - 1; i++) {\r\n  \t\tsqDist = _sqClosestPointOnSegment(points[i], points[first], points[last], true);\r\n\r\n  \t\tif (sqDist > maxSqDist) {\r\n  \t\t\tindex = i;\r\n  \t\t\tmaxSqDist = sqDist;\r\n  \t\t}\r\n  \t}\r\n\r\n  \tif (maxSqDist > sqTolerance) {\r\n  \t\tmarkers[index] = 1;\r\n\r\n  \t\t_simplifyDPStep(points, markers, sqTolerance, first, index);\r\n  \t\t_simplifyDPStep(points, markers, sqTolerance, index, last);\r\n  \t}\r\n  }\r\n\r\n  // reduce points that are too close to each other to a single point\r\n  function _reducePoints(points, sqTolerance) {\r\n  \tvar reducedPoints = [points[0]];\r\n\r\n  \tfor (var i = 1, prev = 0, len = points.length; i < len; i++) {\r\n  \t\tif (_sqDist(points[i], points[prev]) > sqTolerance) {\r\n  \t\t\treducedPoints.push(points[i]);\r\n  \t\t\tprev = i;\r\n  \t\t}\r\n  \t}\r\n  \tif (prev < len - 1) {\r\n  \t\treducedPoints.push(points[len - 1]);\r\n  \t}\r\n  \treturn reducedPoints;\r\n  }\r\n\r\n  var _lastCode;\r\n\r\n  // @function clipSegment(a: Point, b: Point, bounds: Bounds, useLastCode?: Boolean, round?: Boolean): Point[]|Boolean\r\n  // Clips the segment a to b by rectangular bounds with the\r\n  // [Cohen-Sutherland algorithm](https://en.wikipedia.org/wiki/Cohen%E2%80%93Sutherland_algorithm)\r\n  // (modifying the segment points directly!). Used by Leaflet to only show polyline\r\n  // points that are on the screen or near, increasing performance.\r\n  function clipSegment(a, b, bounds, useLastCode, round) {\r\n  \tvar codeA = useLastCode ? _lastCode : _getBitCode(a, bounds),\r\n  \t    codeB = _getBitCode(b, bounds),\r\n\r\n  \t    codeOut, p, newCode;\r\n\r\n  \t    // save 2nd code to avoid calculating it on the next segment\r\n  \t    _lastCode = codeB;\r\n\r\n  \twhile (true) {\r\n  \t\t// if a,b is inside the clip window (trivial accept)\r\n  \t\tif (!(codeA | codeB)) {\r\n  \t\t\treturn [a, b];\r\n  \t\t}\r\n\r\n  \t\t// if a,b is outside the clip window (trivial reject)\r\n  \t\tif (codeA & codeB) {\r\n  \t\t\treturn false;\r\n  \t\t}\r\n\r\n  \t\t// other cases\r\n  \t\tcodeOut = codeA || codeB;\r\n  \t\tp = _getEdgeIntersection(a, b, codeOut, bounds, round);\r\n  \t\tnewCode = _getBitCode(p, bounds);\r\n\r\n  \t\tif (codeOut === codeA) {\r\n  \t\t\ta = p;\r\n  \t\t\tcodeA = newCode;\r\n  \t\t} else {\r\n  \t\t\tb = p;\r\n  \t\t\tcodeB = newCode;\r\n  \t\t}\r\n  \t}\r\n  }\r\n\r\n  function _getEdgeIntersection(a, b, code, bounds, round) {\r\n  \tvar dx = b.x - a.x,\r\n  \t    dy = b.y - a.y,\r\n  \t    min = bounds.min,\r\n  \t    max = bounds.max,\r\n  \t    x, y;\r\n\r\n  \tif (code & 8) { // top\r\n  \t\tx = a.x + dx * (max.y - a.y) / dy;\r\n  \t\ty = max.y;\r\n\r\n  \t} else if (code & 4) { // bottom\r\n  \t\tx = a.x + dx * (min.y - a.y) / dy;\r\n  \t\ty = min.y;\r\n\r\n  \t} else if (code & 2) { // right\r\n  \t\tx = max.x;\r\n  \t\ty = a.y + dy * (max.x - a.x) / dx;\r\n\r\n  \t} else if (code & 1) { // left\r\n  \t\tx = min.x;\r\n  \t\ty = a.y + dy * (min.x - a.x) / dx;\r\n  \t}\r\n\r\n  \treturn new Point(x, y, round);\r\n  }\r\n\r\n  function _getBitCode(p, bounds) {\r\n  \tvar code = 0;\r\n\r\n  \tif (p.x < bounds.min.x) { // left\r\n  \t\tcode |= 1;\r\n  \t} else if (p.x > bounds.max.x) { // right\r\n  \t\tcode |= 2;\r\n  \t}\r\n\r\n  \tif (p.y < bounds.min.y) { // bottom\r\n  \t\tcode |= 4;\r\n  \t} else if (p.y > bounds.max.y) { // top\r\n  \t\tcode |= 8;\r\n  \t}\r\n\r\n  \treturn code;\r\n  }\r\n\r\n  // square distance (to avoid unnecessary Math.sqrt calls)\r\n  function _sqDist(p1, p2) {\r\n  \tvar dx = p2.x - p1.x,\r\n  \t    dy = p2.y - p1.y;\r\n  \treturn dx * dx + dy * dy;\r\n  }\r\n\r\n  // return closest point on segment or distance to that point\r\n  function _sqClosestPointOnSegment(p, p1, p2, sqDist) {\r\n  \tvar x = p1.x,\r\n  \t    y = p1.y,\r\n  \t    dx = p2.x - x,\r\n  \t    dy = p2.y - y,\r\n  \t    dot = dx * dx + dy * dy,\r\n  \t    t;\r\n\r\n  \tif (dot > 0) {\r\n  \t\tt = ((p.x - x) * dx + (p.y - y) * dy) / dot;\r\n\r\n  \t\tif (t > 1) {\r\n  \t\t\tx = p2.x;\r\n  \t\t\ty = p2.y;\r\n  \t\t} else if (t > 0) {\r\n  \t\t\tx += dx * t;\r\n  \t\t\ty += dy * t;\r\n  \t\t}\r\n  \t}\r\n\r\n  \tdx = p.x - x;\r\n  \tdy = p.y - y;\r\n\r\n  \treturn sqDist ? dx * dx + dy * dy : new Point(x, y);\r\n  }\r\n\r\n\r\n  // @function isFlat(latlngs: LatLng[]): Boolean\r\n  // Returns true if `latlngs` is a flat array, false is nested.\r\n  function isFlat(latlngs) {\r\n  \treturn !isArray(latlngs[0]) || (typeof latlngs[0][0] !== 'object' && typeof latlngs[0][0] !== 'undefined');\r\n  }\r\n\r\n  function _flat(latlngs) {\r\n  \tconsole.warn('Deprecated use of _flat, please use L.LineUtil.isFlat instead.');\r\n  \treturn isFlat(latlngs);\r\n  }\n\n  var LineUtil = ({\n    simplify: simplify,\n    pointToSegmentDistance: pointToSegmentDistance,\n    closestPointOnSegment: closestPointOnSegment,\n    clipSegment: clipSegment,\n    _getEdgeIntersection: _getEdgeIntersection,\n    _getBitCode: _getBitCode,\n    _sqClosestPointOnSegment: _sqClosestPointOnSegment,\n    isFlat: isFlat,\n    _flat: _flat\n  });\n\n  /*\r\n   * @namespace PolyUtil\r\n   * Various utility functions for polygon geometries.\r\n   */\r\n\r\n  /* @function clipPolygon(points: Point[], bounds: Bounds, round?: Boolean): Point[]\r\n   * Clips the polygon geometry defined by the given `points` by the given bounds (using the [Sutherland-Hodgman algorithm](https://en.wikipedia.org/wiki/Sutherland%E2%80%93Hodgman_algorithm)).\r\n   * Used by Leaflet to only show polygon points that are on the screen or near, increasing\r\n   * performance. Note that polygon points needs different algorithm for clipping\r\n   * than polyline, so there's a separate method for it.\r\n   */\r\n  function clipPolygon(points, bounds, round) {\r\n  \tvar clippedPoints,\r\n  \t    edges = [1, 4, 2, 8],\r\n  \t    i, j, k,\r\n  \t    a, b,\r\n  \t    len, edge, p;\r\n\r\n  \tfor (i = 0, len = points.length; i < len; i++) {\r\n  \t\tpoints[i]._code = _getBitCode(points[i], bounds);\r\n  \t}\r\n\r\n  \t// for each edge (left, bottom, right, top)\r\n  \tfor (k = 0; k < 4; k++) {\r\n  \t\tedge = edges[k];\r\n  \t\tclippedPoints = [];\r\n\r\n  \t\tfor (i = 0, len = points.length, j = len - 1; i < len; j = i++) {\r\n  \t\t\ta = points[i];\r\n  \t\t\tb = points[j];\r\n\r\n  \t\t\t// if a is inside the clip window\r\n  \t\t\tif (!(a._code & edge)) {\r\n  \t\t\t\t// if b is outside the clip window (a->b goes out of screen)\r\n  \t\t\t\tif (b._code & edge) {\r\n  \t\t\t\t\tp = _getEdgeIntersection(b, a, edge, bounds, round);\r\n  \t\t\t\t\tp._code = _getBitCode(p, bounds);\r\n  \t\t\t\t\tclippedPoints.push(p);\r\n  \t\t\t\t}\r\n  \t\t\t\tclippedPoints.push(a);\r\n\r\n  \t\t\t// else if b is inside the clip window (a->b enters the screen)\r\n  \t\t\t} else if (!(b._code & edge)) {\r\n  \t\t\t\tp = _getEdgeIntersection(b, a, edge, bounds, round);\r\n  \t\t\t\tp._code = _getBitCode(p, bounds);\r\n  \t\t\t\tclippedPoints.push(p);\r\n  \t\t\t}\r\n  \t\t}\r\n  \t\tpoints = clippedPoints;\r\n  \t}\r\n\r\n  \treturn points;\r\n  }\n\n  var PolyUtil = ({\n    clipPolygon: clipPolygon\n  });\n\n  /*\r\n   * @namespace Projection\r\n   * @section\r\n   * Leaflet comes with a set of already defined Projections out of the box:\r\n   *\r\n   * @projection L.Projection.LonLat\r\n   *\r\n   * Equirectangular, or Plate Carree projection — the most simple projection,\r\n   * mostly used by GIS enthusiasts. Directly maps `x` as longitude, and `y` as\r\n   * latitude. Also suitable for flat worlds, e.g. game maps. Used by the\r\n   * `EPSG:4326` and `Simple` CRS.\r\n   */\r\n\r\n  var LonLat = {\r\n  \tproject: function (latlng) {\r\n  \t\treturn new Point(latlng.lng, latlng.lat);\r\n  \t},\r\n\r\n  \tunproject: function (point) {\r\n  \t\treturn new LatLng(point.y, point.x);\r\n  \t},\r\n\r\n  \tbounds: new Bounds([-180, -90], [180, 90])\r\n  };\n\n  /*\r\n   * @namespace Projection\r\n   * @projection L.Projection.Mercator\r\n   *\r\n   * Elliptical Mercator projection — more complex than Spherical Mercator. Assumes that Earth is an ellipsoid. Used by the EPSG:3395 CRS.\r\n   */\r\n\r\n  var Mercator = {\r\n  \tR: 6378137,\r\n  \tR_MINOR: 6356752.314245179,\r\n\r\n  \tbounds: new Bounds([-20037508.34279, -15496570.73972], [20037508.34279, 18764656.23138]),\r\n\r\n  \tproject: function (latlng) {\r\n  \t\tvar d = Math.PI / 180,\r\n  \t\t    r = this.R,\r\n  \t\t    y = latlng.lat * d,\r\n  \t\t    tmp = this.R_MINOR / r,\r\n  \t\t    e = Math.sqrt(1 - tmp * tmp),\r\n  \t\t    con = e * Math.sin(y);\r\n\r\n  \t\tvar ts = Math.tan(Math.PI / 4 - y / 2) / Math.pow((1 - con) / (1 + con), e / 2);\r\n  \t\ty = -r * Math.log(Math.max(ts, 1E-10));\r\n\r\n  \t\treturn new Point(latlng.lng * d * r, y);\r\n  \t},\r\n\r\n  \tunproject: function (point) {\r\n  \t\tvar d = 180 / Math.PI,\r\n  \t\t    r = this.R,\r\n  \t\t    tmp = this.R_MINOR / r,\r\n  \t\t    e = Math.sqrt(1 - tmp * tmp),\r\n  \t\t    ts = Math.exp(-point.y / r),\r\n  \t\t    phi = Math.PI / 2 - 2 * Math.atan(ts);\r\n\r\n  \t\tfor (var i = 0, dphi = 0.1, con; i < 15 && Math.abs(dphi) > 1e-7; i++) {\r\n  \t\t\tcon = e * Math.sin(phi);\r\n  \t\t\tcon = Math.pow((1 - con) / (1 + con), e / 2);\r\n  \t\t\tdphi = Math.PI / 2 - 2 * Math.atan(ts * con) - phi;\r\n  \t\t\tphi += dphi;\r\n  \t\t}\r\n\r\n  \t\treturn new LatLng(phi * d, point.x * d / r);\r\n  \t}\r\n  };\n\n  /*\n   * @class Projection\n\n   * An object with methods for projecting geographical coordinates of the world onto\n   * a flat surface (and back). See [Map projection](http://en.wikipedia.org/wiki/Map_projection).\n\n   * @property bounds: Bounds\n   * The bounds (specified in CRS units) where the projection is valid\n\n   * @method project(latlng: LatLng): Point\n   * Projects geographical coordinates into a 2D point.\n   * Only accepts actual `L.LatLng` instances, not arrays.\n\n   * @method unproject(point: Point): LatLng\n   * The inverse of `project`. Projects a 2D point into a geographical location.\n   * Only accepts actual `L.Point` instances, not arrays.\n\n   * Note that the projection instances do not inherit from Leaflet's `Class` object,\n   * and can't be instantiated. Also, new classes can't inherit from them,\n   * and methods can't be added to them with the `include` function.\n\n   */\n\n  var index = ({\n    LonLat: LonLat,\n    Mercator: Mercator,\n    SphericalMercator: SphericalMercator\n  });\n\n  /*\r\n   * @namespace CRS\r\n   * @crs L.CRS.EPSG3395\r\n   *\r\n   * Rarely used by some commercial tile providers. Uses Elliptical Mercator projection.\r\n   */\r\n  var EPSG3395 = extend({}, Earth, {\r\n  \tcode: 'EPSG:3395',\r\n  \tprojection: Mercator,\r\n\r\n  \ttransformation: (function () {\r\n  \t\tvar scale = 0.5 / (Math.PI * Mercator.R);\r\n  \t\treturn toTransformation(scale, 0.5, -scale, 0.5);\r\n  \t}())\r\n  });\n\n  /*\r\n   * @namespace CRS\r\n   * @crs L.CRS.EPSG4326\r\n   *\r\n   * A common CRS among GIS enthusiasts. Uses simple Equirectangular projection.\r\n   *\r\n   * Leaflet 1.0.x complies with the [TMS coordinate scheme for EPSG:4326](https://wiki.osgeo.org/wiki/Tile_Map_Service_Specification#global-geodetic),\r\n   * which is a breaking change from 0.7.x behaviour.  If you are using a `TileLayer`\r\n   * with this CRS, ensure that there are two 256x256 pixel tiles covering the\r\n   * whole earth at zoom level zero, and that the tile coordinate origin is (-180,+90),\r\n   * or (-180,-90) for `TileLayer`s with [the `tms` option](#tilelayer-tms) set.\r\n   */\r\n\r\n  var EPSG4326 = extend({}, Earth, {\r\n  \tcode: 'EPSG:4326',\r\n  \tprojection: LonLat,\r\n  \ttransformation: toTransformation(1 / 180, 1, -1 / 180, 0.5)\r\n  });\n\n  /*\n   * @namespace CRS\n   * @crs L.CRS.Simple\n   *\n   * A simple CRS that maps longitude and latitude into `x` and `y` directly.\n   * May be used for maps of flat surfaces (e.g. game maps). Note that the `y`\n   * axis should still be inverted (going from bottom to top). `distance()` returns\n   * simple euclidean distance.\n   */\n\n  var Simple = extend({}, CRS, {\n  \tprojection: LonLat,\n  \ttransformation: toTransformation(1, 0, -1, 0),\n\n  \tscale: function (zoom) {\n  \t\treturn Math.pow(2, zoom);\n  \t},\n\n  \tzoom: function (scale) {\n  \t\treturn Math.log(scale) / Math.LN2;\n  \t},\n\n  \tdistance: function (latlng1, latlng2) {\n  \t\tvar dx = latlng2.lng - latlng1.lng,\n  \t\t    dy = latlng2.lat - latlng1.lat;\n\n  \t\treturn Math.sqrt(dx * dx + dy * dy);\n  \t},\n\n  \tinfinite: true\n  });\n\n  CRS.Earth = Earth;\n  CRS.EPSG3395 = EPSG3395;\n  CRS.EPSG3857 = EPSG3857;\n  CRS.EPSG900913 = EPSG900913;\n  CRS.EPSG4326 = EPSG4326;\n  CRS.Simple = Simple;\n\n  /*\n   * @class Layer\n   * @inherits Evented\n   * @aka L.Layer\n   * @aka ILayer\n   *\n   * A set of methods from the Layer base class that all Leaflet layers use.\n   * Inherits all methods, options and events from `L.Evented`.\n   *\n   * @example\n   *\n   * ```js\n   * var layer = L.marker(latlng).addTo(map);\n   * layer.addTo(map);\n   * layer.remove();\n   * ```\n   *\n   * @event add: Event\n   * Fired after the layer is added to a map\n   *\n   * @event remove: Event\n   * Fired after the layer is removed from a map\n   */\n\n\n  var Layer = Evented.extend({\n\n  \t// Classes extending `L.Layer` will inherit the following options:\n  \toptions: {\n  \t\t// @option pane: String = 'overlayPane'\n  \t\t// By default the layer will be added to the map's [overlay pane](#map-overlaypane). Overriding this option will cause the layer to be placed on another pane by default.\n  \t\tpane: 'overlayPane',\n\n  \t\t// @option attribution: String = null\n  \t\t// String to be shown in the attribution control, e.g. \"© OpenStreetMap contributors\". It describes the layer data and is often a legal obligation towards copyright holders and tile providers.\n  \t\tattribution: null,\n\n  \t\tbubblingMouseEvents: true\n  \t},\n\n  \t/* @section\n  \t * Classes extending `L.Layer` will inherit the following methods:\n  \t *\n  \t * @method addTo(map: Map|LayerGroup): this\n  \t * Adds the layer to the given map or layer group.\n  \t */\n  \taddTo: function (map) {\n  \t\tmap.addLayer(this);\n  \t\treturn this;\n  \t},\n\n  \t// @method remove: this\n  \t// Removes the layer from the map it is currently active on.\n  \tremove: function () {\n  \t\treturn this.removeFrom(this._map || this._mapToAdd);\n  \t},\n\n  \t// @method removeFrom(map: Map): this\n  \t// Removes the layer from the given map\n  \t//\n  \t// @alternative\n  \t// @method removeFrom(group: LayerGroup): this\n  \t// Removes the layer from the given `LayerGroup`\n  \tremoveFrom: function (obj) {\n  \t\tif (obj) {\n  \t\t\tobj.removeLayer(this);\n  \t\t}\n  \t\treturn this;\n  \t},\n\n  \t// @method getPane(name? : String): HTMLElement\n  \t// Returns the `HTMLElement` representing the named pane on the map. If `name` is omitted, returns the pane for this layer.\n  \tgetPane: function (name) {\n  \t\treturn this._map.getPane(name ? (this.options[name] || name) : this.options.pane);\n  \t},\n\n  \taddInteractiveTarget: function (targetEl) {\n  \t\tthis._map._targets[stamp(targetEl)] = this;\n  \t\treturn this;\n  \t},\n\n  \tremoveInteractiveTarget: function (targetEl) {\n  \t\tdelete this._map._targets[stamp(targetEl)];\n  \t\treturn this;\n  \t},\n\n  \t// @method getAttribution: String\n  \t// Used by the `attribution control`, returns the [attribution option](#gridlayer-attribution).\n  \tgetAttribution: function () {\n  \t\treturn this.options.attribution;\n  \t},\n\n  \t_layerAdd: function (e) {\n  \t\tvar map = e.target;\n\n  \t\t// check in case layer gets added and then removed before the map is ready\n  \t\tif (!map.hasLayer(this)) { return; }\n\n  \t\tthis._map = map;\n  \t\tthis._zoomAnimated = map._zoomAnimated;\n\n  \t\tif (this.getEvents) {\n  \t\t\tvar events = this.getEvents();\n  \t\t\tmap.on(events, this);\n  \t\t\tthis.once('remove', function () {\n  \t\t\t\tmap.off(events, this);\n  \t\t\t}, this);\n  \t\t}\n\n  \t\tthis.onAdd(map);\n\n  \t\tif (this.getAttribution && map.attributionControl) {\n  \t\t\tmap.attributionControl.addAttribution(this.getAttribution());\n  \t\t}\n\n  \t\tthis.fire('add');\n  \t\tmap.fire('layeradd', {layer: this});\n  \t}\n  });\n\n  /* @section Extension methods\n   * @uninheritable\n   *\n   * Every layer should extend from `L.Layer` and (re-)implement the following methods.\n   *\n   * @method onAdd(map: Map): this\n   * Should contain code that creates DOM elements for the layer, adds them to `map panes` where they should belong and puts listeners on relevant map events. Called on [`map.addLayer(layer)`](#map-addlayer).\n   *\n   * @method onRemove(map: Map): this\n   * Should contain all clean up code that removes the layer's elements from the DOM and removes listeners previously added in [`onAdd`](#layer-onadd). Called on [`map.removeLayer(layer)`](#map-removelayer).\n   *\n   * @method getEvents(): Object\n   * This optional method should return an object like `{ viewreset: this._reset }` for [`addEventListener`](#evented-addeventlistener). The event handlers in this object will be automatically added and removed from the map with your layer.\n   *\n   * @method getAttribution(): String\n   * This optional method should return a string containing HTML to be shown on the `Attribution control` whenever the layer is visible.\n   *\n   * @method beforeAdd(map: Map): this\n   * Optional method. Called on [`map.addLayer(layer)`](#map-addlayer), before the layer is added to the map, before events are initialized, without waiting until the map is in a usable state. Use for early initialization only.\n   */\n\n\n  /* @namespace Map\n   * @section Layer events\n   *\n   * @event layeradd: LayerEvent\n   * Fired when a new layer is added to the map.\n   *\n   * @event layerremove: LayerEvent\n   * Fired when some layer is removed from the map\n   *\n   * @section Methods for Layers and Controls\n   */\n  Map.include({\n  \t// @method addLayer(layer: Layer): this\n  \t// Adds the given layer to the map\n  \taddLayer: function (layer) {\n  \t\tif (!layer._layerAdd) {\n  \t\t\tthrow new Error('The provided object is not a Layer.');\n  \t\t}\n\n  \t\tvar id = stamp(layer);\n  \t\tif (this._layers[id]) { return this; }\n  \t\tthis._layers[id] = layer;\n\n  \t\tlayer._mapToAdd = this;\n\n  \t\tif (layer.beforeAdd) {\n  \t\t\tlayer.beforeAdd(this);\n  \t\t}\n\n  \t\tthis.whenReady(layer._layerAdd, layer);\n\n  \t\treturn this;\n  \t},\n\n  \t// @method removeLayer(layer: Layer): this\n  \t// Removes the given layer from the map.\n  \tremoveLayer: function (layer) {\n  \t\tvar id = stamp(layer);\n\n  \t\tif (!this._layers[id]) { return this; }\n\n  \t\tif (this._loaded) {\n  \t\t\tlayer.onRemove(this);\n  \t\t}\n\n  \t\tif (layer.getAttribution && this.attributionControl) {\n  \t\t\tthis.attributionControl.removeAttribution(layer.getAttribution());\n  \t\t}\n\n  \t\tdelete this._layers[id];\n\n  \t\tif (this._loaded) {\n  \t\t\tthis.fire('layerremove', {layer: layer});\n  \t\t\tlayer.fire('remove');\n  \t\t}\n\n  \t\tlayer._map = layer._mapToAdd = null;\n\n  \t\treturn this;\n  \t},\n\n  \t// @method hasLayer(layer: Layer): Boolean\n  \t// Returns `true` if the given layer is currently added to the map\n  \thasLayer: function (layer) {\n  \t\treturn !!layer && (stamp(layer) in this._layers);\n  \t},\n\n  \t/* @method eachLayer(fn: Function, context?: Object): this\n  \t * Iterates over the layers of the map, optionally specifying context of the iterator function.\n  \t * ```\n  \t * map.eachLayer(function(layer){\n  \t *     layer.bindPopup('Hello');\n  \t * });\n  \t * ```\n  \t */\n  \teachLayer: function (method, context) {\n  \t\tfor (var i in this._layers) {\n  \t\t\tmethod.call(context, this._layers[i]);\n  \t\t}\n  \t\treturn this;\n  \t},\n\n  \t_addLayers: function (layers) {\n  \t\tlayers = layers ? (isArray(layers) ? layers : [layers]) : [];\n\n  \t\tfor (var i = 0, len = layers.length; i < len; i++) {\n  \t\t\tthis.addLayer(layers[i]);\n  \t\t}\n  \t},\n\n  \t_addZoomLimit: function (layer) {\n  \t\tif (isNaN(layer.options.maxZoom) || !isNaN(layer.options.minZoom)) {\n  \t\t\tthis._zoomBoundLayers[stamp(layer)] = layer;\n  \t\t\tthis._updateZoomLevels();\n  \t\t}\n  \t},\n\n  \t_removeZoomLimit: function (layer) {\n  \t\tvar id = stamp(layer);\n\n  \t\tif (this._zoomBoundLayers[id]) {\n  \t\t\tdelete this._zoomBoundLayers[id];\n  \t\t\tthis._updateZoomLevels();\n  \t\t}\n  \t},\n\n  \t_updateZoomLevels: function () {\n  \t\tvar minZoom = Infinity,\n  \t\t    maxZoom = -Infinity,\n  \t\t    oldZoomSpan = this._getZoomSpan();\n\n  \t\tfor (var i in this._zoomBoundLayers) {\n  \t\t\tvar options = this._zoomBoundLayers[i].options;\n\n  \t\t\tminZoom = options.minZoom === undefined ? minZoom : Math.min(minZoom, options.minZoom);\n  \t\t\tmaxZoom = options.maxZoom === undefined ? maxZoom : Math.max(maxZoom, options.maxZoom);\n  \t\t}\n\n  \t\tthis._layersMaxZoom = maxZoom === -Infinity ? undefined : maxZoom;\n  \t\tthis._layersMinZoom = minZoom === Infinity ? undefined : minZoom;\n\n  \t\t// @section Map state change events\n  \t\t// @event zoomlevelschange: Event\n  \t\t// Fired when the number of zoomlevels on the map is changed due\n  \t\t// to adding or removing a layer.\n  \t\tif (oldZoomSpan !== this._getZoomSpan()) {\n  \t\t\tthis.fire('zoomlevelschange');\n  \t\t}\n\n  \t\tif (this.options.maxZoom === undefined && this._layersMaxZoom && this.getZoom() > this._layersMaxZoom) {\n  \t\t\tthis.setZoom(this._layersMaxZoom);\n  \t\t}\n  \t\tif (this.options.minZoom === undefined && this._layersMinZoom && this.getZoom() < this._layersMinZoom) {\n  \t\t\tthis.setZoom(this._layersMinZoom);\n  \t\t}\n  \t}\n  });\n\n  /*\r\n   * @class LayerGroup\r\n   * @aka L.LayerGroup\r\n   * @inherits Layer\r\n   *\r\n   * Used to group several layers and handle them as one. If you add it to the map,\r\n   * any layers added or removed from the group will be added/removed on the map as\r\n   * well. Extends `Layer`.\r\n   *\r\n   * @example\r\n   *\r\n   * ```js\r\n   * L.layerGroup([marker1, marker2])\r\n   * \t.addLayer(polyline)\r\n   * \t.addTo(map);\r\n   * ```\r\n   */\r\n\r\n  var LayerGroup = Layer.extend({\r\n\r\n  \tinitialize: function (layers, options) {\r\n  \t\tsetOptions(this, options);\r\n\r\n  \t\tthis._layers = {};\r\n\r\n  \t\tvar i, len;\r\n\r\n  \t\tif (layers) {\r\n  \t\t\tfor (i = 0, len = layers.length; i < len; i++) {\r\n  \t\t\t\tthis.addLayer(layers[i]);\r\n  \t\t\t}\r\n  \t\t}\r\n  \t},\r\n\r\n  \t// @method addLayer(layer: Layer): this\r\n  \t// Adds the given layer to the group.\r\n  \taddLayer: function (layer) {\r\n  \t\tvar id = this.getLayerId(layer);\r\n\r\n  \t\tthis._layers[id] = layer;\r\n\r\n  \t\tif (this._map) {\r\n  \t\t\tthis._map.addLayer(layer);\r\n  \t\t}\r\n\r\n  \t\treturn this;\r\n  \t},\r\n\r\n  \t// @method removeLayer(layer: Layer): this\r\n  \t// Removes the given layer from the group.\r\n  \t// @alternative\r\n  \t// @method removeLayer(id: Number): this\r\n  \t// Removes the layer with the given internal ID from the group.\r\n  \tremoveLayer: function (layer) {\r\n  \t\tvar id = layer in this._layers ? layer : this.getLayerId(layer);\r\n\r\n  \t\tif (this._map && this._layers[id]) {\r\n  \t\t\tthis._map.removeLayer(this._layers[id]);\r\n  \t\t}\r\n\r\n  \t\tdelete this._layers[id];\r\n\r\n  \t\treturn this;\r\n  \t},\r\n\r\n  \t// @method hasLayer(layer: Layer): Boolean\r\n  \t// Returns `true` if the given layer is currently added to the group.\r\n  \t// @alternative\r\n  \t// @method hasLayer(id: Number): Boolean\r\n  \t// Returns `true` if the given internal ID is currently added to the group.\r\n  \thasLayer: function (layer) {\r\n  \t\tif (!layer) { return false; }\r\n  \t\tvar layerId = typeof layer === 'number' ? layer : this.getLayerId(layer);\r\n  \t\treturn layerId in this._layers;\r\n  \t},\r\n\r\n  \t// @method clearLayers(): this\r\n  \t// Removes all the layers from the group.\r\n  \tclearLayers: function () {\r\n  \t\treturn this.eachLayer(this.removeLayer, this);\r\n  \t},\r\n\r\n  \t// @method invoke(methodName: String, …): this\r\n  \t// Calls `methodName` on every layer contained in this group, passing any\r\n  \t// additional parameters. Has no effect if the layers contained do not\r\n  \t// implement `methodName`.\r\n  \tinvoke: function (methodName) {\r\n  \t\tvar args = Array.prototype.slice.call(arguments, 1),\r\n  \t\t    i, layer;\r\n\r\n  \t\tfor (i in this._layers) {\r\n  \t\t\tlayer = this._layers[i];\r\n\r\n  \t\t\tif (layer[methodName]) {\r\n  \t\t\t\tlayer[methodName].apply(layer, args);\r\n  \t\t\t}\r\n  \t\t}\r\n\r\n  \t\treturn this;\r\n  \t},\r\n\r\n  \tonAdd: function (map) {\r\n  \t\tthis.eachLayer(map.addLayer, map);\r\n  \t},\r\n\r\n  \tonRemove: function (map) {\r\n  \t\tthis.eachLayer(map.removeLayer, map);\r\n  \t},\r\n\r\n  \t// @method eachLayer(fn: Function, context?: Object): this\r\n  \t// Iterates over the layers of the group, optionally specifying context of the iterator function.\r\n  \t// ```js\r\n  \t// group.eachLayer(function (layer) {\r\n  \t// \tlayer.bindPopup('Hello');\r\n  \t// });\r\n  \t// ```\r\n  \teachLayer: function (method, context) {\r\n  \t\tfor (var i in this._layers) {\r\n  \t\t\tmethod.call(context, this._layers[i]);\r\n  \t\t}\r\n  \t\treturn this;\r\n  \t},\r\n\r\n  \t// @method getLayer(id: Number): Layer\r\n  \t// Returns the layer with the given internal ID.\r\n  \tgetLayer: function (id) {\r\n  \t\treturn this._layers[id];\r\n  \t},\r\n\r\n  \t// @method getLayers(): Layer[]\r\n  \t// Returns an array of all the layers added to the group.\r\n  \tgetLayers: function () {\r\n  \t\tvar layers = [];\r\n  \t\tthis.eachLayer(layers.push, layers);\r\n  \t\treturn layers;\r\n  \t},\r\n\r\n  \t// @method setZIndex(zIndex: Number): this\r\n  \t// Calls `setZIndex` on every layer contained in this group, passing the z-index.\r\n  \tsetZIndex: function (zIndex) {\r\n  \t\treturn this.invoke('setZIndex', zIndex);\r\n  \t},\r\n\r\n  \t// @method getLayerId(layer: Layer): Number\r\n  \t// Returns the internal ID for a layer\r\n  \tgetLayerId: function (layer) {\r\n  \t\treturn stamp(layer);\r\n  \t}\r\n  });\r\n\r\n\r\n  // @factory L.layerGroup(layers?: Layer[], options?: Object)\r\n  // Create a layer group, optionally given an initial set of layers and an `options` object.\r\n  var layerGroup = function (layers, options) {\r\n  \treturn new LayerGroup(layers, options);\r\n  };\n\n  /*\r\n   * @class FeatureGroup\r\n   * @aka L.FeatureGroup\r\n   * @inherits LayerGroup\r\n   *\r\n   * Extended `LayerGroup` that makes it easier to do the same thing to all its member layers:\r\n   *  * [`bindPopup`](#layer-bindpopup) binds a popup to all of the layers at once (likewise with [`bindTooltip`](#layer-bindtooltip))\r\n   *  * Events are propagated to the `FeatureGroup`, so if the group has an event\r\n   * handler, it will handle events from any of the layers. This includes mouse events\r\n   * and custom events.\r\n   *  * Has `layeradd` and `layerremove` events\r\n   *\r\n   * @example\r\n   *\r\n   * ```js\r\n   * L.featureGroup([marker1, marker2, polyline])\r\n   * \t.bindPopup('Hello world!')\r\n   * \t.on('click', function() { alert('Clicked on a member of the group!'); })\r\n   * \t.addTo(map);\r\n   * ```\r\n   */\r\n\r\n  var FeatureGroup = LayerGroup.extend({\r\n\r\n  \taddLayer: function (layer) {\r\n  \t\tif (this.hasLayer(layer)) {\r\n  \t\t\treturn this;\r\n  \t\t}\r\n\r\n  \t\tlayer.addEventParent(this);\r\n\r\n  \t\tLayerGroup.prototype.addLayer.call(this, layer);\r\n\r\n  \t\t// @event layeradd: LayerEvent\r\n  \t\t// Fired when a layer is added to this `FeatureGroup`\r\n  \t\treturn this.fire('layeradd', {layer: layer});\r\n  \t},\r\n\r\n  \tremoveLayer: function (layer) {\r\n  \t\tif (!this.hasLayer(layer)) {\r\n  \t\t\treturn this;\r\n  \t\t}\r\n  \t\tif (layer in this._layers) {\r\n  \t\t\tlayer = this._layers[layer];\r\n  \t\t}\r\n\r\n  \t\tlayer.removeEventParent(this);\r\n\r\n  \t\tLayerGroup.prototype.removeLayer.call(this, layer);\r\n\r\n  \t\t// @event layerremove: LayerEvent\r\n  \t\t// Fired when a layer is removed from this `FeatureGroup`\r\n  \t\treturn this.fire('layerremove', {layer: layer});\r\n  \t},\r\n\r\n  \t// @method setStyle(style: Path options): this\r\n  \t// Sets the given path options to each layer of the group that has a `setStyle` method.\r\n  \tsetStyle: function (style) {\r\n  \t\treturn this.invoke('setStyle', style);\r\n  \t},\r\n\r\n  \t// @method bringToFront(): this\r\n  \t// Brings the layer group to the top of all other layers\r\n  \tbringToFront: function () {\r\n  \t\treturn this.invoke('bringToFront');\r\n  \t},\r\n\r\n  \t// @method bringToBack(): this\r\n  \t// Brings the layer group to the back of all other layers\r\n  \tbringToBack: function () {\r\n  \t\treturn this.invoke('bringToBack');\r\n  \t},\r\n\r\n  \t// @method getBounds(): LatLngBounds\r\n  \t// Returns the LatLngBounds of the Feature Group (created from bounds and coordinates of its children).\r\n  \tgetBounds: function () {\r\n  \t\tvar bounds = new LatLngBounds();\r\n\r\n  \t\tfor (var id in this._layers) {\r\n  \t\t\tvar layer = this._layers[id];\r\n  \t\t\tbounds.extend(layer.getBounds ? layer.getBounds() : layer.getLatLng());\r\n  \t\t}\r\n  \t\treturn bounds;\r\n  \t}\r\n  });\r\n\r\n  // @factory L.featureGroup(layers?: Layer[], options?: Object)\r\n  // Create a feature group, optionally given an initial set of layers and an `options` object.\r\n  var featureGroup = function (layers, options) {\r\n  \treturn new FeatureGroup(layers, options);\r\n  };\n\n  /*\r\n   * @class Icon\r\n   * @aka L.Icon\r\n   *\r\n   * Represents an icon to provide when creating a marker.\r\n   *\r\n   * @example\r\n   *\r\n   * ```js\r\n   * var myIcon = L.icon({\r\n   *     iconUrl: 'my-icon.png',\r\n   *     iconRetinaUrl: 'my-icon@2x.png',\r\n   *     iconSize: [38, 95],\r\n   *     iconAnchor: [22, 94],\r\n   *     popupAnchor: [-3, -76],\r\n   *     shadowUrl: 'my-icon-shadow.png',\r\n   *     shadowRetinaUrl: 'my-icon-shadow@2x.png',\r\n   *     shadowSize: [68, 95],\r\n   *     shadowAnchor: [22, 94]\r\n   * });\r\n   *\r\n   * L.marker([50.505, 30.57], {icon: myIcon}).addTo(map);\r\n   * ```\r\n   *\r\n   * `L.Icon.Default` extends `L.Icon` and is the blue icon Leaflet uses for markers by default.\r\n   *\r\n   */\r\n\r\n  var Icon = Class.extend({\r\n\r\n  \t/* @section\r\n  \t * @aka Icon options\r\n  \t *\r\n  \t * @option iconUrl: String = null\r\n  \t * **(required)** The URL to the icon image (absolute or relative to your script path).\r\n  \t *\r\n  \t * @option iconRetinaUrl: String = null\r\n  \t * The URL to a retina sized version of the icon image (absolute or relative to your\r\n  \t * script path). Used for Retina screen devices.\r\n  \t *\r\n  \t * @option iconSize: Point = null\r\n  \t * Size of the icon image in pixels.\r\n  \t *\r\n  \t * @option iconAnchor: Point = null\r\n  \t * The coordinates of the \"tip\" of the icon (relative to its top left corner). The icon\r\n  \t * will be aligned so that this point is at the marker's geographical location. Centered\r\n  \t * by default if size is specified, also can be set in CSS with negative margins.\r\n  \t *\r\n  \t * @option popupAnchor: Point = [0, 0]\r\n  \t * The coordinates of the point from which popups will \"open\", relative to the icon anchor.\r\n  \t *\r\n  \t * @option tooltipAnchor: Point = [0, 0]\r\n  \t * The coordinates of the point from which tooltips will \"open\", relative to the icon anchor.\r\n  \t *\r\n  \t * @option shadowUrl: String = null\r\n  \t * The URL to the icon shadow image. If not specified, no shadow image will be created.\r\n  \t *\r\n  \t * @option shadowRetinaUrl: String = null\r\n  \t *\r\n  \t * @option shadowSize: Point = null\r\n  \t * Size of the shadow image in pixels.\r\n  \t *\r\n  \t * @option shadowAnchor: Point = null\r\n  \t * The coordinates of the \"tip\" of the shadow (relative to its top left corner) (the same\r\n  \t * as iconAnchor if not specified).\r\n  \t *\r\n  \t * @option className: String = ''\r\n  \t * A custom class name to assign to both icon and shadow images. Empty by default.\r\n  \t */\r\n\r\n  \toptions: {\r\n  \t\tpopupAnchor: [0, 0],\r\n  \t\ttooltipAnchor: [0, 0]\r\n  \t},\r\n\r\n  \tinitialize: function (options) {\r\n  \t\tsetOptions(this, options);\r\n  \t},\r\n\r\n  \t// @method createIcon(oldIcon?: HTMLElement): HTMLElement\r\n  \t// Called internally when the icon has to be shown, returns a `<img>` HTML element\r\n  \t// styled according to the options.\r\n  \tcreateIcon: function (oldIcon) {\r\n  \t\treturn this._createIcon('icon', oldIcon);\r\n  \t},\r\n\r\n  \t// @method createShadow(oldIcon?: HTMLElement): HTMLElement\r\n  \t// As `createIcon`, but for the shadow beneath it.\r\n  \tcreateShadow: function (oldIcon) {\r\n  \t\treturn this._createIcon('shadow', oldIcon);\r\n  \t},\r\n\r\n  \t_createIcon: function (name, oldIcon) {\r\n  \t\tvar src = this._getIconUrl(name);\r\n\r\n  \t\tif (!src) {\r\n  \t\t\tif (name === 'icon') {\r\n  \t\t\t\tthrow new Error('iconUrl not set in Icon options (see the docs).');\r\n  \t\t\t}\r\n  \t\t\treturn null;\r\n  \t\t}\r\n\r\n  \t\tvar img = this._createImg(src, oldIcon && oldIcon.tagName === 'IMG' ? oldIcon : null);\r\n  \t\tthis._setIconStyles(img, name);\r\n\r\n  \t\treturn img;\r\n  \t},\r\n\r\n  \t_setIconStyles: function (img, name) {\r\n  \t\tvar options = this.options;\r\n  \t\tvar sizeOption = options[name + 'Size'];\r\n\r\n  \t\tif (typeof sizeOption === 'number') {\r\n  \t\t\tsizeOption = [sizeOption, sizeOption];\r\n  \t\t}\r\n\r\n  \t\tvar size = toPoint(sizeOption),\r\n  \t\t    anchor = toPoint(name === 'shadow' && options.shadowAnchor || options.iconAnchor ||\r\n  \t\t            size && size.divideBy(2, true));\r\n\r\n  \t\timg.className = 'leaflet-marker-' + name + ' ' + (options.className || '');\r\n\r\n  \t\tif (anchor) {\r\n  \t\t\timg.style.marginLeft = (-anchor.x) + 'px';\r\n  \t\t\timg.style.marginTop  = (-anchor.y) + 'px';\r\n  \t\t}\r\n\r\n  \t\tif (size) {\r\n  \t\t\timg.style.width  = size.x + 'px';\r\n  \t\t\timg.style.height = size.y + 'px';\r\n  \t\t}\r\n  \t},\r\n\r\n  \t_createImg: function (src, el) {\r\n  \t\tel = el || document.createElement('img');\r\n  \t\tel.src = src;\r\n  \t\treturn el;\r\n  \t},\r\n\r\n  \t_getIconUrl: function (name) {\r\n  \t\treturn retina && this.options[name + 'RetinaUrl'] || this.options[name + 'Url'];\r\n  \t}\r\n  });\r\n\r\n\r\n  // @factory L.icon(options: Icon options)\r\n  // Creates an icon instance with the given options.\r\n  function icon(options) {\r\n  \treturn new Icon(options);\r\n  }\n\n  /*\n   * @miniclass Icon.Default (Icon)\n   * @aka L.Icon.Default\n   * @section\n   *\n   * A trivial subclass of `Icon`, represents the icon to use in `Marker`s when\n   * no icon is specified. Points to the blue marker image distributed with Leaflet\n   * releases.\n   *\n   * In order to customize the default icon, just change the properties of `L.Icon.Default.prototype.options`\n   * (which is a set of `Icon options`).\n   *\n   * If you want to _completely_ replace the default icon, override the\n   * `L.Marker.prototype.options.icon` with your own icon instead.\n   */\n\n  var IconDefault = Icon.extend({\n\n  \toptions: {\n  \t\ticonUrl:       'marker-icon.png',\n  \t\ticonRetinaUrl: 'marker-icon-2x.png',\n  \t\tshadowUrl:     'marker-shadow.png',\n  \t\ticonSize:    [25, 41],\n  \t\ticonAnchor:  [12, 41],\n  \t\tpopupAnchor: [1, -34],\n  \t\ttooltipAnchor: [16, -28],\n  \t\tshadowSize:  [41, 41]\n  \t},\n\n  \t_getIconUrl: function (name) {\n  \t\tif (!IconDefault.imagePath) {\t// Deprecated, backwards-compatibility only\n  \t\t\tIconDefault.imagePath = this._detectIconPath();\n  \t\t}\n\n  \t\t// @option imagePath: String\n  \t\t// `Icon.Default` will try to auto-detect the location of the\n  \t\t// blue icon images. If you are placing these images in a non-standard\n  \t\t// way, set this option to point to the right path.\n  \t\treturn (this.options.imagePath || IconDefault.imagePath) + Icon.prototype._getIconUrl.call(this, name);\n  \t},\n\n  \t_detectIconPath: function () {\n  \t\tvar el = create$1('div',  'leaflet-default-icon-path', document.body);\n  \t\tvar path = getStyle(el, 'background-image') ||\n  \t\t           getStyle(el, 'backgroundImage');\t// IE8\n\n  \t\tdocument.body.removeChild(el);\n\n  \t\tif (path === null || path.indexOf('url') !== 0) {\n  \t\t\tpath = '';\n  \t\t} else {\n  \t\t\tpath = path.replace(/^url\\([\"']?/, '').replace(/marker-icon\\.png[\"']?\\)$/, '');\n  \t\t}\n\n  \t\treturn path;\n  \t}\n  });\n\n  /*\n   * L.Handler.MarkerDrag is used internally by L.Marker to make the markers draggable.\n   */\n\n\n  /* @namespace Marker\n   * @section Interaction handlers\n   *\n   * Interaction handlers are properties of a marker instance that allow you to control interaction behavior in runtime, enabling or disabling certain features such as dragging (see `Handler` methods). Example:\n   *\n   * ```js\n   * marker.dragging.disable();\n   * ```\n   *\n   * @property dragging: Handler\n   * Marker dragging handler (by both mouse and touch). Only valid when the marker is on the map (Otherwise set [`marker.options.draggable`](#marker-draggable)).\n   */\n\n  var MarkerDrag = Handler.extend({\n  \tinitialize: function (marker) {\n  \t\tthis._marker = marker;\n  \t},\n\n  \taddHooks: function () {\n  \t\tvar icon = this._marker._icon;\n\n  \t\tif (!this._draggable) {\n  \t\t\tthis._draggable = new Draggable(icon, icon, true);\n  \t\t}\n\n  \t\tthis._draggable.on({\n  \t\t\tdragstart: this._onDragStart,\n  \t\t\tpredrag: this._onPreDrag,\n  \t\t\tdrag: this._onDrag,\n  \t\t\tdragend: this._onDragEnd\n  \t\t}, this).enable();\n\n  \t\taddClass(icon, 'leaflet-marker-draggable');\n  \t},\n\n  \tremoveHooks: function () {\n  \t\tthis._draggable.off({\n  \t\t\tdragstart: this._onDragStart,\n  \t\t\tpredrag: this._onPreDrag,\n  \t\t\tdrag: this._onDrag,\n  \t\t\tdragend: this._onDragEnd\n  \t\t}, this).disable();\n\n  \t\tif (this._marker._icon) {\n  \t\t\tremoveClass(this._marker._icon, 'leaflet-marker-draggable');\n  \t\t}\n  \t},\n\n  \tmoved: function () {\n  \t\treturn this._draggable && this._draggable._moved;\n  \t},\n\n  \t_adjustPan: function (e) {\n  \t\tvar marker = this._marker,\n  \t\t    map = marker._map,\n  \t\t    speed = this._marker.options.autoPanSpeed,\n  \t\t    padding = this._marker.options.autoPanPadding,\n  \t\t    iconPos = getPosition(marker._icon),\n  \t\t    bounds = map.getPixelBounds(),\n  \t\t    origin = map.getPixelOrigin();\n\n  \t\tvar panBounds = toBounds(\n  \t\t\tbounds.min._subtract(origin).add(padding),\n  \t\t\tbounds.max._subtract(origin).subtract(padding)\n  \t\t);\n\n  \t\tif (!panBounds.contains(iconPos)) {\n  \t\t\t// Compute incremental movement\n  \t\t\tvar movement = toPoint(\n  \t\t\t\t(Math.max(panBounds.max.x, iconPos.x) - panBounds.max.x) / (bounds.max.x - panBounds.max.x) -\n  \t\t\t\t(Math.min(panBounds.min.x, iconPos.x) - panBounds.min.x) / (bounds.min.x - panBounds.min.x),\n\n  \t\t\t\t(Math.max(panBounds.max.y, iconPos.y) - panBounds.max.y) / (bounds.max.y - panBounds.max.y) -\n  \t\t\t\t(Math.min(panBounds.min.y, iconPos.y) - panBounds.min.y) / (bounds.min.y - panBounds.min.y)\n  \t\t\t).multiplyBy(speed);\n\n  \t\t\tmap.panBy(movement, {animate: false});\n\n  \t\t\tthis._draggable._newPos._add(movement);\n  \t\t\tthis._draggable._startPos._add(movement);\n\n  \t\t\tsetPosition(marker._icon, this._draggable._newPos);\n  \t\t\tthis._onDrag(e);\n\n  \t\t\tthis._panRequest = requestAnimFrame(this._adjustPan.bind(this, e));\n  \t\t}\n  \t},\n\n  \t_onDragStart: function () {\n  \t\t// @section Dragging events\n  \t\t// @event dragstart: Event\n  \t\t// Fired when the user starts dragging the marker.\n\n  \t\t// @event movestart: Event\n  \t\t// Fired when the marker starts moving (because of dragging).\n\n  \t\tthis._oldLatLng = this._marker.getLatLng();\n\n  \t\t// When using ES6 imports it could not be set when `Popup` was not imported as well\n  \t\tthis._marker.closePopup && this._marker.closePopup();\n\n  \t\tthis._marker\n  \t\t\t.fire('movestart')\n  \t\t\t.fire('dragstart');\n  \t},\n\n  \t_onPreDrag: function (e) {\n  \t\tif (this._marker.options.autoPan) {\n  \t\t\tcancelAnimFrame(this._panRequest);\n  \t\t\tthis._panRequest = requestAnimFrame(this._adjustPan.bind(this, e));\n  \t\t}\n  \t},\n\n  \t_onDrag: function (e) {\n  \t\tvar marker = this._marker,\n  \t\t    shadow = marker._shadow,\n  \t\t    iconPos = getPosition(marker._icon),\n  \t\t    latlng = marker._map.layerPointToLatLng(iconPos);\n\n  \t\t// update shadow position\n  \t\tif (shadow) {\n  \t\t\tsetPosition(shadow, iconPos);\n  \t\t}\n\n  \t\tmarker._latlng = latlng;\n  \t\te.latlng = latlng;\n  \t\te.oldLatLng = this._oldLatLng;\n\n  \t\t// @event drag: Event\n  \t\t// Fired repeatedly while the user drags the marker.\n  \t\tmarker\n  \t\t    .fire('move', e)\n  \t\t    .fire('drag', e);\n  \t},\n\n  \t_onDragEnd: function (e) {\n  \t\t// @event dragend: DragEndEvent\n  \t\t// Fired when the user stops dragging the marker.\n\n  \t\t cancelAnimFrame(this._panRequest);\n\n  \t\t// @event moveend: Event\n  \t\t// Fired when the marker stops moving (because of dragging).\n  \t\tdelete this._oldLatLng;\n  \t\tthis._marker\n  \t\t    .fire('moveend')\n  \t\t    .fire('dragend', e);\n  \t}\n  });\n\n  /*\r\n   * @class Marker\r\n   * @inherits Interactive layer\r\n   * @aka L.Marker\r\n   * L.Marker is used to display clickable/draggable icons on the map. Extends `Layer`.\r\n   *\r\n   * @example\r\n   *\r\n   * ```js\r\n   * L.marker([50.5, 30.5]).addTo(map);\r\n   * ```\r\n   */\r\n\r\n  var Marker = Layer.extend({\r\n\r\n  \t// @section\r\n  \t// @aka Marker options\r\n  \toptions: {\r\n  \t\t// @option icon: Icon = *\r\n  \t\t// Icon instance to use for rendering the marker.\r\n  \t\t// See [Icon documentation](#L.Icon) for details on how to customize the marker icon.\r\n  \t\t// If not specified, a common instance of `L.Icon.Default` is used.\r\n  \t\ticon: new IconDefault(),\r\n\r\n  \t\t// Option inherited from \"Interactive layer\" abstract class\r\n  \t\tinteractive: true,\r\n\r\n  \t\t// @option keyboard: Boolean = true\r\n  \t\t// Whether the marker can be tabbed to with a keyboard and clicked by pressing enter.\r\n  \t\tkeyboard: true,\r\n\r\n  \t\t// @option title: String = ''\r\n  \t\t// Text for the browser tooltip that appear on marker hover (no tooltip by default).\r\n  \t\ttitle: '',\r\n\r\n  \t\t// @option alt: String = ''\r\n  \t\t// Text for the `alt` attribute of the icon image (useful for accessibility).\r\n  \t\talt: '',\r\n\r\n  \t\t// @option zIndexOffset: Number = 0\r\n  \t\t// By default, marker images zIndex is set automatically based on its latitude. Use this option if you want to put the marker on top of all others (or below), specifying a high value like `1000` (or high negative value, respectively).\r\n  \t\tzIndexOffset: 0,\r\n\r\n  \t\t// @option opacity: Number = 1.0\r\n  \t\t// The opacity of the marker.\r\n  \t\topacity: 1,\r\n\r\n  \t\t// @option riseOnHover: Boolean = false\r\n  \t\t// If `true`, the marker will get on top of others when you hover the mouse over it.\r\n  \t\triseOnHover: false,\r\n\r\n  \t\t// @option riseOffset: Number = 250\r\n  \t\t// The z-index offset used for the `riseOnHover` feature.\r\n  \t\triseOffset: 250,\r\n\r\n  \t\t// @option pane: String = 'markerPane'\r\n  \t\t// `Map pane` where the markers icon will be added.\r\n  \t\tpane: 'markerPane',\r\n\r\n  \t\t// @option shadowPane: String = 'shadowPane'\r\n  \t\t// `Map pane` where the markers shadow will be added.\r\n  \t\tshadowPane: 'shadowPane',\r\n\r\n  \t\t// @option bubblingMouseEvents: Boolean = false\r\n  \t\t// When `true`, a mouse event on this marker will trigger the same event on the map\r\n  \t\t// (unless [`L.DomEvent.stopPropagation`](#domevent-stoppropagation) is used).\r\n  \t\tbubblingMouseEvents: false,\r\n\r\n  \t\t// @section Draggable marker options\r\n  \t\t// @option draggable: Boolean = false\r\n  \t\t// Whether the marker is draggable with mouse/touch or not.\r\n  \t\tdraggable: false,\r\n\r\n  \t\t// @option autoPan: Boolean = false\r\n  \t\t// Whether to pan the map when dragging this marker near its edge or not.\r\n  \t\tautoPan: false,\r\n\r\n  \t\t// @option autoPanPadding: Point = Point(50, 50)\r\n  \t\t// Distance (in pixels to the left/right and to the top/bottom) of the\r\n  \t\t// map edge to start panning the map.\r\n  \t\tautoPanPadding: [50, 50],\r\n\r\n  \t\t// @option autoPanSpeed: Number = 10\r\n  \t\t// Number of pixels the map should pan by.\r\n  \t\tautoPanSpeed: 10\r\n  \t},\r\n\r\n  \t/* @section\r\n  \t *\r\n  \t * In addition to [shared layer methods](#Layer) like `addTo()` and `remove()` and [popup methods](#Popup) like bindPopup() you can also use the following methods:\r\n  \t */\r\n\r\n  \tinitialize: function (latlng, options) {\r\n  \t\tsetOptions(this, options);\r\n  \t\tthis._latlng = toLatLng(latlng);\r\n  \t},\r\n\r\n  \tonAdd: function (map) {\r\n  \t\tthis._zoomAnimated = this._zoomAnimated && map.options.markerZoomAnimation;\r\n\r\n  \t\tif (this._zoomAnimated) {\r\n  \t\t\tmap.on('zoomanim', this._animateZoom, this);\r\n  \t\t}\r\n\r\n  \t\tthis._initIcon();\r\n  \t\tthis.update();\r\n  \t},\r\n\r\n  \tonRemove: function (map) {\r\n  \t\tif (this.dragging && this.dragging.enabled()) {\r\n  \t\t\tthis.options.draggable = true;\r\n  \t\t\tthis.dragging.removeHooks();\r\n  \t\t}\r\n  \t\tdelete this.dragging;\r\n\r\n  \t\tif (this._zoomAnimated) {\r\n  \t\t\tmap.off('zoomanim', this._animateZoom, this);\r\n  \t\t}\r\n\r\n  \t\tthis._removeIcon();\r\n  \t\tthis._removeShadow();\r\n  \t},\r\n\r\n  \tgetEvents: function () {\r\n  \t\treturn {\r\n  \t\t\tzoom: this.update,\r\n  \t\t\tviewreset: this.update\r\n  \t\t};\r\n  \t},\r\n\r\n  \t// @method getLatLng: LatLng\r\n  \t// Returns the current geographical position of the marker.\r\n  \tgetLatLng: function () {\r\n  \t\treturn this._latlng;\r\n  \t},\r\n\r\n  \t// @method setLatLng(latlng: LatLng): this\r\n  \t// Changes the marker position to the given point.\r\n  \tsetLatLng: function (latlng) {\r\n  \t\tvar oldLatLng = this._latlng;\r\n  \t\tthis._latlng = toLatLng(latlng);\r\n  \t\tthis.update();\r\n\r\n  \t\t// @event move: Event\r\n  \t\t// Fired when the marker is moved via [`setLatLng`](#marker-setlatlng) or by [dragging](#marker-dragging). Old and new coordinates are included in event arguments as `oldLatLng`, `latlng`.\r\n  \t\treturn this.fire('move', {oldLatLng: oldLatLng, latlng: this._latlng});\r\n  \t},\r\n\r\n  \t// @method setZIndexOffset(offset: Number): this\r\n  \t// Changes the [zIndex offset](#marker-zindexoffset) of the marker.\r\n  \tsetZIndexOffset: function (offset) {\r\n  \t\tthis.options.zIndexOffset = offset;\r\n  \t\treturn this.update();\r\n  \t},\r\n\r\n  \t// @method getIcon: Icon\r\n  \t// Returns the current icon used by the marker\r\n  \tgetIcon: function () {\r\n  \t\treturn this.options.icon;\r\n  \t},\r\n\r\n  \t// @method setIcon(icon: Icon): this\r\n  \t// Changes the marker icon.\r\n  \tsetIcon: function (icon) {\r\n\r\n  \t\tthis.options.icon = icon;\r\n\r\n  \t\tif (this._map) {\r\n  \t\t\tthis._initIcon();\r\n  \t\t\tthis.update();\r\n  \t\t}\r\n\r\n  \t\tif (this._popup) {\r\n  \t\t\tthis.bindPopup(this._popup, this._popup.options);\r\n  \t\t}\r\n\r\n  \t\treturn this;\r\n  \t},\r\n\r\n  \tgetElement: function () {\r\n  \t\treturn this._icon;\r\n  \t},\r\n\r\n  \tupdate: function () {\r\n\r\n  \t\tif (this._icon && this._map) {\r\n  \t\t\tvar pos = this._map.latLngToLayerPoint(this._latlng).round();\r\n  \t\t\tthis._setPos(pos);\r\n  \t\t}\r\n\r\n  \t\treturn this;\r\n  \t},\r\n\r\n  \t_initIcon: function () {\r\n  \t\tvar options = this.options,\r\n  \t\t    classToAdd = 'leaflet-zoom-' + (this._zoomAnimated ? 'animated' : 'hide');\r\n\r\n  \t\tvar icon = options.icon.createIcon(this._icon),\r\n  \t\t    addIcon = false;\r\n\r\n  \t\t// if we're not reusing the icon, remove the old one and init new one\r\n  \t\tif (icon !== this._icon) {\r\n  \t\t\tif (this._icon) {\r\n  \t\t\t\tthis._removeIcon();\r\n  \t\t\t}\r\n  \t\t\taddIcon = true;\r\n\r\n  \t\t\tif (options.title) {\r\n  \t\t\t\ticon.title = options.title;\r\n  \t\t\t}\r\n\r\n  \t\t\tif (icon.tagName === 'IMG') {\r\n  \t\t\t\ticon.alt = options.alt || '';\r\n  \t\t\t}\r\n  \t\t}\r\n\r\n  \t\taddClass(icon, classToAdd);\r\n\r\n  \t\tif (options.keyboard) {\r\n  \t\t\ticon.tabIndex = '0';\r\n  \t\t}\r\n\r\n  \t\tthis._icon = icon;\r\n\r\n  \t\tif (options.riseOnHover) {\r\n  \t\t\tthis.on({\r\n  \t\t\t\tmouseover: this._bringToFront,\r\n  \t\t\t\tmouseout: this._resetZIndex\r\n  \t\t\t});\r\n  \t\t}\r\n\r\n  \t\tvar newShadow = options.icon.createShadow(this._shadow),\r\n  \t\t    addShadow = false;\r\n\r\n  \t\tif (newShadow !== this._shadow) {\r\n  \t\t\tthis._removeShadow();\r\n  \t\t\taddShadow = true;\r\n  \t\t}\r\n\r\n  \t\tif (newShadow) {\r\n  \t\t\taddClass(newShadow, classToAdd);\r\n  \t\t\tnewShadow.alt = '';\r\n  \t\t}\r\n  \t\tthis._shadow = newShadow;\r\n\r\n\r\n  \t\tif (options.opacity < 1) {\r\n  \t\t\tthis._updateOpacity();\r\n  \t\t}\r\n\r\n\r\n  \t\tif (addIcon) {\r\n  \t\t\tthis.getPane().appendChild(this._icon);\r\n  \t\t}\r\n  \t\tthis._initInteraction();\r\n  \t\tif (newShadow && addShadow) {\r\n  \t\t\tthis.getPane(options.shadowPane).appendChild(this._shadow);\r\n  \t\t}\r\n  \t},\r\n\r\n  \t_removeIcon: function () {\r\n  \t\tif (this.options.riseOnHover) {\r\n  \t\t\tthis.off({\r\n  \t\t\t\tmouseover: this._bringToFront,\r\n  \t\t\t\tmouseout: this._resetZIndex\r\n  \t\t\t});\r\n  \t\t}\r\n\r\n  \t\tremove(this._icon);\r\n  \t\tthis.removeInteractiveTarget(this._icon);\r\n\r\n  \t\tthis._icon = null;\r\n  \t},\r\n\r\n  \t_removeShadow: function () {\r\n  \t\tif (this._shadow) {\r\n  \t\t\tremove(this._shadow);\r\n  \t\t}\r\n  \t\tthis._shadow = null;\r\n  \t},\r\n\r\n  \t_setPos: function (pos) {\r\n\r\n  \t\tif (this._icon) {\r\n  \t\t\tsetPosition(this._icon, pos);\r\n  \t\t}\r\n\r\n  \t\tif (this._shadow) {\r\n  \t\t\tsetPosition(this._shadow, pos);\r\n  \t\t}\r\n\r\n  \t\tthis._zIndex = pos.y + this.options.zIndexOffset;\r\n\r\n  \t\tthis._resetZIndex();\r\n  \t},\r\n\r\n  \t_updateZIndex: function (offset) {\r\n  \t\tif (this._icon) {\r\n  \t\t\tthis._icon.style.zIndex = this._zIndex + offset;\r\n  \t\t}\r\n  \t},\r\n\r\n  \t_animateZoom: function (opt) {\r\n  \t\tvar pos = this._map._latLngToNewLayerPoint(this._latlng, opt.zoom, opt.center).round();\r\n\r\n  \t\tthis._setPos(pos);\r\n  \t},\r\n\r\n  \t_initInteraction: function () {\r\n\r\n  \t\tif (!this.options.interactive) { return; }\r\n\r\n  \t\taddClass(this._icon, 'leaflet-interactive');\r\n\r\n  \t\tthis.addInteractiveTarget(this._icon);\r\n\r\n  \t\tif (MarkerDrag) {\r\n  \t\t\tvar draggable = this.options.draggable;\r\n  \t\t\tif (this.dragging) {\r\n  \t\t\t\tdraggable = this.dragging.enabled();\r\n  \t\t\t\tthis.dragging.disable();\r\n  \t\t\t}\r\n\r\n  \t\t\tthis.dragging = new MarkerDrag(this);\r\n\r\n  \t\t\tif (draggable) {\r\n  \t\t\t\tthis.dragging.enable();\r\n  \t\t\t}\r\n  \t\t}\r\n  \t},\r\n\r\n  \t// @method setOpacity(opacity: Number): this\r\n  \t// Changes the opacity of the marker.\r\n  \tsetOpacity: function (opacity) {\r\n  \t\tthis.options.opacity = opacity;\r\n  \t\tif (this._map) {\r\n  \t\t\tthis._updateOpacity();\r\n  \t\t}\r\n\r\n  \t\treturn this;\r\n  \t},\r\n\r\n  \t_updateOpacity: function () {\r\n  \t\tvar opacity = this.options.opacity;\r\n\r\n  \t\tif (this._icon) {\r\n  \t\t\tsetOpacity(this._icon, opacity);\r\n  \t\t}\r\n\r\n  \t\tif (this._shadow) {\r\n  \t\t\tsetOpacity(this._shadow, opacity);\r\n  \t\t}\r\n  \t},\r\n\r\n  \t_bringToFront: function () {\r\n  \t\tthis._updateZIndex(this.options.riseOffset);\r\n  \t},\r\n\r\n  \t_resetZIndex: function () {\r\n  \t\tthis._updateZIndex(0);\r\n  \t},\r\n\r\n  \t_getPopupAnchor: function () {\r\n  \t\treturn this.options.icon.options.popupAnchor;\r\n  \t},\r\n\r\n  \t_getTooltipAnchor: function () {\r\n  \t\treturn this.options.icon.options.tooltipAnchor;\r\n  \t}\r\n  });\r\n\r\n\r\n  // factory L.marker(latlng: LatLng, options? : Marker options)\r\n\r\n  // @factory L.marker(latlng: LatLng, options? : Marker options)\r\n  // Instantiates a Marker object given a geographical point and optionally an options object.\r\n  function marker(latlng, options) {\r\n  \treturn new Marker(latlng, options);\r\n  }\n\n  /*\n   * @class Path\n   * @aka L.Path\n   * @inherits Interactive layer\n   *\n   * An abstract class that contains options and constants shared between vector\n   * overlays (Polygon, Polyline, Circle). Do not use it directly. Extends `Layer`.\n   */\n\n  var Path = Layer.extend({\n\n  \t// @section\n  \t// @aka Path options\n  \toptions: {\n  \t\t// @option stroke: Boolean = true\n  \t\t// Whether to draw stroke along the path. Set it to `false` to disable borders on polygons or circles.\n  \t\tstroke: true,\n\n  \t\t// @option color: String = '#3388ff'\n  \t\t// Stroke color\n  \t\tcolor: '#3388ff',\n\n  \t\t// @option weight: Number = 3\n  \t\t// Stroke width in pixels\n  \t\tweight: 3,\n\n  \t\t// @option opacity: Number = 1.0\n  \t\t// Stroke opacity\n  \t\topacity: 1,\n\n  \t\t// @option lineCap: String= 'round'\n  \t\t// A string that defines [shape to be used at the end](https://developer.mozilla.org/docs/Web/SVG/Attribute/stroke-linecap) of the stroke.\n  \t\tlineCap: 'round',\n\n  \t\t// @option lineJoin: String = 'round'\n  \t\t// A string that defines [shape to be used at the corners](https://developer.mozilla.org/docs/Web/SVG/Attribute/stroke-linejoin) of the stroke.\n  \t\tlineJoin: 'round',\n\n  \t\t// @option dashArray: String = null\n  \t\t// A string that defines the stroke [dash pattern](https://developer.mozilla.org/docs/Web/SVG/Attribute/stroke-dasharray). Doesn't work on `Canvas`-powered layers in [some old browsers](https://developer.mozilla.org/docs/Web/API/CanvasRenderingContext2D/setLineDash#Browser_compatibility).\n  \t\tdashArray: null,\n\n  \t\t// @option dashOffset: String = null\n  \t\t// A string that defines the [distance into the dash pattern to start the dash](https://developer.mozilla.org/docs/Web/SVG/Attribute/stroke-dashoffset). Doesn't work on `Canvas`-powered layers in [some old browsers](https://developer.mozilla.org/docs/Web/API/CanvasRenderingContext2D/setLineDash#Browser_compatibility).\n  \t\tdashOffset: null,\n\n  \t\t// @option fill: Boolean = depends\n  \t\t// Whether to fill the path with color. Set it to `false` to disable filling on polygons or circles.\n  \t\tfill: false,\n\n  \t\t// @option fillColor: String = *\n  \t\t// Fill color. Defaults to the value of the [`color`](#path-color) option\n  \t\tfillColor: null,\n\n  \t\t// @option fillOpacity: Number = 0.2\n  \t\t// Fill opacity.\n  \t\tfillOpacity: 0.2,\n\n  \t\t// @option fillRule: String = 'evenodd'\n  \t\t// A string that defines [how the inside of a shape](https://developer.mozilla.org/docs/Web/SVG/Attribute/fill-rule) is determined.\n  \t\tfillRule: 'evenodd',\n\n  \t\t// className: '',\n\n  \t\t// Option inherited from \"Interactive layer\" abstract class\n  \t\tinteractive: true,\n\n  \t\t// @option bubblingMouseEvents: Boolean = true\n  \t\t// When `true`, a mouse event on this path will trigger the same event on the map\n  \t\t// (unless [`L.DomEvent.stopPropagation`](#domevent-stoppropagation) is used).\n  \t\tbubblingMouseEvents: true\n  \t},\n\n  \tbeforeAdd: function (map) {\n  \t\t// Renderer is set here because we need to call renderer.getEvents\n  \t\t// before this.getEvents.\n  \t\tthis._renderer = map.getRenderer(this);\n  \t},\n\n  \tonAdd: function () {\n  \t\tthis._renderer._initPath(this);\n  \t\tthis._reset();\n  \t\tthis._renderer._addPath(this);\n  \t},\n\n  \tonRemove: function () {\n  \t\tthis._renderer._removePath(this);\n  \t},\n\n  \t// @method redraw(): this\n  \t// Redraws the layer. Sometimes useful after you changed the coordinates that the path uses.\n  \tredraw: function () {\n  \t\tif (this._map) {\n  \t\t\tthis._renderer._updatePath(this);\n  \t\t}\n  \t\treturn this;\n  \t},\n\n  \t// @method setStyle(style: Path options): this\n  \t// Changes the appearance of a Path based on the options in the `Path options` object.\n  \tsetStyle: function (style) {\n  \t\tsetOptions(this, style);\n  \t\tif (this._renderer) {\n  \t\t\tthis._renderer._updateStyle(this);\n  \t\t\tif (this.options.stroke && style && Object.prototype.hasOwnProperty.call(style, 'weight')) {\n  \t\t\t\tthis._updateBounds();\n  \t\t\t}\n  \t\t}\n  \t\treturn this;\n  \t},\n\n  \t// @method bringToFront(): this\n  \t// Brings the layer to the top of all path layers.\n  \tbringToFront: function () {\n  \t\tif (this._renderer) {\n  \t\t\tthis._renderer._bringToFront(this);\n  \t\t}\n  \t\treturn this;\n  \t},\n\n  \t// @method bringToBack(): this\n  \t// Brings the layer to the bottom of all path layers.\n  \tbringToBack: function () {\n  \t\tif (this._renderer) {\n  \t\t\tthis._renderer._bringToBack(this);\n  \t\t}\n  \t\treturn this;\n  \t},\n\n  \tgetElement: function () {\n  \t\treturn this._path;\n  \t},\n\n  \t_reset: function () {\n  \t\t// defined in child classes\n  \t\tthis._project();\n  \t\tthis._update();\n  \t},\n\n  \t_clickTolerance: function () {\n  \t\t// used when doing hit detection for Canvas layers\n  \t\treturn (this.options.stroke ? this.options.weight / 2 : 0) + this._renderer.options.tolerance;\n  \t}\n  });\n\n  /*\n   * @class CircleMarker\n   * @aka L.CircleMarker\n   * @inherits Path\n   *\n   * A circle of a fixed size with radius specified in pixels. Extends `Path`.\n   */\n\n  var CircleMarker = Path.extend({\n\n  \t// @section\n  \t// @aka CircleMarker options\n  \toptions: {\n  \t\tfill: true,\n\n  \t\t// @option radius: Number = 10\n  \t\t// Radius of the circle marker, in pixels\n  \t\tradius: 10\n  \t},\n\n  \tinitialize: function (latlng, options) {\n  \t\tsetOptions(this, options);\n  \t\tthis._latlng = toLatLng(latlng);\n  \t\tthis._radius = this.options.radius;\n  \t},\n\n  \t// @method setLatLng(latLng: LatLng): this\n  \t// Sets the position of a circle marker to a new location.\n  \tsetLatLng: function (latlng) {\n  \t\tvar oldLatLng = this._latlng;\n  \t\tthis._latlng = toLatLng(latlng);\n  \t\tthis.redraw();\n\n  \t\t// @event move: Event\n  \t\t// Fired when the marker is moved via [`setLatLng`](#circlemarker-setlatlng). Old and new coordinates are included in event arguments as `oldLatLng`, `latlng`.\n  \t\treturn this.fire('move', {oldLatLng: oldLatLng, latlng: this._latlng});\n  \t},\n\n  \t// @method getLatLng(): LatLng\n  \t// Returns the current geographical position of the circle marker\n  \tgetLatLng: function () {\n  \t\treturn this._latlng;\n  \t},\n\n  \t// @method setRadius(radius: Number): this\n  \t// Sets the radius of a circle marker. Units are in pixels.\n  \tsetRadius: function (radius) {\n  \t\tthis.options.radius = this._radius = radius;\n  \t\treturn this.redraw();\n  \t},\n\n  \t// @method getRadius(): Number\n  \t// Returns the current radius of the circle\n  \tgetRadius: function () {\n  \t\treturn this._radius;\n  \t},\n\n  \tsetStyle : function (options) {\n  \t\tvar radius = options && options.radius || this._radius;\n  \t\tPath.prototype.setStyle.call(this, options);\n  \t\tthis.setRadius(radius);\n  \t\treturn this;\n  \t},\n\n  \t_project: function () {\n  \t\tthis._point = this._map.latLngToLayerPoint(this._latlng);\n  \t\tthis._updateBounds();\n  \t},\n\n  \t_updateBounds: function () {\n  \t\tvar r = this._radius,\n  \t\t    r2 = this._radiusY || r,\n  \t\t    w = this._clickTolerance(),\n  \t\t    p = [r + w, r2 + w];\n  \t\tthis._pxBounds = new Bounds(this._point.subtract(p), this._point.add(p));\n  \t},\n\n  \t_update: function () {\n  \t\tif (this._map) {\n  \t\t\tthis._updatePath();\n  \t\t}\n  \t},\n\n  \t_updatePath: function () {\n  \t\tthis._renderer._updateCircle(this);\n  \t},\n\n  \t_empty: function () {\n  \t\treturn this._radius && !this._renderer._bounds.intersects(this._pxBounds);\n  \t},\n\n  \t// Needed by the `Canvas` renderer for interactivity\n  \t_containsPoint: function (p) {\n  \t\treturn p.distanceTo(this._point) <= this._radius + this._clickTolerance();\n  \t}\n  });\n\n\n  // @factory L.circleMarker(latlng: LatLng, options?: CircleMarker options)\n  // Instantiates a circle marker object given a geographical point, and an optional options object.\n  function circleMarker(latlng, options) {\n  \treturn new CircleMarker(latlng, options);\n  }\n\n  /*\n   * @class Circle\n   * @aka L.Circle\n   * @inherits CircleMarker\n   *\n   * A class for drawing circle overlays on a map. Extends `CircleMarker`.\n   *\n   * It's an approximation and starts to diverge from a real circle closer to poles (due to projection distortion).\n   *\n   * @example\n   *\n   * ```js\n   * L.circle([50.5, 30.5], {radius: 200}).addTo(map);\n   * ```\n   */\n\n  var Circle = CircleMarker.extend({\n\n  \tinitialize: function (latlng, options, legacyOptions) {\n  \t\tif (typeof options === 'number') {\n  \t\t\t// Backwards compatibility with 0.7.x factory (latlng, radius, options?)\n  \t\t\toptions = extend({}, legacyOptions, {radius: options});\n  \t\t}\n  \t\tsetOptions(this, options);\n  \t\tthis._latlng = toLatLng(latlng);\n\n  \t\tif (isNaN(this.options.radius)) { throw new Error('Circle radius cannot be NaN'); }\n\n  \t\t// @section\n  \t\t// @aka Circle options\n  \t\t// @option radius: Number; Radius of the circle, in meters.\n  \t\tthis._mRadius = this.options.radius;\n  \t},\n\n  \t// @method setRadius(radius: Number): this\n  \t// Sets the radius of a circle. Units are in meters.\n  \tsetRadius: function (radius) {\n  \t\tthis._mRadius = radius;\n  \t\treturn this.redraw();\n  \t},\n\n  \t// @method getRadius(): Number\n  \t// Returns the current radius of a circle. Units are in meters.\n  \tgetRadius: function () {\n  \t\treturn this._mRadius;\n  \t},\n\n  \t// @method getBounds(): LatLngBounds\n  \t// Returns the `LatLngBounds` of the path.\n  \tgetBounds: function () {\n  \t\tvar half = [this._radius, this._radiusY || this._radius];\n\n  \t\treturn new LatLngBounds(\n  \t\t\tthis._map.layerPointToLatLng(this._point.subtract(half)),\n  \t\t\tthis._map.layerPointToLatLng(this._point.add(half)));\n  \t},\n\n  \tsetStyle: Path.prototype.setStyle,\n\n  \t_project: function () {\n\n  \t\tvar lng = this._latlng.lng,\n  \t\t    lat = this._latlng.lat,\n  \t\t    map = this._map,\n  \t\t    crs = map.options.crs;\n\n  \t\tif (crs.distance === Earth.distance) {\n  \t\t\tvar d = Math.PI / 180,\n  \t\t\t    latR = (this._mRadius / Earth.R) / d,\n  \t\t\t    top = map.project([lat + latR, lng]),\n  \t\t\t    bottom = map.project([lat - latR, lng]),\n  \t\t\t    p = top.add(bottom).divideBy(2),\n  \t\t\t    lat2 = map.unproject(p).lat,\n  \t\t\t    lngR = Math.acos((Math.cos(latR * d) - Math.sin(lat * d) * Math.sin(lat2 * d)) /\n  \t\t\t            (Math.cos(lat * d) * Math.cos(lat2 * d))) / d;\n\n  \t\t\tif (isNaN(lngR) || lngR === 0) {\n  \t\t\t\tlngR = latR / Math.cos(Math.PI / 180 * lat); // Fallback for edge case, #2425\n  \t\t\t}\n\n  \t\t\tthis._point = p.subtract(map.getPixelOrigin());\n  \t\t\tthis._radius = isNaN(lngR) ? 0 : p.x - map.project([lat2, lng - lngR]).x;\n  \t\t\tthis._radiusY = p.y - top.y;\n\n  \t\t} else {\n  \t\t\tvar latlng2 = crs.unproject(crs.project(this._latlng).subtract([this._mRadius, 0]));\n\n  \t\t\tthis._point = map.latLngToLayerPoint(this._latlng);\n  \t\t\tthis._radius = this._point.x - map.latLngToLayerPoint(latlng2).x;\n  \t\t}\n\n  \t\tthis._updateBounds();\n  \t}\n  });\n\n  // @factory L.circle(latlng: LatLng, options?: Circle options)\n  // Instantiates a circle object given a geographical point, and an options object\n  // which contains the circle radius.\n  // @alternative\n  // @factory L.circle(latlng: LatLng, radius: Number, options?: Circle options)\n  // Obsolete way of instantiating a circle, for compatibility with 0.7.x code.\n  // Do not use in new applications or plugins.\n  function circle(latlng, options, legacyOptions) {\n  \treturn new Circle(latlng, options, legacyOptions);\n  }\n\n  /*\n   * @class Polyline\n   * @aka L.Polyline\n   * @inherits Path\n   *\n   * A class for drawing polyline overlays on a map. Extends `Path`.\n   *\n   * @example\n   *\n   * ```js\n   * // create a red polyline from an array of LatLng points\n   * var latlngs = [\n   * \t[45.51, -122.68],\n   * \t[37.77, -122.43],\n   * \t[34.04, -118.2]\n   * ];\n   *\n   * var polyline = L.polyline(latlngs, {color: 'red'}).addTo(map);\n   *\n   * // zoom the map to the polyline\n   * map.fitBounds(polyline.getBounds());\n   * ```\n   *\n   * You can also pass a multi-dimensional array to represent a `MultiPolyline` shape:\n   *\n   * ```js\n   * // create a red polyline from an array of arrays of LatLng points\n   * var latlngs = [\n   * \t[[45.51, -122.68],\n   * \t [37.77, -122.43],\n   * \t [34.04, -118.2]],\n   * \t[[40.78, -73.91],\n   * \t [41.83, -87.62],\n   * \t [32.76, -96.72]]\n   * ];\n   * ```\n   */\n\n\n  var Polyline = Path.extend({\n\n  \t// @section\n  \t// @aka Polyline options\n  \toptions: {\n  \t\t// @option smoothFactor: Number = 1.0\n  \t\t// How much to simplify the polyline on each zoom level. More means\n  \t\t// better performance and smoother look, and less means more accurate representation.\n  \t\tsmoothFactor: 1.0,\n\n  \t\t// @option noClip: Boolean = false\n  \t\t// Disable polyline clipping.\n  \t\tnoClip: false\n  \t},\n\n  \tinitialize: function (latlngs, options) {\n  \t\tsetOptions(this, options);\n  \t\tthis._setLatLngs(latlngs);\n  \t},\n\n  \t// @method getLatLngs(): LatLng[]\n  \t// Returns an array of the points in the path, or nested arrays of points in case of multi-polyline.\n  \tgetLatLngs: function () {\n  \t\treturn this._latlngs;\n  \t},\n\n  \t// @method setLatLngs(latlngs: LatLng[]): this\n  \t// Replaces all the points in the polyline with the given array of geographical points.\n  \tsetLatLngs: function (latlngs) {\n  \t\tthis._setLatLngs(latlngs);\n  \t\treturn this.redraw();\n  \t},\n\n  \t// @method isEmpty(): Boolean\n  \t// Returns `true` if the Polyline has no LatLngs.\n  \tisEmpty: function () {\n  \t\treturn !this._latlngs.length;\n  \t},\n\n  \t// @method closestLayerPoint(p: Point): Point\n  \t// Returns the point closest to `p` on the Polyline.\n  \tclosestLayerPoint: function (p) {\n  \t\tvar minDistance = Infinity,\n  \t\t    minPoint = null,\n  \t\t    closest = _sqClosestPointOnSegment,\n  \t\t    p1, p2;\n\n  \t\tfor (var j = 0, jLen = this._parts.length; j < jLen; j++) {\n  \t\t\tvar points = this._parts[j];\n\n  \t\t\tfor (var i = 1, len = points.length; i < len; i++) {\n  \t\t\t\tp1 = points[i - 1];\n  \t\t\t\tp2 = points[i];\n\n  \t\t\t\tvar sqDist = closest(p, p1, p2, true);\n\n  \t\t\t\tif (sqDist < minDistance) {\n  \t\t\t\t\tminDistance = sqDist;\n  \t\t\t\t\tminPoint = closest(p, p1, p2);\n  \t\t\t\t}\n  \t\t\t}\n  \t\t}\n  \t\tif (minPoint) {\n  \t\t\tminPoint.distance = Math.sqrt(minDistance);\n  \t\t}\n  \t\treturn minPoint;\n  \t},\n\n  \t// @method getCenter(): LatLng\n  \t// Returns the center ([centroid](http://en.wikipedia.org/wiki/Centroid)) of the polyline.\n  \tgetCenter: function () {\n  \t\t// throws error when not yet added to map as this center calculation requires projected coordinates\n  \t\tif (!this._map) {\n  \t\t\tthrow new Error('Must add layer to map before using getCenter()');\n  \t\t}\n\n  \t\tvar i, halfDist, segDist, dist, p1, p2, ratio,\n  \t\t    points = this._rings[0],\n  \t\t    len = points.length;\n\n  \t\tif (!len) { return null; }\n\n  \t\t// polyline centroid algorithm; only uses the first ring if there are multiple\n\n  \t\tfor (i = 0, halfDist = 0; i < len - 1; i++) {\n  \t\t\thalfDist += points[i].distanceTo(points[i + 1]) / 2;\n  \t\t}\n\n  \t\t// The line is so small in the current view that all points are on the same pixel.\n  \t\tif (halfDist === 0) {\n  \t\t\treturn this._map.layerPointToLatLng(points[0]);\n  \t\t}\n\n  \t\tfor (i = 0, dist = 0; i < len - 1; i++) {\n  \t\t\tp1 = points[i];\n  \t\t\tp2 = points[i + 1];\n  \t\t\tsegDist = p1.distanceTo(p2);\n  \t\t\tdist += segDist;\n\n  \t\t\tif (dist > halfDist) {\n  \t\t\t\tratio = (dist - halfDist) / segDist;\n  \t\t\t\treturn this._map.layerPointToLatLng([\n  \t\t\t\t\tp2.x - ratio * (p2.x - p1.x),\n  \t\t\t\t\tp2.y - ratio * (p2.y - p1.y)\n  \t\t\t\t]);\n  \t\t\t}\n  \t\t}\n  \t},\n\n  \t// @method getBounds(): LatLngBounds\n  \t// Returns the `LatLngBounds` of the path.\n  \tgetBounds: function () {\n  \t\treturn this._bounds;\n  \t},\n\n  \t// @method addLatLng(latlng: LatLng, latlngs?: LatLng[]): this\n  \t// Adds a given point to the polyline. By default, adds to the first ring of\n  \t// the polyline in case of a multi-polyline, but can be overridden by passing\n  \t// a specific ring as a LatLng array (that you can earlier access with [`getLatLngs`](#polyline-getlatlngs)).\n  \taddLatLng: function (latlng, latlngs) {\n  \t\tlatlngs = latlngs || this._defaultShape();\n  \t\tlatlng = toLatLng(latlng);\n  \t\tlatlngs.push(latlng);\n  \t\tthis._bounds.extend(latlng);\n  \t\treturn this.redraw();\n  \t},\n\n  \t_setLatLngs: function (latlngs) {\n  \t\tthis._bounds = new LatLngBounds();\n  \t\tthis._latlngs = this._convertLatLngs(latlngs);\n  \t},\n\n  \t_defaultShape: function () {\n  \t\treturn isFlat(this._latlngs) ? this._latlngs : this._latlngs[0];\n  \t},\n\n  \t// recursively convert latlngs input into actual LatLng instances; calculate bounds along the way\n  \t_convertLatLngs: function (latlngs) {\n  \t\tvar result = [],\n  \t\t    flat = isFlat(latlngs);\n\n  \t\tfor (var i = 0, len = latlngs.length; i < len; i++) {\n  \t\t\tif (flat) {\n  \t\t\t\tresult[i] = toLatLng(latlngs[i]);\n  \t\t\t\tthis._bounds.extend(result[i]);\n  \t\t\t} else {\n  \t\t\t\tresult[i] = this._convertLatLngs(latlngs[i]);\n  \t\t\t}\n  \t\t}\n\n  \t\treturn result;\n  \t},\n\n  \t_project: function () {\n  \t\tvar pxBounds = new Bounds();\n  \t\tthis._rings = [];\n  \t\tthis._projectLatlngs(this._latlngs, this._rings, pxBounds);\n\n  \t\tif (this._bounds.isValid() && pxBounds.isValid()) {\n  \t\t\tthis._rawPxBounds = pxBounds;\n  \t\t\tthis._updateBounds();\n  \t\t}\n  \t},\n\n  \t_updateBounds: function () {\n  \t\tvar w = this._clickTolerance(),\n  \t\t    p = new Point(w, w);\n  \t\tthis._pxBounds = new Bounds([\n  \t\t\tthis._rawPxBounds.min.subtract(p),\n  \t\t\tthis._rawPxBounds.max.add(p)\n  \t\t]);\n  \t},\n\n  \t// recursively turns latlngs into a set of rings with projected coordinates\n  \t_projectLatlngs: function (latlngs, result, projectedBounds) {\n  \t\tvar flat = latlngs[0] instanceof LatLng,\n  \t\t    len = latlngs.length,\n  \t\t    i, ring;\n\n  \t\tif (flat) {\n  \t\t\tring = [];\n  \t\t\tfor (i = 0; i < len; i++) {\n  \t\t\t\tring[i] = this._map.latLngToLayerPoint(latlngs[i]);\n  \t\t\t\tprojectedBounds.extend(ring[i]);\n  \t\t\t}\n  \t\t\tresult.push(ring);\n  \t\t} else {\n  \t\t\tfor (i = 0; i < len; i++) {\n  \t\t\t\tthis._projectLatlngs(latlngs[i], result, projectedBounds);\n  \t\t\t}\n  \t\t}\n  \t},\n\n  \t// clip polyline by renderer bounds so that we have less to render for performance\n  \t_clipPoints: function () {\n  \t\tvar bounds = this._renderer._bounds;\n\n  \t\tthis._parts = [];\n  \t\tif (!this._pxBounds || !this._pxBounds.intersects(bounds)) {\n  \t\t\treturn;\n  \t\t}\n\n  \t\tif (this.options.noClip) {\n  \t\t\tthis._parts = this._rings;\n  \t\t\treturn;\n  \t\t}\n\n  \t\tvar parts = this._parts,\n  \t\t    i, j, k, len, len2, segment, points;\n\n  \t\tfor (i = 0, k = 0, len = this._rings.length; i < len; i++) {\n  \t\t\tpoints = this._rings[i];\n\n  \t\t\tfor (j = 0, len2 = points.length; j < len2 - 1; j++) {\n  \t\t\t\tsegment = clipSegment(points[j], points[j + 1], bounds, j, true);\n\n  \t\t\t\tif (!segment) { continue; }\n\n  \t\t\t\tparts[k] = parts[k] || [];\n  \t\t\t\tparts[k].push(segment[0]);\n\n  \t\t\t\t// if segment goes out of screen, or it's the last one, it's the end of the line part\n  \t\t\t\tif ((segment[1] !== points[j + 1]) || (j === len2 - 2)) {\n  \t\t\t\t\tparts[k].push(segment[1]);\n  \t\t\t\t\tk++;\n  \t\t\t\t}\n  \t\t\t}\n  \t\t}\n  \t},\n\n  \t// simplify each clipped part of the polyline for performance\n  \t_simplifyPoints: function () {\n  \t\tvar parts = this._parts,\n  \t\t    tolerance = this.options.smoothFactor;\n\n  \t\tfor (var i = 0, len = parts.length; i < len; i++) {\n  \t\t\tparts[i] = simplify(parts[i], tolerance);\n  \t\t}\n  \t},\n\n  \t_update: function () {\n  \t\tif (!this._map) { return; }\n\n  \t\tthis._clipPoints();\n  \t\tthis._simplifyPoints();\n  \t\tthis._updatePath();\n  \t},\n\n  \t_updatePath: function () {\n  \t\tthis._renderer._updatePoly(this);\n  \t},\n\n  \t// Needed by the `Canvas` renderer for interactivity\n  \t_containsPoint: function (p, closed) {\n  \t\tvar i, j, k, len, len2, part,\n  \t\t    w = this._clickTolerance();\n\n  \t\tif (!this._pxBounds || !this._pxBounds.contains(p)) { return false; }\n\n  \t\t// hit detection for polylines\n  \t\tfor (i = 0, len = this._parts.length; i < len; i++) {\n  \t\t\tpart = this._parts[i];\n\n  \t\t\tfor (j = 0, len2 = part.length, k = len2 - 1; j < len2; k = j++) {\n  \t\t\t\tif (!closed && (j === 0)) { continue; }\n\n  \t\t\t\tif (pointToSegmentDistance(p, part[k], part[j]) <= w) {\n  \t\t\t\t\treturn true;\n  \t\t\t\t}\n  \t\t\t}\n  \t\t}\n  \t\treturn false;\n  \t}\n  });\n\n  // @factory L.polyline(latlngs: LatLng[], options?: Polyline options)\n  // Instantiates a polyline object given an array of geographical points and\n  // optionally an options object. You can create a `Polyline` object with\n  // multiple separate lines (`MultiPolyline`) by passing an array of arrays\n  // of geographic points.\n  function polyline(latlngs, options) {\n  \treturn new Polyline(latlngs, options);\n  }\n\n  // Retrocompat. Allow plugins to support Leaflet versions before and after 1.1.\n  Polyline._flat = _flat;\n\n  /*\n   * @class Polygon\n   * @aka L.Polygon\n   * @inherits Polyline\n   *\n   * A class for drawing polygon overlays on a map. Extends `Polyline`.\n   *\n   * Note that points you pass when creating a polygon shouldn't have an additional last point equal to the first one — it's better to filter out such points.\n   *\n   *\n   * @example\n   *\n   * ```js\n   * // create a red polygon from an array of LatLng points\n   * var latlngs = [[37, -109.05],[41, -109.03],[41, -102.05],[37, -102.04]];\n   *\n   * var polygon = L.polygon(latlngs, {color: 'red'}).addTo(map);\n   *\n   * // zoom the map to the polygon\n   * map.fitBounds(polygon.getBounds());\n   * ```\n   *\n   * You can also pass an array of arrays of latlngs, with the first array representing the outer shape and the other arrays representing holes in the outer shape:\n   *\n   * ```js\n   * var latlngs = [\n   *   [[37, -109.05],[41, -109.03],[41, -102.05],[37, -102.04]], // outer ring\n   *   [[37.29, -108.58],[40.71, -108.58],[40.71, -102.50],[37.29, -102.50]] // hole\n   * ];\n   * ```\n   *\n   * Additionally, you can pass a multi-dimensional array to represent a MultiPolygon shape.\n   *\n   * ```js\n   * var latlngs = [\n   *   [ // first polygon\n   *     [[37, -109.05],[41, -109.03],[41, -102.05],[37, -102.04]], // outer ring\n   *     [[37.29, -108.58],[40.71, -108.58],[40.71, -102.50],[37.29, -102.50]] // hole\n   *   ],\n   *   [ // second polygon\n   *     [[41, -111.03],[45, -111.04],[45, -104.05],[41, -104.05]]\n   *   ]\n   * ];\n   * ```\n   */\n\n  var Polygon = Polyline.extend({\n\n  \toptions: {\n  \t\tfill: true\n  \t},\n\n  \tisEmpty: function () {\n  \t\treturn !this._latlngs.length || !this._latlngs[0].length;\n  \t},\n\n  \tgetCenter: function () {\n  \t\t// throws error when not yet added to map as this center calculation requires projected coordinates\n  \t\tif (!this._map) {\n  \t\t\tthrow new Error('Must add layer to map before using getCenter()');\n  \t\t}\n\n  \t\tvar i, j, p1, p2, f, area, x, y, center,\n  \t\t    points = this._rings[0],\n  \t\t    len = points.length;\n\n  \t\tif (!len) { return null; }\n\n  \t\t// polygon centroid algorithm; only uses the first ring if there are multiple\n\n  \t\tarea = x = y = 0;\n\n  \t\tfor (i = 0, j = len - 1; i < len; j = i++) {\n  \t\t\tp1 = points[i];\n  \t\t\tp2 = points[j];\n\n  \t\t\tf = p1.y * p2.x - p2.y * p1.x;\n  \t\t\tx += (p1.x + p2.x) * f;\n  \t\t\ty += (p1.y + p2.y) * f;\n  \t\t\tarea += f * 3;\n  \t\t}\n\n  \t\tif (area === 0) {\n  \t\t\t// Polygon is so small that all points are on same pixel.\n  \t\t\tcenter = points[0];\n  \t\t} else {\n  \t\t\tcenter = [x / area, y / area];\n  \t\t}\n  \t\treturn this._map.layerPointToLatLng(center);\n  \t},\n\n  \t_convertLatLngs: function (latlngs) {\n  \t\tvar result = Polyline.prototype._convertLatLngs.call(this, latlngs),\n  \t\t    len = result.length;\n\n  \t\t// remove last point if it equals first one\n  \t\tif (len >= 2 && result[0] instanceof LatLng && result[0].equals(result[len - 1])) {\n  \t\t\tresult.pop();\n  \t\t}\n  \t\treturn result;\n  \t},\n\n  \t_setLatLngs: function (latlngs) {\n  \t\tPolyline.prototype._setLatLngs.call(this, latlngs);\n  \t\tif (isFlat(this._latlngs)) {\n  \t\t\tthis._latlngs = [this._latlngs];\n  \t\t}\n  \t},\n\n  \t_defaultShape: function () {\n  \t\treturn isFlat(this._latlngs[0]) ? this._latlngs[0] : this._latlngs[0][0];\n  \t},\n\n  \t_clipPoints: function () {\n  \t\t// polygons need a different clipping algorithm so we redefine that\n\n  \t\tvar bounds = this._renderer._bounds,\n  \t\t    w = this.options.weight,\n  \t\t    p = new Point(w, w);\n\n  \t\t// increase clip padding by stroke width to avoid stroke on clip edges\n  \t\tbounds = new Bounds(bounds.min.subtract(p), bounds.max.add(p));\n\n  \t\tthis._parts = [];\n  \t\tif (!this._pxBounds || !this._pxBounds.intersects(bounds)) {\n  \t\t\treturn;\n  \t\t}\n\n  \t\tif (this.options.noClip) {\n  \t\t\tthis._parts = this._rings;\n  \t\t\treturn;\n  \t\t}\n\n  \t\tfor (var i = 0, len = this._rings.length, clipped; i < len; i++) {\n  \t\t\tclipped = clipPolygon(this._rings[i], bounds, true);\n  \t\t\tif (clipped.length) {\n  \t\t\t\tthis._parts.push(clipped);\n  \t\t\t}\n  \t\t}\n  \t},\n\n  \t_updatePath: function () {\n  \t\tthis._renderer._updatePoly(this, true);\n  \t},\n\n  \t// Needed by the `Canvas` renderer for interactivity\n  \t_containsPoint: function (p) {\n  \t\tvar inside = false,\n  \t\t    part, p1, p2, i, j, k, len, len2;\n\n  \t\tif (!this._pxBounds || !this._pxBounds.contains(p)) { return false; }\n\n  \t\t// ray casting algorithm for detecting if point is in polygon\n  \t\tfor (i = 0, len = this._parts.length; i < len; i++) {\n  \t\t\tpart = this._parts[i];\n\n  \t\t\tfor (j = 0, len2 = part.length, k = len2 - 1; j < len2; k = j++) {\n  \t\t\t\tp1 = part[j];\n  \t\t\t\tp2 = part[k];\n\n  \t\t\t\tif (((p1.y > p.y) !== (p2.y > p.y)) && (p.x < (p2.x - p1.x) * (p.y - p1.y) / (p2.y - p1.y) + p1.x)) {\n  \t\t\t\t\tinside = !inside;\n  \t\t\t\t}\n  \t\t\t}\n  \t\t}\n\n  \t\t// also check if it's on polygon stroke\n  \t\treturn inside || Polyline.prototype._containsPoint.call(this, p, true);\n  \t}\n\n  });\n\n\n  // @factory L.polygon(latlngs: LatLng[], options?: Polyline options)\n  function polygon(latlngs, options) {\n  \treturn new Polygon(latlngs, options);\n  }\n\n  /*\r\n   * @class GeoJSON\r\n   * @aka L.GeoJSON\r\n   * @inherits FeatureGroup\r\n   *\r\n   * Represents a GeoJSON object or an array of GeoJSON objects. Allows you to parse\r\n   * GeoJSON data and display it on the map. Extends `FeatureGroup`.\r\n   *\r\n   * @example\r\n   *\r\n   * ```js\r\n   * L.geoJSON(data, {\r\n   * \tstyle: function (feature) {\r\n   * \t\treturn {color: feature.properties.color};\r\n   * \t}\r\n   * }).bindPopup(function (layer) {\r\n   * \treturn layer.feature.properties.description;\r\n   * }).addTo(map);\r\n   * ```\r\n   */\r\n\r\n  var GeoJSON = FeatureGroup.extend({\r\n\r\n  \t/* @section\r\n  \t * @aka GeoJSON options\r\n  \t *\r\n  \t * @option pointToLayer: Function = *\r\n  \t * A `Function` defining how GeoJSON points spawn Leaflet layers. It is internally\r\n  \t * called when data is added, passing the GeoJSON point feature and its `LatLng`.\r\n  \t * The default is to spawn a default `Marker`:\r\n  \t * ```js\r\n  \t * function(geoJsonPoint, latlng) {\r\n  \t * \treturn L.marker(latlng);\r\n  \t * }\r\n  \t * ```\r\n  \t *\r\n  \t * @option style: Function = *\r\n  \t * A `Function` defining the `Path options` for styling GeoJSON lines and polygons,\r\n  \t * called internally when data is added.\r\n  \t * The default value is to not override any defaults:\r\n  \t * ```js\r\n  \t * function (geoJsonFeature) {\r\n  \t * \treturn {}\r\n  \t * }\r\n  \t * ```\r\n  \t *\r\n  \t * @option onEachFeature: Function = *\r\n  \t * A `Function` that will be called once for each created `Feature`, after it has\r\n  \t * been created and styled. Useful for attaching events and popups to features.\r\n  \t * The default is to do nothing with the newly created layers:\r\n  \t * ```js\r\n  \t * function (feature, layer) {}\r\n  \t * ```\r\n  \t *\r\n  \t * @option filter: Function = *\r\n  \t * A `Function` that will be used to decide whether to include a feature or not.\r\n  \t * The default is to include all features:\r\n  \t * ```js\r\n  \t * function (geoJsonFeature) {\r\n  \t * \treturn true;\r\n  \t * }\r\n  \t * ```\r\n  \t * Note: dynamically changing the `filter` option will have effect only on newly\r\n  \t * added data. It will _not_ re-evaluate already included features.\r\n  \t *\r\n  \t * @option coordsToLatLng: Function = *\r\n  \t * A `Function` that will be used for converting GeoJSON coordinates to `LatLng`s.\r\n  \t * The default is the `coordsToLatLng` static method.\r\n  \t *\r\n  \t * @option markersInheritOptions: Boolean = false\r\n  \t * Whether default Markers for \"Point\" type Features inherit from group options.\r\n  \t */\r\n\r\n  \tinitialize: function (geojson, options) {\r\n  \t\tsetOptions(this, options);\r\n\r\n  \t\tthis._layers = {};\r\n\r\n  \t\tif (geojson) {\r\n  \t\t\tthis.addData(geojson);\r\n  \t\t}\r\n  \t},\r\n\r\n  \t// @method addData( <GeoJSON> data ): this\r\n  \t// Adds a GeoJSON object to the layer.\r\n  \taddData: function (geojson) {\r\n  \t\tvar features = isArray(geojson) ? geojson : geojson.features,\r\n  \t\t    i, len, feature;\r\n\r\n  \t\tif (features) {\r\n  \t\t\tfor (i = 0, len = features.length; i < len; i++) {\r\n  \t\t\t\t// only add this if geometry or geometries are set and not null\r\n  \t\t\t\tfeature = features[i];\r\n  \t\t\t\tif (feature.geometries || feature.geometry || feature.features || feature.coordinates) {\r\n  \t\t\t\t\tthis.addData(feature);\r\n  \t\t\t\t}\r\n  \t\t\t}\r\n  \t\t\treturn this;\r\n  \t\t}\r\n\r\n  \t\tvar options = this.options;\r\n\r\n  \t\tif (options.filter && !options.filter(geojson)) { return this; }\r\n\r\n  \t\tvar layer = geometryToLayer(geojson, options);\r\n  \t\tif (!layer) {\r\n  \t\t\treturn this;\r\n  \t\t}\r\n  \t\tlayer.feature = asFeature(geojson);\r\n\r\n  \t\tlayer.defaultOptions = layer.options;\r\n  \t\tthis.resetStyle(layer);\r\n\r\n  \t\tif (options.onEachFeature) {\r\n  \t\t\toptions.onEachFeature(geojson, layer);\r\n  \t\t}\r\n\r\n  \t\treturn this.addLayer(layer);\r\n  \t},\r\n\r\n  \t// @method resetStyle( <Path> layer? ): this\r\n  \t// Resets the given vector layer's style to the original GeoJSON style, useful for resetting style after hover events.\r\n  \t// If `layer` is omitted, the style of all features in the current layer is reset.\r\n  \tresetStyle: function (layer) {\r\n  \t\tif (layer === undefined) {\r\n  \t\t\treturn this.eachLayer(this.resetStyle, this);\r\n  \t\t}\r\n  \t\t// reset any custom styles\r\n  \t\tlayer.options = extend({}, layer.defaultOptions);\r\n  \t\tthis._setLayerStyle(layer, this.options.style);\r\n  \t\treturn this;\r\n  \t},\r\n\r\n  \t// @method setStyle( <Function> style ): this\r\n  \t// Changes styles of GeoJSON vector layers with the given style function.\r\n  \tsetStyle: function (style) {\r\n  \t\treturn this.eachLayer(function (layer) {\r\n  \t\t\tthis._setLayerStyle(layer, style);\r\n  \t\t}, this);\r\n  \t},\r\n\r\n  \t_setLayerStyle: function (layer, style) {\r\n  \t\tif (layer.setStyle) {\r\n  \t\t\tif (typeof style === 'function') {\r\n  \t\t\t\tstyle = style(layer.feature);\r\n  \t\t\t}\r\n  \t\t\tlayer.setStyle(style);\r\n  \t\t}\r\n  \t}\r\n  });\r\n\r\n  // @section\r\n  // There are several static functions which can be called without instantiating L.GeoJSON:\r\n\r\n  // @function geometryToLayer(featureData: Object, options?: GeoJSON options): Layer\r\n  // Creates a `Layer` from a given GeoJSON feature. Can use a custom\r\n  // [`pointToLayer`](#geojson-pointtolayer) and/or [`coordsToLatLng`](#geojson-coordstolatlng)\r\n  // functions if provided as options.\r\n  function geometryToLayer(geojson, options) {\r\n\r\n  \tvar geometry = geojson.type === 'Feature' ? geojson.geometry : geojson,\r\n  \t    coords = geometry ? geometry.coordinates : null,\r\n  \t    layers = [],\r\n  \t    pointToLayer = options && options.pointToLayer,\r\n  \t    _coordsToLatLng = options && options.coordsToLatLng || coordsToLatLng,\r\n  \t    latlng, latlngs, i, len;\r\n\r\n  \tif (!coords && !geometry) {\r\n  \t\treturn null;\r\n  \t}\r\n\r\n  \tswitch (geometry.type) {\r\n  \tcase 'Point':\r\n  \t\tlatlng = _coordsToLatLng(coords);\r\n  \t\treturn _pointToLayer(pointToLayer, geojson, latlng, options);\r\n\r\n  \tcase 'MultiPoint':\r\n  \t\tfor (i = 0, len = coords.length; i < len; i++) {\r\n  \t\t\tlatlng = _coordsToLatLng(coords[i]);\r\n  \t\t\tlayers.push(_pointToLayer(pointToLayer, geojson, latlng, options));\r\n  \t\t}\r\n  \t\treturn new FeatureGroup(layers);\r\n\r\n  \tcase 'LineString':\r\n  \tcase 'MultiLineString':\r\n  \t\tlatlngs = coordsToLatLngs(coords, geometry.type === 'LineString' ? 0 : 1, _coordsToLatLng);\r\n  \t\treturn new Polyline(latlngs, options);\r\n\r\n  \tcase 'Polygon':\r\n  \tcase 'MultiPolygon':\r\n  \t\tlatlngs = coordsToLatLngs(coords, geometry.type === 'Polygon' ? 1 : 2, _coordsToLatLng);\r\n  \t\treturn new Polygon(latlngs, options);\r\n\r\n  \tcase 'GeometryCollection':\r\n  \t\tfor (i = 0, len = geometry.geometries.length; i < len; i++) {\r\n  \t\t\tvar layer = geometryToLayer({\r\n  \t\t\t\tgeometry: geometry.geometries[i],\r\n  \t\t\t\ttype: 'Feature',\r\n  \t\t\t\tproperties: geojson.properties\r\n  \t\t\t}, options);\r\n\r\n  \t\t\tif (layer) {\r\n  \t\t\t\tlayers.push(layer);\r\n  \t\t\t}\r\n  \t\t}\r\n  \t\treturn new FeatureGroup(layers);\r\n\r\n  \tdefault:\r\n  \t\tthrow new Error('Invalid GeoJSON object.');\r\n  \t}\r\n  }\r\n\r\n  function _pointToLayer(pointToLayerFn, geojson, latlng, options) {\r\n  \treturn pointToLayerFn ?\r\n  \t\tpointToLayerFn(geojson, latlng) :\r\n  \t\tnew Marker(latlng, options && options.markersInheritOptions && options);\r\n  }\r\n\r\n  // @function coordsToLatLng(coords: Array): LatLng\r\n  // Creates a `LatLng` object from an array of 2 numbers (longitude, latitude)\r\n  // or 3 numbers (longitude, latitude, altitude) used in GeoJSON for points.\r\n  function coordsToLatLng(coords) {\r\n  \treturn new LatLng(coords[1], coords[0], coords[2]);\r\n  }\r\n\r\n  // @function coordsToLatLngs(coords: Array, levelsDeep?: Number, coordsToLatLng?: Function): Array\r\n  // Creates a multidimensional array of `LatLng`s from a GeoJSON coordinates array.\r\n  // `levelsDeep` specifies the nesting level (0 is for an array of points, 1 for an array of arrays of points, etc., 0 by default).\r\n  // Can use a custom [`coordsToLatLng`](#geojson-coordstolatlng) function.\r\n  function coordsToLatLngs(coords, levelsDeep, _coordsToLatLng) {\r\n  \tvar latlngs = [];\r\n\r\n  \tfor (var i = 0, len = coords.length, latlng; i < len; i++) {\r\n  \t\tlatlng = levelsDeep ?\r\n  \t\t\tcoordsToLatLngs(coords[i], levelsDeep - 1, _coordsToLatLng) :\r\n  \t\t\t(_coordsToLatLng || coordsToLatLng)(coords[i]);\r\n\r\n  \t\tlatlngs.push(latlng);\r\n  \t}\r\n\r\n  \treturn latlngs;\r\n  }\r\n\r\n  // @function latLngToCoords(latlng: LatLng, precision?: Number): Array\r\n  // Reverse of [`coordsToLatLng`](#geojson-coordstolatlng)\r\n  function latLngToCoords(latlng, precision) {\r\n  \tprecision = typeof precision === 'number' ? precision : 6;\r\n  \treturn latlng.alt !== undefined ?\r\n  \t\t[formatNum(latlng.lng, precision), formatNum(latlng.lat, precision), formatNum(latlng.alt, precision)] :\r\n  \t\t[formatNum(latlng.lng, precision), formatNum(latlng.lat, precision)];\r\n  }\r\n\r\n  // @function latLngsToCoords(latlngs: Array, levelsDeep?: Number, closed?: Boolean): Array\r\n  // Reverse of [`coordsToLatLngs`](#geojson-coordstolatlngs)\r\n  // `closed` determines whether the first point should be appended to the end of the array to close the feature, only used when `levelsDeep` is 0. False by default.\r\n  function latLngsToCoords(latlngs, levelsDeep, closed, precision) {\r\n  \tvar coords = [];\r\n\r\n  \tfor (var i = 0, len = latlngs.length; i < len; i++) {\r\n  \t\tcoords.push(levelsDeep ?\r\n  \t\t\tlatLngsToCoords(latlngs[i], levelsDeep - 1, closed, precision) :\r\n  \t\t\tlatLngToCoords(latlngs[i], precision));\r\n  \t}\r\n\r\n  \tif (!levelsDeep && closed) {\r\n  \t\tcoords.push(coords[0]);\r\n  \t}\r\n\r\n  \treturn coords;\r\n  }\r\n\r\n  function getFeature(layer, newGeometry) {\r\n  \treturn layer.feature ?\r\n  \t\textend({}, layer.feature, {geometry: newGeometry}) :\r\n  \t\tasFeature(newGeometry);\r\n  }\r\n\r\n  // @function asFeature(geojson: Object): Object\r\n  // Normalize GeoJSON geometries/features into GeoJSON features.\r\n  function asFeature(geojson) {\r\n  \tif (geojson.type === 'Feature' || geojson.type === 'FeatureCollection') {\r\n  \t\treturn geojson;\r\n  \t}\r\n\r\n  \treturn {\r\n  \t\ttype: 'Feature',\r\n  \t\tproperties: {},\r\n  \t\tgeometry: geojson\r\n  \t};\r\n  }\r\n\r\n  var PointToGeoJSON = {\r\n  \ttoGeoJSON: function (precision) {\r\n  \t\treturn getFeature(this, {\r\n  \t\t\ttype: 'Point',\r\n  \t\t\tcoordinates: latLngToCoords(this.getLatLng(), precision)\r\n  \t\t});\r\n  \t}\r\n  };\r\n\r\n  // @namespace Marker\r\n  // @section Other methods\r\n  // @method toGeoJSON(precision?: Number): Object\r\n  // `precision` is the number of decimal places for coordinates.\r\n  // The default value is 6 places.\r\n  // Returns a [`GeoJSON`](http://en.wikipedia.org/wiki/GeoJSON) representation of the marker (as a GeoJSON `Point` Feature).\r\n  Marker.include(PointToGeoJSON);\r\n\r\n  // @namespace CircleMarker\r\n  // @method toGeoJSON(precision?: Number): Object\r\n  // `precision` is the number of decimal places for coordinates.\r\n  // The default value is 6 places.\r\n  // Returns a [`GeoJSON`](http://en.wikipedia.org/wiki/GeoJSON) representation of the circle marker (as a GeoJSON `Point` Feature).\r\n  Circle.include(PointToGeoJSON);\r\n  CircleMarker.include(PointToGeoJSON);\r\n\r\n\r\n  // @namespace Polyline\r\n  // @method toGeoJSON(precision?: Number): Object\r\n  // `precision` is the number of decimal places for coordinates.\r\n  // The default value is 6 places.\r\n  // Returns a [`GeoJSON`](http://en.wikipedia.org/wiki/GeoJSON) representation of the polyline (as a GeoJSON `LineString` or `MultiLineString` Feature).\r\n  Polyline.include({\r\n  \ttoGeoJSON: function (precision) {\r\n  \t\tvar multi = !isFlat(this._latlngs);\r\n\r\n  \t\tvar coords = latLngsToCoords(this._latlngs, multi ? 1 : 0, false, precision);\r\n\r\n  \t\treturn getFeature(this, {\r\n  \t\t\ttype: (multi ? 'Multi' : '') + 'LineString',\r\n  \t\t\tcoordinates: coords\r\n  \t\t});\r\n  \t}\r\n  });\r\n\r\n  // @namespace Polygon\r\n  // @method toGeoJSON(precision?: Number): Object\r\n  // `precision` is the number of decimal places for coordinates.\r\n  // The default value is 6 places.\r\n  // Returns a [`GeoJSON`](http://en.wikipedia.org/wiki/GeoJSON) representation of the polygon (as a GeoJSON `Polygon` or `MultiPolygon` Feature).\r\n  Polygon.include({\r\n  \ttoGeoJSON: function (precision) {\r\n  \t\tvar holes = !isFlat(this._latlngs),\r\n  \t\t    multi = holes && !isFlat(this._latlngs[0]);\r\n\r\n  \t\tvar coords = latLngsToCoords(this._latlngs, multi ? 2 : holes ? 1 : 0, true, precision);\r\n\r\n  \t\tif (!holes) {\r\n  \t\t\tcoords = [coords];\r\n  \t\t}\r\n\r\n  \t\treturn getFeature(this, {\r\n  \t\t\ttype: (multi ? 'Multi' : '') + 'Polygon',\r\n  \t\t\tcoordinates: coords\r\n  \t\t});\r\n  \t}\r\n  });\r\n\r\n\r\n  // @namespace LayerGroup\r\n  LayerGroup.include({\r\n  \ttoMultiPoint: function (precision) {\r\n  \t\tvar coords = [];\r\n\r\n  \t\tthis.eachLayer(function (layer) {\r\n  \t\t\tcoords.push(layer.toGeoJSON(precision).geometry.coordinates);\r\n  \t\t});\r\n\r\n  \t\treturn getFeature(this, {\r\n  \t\t\ttype: 'MultiPoint',\r\n  \t\t\tcoordinates: coords\r\n  \t\t});\r\n  \t},\r\n\r\n  \t// @method toGeoJSON(precision?: Number): Object\r\n  \t// `precision` is the number of decimal places for coordinates.\r\n  \t// The default value is 6 places.\r\n  \t// Returns a [`GeoJSON`](http://en.wikipedia.org/wiki/GeoJSON) representation of the layer group (as a GeoJSON `FeatureCollection`, `GeometryCollection`, or `MultiPoint`).\r\n  \ttoGeoJSON: function (precision) {\r\n\r\n  \t\tvar type = this.feature && this.feature.geometry && this.feature.geometry.type;\r\n\r\n  \t\tif (type === 'MultiPoint') {\r\n  \t\t\treturn this.toMultiPoint(precision);\r\n  \t\t}\r\n\r\n  \t\tvar isGeometryCollection = type === 'GeometryCollection',\r\n  \t\t    jsons = [];\r\n\r\n  \t\tthis.eachLayer(function (layer) {\r\n  \t\t\tif (layer.toGeoJSON) {\r\n  \t\t\t\tvar json = layer.toGeoJSON(precision);\r\n  \t\t\t\tif (isGeometryCollection) {\r\n  \t\t\t\t\tjsons.push(json.geometry);\r\n  \t\t\t\t} else {\r\n  \t\t\t\t\tvar feature = asFeature(json);\r\n  \t\t\t\t\t// Squash nested feature collections\r\n  \t\t\t\t\tif (feature.type === 'FeatureCollection') {\r\n  \t\t\t\t\t\tjsons.push.apply(jsons, feature.features);\r\n  \t\t\t\t\t} else {\r\n  \t\t\t\t\t\tjsons.push(feature);\r\n  \t\t\t\t\t}\r\n  \t\t\t\t}\r\n  \t\t\t}\r\n  \t\t});\r\n\r\n  \t\tif (isGeometryCollection) {\r\n  \t\t\treturn getFeature(this, {\r\n  \t\t\t\tgeometries: jsons,\r\n  \t\t\t\ttype: 'GeometryCollection'\r\n  \t\t\t});\r\n  \t\t}\r\n\r\n  \t\treturn {\r\n  \t\t\ttype: 'FeatureCollection',\r\n  \t\t\tfeatures: jsons\r\n  \t\t};\r\n  \t}\r\n  });\r\n\r\n  // @namespace GeoJSON\r\n  // @factory L.geoJSON(geojson?: Object, options?: GeoJSON options)\r\n  // Creates a GeoJSON layer. Optionally accepts an object in\r\n  // [GeoJSON format](https://tools.ietf.org/html/rfc7946) to display on the map\r\n  // (you can alternatively add it later with `addData` method) and an `options` object.\r\n  function geoJSON(geojson, options) {\r\n  \treturn new GeoJSON(geojson, options);\r\n  }\r\n\r\n  // Backward compatibility.\r\n  var geoJson = geoJSON;\n\n  /*\r\n   * @class ImageOverlay\r\n   * @aka L.ImageOverlay\r\n   * @inherits Interactive layer\r\n   *\r\n   * Used to load and display a single image over specific bounds of the map. Extends `Layer`.\r\n   *\r\n   * @example\r\n   *\r\n   * ```js\r\n   * var imageUrl = 'http://www.lib.utexas.edu/maps/historical/newark_nj_1922.jpg',\r\n   * \timageBounds = [[40.712216, -74.22655], [40.773941, -74.12544]];\r\n   * L.imageOverlay(imageUrl, imageBounds).addTo(map);\r\n   * ```\r\n   */\r\n\r\n  var ImageOverlay = Layer.extend({\r\n\r\n  \t// @section\r\n  \t// @aka ImageOverlay options\r\n  \toptions: {\r\n  \t\t// @option opacity: Number = 1.0\r\n  \t\t// The opacity of the image overlay.\r\n  \t\topacity: 1,\r\n\r\n  \t\t// @option alt: String = ''\r\n  \t\t// Text for the `alt` attribute of the image (useful for accessibility).\r\n  \t\talt: '',\r\n\r\n  \t\t// @option interactive: Boolean = false\r\n  \t\t// If `true`, the image overlay will emit [mouse events](#interactive-layer) when clicked or hovered.\r\n  \t\tinteractive: false,\r\n\r\n  \t\t// @option crossOrigin: Boolean|String = false\r\n  \t\t// Whether the crossOrigin attribute will be added to the image.\r\n  \t\t// If a String is provided, the image will have its crossOrigin attribute set to the String provided. This is needed if you want to access image pixel data.\r\n  \t\t// Refer to [CORS Settings](https://developer.mozilla.org/en-US/docs/Web/HTML/CORS_settings_attributes) for valid String values.\r\n  \t\tcrossOrigin: false,\r\n\r\n  \t\t// @option errorOverlayUrl: String = ''\r\n  \t\t// URL to the overlay image to show in place of the overlay that failed to load.\r\n  \t\terrorOverlayUrl: '',\r\n\r\n  \t\t// @option zIndex: Number = 1\r\n  \t\t// The explicit [zIndex](https://developer.mozilla.org/docs/Web/CSS/CSS_Positioning/Understanding_z_index) of the overlay layer.\r\n  \t\tzIndex: 1,\r\n\r\n  \t\t// @option className: String = ''\r\n  \t\t// A custom class name to assign to the image. Empty by default.\r\n  \t\tclassName: ''\r\n  \t},\r\n\r\n  \tinitialize: function (url, bounds, options) { // (String, LatLngBounds, Object)\r\n  \t\tthis._url = url;\r\n  \t\tthis._bounds = toLatLngBounds(bounds);\r\n\r\n  \t\tsetOptions(this, options);\r\n  \t},\r\n\r\n  \tonAdd: function () {\r\n  \t\tif (!this._image) {\r\n  \t\t\tthis._initImage();\r\n\r\n  \t\t\tif (this.options.opacity < 1) {\r\n  \t\t\t\tthis._updateOpacity();\r\n  \t\t\t}\r\n  \t\t}\r\n\r\n  \t\tif (this.options.interactive) {\r\n  \t\t\taddClass(this._image, 'leaflet-interactive');\r\n  \t\t\tthis.addInteractiveTarget(this._image);\r\n  \t\t}\r\n\r\n  \t\tthis.getPane().appendChild(this._image);\r\n  \t\tthis._reset();\r\n  \t},\r\n\r\n  \tonRemove: function () {\r\n  \t\tremove(this._image);\r\n  \t\tif (this.options.interactive) {\r\n  \t\t\tthis.removeInteractiveTarget(this._image);\r\n  \t\t}\r\n  \t},\r\n\r\n  \t// @method setOpacity(opacity: Number): this\r\n  \t// Sets the opacity of the overlay.\r\n  \tsetOpacity: function (opacity) {\r\n  \t\tthis.options.opacity = opacity;\r\n\r\n  \t\tif (this._image) {\r\n  \t\t\tthis._updateOpacity();\r\n  \t\t}\r\n  \t\treturn this;\r\n  \t},\r\n\r\n  \tsetStyle: function (styleOpts) {\r\n  \t\tif (styleOpts.opacity) {\r\n  \t\t\tthis.setOpacity(styleOpts.opacity);\r\n  \t\t}\r\n  \t\treturn this;\r\n  \t},\r\n\r\n  \t// @method bringToFront(): this\r\n  \t// Brings the layer to the top of all overlays.\r\n  \tbringToFront: function () {\r\n  \t\tif (this._map) {\r\n  \t\t\ttoFront(this._image);\r\n  \t\t}\r\n  \t\treturn this;\r\n  \t},\r\n\r\n  \t// @method bringToBack(): this\r\n  \t// Brings the layer to the bottom of all overlays.\r\n  \tbringToBack: function () {\r\n  \t\tif (this._map) {\r\n  \t\t\ttoBack(this._image);\r\n  \t\t}\r\n  \t\treturn this;\r\n  \t},\r\n\r\n  \t// @method setUrl(url: String): this\r\n  \t// Changes the URL of the image.\r\n  \tsetUrl: function (url) {\r\n  \t\tthis._url = url;\r\n\r\n  \t\tif (this._image) {\r\n  \t\t\tthis._image.src = url;\r\n  \t\t}\r\n  \t\treturn this;\r\n  \t},\r\n\r\n  \t// @method setBounds(bounds: LatLngBounds): this\r\n  \t// Update the bounds that this ImageOverlay covers\r\n  \tsetBounds: function (bounds) {\r\n  \t\tthis._bounds = toLatLngBounds(bounds);\r\n\r\n  \t\tif (this._map) {\r\n  \t\t\tthis._reset();\r\n  \t\t}\r\n  \t\treturn this;\r\n  \t},\r\n\r\n  \tgetEvents: function () {\r\n  \t\tvar events = {\r\n  \t\t\tzoom: this._reset,\r\n  \t\t\tviewreset: this._reset\r\n  \t\t};\r\n\r\n  \t\tif (this._zoomAnimated) {\r\n  \t\t\tevents.zoomanim = this._animateZoom;\r\n  \t\t}\r\n\r\n  \t\treturn events;\r\n  \t},\r\n\r\n  \t// @method setZIndex(value: Number): this\r\n  \t// Changes the [zIndex](#imageoverlay-zindex) of the image overlay.\r\n  \tsetZIndex: function (value) {\r\n  \t\tthis.options.zIndex = value;\r\n  \t\tthis._updateZIndex();\r\n  \t\treturn this;\r\n  \t},\r\n\r\n  \t// @method getBounds(): LatLngBounds\r\n  \t// Get the bounds that this ImageOverlay covers\r\n  \tgetBounds: function () {\r\n  \t\treturn this._bounds;\r\n  \t},\r\n\r\n  \t// @method getElement(): HTMLElement\r\n  \t// Returns the instance of [`HTMLImageElement`](https://developer.mozilla.org/docs/Web/API/HTMLImageElement)\r\n  \t// used by this overlay.\r\n  \tgetElement: function () {\r\n  \t\treturn this._image;\r\n  \t},\r\n\r\n  \t_initImage: function () {\r\n  \t\tvar wasElementSupplied = this._url.tagName === 'IMG';\r\n  \t\tvar img = this._image = wasElementSupplied ? this._url : create$1('img');\r\n\r\n  \t\taddClass(img, 'leaflet-image-layer');\r\n  \t\tif (this._zoomAnimated) { addClass(img, 'leaflet-zoom-animated'); }\r\n  \t\tif (this.options.className) { addClass(img, this.options.className); }\r\n\r\n  \t\timg.onselectstart = falseFn;\r\n  \t\timg.onmousemove = falseFn;\r\n\r\n  \t\t// @event load: Event\r\n  \t\t// Fired when the ImageOverlay layer has loaded its image\r\n  \t\timg.onload = bind(this.fire, this, 'load');\r\n  \t\timg.onerror = bind(this._overlayOnError, this, 'error');\r\n\r\n  \t\tif (this.options.crossOrigin || this.options.crossOrigin === '') {\r\n  \t\t\timg.crossOrigin = this.options.crossOrigin === true ? '' : this.options.crossOrigin;\r\n  \t\t}\r\n\r\n  \t\tif (this.options.zIndex) {\r\n  \t\t\tthis._updateZIndex();\r\n  \t\t}\r\n\r\n  \t\tif (wasElementSupplied) {\r\n  \t\t\tthis._url = img.src;\r\n  \t\t\treturn;\r\n  \t\t}\r\n\r\n  \t\timg.src = this._url;\r\n  \t\timg.alt = this.options.alt;\r\n  \t},\r\n\r\n  \t_animateZoom: function (e) {\r\n  \t\tvar scale = this._map.getZoomScale(e.zoom),\r\n  \t\t    offset = this._map._latLngBoundsToNewLayerBounds(this._bounds, e.zoom, e.center).min;\r\n\r\n  \t\tsetTransform(this._image, offset, scale);\r\n  \t},\r\n\r\n  \t_reset: function () {\r\n  \t\tvar image = this._image,\r\n  \t\t    bounds = new Bounds(\r\n  \t\t        this._map.latLngToLayerPoint(this._bounds.getNorthWest()),\r\n  \t\t        this._map.latLngToLayerPoint(this._bounds.getSouthEast())),\r\n  \t\t    size = bounds.getSize();\r\n\r\n  \t\tsetPosition(image, bounds.min);\r\n\r\n  \t\timage.style.width  = size.x + 'px';\r\n  \t\timage.style.height = size.y + 'px';\r\n  \t},\r\n\r\n  \t_updateOpacity: function () {\r\n  \t\tsetOpacity(this._image, this.options.opacity);\r\n  \t},\r\n\r\n  \t_updateZIndex: function () {\r\n  \t\tif (this._image && this.options.zIndex !== undefined && this.options.zIndex !== null) {\r\n  \t\t\tthis._image.style.zIndex = this.options.zIndex;\r\n  \t\t}\r\n  \t},\r\n\r\n  \t_overlayOnError: function () {\r\n  \t\t// @event error: Event\r\n  \t\t// Fired when the ImageOverlay layer fails to load its image\r\n  \t\tthis.fire('error');\r\n\r\n  \t\tvar errorUrl = this.options.errorOverlayUrl;\r\n  \t\tif (errorUrl && this._url !== errorUrl) {\r\n  \t\t\tthis._url = errorUrl;\r\n  \t\t\tthis._image.src = errorUrl;\r\n  \t\t}\r\n  \t}\r\n  });\r\n\r\n  // @factory L.imageOverlay(imageUrl: String, bounds: LatLngBounds, options?: ImageOverlay options)\r\n  // Instantiates an image overlay object given the URL of the image and the\r\n  // geographical bounds it is tied to.\r\n  var imageOverlay = function (url, bounds, options) {\r\n  \treturn new ImageOverlay(url, bounds, options);\r\n  };\n\n  /*\r\n   * @class VideoOverlay\r\n   * @aka L.VideoOverlay\r\n   * @inherits ImageOverlay\r\n   *\r\n   * Used to load and display a video player over specific bounds of the map. Extends `ImageOverlay`.\r\n   *\r\n   * A video overlay uses the [`<video>`](https://developer.mozilla.org/docs/Web/HTML/Element/video)\r\n   * HTML5 element.\r\n   *\r\n   * @example\r\n   *\r\n   * ```js\r\n   * var videoUrl = 'https://www.mapbox.com/bites/00188/patricia_nasa.webm',\r\n   * \tvideoBounds = [[ 32, -130], [ 13, -100]];\r\n   * L.videoOverlay(videoUrl, videoBounds ).addTo(map);\r\n   * ```\r\n   */\r\n\r\n  var VideoOverlay = ImageOverlay.extend({\r\n\r\n  \t// @section\r\n  \t// @aka VideoOverlay options\r\n  \toptions: {\r\n  \t\t// @option autoplay: Boolean = true\r\n  \t\t// Whether the video starts playing automatically when loaded.\r\n  \t\tautoplay: true,\r\n\r\n  \t\t// @option loop: Boolean = true\r\n  \t\t// Whether the video will loop back to the beginning when played.\r\n  \t\tloop: true,\r\n\r\n  \t\t// @option keepAspectRatio: Boolean = true\r\n  \t\t// Whether the video will save aspect ratio after the projection.\r\n  \t\t// Relevant for supported browsers. Browser compatibility- https://developer.mozilla.org/en-US/docs/Web/CSS/object-fit\r\n  \t\tkeepAspectRatio: true,\r\n\r\n  \t\t// @option muted: Boolean = false\r\n  \t\t// Whether the video starts on mute when loaded.\r\n  \t\tmuted: false\r\n  \t},\r\n\r\n  \t_initImage: function () {\r\n  \t\tvar wasElementSupplied = this._url.tagName === 'VIDEO';\r\n  \t\tvar vid = this._image = wasElementSupplied ? this._url : create$1('video');\r\n\r\n  \t\taddClass(vid, 'leaflet-image-layer');\r\n  \t\tif (this._zoomAnimated) { addClass(vid, 'leaflet-zoom-animated'); }\r\n  \t\tif (this.options.className) { addClass(vid, this.options.className); }\r\n\r\n  \t\tvid.onselectstart = falseFn;\r\n  \t\tvid.onmousemove = falseFn;\r\n\r\n  \t\t// @event load: Event\r\n  \t\t// Fired when the video has finished loading the first frame\r\n  \t\tvid.onloadeddata = bind(this.fire, this, 'load');\r\n\r\n  \t\tif (wasElementSupplied) {\r\n  \t\t\tvar sourceElements = vid.getElementsByTagName('source');\r\n  \t\t\tvar sources = [];\r\n  \t\t\tfor (var j = 0; j < sourceElements.length; j++) {\r\n  \t\t\t\tsources.push(sourceElements[j].src);\r\n  \t\t\t}\r\n\r\n  \t\t\tthis._url = (sourceElements.length > 0) ? sources : [vid.src];\r\n  \t\t\treturn;\r\n  \t\t}\r\n\r\n  \t\tif (!isArray(this._url)) { this._url = [this._url]; }\r\n\r\n  \t\tif (!this.options.keepAspectRatio && Object.prototype.hasOwnProperty.call(vid.style, 'objectFit')) {\r\n  \t\t\tvid.style['objectFit'] = 'fill';\r\n  \t\t}\r\n  \t\tvid.autoplay = !!this.options.autoplay;\r\n  \t\tvid.loop = !!this.options.loop;\r\n  \t\tvid.muted = !!this.options.muted;\r\n  \t\tfor (var i = 0; i < this._url.length; i++) {\r\n  \t\t\tvar source = create$1('source');\r\n  \t\t\tsource.src = this._url[i];\r\n  \t\t\tvid.appendChild(source);\r\n  \t\t}\r\n  \t}\r\n\r\n  \t// @method getElement(): HTMLVideoElement\r\n  \t// Returns the instance of [`HTMLVideoElement`](https://developer.mozilla.org/docs/Web/API/HTMLVideoElement)\r\n  \t// used by this overlay.\r\n  });\r\n\r\n\r\n  // @factory L.videoOverlay(video: String|Array|HTMLVideoElement, bounds: LatLngBounds, options?: VideoOverlay options)\r\n  // Instantiates an image overlay object given the URL of the video (or array of URLs, or even a video element) and the\r\n  // geographical bounds it is tied to.\r\n\r\n  function videoOverlay(video, bounds, options) {\r\n  \treturn new VideoOverlay(video, bounds, options);\r\n  }\n\n  /*\n   * @class SVGOverlay\n   * @aka L.SVGOverlay\n   * @inherits ImageOverlay\n   *\n   * Used to load, display and provide DOM access to an SVG file over specific bounds of the map. Extends `ImageOverlay`.\n   *\n   * An SVG overlay uses the [`<svg>`](https://developer.mozilla.org/docs/Web/SVG/Element/svg) element.\n   *\n   * @example\n   *\n   * ```js\n   * var svgElement = document.createElementNS(\"http://www.w3.org/2000/svg\", \"svg\");\n   * svgElement.setAttribute('xmlns', \"http://www.w3.org/2000/svg\");\n   * svgElement.setAttribute('viewBox', \"0 0 200 200\");\n   * svgElement.innerHTML = '<rect width=\"200\" height=\"200\"/><rect x=\"75\" y=\"23\" width=\"50\" height=\"50\" style=\"fill:red\"/><rect x=\"75\" y=\"123\" width=\"50\" height=\"50\" style=\"fill:#0013ff\"/>';\n   * var svgElementBounds = [ [ 32, -130 ], [ 13, -100 ] ];\n   * L.svgOverlay(svgElement, svgElementBounds).addTo(map);\n   * ```\n   */\n\n  var SVGOverlay = ImageOverlay.extend({\n  \t_initImage: function () {\n  \t\tvar el = this._image = this._url;\n\n  \t\taddClass(el, 'leaflet-image-layer');\n  \t\tif (this._zoomAnimated) { addClass(el, 'leaflet-zoom-animated'); }\n  \t\tif (this.options.className) { addClass(el, this.options.className); }\n\n  \t\tel.onselectstart = falseFn;\n  \t\tel.onmousemove = falseFn;\n  \t}\n\n  \t// @method getElement(): SVGElement\n  \t// Returns the instance of [`SVGElement`](https://developer.mozilla.org/docs/Web/API/SVGElement)\n  \t// used by this overlay.\n  });\n\n\n  // @factory L.svgOverlay(svg: String|SVGElement, bounds: LatLngBounds, options?: SVGOverlay options)\n  // Instantiates an image overlay object given an SVG element and the geographical bounds it is tied to.\n  // A viewBox attribute is required on the SVG element to zoom in and out properly.\n\n  function svgOverlay(el, bounds, options) {\n  \treturn new SVGOverlay(el, bounds, options);\n  }\n\n  /*\r\n   * @class DivOverlay\r\n   * @inherits Layer\r\n   * @aka L.DivOverlay\r\n   * Base model for L.Popup and L.Tooltip. Inherit from it for custom popup like plugins.\r\n   */\r\n\r\n  // @namespace DivOverlay\r\n  var DivOverlay = Layer.extend({\r\n\r\n  \t// @section\r\n  \t// @aka DivOverlay options\r\n  \toptions: {\r\n  \t\t// @option offset: Point = Point(0, 7)\r\n  \t\t// The offset of the popup position. Useful to control the anchor\r\n  \t\t// of the popup when opening it on some overlays.\r\n  \t\toffset: [0, 7],\r\n\r\n  \t\t// @option className: String = ''\r\n  \t\t// A custom CSS class name to assign to the popup.\r\n  \t\tclassName: '',\r\n\r\n  \t\t// @option pane: String = 'popupPane'\r\n  \t\t// `Map pane` where the popup will be added.\r\n  \t\tpane: 'popupPane'\r\n  \t},\r\n\r\n  \tinitialize: function (options, source) {\r\n  \t\tsetOptions(this, options);\r\n\r\n  \t\tthis._source = source;\r\n  \t},\r\n\r\n  \tonAdd: function (map) {\r\n  \t\tthis._zoomAnimated = map._zoomAnimated;\r\n\r\n  \t\tif (!this._container) {\r\n  \t\t\tthis._initLayout();\r\n  \t\t}\r\n\r\n  \t\tif (map._fadeAnimated) {\r\n  \t\t\tsetOpacity(this._container, 0);\r\n  \t\t}\r\n\r\n  \t\tclearTimeout(this._removeTimeout);\r\n  \t\tthis.getPane().appendChild(this._container);\r\n  \t\tthis.update();\r\n\r\n  \t\tif (map._fadeAnimated) {\r\n  \t\t\tsetOpacity(this._container, 1);\r\n  \t\t}\r\n\r\n  \t\tthis.bringToFront();\r\n  \t},\r\n\r\n  \tonRemove: function (map) {\r\n  \t\tif (map._fadeAnimated) {\r\n  \t\t\tsetOpacity(this._container, 0);\r\n  \t\t\tthis._removeTimeout = setTimeout(bind(remove, undefined, this._container), 200);\r\n  \t\t} else {\r\n  \t\t\tremove(this._container);\r\n  \t\t}\r\n  \t},\r\n\r\n  \t// @namespace Popup\r\n  \t// @method getLatLng: LatLng\r\n  \t// Returns the geographical point of popup.\r\n  \tgetLatLng: function () {\r\n  \t\treturn this._latlng;\r\n  \t},\r\n\r\n  \t// @method setLatLng(latlng: LatLng): this\r\n  \t// Sets the geographical point where the popup will open.\r\n  \tsetLatLng: function (latlng) {\r\n  \t\tthis._latlng = toLatLng(latlng);\r\n  \t\tif (this._map) {\r\n  \t\t\tthis._updatePosition();\r\n  \t\t\tthis._adjustPan();\r\n  \t\t}\r\n  \t\treturn this;\r\n  \t},\r\n\r\n  \t// @method getContent: String|HTMLElement\r\n  \t// Returns the content of the popup.\r\n  \tgetContent: function () {\r\n  \t\treturn this._content;\r\n  \t},\r\n\r\n  \t// @method setContent(htmlContent: String|HTMLElement|Function): this\r\n  \t// Sets the HTML content of the popup. If a function is passed the source layer will be passed to the function. The function should return a `String` or `HTMLElement` to be used in the popup.\r\n  \tsetContent: function (content) {\r\n  \t\tthis._content = content;\r\n  \t\tthis.update();\r\n  \t\treturn this;\r\n  \t},\r\n\r\n  \t// @method getElement: String|HTMLElement\r\n  \t// Returns the HTML container of the popup.\r\n  \tgetElement: function () {\r\n  \t\treturn this._container;\r\n  \t},\r\n\r\n  \t// @method update: null\r\n  \t// Updates the popup content, layout and position. Useful for updating the popup after something inside changed, e.g. image loaded.\r\n  \tupdate: function () {\r\n  \t\tif (!this._map) { return; }\r\n\r\n  \t\tthis._container.style.visibility = 'hidden';\r\n\r\n  \t\tthis._updateContent();\r\n  \t\tthis._updateLayout();\r\n  \t\tthis._updatePosition();\r\n\r\n  \t\tthis._container.style.visibility = '';\r\n\r\n  \t\tthis._adjustPan();\r\n  \t},\r\n\r\n  \tgetEvents: function () {\r\n  \t\tvar events = {\r\n  \t\t\tzoom: this._updatePosition,\r\n  \t\t\tviewreset: this._updatePosition\r\n  \t\t};\r\n\r\n  \t\tif (this._zoomAnimated) {\r\n  \t\t\tevents.zoomanim = this._animateZoom;\r\n  \t\t}\r\n  \t\treturn events;\r\n  \t},\r\n\r\n  \t// @method isOpen: Boolean\r\n  \t// Returns `true` when the popup is visible on the map.\r\n  \tisOpen: function () {\r\n  \t\treturn !!this._map && this._map.hasLayer(this);\r\n  \t},\r\n\r\n  \t// @method bringToFront: this\r\n  \t// Brings this popup in front of other popups (in the same map pane).\r\n  \tbringToFront: function () {\r\n  \t\tif (this._map) {\r\n  \t\t\ttoFront(this._container);\r\n  \t\t}\r\n  \t\treturn this;\r\n  \t},\r\n\r\n  \t// @method bringToBack: this\r\n  \t// Brings this popup to the back of other popups (in the same map pane).\r\n  \tbringToBack: function () {\r\n  \t\tif (this._map) {\r\n  \t\t\ttoBack(this._container);\r\n  \t\t}\r\n  \t\treturn this;\r\n  \t},\r\n\r\n  \t_prepareOpen: function (parent, layer, latlng) {\r\n  \t\tif (!(layer instanceof Layer)) {\r\n  \t\t\tlatlng = layer;\r\n  \t\t\tlayer = parent;\r\n  \t\t}\r\n\r\n  \t\tif (layer instanceof FeatureGroup) {\r\n  \t\t\tfor (var id in parent._layers) {\r\n  \t\t\t\tlayer = parent._layers[id];\r\n  \t\t\t\tbreak;\r\n  \t\t\t}\r\n  \t\t}\r\n\r\n  \t\tif (!latlng) {\r\n  \t\t\tif (layer.getCenter) {\r\n  \t\t\t\tlatlng = layer.getCenter();\r\n  \t\t\t} else if (layer.getLatLng) {\r\n  \t\t\t\tlatlng = layer.getLatLng();\r\n  \t\t\t} else {\r\n  \t\t\t\tthrow new Error('Unable to get source layer LatLng.');\r\n  \t\t\t}\r\n  \t\t}\r\n\r\n  \t\t// set overlay source to this layer\r\n  \t\tthis._source = layer;\r\n\r\n  \t\t// update the overlay (content, layout, ect...)\r\n  \t\tthis.update();\r\n\r\n  \t\treturn latlng;\r\n  \t},\r\n\r\n  \t_updateContent: function () {\r\n  \t\tif (!this._content) { return; }\r\n\r\n  \t\tvar node = this._contentNode;\r\n  \t\tvar content = (typeof this._content === 'function') ? this._content(this._source || this) : this._content;\r\n\r\n  \t\tif (typeof content === 'string') {\r\n  \t\t\tnode.innerHTML = content;\r\n  \t\t} else {\r\n  \t\t\twhile (node.hasChildNodes()) {\r\n  \t\t\t\tnode.removeChild(node.firstChild);\r\n  \t\t\t}\r\n  \t\t\tnode.appendChild(content);\r\n  \t\t}\r\n  \t\tthis.fire('contentupdate');\r\n  \t},\r\n\r\n  \t_updatePosition: function () {\r\n  \t\tif (!this._map) { return; }\r\n\r\n  \t\tvar pos = this._map.latLngToLayerPoint(this._latlng),\r\n  \t\t    offset = toPoint(this.options.offset),\r\n  \t\t    anchor = this._getAnchor();\r\n\r\n  \t\tif (this._zoomAnimated) {\r\n  \t\t\tsetPosition(this._container, pos.add(anchor));\r\n  \t\t} else {\r\n  \t\t\toffset = offset.add(pos).add(anchor);\r\n  \t\t}\r\n\r\n  \t\tvar bottom = this._containerBottom = -offset.y,\r\n  \t\t    left = this._containerLeft = -Math.round(this._containerWidth / 2) + offset.x;\r\n\r\n  \t\t// bottom position the popup in case the height of the popup changes (images loading etc)\r\n  \t\tthis._container.style.bottom = bottom + 'px';\r\n  \t\tthis._container.style.left = left + 'px';\r\n  \t},\r\n\r\n  \t_getAnchor: function () {\r\n  \t\treturn [0, 0];\r\n  \t}\r\n\r\n  });\n\n  /*\r\n   * @class Popup\r\n   * @inherits DivOverlay\r\n   * @aka L.Popup\r\n   * Used to open popups in certain places of the map. Use [Map.openPopup](#map-openpopup) to\r\n   * open popups while making sure that only one popup is open at one time\r\n   * (recommended for usability), or use [Map.addLayer](#map-addlayer) to open as many as you want.\r\n   *\r\n   * @example\r\n   *\r\n   * If you want to just bind a popup to marker click and then open it, it's really easy:\r\n   *\r\n   * ```js\r\n   * marker.bindPopup(popupContent).openPopup();\r\n   * ```\r\n   * Path overlays like polylines also have a `bindPopup` method.\r\n   * Here's a more complicated way to open a popup on a map:\r\n   *\r\n   * ```js\r\n   * var popup = L.popup()\r\n   * \t.setLatLng(latlng)\r\n   * \t.setContent('<p>Hello world!<br />This is a nice popup.</p>')\r\n   * \t.openOn(map);\r\n   * ```\r\n   */\r\n\r\n\r\n  // @namespace Popup\r\n  var Popup = DivOverlay.extend({\r\n\r\n  \t// @section\r\n  \t// @aka Popup options\r\n  \toptions: {\r\n  \t\t// @option maxWidth: Number = 300\r\n  \t\t// Max width of the popup, in pixels.\r\n  \t\tmaxWidth: 300,\r\n\r\n  \t\t// @option minWidth: Number = 50\r\n  \t\t// Min width of the popup, in pixels.\r\n  \t\tminWidth: 50,\r\n\r\n  \t\t// @option maxHeight: Number = null\r\n  \t\t// If set, creates a scrollable container of the given height\r\n  \t\t// inside a popup if its content exceeds it.\r\n  \t\tmaxHeight: null,\r\n\r\n  \t\t// @option autoPan: Boolean = true\r\n  \t\t// Set it to `false` if you don't want the map to do panning animation\r\n  \t\t// to fit the opened popup.\r\n  \t\tautoPan: true,\r\n\r\n  \t\t// @option autoPanPaddingTopLeft: Point = null\r\n  \t\t// The margin between the popup and the top left corner of the map\r\n  \t\t// view after autopanning was performed.\r\n  \t\tautoPanPaddingTopLeft: null,\r\n\r\n  \t\t// @option autoPanPaddingBottomRight: Point = null\r\n  \t\t// The margin between the popup and the bottom right corner of the map\r\n  \t\t// view after autopanning was performed.\r\n  \t\tautoPanPaddingBottomRight: null,\r\n\r\n  \t\t// @option autoPanPadding: Point = Point(5, 5)\r\n  \t\t// Equivalent of setting both top left and bottom right autopan padding to the same value.\r\n  \t\tautoPanPadding: [5, 5],\r\n\r\n  \t\t// @option keepInView: Boolean = false\r\n  \t\t// Set it to `true` if you want to prevent users from panning the popup\r\n  \t\t// off of the screen while it is open.\r\n  \t\tkeepInView: false,\r\n\r\n  \t\t// @option closeButton: Boolean = true\r\n  \t\t// Controls the presence of a close button in the popup.\r\n  \t\tcloseButton: true,\r\n\r\n  \t\t// @option autoClose: Boolean = true\r\n  \t\t// Set it to `false` if you want to override the default behavior of\r\n  \t\t// the popup closing when another popup is opened.\r\n  \t\tautoClose: true,\r\n\r\n  \t\t// @option closeOnEscapeKey: Boolean = true\r\n  \t\t// Set it to `false` if you want to override the default behavior of\r\n  \t\t// the ESC key for closing of the popup.\r\n  \t\tcloseOnEscapeKey: true,\r\n\r\n  \t\t// @option closeOnClick: Boolean = *\r\n  \t\t// Set it if you want to override the default behavior of the popup closing when user clicks\r\n  \t\t// on the map. Defaults to the map's [`closePopupOnClick`](#map-closepopuponclick) option.\r\n\r\n  \t\t// @option className: String = ''\r\n  \t\t// A custom CSS class name to assign to the popup.\r\n  \t\tclassName: ''\r\n  \t},\r\n\r\n  \t// @namespace Popup\r\n  \t// @method openOn(map: Map): this\r\n  \t// Adds the popup to the map and closes the previous one. The same as `map.openPopup(popup)`.\r\n  \topenOn: function (map) {\r\n  \t\tmap.openPopup(this);\r\n  \t\treturn this;\r\n  \t},\r\n\r\n  \tonAdd: function (map) {\r\n  \t\tDivOverlay.prototype.onAdd.call(this, map);\r\n\r\n  \t\t// @namespace Map\r\n  \t\t// @section Popup events\r\n  \t\t// @event popupopen: PopupEvent\r\n  \t\t// Fired when a popup is opened in the map\r\n  \t\tmap.fire('popupopen', {popup: this});\r\n\r\n  \t\tif (this._source) {\r\n  \t\t\t// @namespace Layer\r\n  \t\t\t// @section Popup events\r\n  \t\t\t// @event popupopen: PopupEvent\r\n  \t\t\t// Fired when a popup bound to this layer is opened\r\n  \t\t\tthis._source.fire('popupopen', {popup: this}, true);\r\n  \t\t\t// For non-path layers, we toggle the popup when clicking\r\n  \t\t\t// again the layer, so prevent the map to reopen it.\r\n  \t\t\tif (!(this._source instanceof Path)) {\r\n  \t\t\t\tthis._source.on('preclick', stopPropagation);\r\n  \t\t\t}\r\n  \t\t}\r\n  \t},\r\n\r\n  \tonRemove: function (map) {\r\n  \t\tDivOverlay.prototype.onRemove.call(this, map);\r\n\r\n  \t\t// @namespace Map\r\n  \t\t// @section Popup events\r\n  \t\t// @event popupclose: PopupEvent\r\n  \t\t// Fired when a popup in the map is closed\r\n  \t\tmap.fire('popupclose', {popup: this});\r\n\r\n  \t\tif (this._source) {\r\n  \t\t\t// @namespace Layer\r\n  \t\t\t// @section Popup events\r\n  \t\t\t// @event popupclose: PopupEvent\r\n  \t\t\t// Fired when a popup bound to this layer is closed\r\n  \t\t\tthis._source.fire('popupclose', {popup: this}, true);\r\n  \t\t\tif (!(this._source instanceof Path)) {\r\n  \t\t\t\tthis._source.off('preclick', stopPropagation);\r\n  \t\t\t}\r\n  \t\t}\r\n  \t},\r\n\r\n  \tgetEvents: function () {\r\n  \t\tvar events = DivOverlay.prototype.getEvents.call(this);\r\n\r\n  \t\tif (this.options.closeOnClick !== undefined ? this.options.closeOnClick : this._map.options.closePopupOnClick) {\r\n  \t\t\tevents.preclick = this._close;\r\n  \t\t}\r\n\r\n  \t\tif (this.options.keepInView) {\r\n  \t\t\tevents.moveend = this._adjustPan;\r\n  \t\t}\r\n\r\n  \t\treturn events;\r\n  \t},\r\n\r\n  \t_close: function () {\r\n  \t\tif (this._map) {\r\n  \t\t\tthis._map.closePopup(this);\r\n  \t\t}\r\n  \t},\r\n\r\n  \t_initLayout: function () {\r\n  \t\tvar prefix = 'leaflet-popup',\r\n  \t\t    container = this._container = create$1('div',\r\n  \t\t\tprefix + ' ' + (this.options.className || '') +\r\n  \t\t\t' leaflet-zoom-animated');\r\n\r\n  \t\tvar wrapper = this._wrapper = create$1('div', prefix + '-content-wrapper', container);\r\n  \t\tthis._contentNode = create$1('div', prefix + '-content', wrapper);\r\n\r\n  \t\tdisableClickPropagation(container);\r\n  \t\tdisableScrollPropagation(this._contentNode);\r\n  \t\ton(container, 'contextmenu', stopPropagation);\r\n\r\n  \t\tthis._tipContainer = create$1('div', prefix + '-tip-container', container);\r\n  \t\tthis._tip = create$1('div', prefix + '-tip', this._tipContainer);\r\n\r\n  \t\tif (this.options.closeButton) {\r\n  \t\t\tvar closeButton = this._closeButton = create$1('a', prefix + '-close-button', container);\r\n  \t\t\tcloseButton.href = '#close';\r\n  \t\t\tcloseButton.innerHTML = '&#215;';\r\n\r\n  \t\t\ton(closeButton, 'click', this._onCloseButtonClick, this);\r\n  \t\t}\r\n  \t},\r\n\r\n  \t_updateLayout: function () {\r\n  \t\tvar container = this._contentNode,\r\n  \t\t    style = container.style;\r\n\r\n  \t\tstyle.width = '';\r\n  \t\tstyle.whiteSpace = 'nowrap';\r\n\r\n  \t\tvar width = container.offsetWidth;\r\n  \t\twidth = Math.min(width, this.options.maxWidth);\r\n  \t\twidth = Math.max(width, this.options.minWidth);\r\n\r\n  \t\tstyle.width = (width + 1) + 'px';\r\n  \t\tstyle.whiteSpace = '';\r\n\r\n  \t\tstyle.height = '';\r\n\r\n  \t\tvar height = container.offsetHeight,\r\n  \t\t    maxHeight = this.options.maxHeight,\r\n  \t\t    scrolledClass = 'leaflet-popup-scrolled';\r\n\r\n  \t\tif (maxHeight && height > maxHeight) {\r\n  \t\t\tstyle.height = maxHeight + 'px';\r\n  \t\t\taddClass(container, scrolledClass);\r\n  \t\t} else {\r\n  \t\t\tremoveClass(container, scrolledClass);\r\n  \t\t}\r\n\r\n  \t\tthis._containerWidth = this._container.offsetWidth;\r\n  \t},\r\n\r\n  \t_animateZoom: function (e) {\r\n  \t\tvar pos = this._map._latLngToNewLayerPoint(this._latlng, e.zoom, e.center),\r\n  \t\t    anchor = this._getAnchor();\r\n  \t\tsetPosition(this._container, pos.add(anchor));\r\n  \t},\r\n\r\n  \t_adjustPan: function () {\r\n  \t\tif (!this.options.autoPan) { return; }\r\n  \t\tif (this._map._panAnim) { this._map._panAnim.stop(); }\r\n\r\n  \t\tvar map = this._map,\r\n  \t\t    marginBottom = parseInt(getStyle(this._container, 'marginBottom'), 10) || 0,\r\n  \t\t    containerHeight = this._container.offsetHeight + marginBottom,\r\n  \t\t    containerWidth = this._containerWidth,\r\n  \t\t    layerPos = new Point(this._containerLeft, -containerHeight - this._containerBottom);\r\n\r\n  \t\tlayerPos._add(getPosition(this._container));\r\n\r\n  \t\tvar containerPos = map.layerPointToContainerPoint(layerPos),\r\n  \t\t    padding = toPoint(this.options.autoPanPadding),\r\n  \t\t    paddingTL = toPoint(this.options.autoPanPaddingTopLeft || padding),\r\n  \t\t    paddingBR = toPoint(this.options.autoPanPaddingBottomRight || padding),\r\n  \t\t    size = map.getSize(),\r\n  \t\t    dx = 0,\r\n  \t\t    dy = 0;\r\n\r\n  \t\tif (containerPos.x + containerWidth + paddingBR.x > size.x) { // right\r\n  \t\t\tdx = containerPos.x + containerWidth - size.x + paddingBR.x;\r\n  \t\t}\r\n  \t\tif (containerPos.x - dx - paddingTL.x < 0) { // left\r\n  \t\t\tdx = containerPos.x - paddingTL.x;\r\n  \t\t}\r\n  \t\tif (containerPos.y + containerHeight + paddingBR.y > size.y) { // bottom\r\n  \t\t\tdy = containerPos.y + containerHeight - size.y + paddingBR.y;\r\n  \t\t}\r\n  \t\tif (containerPos.y - dy - paddingTL.y < 0) { // top\r\n  \t\t\tdy = containerPos.y - paddingTL.y;\r\n  \t\t}\r\n\r\n  \t\t// @namespace Map\r\n  \t\t// @section Popup events\r\n  \t\t// @event autopanstart: Event\r\n  \t\t// Fired when the map starts autopanning when opening a popup.\r\n  \t\tif (dx || dy) {\r\n  \t\t\tmap\r\n  \t\t\t    .fire('autopanstart')\r\n  \t\t\t    .panBy([dx, dy]);\r\n  \t\t}\r\n  \t},\r\n\r\n  \t_onCloseButtonClick: function (e) {\r\n  \t\tthis._close();\r\n  \t\tstop(e);\r\n  \t},\r\n\r\n  \t_getAnchor: function () {\r\n  \t\t// Where should we anchor the popup on the source layer?\r\n  \t\treturn toPoint(this._source && this._source._getPopupAnchor ? this._source._getPopupAnchor() : [0, 0]);\r\n  \t}\r\n\r\n  });\r\n\r\n  // @namespace Popup\r\n  // @factory L.popup(options?: Popup options, source?: Layer)\r\n  // Instantiates a `Popup` object given an optional `options` object that describes its appearance and location and an optional `source` object that is used to tag the popup with a reference to the Layer to which it refers.\r\n  var popup = function (options, source) {\r\n  \treturn new Popup(options, source);\r\n  };\r\n\r\n\r\n  /* @namespace Map\r\n   * @section Interaction Options\r\n   * @option closePopupOnClick: Boolean = true\r\n   * Set it to `false` if you don't want popups to close when user clicks the map.\r\n   */\r\n  Map.mergeOptions({\r\n  \tclosePopupOnClick: true\r\n  });\r\n\r\n\r\n  // @namespace Map\r\n  // @section Methods for Layers and Controls\r\n  Map.include({\r\n  \t// @method openPopup(popup: Popup): this\r\n  \t// Opens the specified popup while closing the previously opened (to make sure only one is opened at one time for usability).\r\n  \t// @alternative\r\n  \t// @method openPopup(content: String|HTMLElement, latlng: LatLng, options?: Popup options): this\r\n  \t// Creates a popup with the specified content and options and opens it in the given point on a map.\r\n  \topenPopup: function (popup, latlng, options) {\r\n  \t\tif (!(popup instanceof Popup)) {\r\n  \t\t\tpopup = new Popup(options).setContent(popup);\r\n  \t\t}\r\n\r\n  \t\tif (latlng) {\r\n  \t\t\tpopup.setLatLng(latlng);\r\n  \t\t}\r\n\r\n  \t\tif (this.hasLayer(popup)) {\r\n  \t\t\treturn this;\r\n  \t\t}\r\n\r\n  \t\tif (this._popup && this._popup.options.autoClose) {\r\n  \t\t\tthis.closePopup();\r\n  \t\t}\r\n\r\n  \t\tthis._popup = popup;\r\n  \t\treturn this.addLayer(popup);\r\n  \t},\r\n\r\n  \t// @method closePopup(popup?: Popup): this\r\n  \t// Closes the popup previously opened with [openPopup](#map-openpopup) (or the given one).\r\n  \tclosePopup: function (popup) {\r\n  \t\tif (!popup || popup === this._popup) {\r\n  \t\t\tpopup = this._popup;\r\n  \t\t\tthis._popup = null;\r\n  \t\t}\r\n  \t\tif (popup) {\r\n  \t\t\tthis.removeLayer(popup);\r\n  \t\t}\r\n  \t\treturn this;\r\n  \t}\r\n  });\r\n\r\n  /*\r\n   * @namespace Layer\r\n   * @section Popup methods example\r\n   *\r\n   * All layers share a set of methods convenient for binding popups to it.\r\n   *\r\n   * ```js\r\n   * var layer = L.Polygon(latlngs).bindPopup('Hi There!').addTo(map);\r\n   * layer.openPopup();\r\n   * layer.closePopup();\r\n   * ```\r\n   *\r\n   * Popups will also be automatically opened when the layer is clicked on and closed when the layer is removed from the map or another popup is opened.\r\n   */\r\n\r\n  // @section Popup methods\r\n  Layer.include({\r\n\r\n  \t// @method bindPopup(content: String|HTMLElement|Function|Popup, options?: Popup options): this\r\n  \t// Binds a popup to the layer with the passed `content` and sets up the\r\n  \t// necessary event listeners. If a `Function` is passed it will receive\r\n  \t// the layer as the first argument and should return a `String` or `HTMLElement`.\r\n  \tbindPopup: function (content, options) {\r\n\r\n  \t\tif (content instanceof Popup) {\r\n  \t\t\tsetOptions(content, options);\r\n  \t\t\tthis._popup = content;\r\n  \t\t\tcontent._source = this;\r\n  \t\t} else {\r\n  \t\t\tif (!this._popup || options) {\r\n  \t\t\t\tthis._popup = new Popup(options, this);\r\n  \t\t\t}\r\n  \t\t\tthis._popup.setContent(content);\r\n  \t\t}\r\n\r\n  \t\tif (!this._popupHandlersAdded) {\r\n  \t\t\tthis.on({\r\n  \t\t\t\tclick: this._openPopup,\r\n  \t\t\t\tkeypress: this._onKeyPress,\r\n  \t\t\t\tremove: this.closePopup,\r\n  \t\t\t\tmove: this._movePopup\r\n  \t\t\t});\r\n  \t\t\tthis._popupHandlersAdded = true;\r\n  \t\t}\r\n\r\n  \t\treturn this;\r\n  \t},\r\n\r\n  \t// @method unbindPopup(): this\r\n  \t// Removes the popup previously bound with `bindPopup`.\r\n  \tunbindPopup: function () {\r\n  \t\tif (this._popup) {\r\n  \t\t\tthis.off({\r\n  \t\t\t\tclick: this._openPopup,\r\n  \t\t\t\tkeypress: this._onKeyPress,\r\n  \t\t\t\tremove: this.closePopup,\r\n  \t\t\t\tmove: this._movePopup\r\n  \t\t\t});\r\n  \t\t\tthis._popupHandlersAdded = false;\r\n  \t\t\tthis._popup = null;\r\n  \t\t}\r\n  \t\treturn this;\r\n  \t},\r\n\r\n  \t// @method openPopup(latlng?: LatLng): this\r\n  \t// Opens the bound popup at the specified `latlng` or at the default popup anchor if no `latlng` is passed.\r\n  \topenPopup: function (layer, latlng) {\r\n  \t\tif (this._popup && this._map) {\r\n  \t\t\tlatlng = this._popup._prepareOpen(this, layer, latlng);\r\n\r\n  \t\t\t// open the popup on the map\r\n  \t\t\tthis._map.openPopup(this._popup, latlng);\r\n  \t\t}\r\n\r\n  \t\treturn this;\r\n  \t},\r\n\r\n  \t// @method closePopup(): this\r\n  \t// Closes the popup bound to this layer if it is open.\r\n  \tclosePopup: function () {\r\n  \t\tif (this._popup) {\r\n  \t\t\tthis._popup._close();\r\n  \t\t}\r\n  \t\treturn this;\r\n  \t},\r\n\r\n  \t// @method togglePopup(): this\r\n  \t// Opens or closes the popup bound to this layer depending on its current state.\r\n  \ttogglePopup: function (target) {\r\n  \t\tif (this._popup) {\r\n  \t\t\tif (this._popup._map) {\r\n  \t\t\t\tthis.closePopup();\r\n  \t\t\t} else {\r\n  \t\t\t\tthis.openPopup(target);\r\n  \t\t\t}\r\n  \t\t}\r\n  \t\treturn this;\r\n  \t},\r\n\r\n  \t// @method isPopupOpen(): boolean\r\n  \t// Returns `true` if the popup bound to this layer is currently open.\r\n  \tisPopupOpen: function () {\r\n  \t\treturn (this._popup ? this._popup.isOpen() : false);\r\n  \t},\r\n\r\n  \t// @method setPopupContent(content: String|HTMLElement|Popup): this\r\n  \t// Sets the content of the popup bound to this layer.\r\n  \tsetPopupContent: function (content) {\r\n  \t\tif (this._popup) {\r\n  \t\t\tthis._popup.setContent(content);\r\n  \t\t}\r\n  \t\treturn this;\r\n  \t},\r\n\r\n  \t// @method getPopup(): Popup\r\n  \t// Returns the popup bound to this layer.\r\n  \tgetPopup: function () {\r\n  \t\treturn this._popup;\r\n  \t},\r\n\r\n  \t_openPopup: function (e) {\r\n  \t\tvar layer = e.layer || e.target;\r\n\r\n  \t\tif (!this._popup) {\r\n  \t\t\treturn;\r\n  \t\t}\r\n\r\n  \t\tif (!this._map) {\r\n  \t\t\treturn;\r\n  \t\t}\r\n\r\n  \t\t// prevent map click\r\n  \t\tstop(e);\r\n\r\n  \t\t// if this inherits from Path its a vector and we can just\r\n  \t\t// open the popup at the new location\r\n  \t\tif (layer instanceof Path) {\r\n  \t\t\tthis.openPopup(e.layer || e.target, e.latlng);\r\n  \t\t\treturn;\r\n  \t\t}\r\n\r\n  \t\t// otherwise treat it like a marker and figure out\r\n  \t\t// if we should toggle it open/closed\r\n  \t\tif (this._map.hasLayer(this._popup) && this._popup._source === layer) {\r\n  \t\t\tthis.closePopup();\r\n  \t\t} else {\r\n  \t\t\tthis.openPopup(layer, e.latlng);\r\n  \t\t}\r\n  \t},\r\n\r\n  \t_movePopup: function (e) {\r\n  \t\tthis._popup.setLatLng(e.latlng);\r\n  \t},\r\n\r\n  \t_onKeyPress: function (e) {\r\n  \t\tif (e.originalEvent.keyCode === 13) {\r\n  \t\t\tthis._openPopup(e);\r\n  \t\t}\r\n  \t}\r\n  });\n\n  /*\n   * @class Tooltip\n   * @inherits DivOverlay\n   * @aka L.Tooltip\n   * Used to display small texts on top of map layers.\n   *\n   * @example\n   *\n   * ```js\n   * marker.bindTooltip(\"my tooltip text\").openTooltip();\n   * ```\n   * Note about tooltip offset. Leaflet takes two options in consideration\n   * for computing tooltip offsetting:\n   * - the `offset` Tooltip option: it defaults to [0, 0], and it's specific to one tooltip.\n   *   Add a positive x offset to move the tooltip to the right, and a positive y offset to\n   *   move it to the bottom. Negatives will move to the left and top.\n   * - the `tooltipAnchor` Icon option: this will only be considered for Marker. You\n   *   should adapt this value if you use a custom icon.\n   */\n\n\n  // @namespace Tooltip\n  var Tooltip = DivOverlay.extend({\n\n  \t// @section\n  \t// @aka Tooltip options\n  \toptions: {\n  \t\t// @option pane: String = 'tooltipPane'\n  \t\t// `Map pane` where the tooltip will be added.\n  \t\tpane: 'tooltipPane',\n\n  \t\t// @option offset: Point = Point(0, 0)\n  \t\t// Optional offset of the tooltip position.\n  \t\toffset: [0, 0],\n\n  \t\t// @option direction: String = 'auto'\n  \t\t// Direction where to open the tooltip. Possible values are: `right`, `left`,\n  \t\t// `top`, `bottom`, `center`, `auto`.\n  \t\t// `auto` will dynamically switch between `right` and `left` according to the tooltip\n  \t\t// position on the map.\n  \t\tdirection: 'auto',\n\n  \t\t// @option permanent: Boolean = false\n  \t\t// Whether to open the tooltip permanently or only on mouseover.\n  \t\tpermanent: false,\n\n  \t\t// @option sticky: Boolean = false\n  \t\t// If true, the tooltip will follow the mouse instead of being fixed at the feature center.\n  \t\tsticky: false,\n\n  \t\t// @option interactive: Boolean = false\n  \t\t// If true, the tooltip will listen to the feature events.\n  \t\tinteractive: false,\n\n  \t\t// @option opacity: Number = 0.9\n  \t\t// Tooltip container opacity.\n  \t\topacity: 0.9\n  \t},\n\n  \tonAdd: function (map) {\n  \t\tDivOverlay.prototype.onAdd.call(this, map);\n  \t\tthis.setOpacity(this.options.opacity);\n\n  \t\t// @namespace Map\n  \t\t// @section Tooltip events\n  \t\t// @event tooltipopen: TooltipEvent\n  \t\t// Fired when a tooltip is opened in the map.\n  \t\tmap.fire('tooltipopen', {tooltip: this});\n\n  \t\tif (this._source) {\n  \t\t\t// @namespace Layer\n  \t\t\t// @section Tooltip events\n  \t\t\t// @event tooltipopen: TooltipEvent\n  \t\t\t// Fired when a tooltip bound to this layer is opened.\n  \t\t\tthis._source.fire('tooltipopen', {tooltip: this}, true);\n  \t\t}\n  \t},\n\n  \tonRemove: function (map) {\n  \t\tDivOverlay.prototype.onRemove.call(this, map);\n\n  \t\t// @namespace Map\n  \t\t// @section Tooltip events\n  \t\t// @event tooltipclose: TooltipEvent\n  \t\t// Fired when a tooltip in the map is closed.\n  \t\tmap.fire('tooltipclose', {tooltip: this});\n\n  \t\tif (this._source) {\n  \t\t\t// @namespace Layer\n  \t\t\t// @section Tooltip events\n  \t\t\t// @event tooltipclose: TooltipEvent\n  \t\t\t// Fired when a tooltip bound to this layer is closed.\n  \t\t\tthis._source.fire('tooltipclose', {tooltip: this}, true);\n  \t\t}\n  \t},\n\n  \tgetEvents: function () {\n  \t\tvar events = DivOverlay.prototype.getEvents.call(this);\n\n  \t\tif (touch && !this.options.permanent) {\n  \t\t\tevents.preclick = this._close;\n  \t\t}\n\n  \t\treturn events;\n  \t},\n\n  \t_close: function () {\n  \t\tif (this._map) {\n  \t\t\tthis._map.closeTooltip(this);\n  \t\t}\n  \t},\n\n  \t_initLayout: function () {\n  \t\tvar prefix = 'leaflet-tooltip',\n  \t\t    className = prefix + ' ' + (this.options.className || '') + ' leaflet-zoom-' + (this._zoomAnimated ? 'animated' : 'hide');\n\n  \t\tthis._contentNode = this._container = create$1('div', className);\n  \t},\n\n  \t_updateLayout: function () {},\n\n  \t_adjustPan: function () {},\n\n  \t_setPosition: function (pos) {\n  \t\tvar subX, subY,\n  \t\t    map = this._map,\n  \t\t    container = this._container,\n  \t\t    centerPoint = map.latLngToContainerPoint(map.getCenter()),\n  \t\t    tooltipPoint = map.layerPointToContainerPoint(pos),\n  \t\t    direction = this.options.direction,\n  \t\t    tooltipWidth = container.offsetWidth,\n  \t\t    tooltipHeight = container.offsetHeight,\n  \t\t    offset = toPoint(this.options.offset),\n  \t\t    anchor = this._getAnchor();\n\n  \t\tif (direction === 'top') {\n  \t\t\tsubX = tooltipWidth / 2;\n  \t\t\tsubY = tooltipHeight;\n  \t\t} else if (direction === 'bottom') {\n  \t\t\tsubX = tooltipWidth / 2;\n  \t\t\tsubY = 0;\n  \t\t} else if (direction === 'center') {\n  \t\t\tsubX = tooltipWidth / 2;\n  \t\t\tsubY = tooltipHeight / 2;\n  \t\t} else if (direction === 'right') {\n  \t\t\tsubX = 0;\n  \t\t\tsubY = tooltipHeight / 2;\n  \t\t} else if (direction === 'left') {\n  \t\t\tsubX = tooltipWidth;\n  \t\t\tsubY = tooltipHeight / 2;\n  \t\t} else if (tooltipPoint.x < centerPoint.x) {\n  \t\t\tdirection = 'right';\n  \t\t\tsubX = 0;\n  \t\t\tsubY = tooltipHeight / 2;\n  \t\t} else {\n  \t\t\tdirection = 'left';\n  \t\t\tsubX = tooltipWidth + (offset.x + anchor.x) * 2;\n  \t\t\tsubY = tooltipHeight / 2;\n  \t\t}\n\n  \t\tpos = pos.subtract(toPoint(subX, subY, true)).add(offset).add(anchor);\n\n  \t\tremoveClass(container, 'leaflet-tooltip-right');\n  \t\tremoveClass(container, 'leaflet-tooltip-left');\n  \t\tremoveClass(container, 'leaflet-tooltip-top');\n  \t\tremoveClass(container, 'leaflet-tooltip-bottom');\n  \t\taddClass(container, 'leaflet-tooltip-' + direction);\n  \t\tsetPosition(container, pos);\n  \t},\n\n  \t_updatePosition: function () {\n  \t\tvar pos = this._map.latLngToLayerPoint(this._latlng);\n  \t\tthis._setPosition(pos);\n  \t},\n\n  \tsetOpacity: function (opacity) {\n  \t\tthis.options.opacity = opacity;\n\n  \t\tif (this._container) {\n  \t\t\tsetOpacity(this._container, opacity);\n  \t\t}\n  \t},\n\n  \t_animateZoom: function (e) {\n  \t\tvar pos = this._map._latLngToNewLayerPoint(this._latlng, e.zoom, e.center);\n  \t\tthis._setPosition(pos);\n  \t},\n\n  \t_getAnchor: function () {\n  \t\t// Where should we anchor the tooltip on the source layer?\n  \t\treturn toPoint(this._source && this._source._getTooltipAnchor && !this.options.sticky ? this._source._getTooltipAnchor() : [0, 0]);\n  \t}\n\n  });\n\n  // @namespace Tooltip\n  // @factory L.tooltip(options?: Tooltip options, source?: Layer)\n  // Instantiates a Tooltip object given an optional `options` object that describes its appearance and location and an optional `source` object that is used to tag the tooltip with a reference to the Layer to which it refers.\n  var tooltip = function (options, source) {\n  \treturn new Tooltip(options, source);\n  };\n\n  // @namespace Map\n  // @section Methods for Layers and Controls\n  Map.include({\n\n  \t// @method openTooltip(tooltip: Tooltip): this\n  \t// Opens the specified tooltip.\n  \t// @alternative\n  \t// @method openTooltip(content: String|HTMLElement, latlng: LatLng, options?: Tooltip options): this\n  \t// Creates a tooltip with the specified content and options and open it.\n  \topenTooltip: function (tooltip, latlng, options) {\n  \t\tif (!(tooltip instanceof Tooltip)) {\n  \t\t\ttooltip = new Tooltip(options).setContent(tooltip);\n  \t\t}\n\n  \t\tif (latlng) {\n  \t\t\ttooltip.setLatLng(latlng);\n  \t\t}\n\n  \t\tif (this.hasLayer(tooltip)) {\n  \t\t\treturn this;\n  \t\t}\n\n  \t\treturn this.addLayer(tooltip);\n  \t},\n\n  \t// @method closeTooltip(tooltip?: Tooltip): this\n  \t// Closes the tooltip given as parameter.\n  \tcloseTooltip: function (tooltip) {\n  \t\tif (tooltip) {\n  \t\t\tthis.removeLayer(tooltip);\n  \t\t}\n  \t\treturn this;\n  \t}\n\n  });\n\n  /*\n   * @namespace Layer\n   * @section Tooltip methods example\n   *\n   * All layers share a set of methods convenient for binding tooltips to it.\n   *\n   * ```js\n   * var layer = L.Polygon(latlngs).bindTooltip('Hi There!').addTo(map);\n   * layer.openTooltip();\n   * layer.closeTooltip();\n   * ```\n   */\n\n  // @section Tooltip methods\n  Layer.include({\n\n  \t// @method bindTooltip(content: String|HTMLElement|Function|Tooltip, options?: Tooltip options): this\n  \t// Binds a tooltip to the layer with the passed `content` and sets up the\n  \t// necessary event listeners. If a `Function` is passed it will receive\n  \t// the layer as the first argument and should return a `String` or `HTMLElement`.\n  \tbindTooltip: function (content, options) {\n\n  \t\tif (content instanceof Tooltip) {\n  \t\t\tsetOptions(content, options);\n  \t\t\tthis._tooltip = content;\n  \t\t\tcontent._source = this;\n  \t\t} else {\n  \t\t\tif (!this._tooltip || options) {\n  \t\t\t\tthis._tooltip = new Tooltip(options, this);\n  \t\t\t}\n  \t\t\tthis._tooltip.setContent(content);\n\n  \t\t}\n\n  \t\tthis._initTooltipInteractions();\n\n  \t\tif (this._tooltip.options.permanent && this._map && this._map.hasLayer(this)) {\n  \t\t\tthis.openTooltip();\n  \t\t}\n\n  \t\treturn this;\n  \t},\n\n  \t// @method unbindTooltip(): this\n  \t// Removes the tooltip previously bound with `bindTooltip`.\n  \tunbindTooltip: function () {\n  \t\tif (this._tooltip) {\n  \t\t\tthis._initTooltipInteractions(true);\n  \t\t\tthis.closeTooltip();\n  \t\t\tthis._tooltip = null;\n  \t\t}\n  \t\treturn this;\n  \t},\n\n  \t_initTooltipInteractions: function (remove$$1) {\n  \t\tif (!remove$$1 && this._tooltipHandlersAdded) { return; }\n  \t\tvar onOff = remove$$1 ? 'off' : 'on',\n  \t\t    events = {\n  \t\t\tremove: this.closeTooltip,\n  \t\t\tmove: this._moveTooltip\n  \t\t    };\n  \t\tif (!this._tooltip.options.permanent) {\n  \t\t\tevents.mouseover = this._openTooltip;\n  \t\t\tevents.mouseout = this.closeTooltip;\n  \t\t\tif (this._tooltip.options.sticky) {\n  \t\t\t\tevents.mousemove = this._moveTooltip;\n  \t\t\t}\n  \t\t\tif (touch) {\n  \t\t\t\tevents.click = this._openTooltip;\n  \t\t\t}\n  \t\t} else {\n  \t\t\tevents.add = this._openTooltip;\n  \t\t}\n  \t\tthis[onOff](events);\n  \t\tthis._tooltipHandlersAdded = !remove$$1;\n  \t},\n\n  \t// @method openTooltip(latlng?: LatLng): this\n  \t// Opens the bound tooltip at the specified `latlng` or at the default tooltip anchor if no `latlng` is passed.\n  \topenTooltip: function (layer, latlng) {\n  \t\tif (this._tooltip && this._map) {\n  \t\t\tlatlng = this._tooltip._prepareOpen(this, layer, latlng);\n\n  \t\t\t// open the tooltip on the map\n  \t\t\tthis._map.openTooltip(this._tooltip, latlng);\n\n  \t\t\t// Tooltip container may not be defined if not permanent and never\n  \t\t\t// opened.\n  \t\t\tif (this._tooltip.options.interactive && this._tooltip._container) {\n  \t\t\t\taddClass(this._tooltip._container, 'leaflet-clickable');\n  \t\t\t\tthis.addInteractiveTarget(this._tooltip._container);\n  \t\t\t}\n  \t\t}\n\n  \t\treturn this;\n  \t},\n\n  \t// @method closeTooltip(): this\n  \t// Closes the tooltip bound to this layer if it is open.\n  \tcloseTooltip: function () {\n  \t\tif (this._tooltip) {\n  \t\t\tthis._tooltip._close();\n  \t\t\tif (this._tooltip.options.interactive && this._tooltip._container) {\n  \t\t\t\tremoveClass(this._tooltip._container, 'leaflet-clickable');\n  \t\t\t\tthis.removeInteractiveTarget(this._tooltip._container);\n  \t\t\t}\n  \t\t}\n  \t\treturn this;\n  \t},\n\n  \t// @method toggleTooltip(): this\n  \t// Opens or closes the tooltip bound to this layer depending on its current state.\n  \ttoggleTooltip: function (target) {\n  \t\tif (this._tooltip) {\n  \t\t\tif (this._tooltip._map) {\n  \t\t\t\tthis.closeTooltip();\n  \t\t\t} else {\n  \t\t\t\tthis.openTooltip(target);\n  \t\t\t}\n  \t\t}\n  \t\treturn this;\n  \t},\n\n  \t// @method isTooltipOpen(): boolean\n  \t// Returns `true` if the tooltip bound to this layer is currently open.\n  \tisTooltipOpen: function () {\n  \t\treturn this._tooltip.isOpen();\n  \t},\n\n  \t// @method setTooltipContent(content: String|HTMLElement|Tooltip): this\n  \t// Sets the content of the tooltip bound to this layer.\n  \tsetTooltipContent: function (content) {\n  \t\tif (this._tooltip) {\n  \t\t\tthis._tooltip.setContent(content);\n  \t\t}\n  \t\treturn this;\n  \t},\n\n  \t// @method getTooltip(): Tooltip\n  \t// Returns the tooltip bound to this layer.\n  \tgetTooltip: function () {\n  \t\treturn this._tooltip;\n  \t},\n\n  \t_openTooltip: function (e) {\n  \t\tvar layer = e.layer || e.target;\n\n  \t\tif (!this._tooltip || !this._map) {\n  \t\t\treturn;\n  \t\t}\n  \t\tthis.openTooltip(layer, this._tooltip.options.sticky ? e.latlng : undefined);\n  \t},\n\n  \t_moveTooltip: function (e) {\n  \t\tvar latlng = e.latlng, containerPoint, layerPoint;\n  \t\tif (this._tooltip.options.sticky && e.originalEvent) {\n  \t\t\tcontainerPoint = this._map.mouseEventToContainerPoint(e.originalEvent);\n  \t\t\tlayerPoint = this._map.containerPointToLayerPoint(containerPoint);\n  \t\t\tlatlng = this._map.layerPointToLatLng(layerPoint);\n  \t\t}\n  \t\tthis._tooltip.setLatLng(latlng);\n  \t}\n  });\n\n  /*\n   * @class DivIcon\n   * @aka L.DivIcon\n   * @inherits Icon\n   *\n   * Represents a lightweight icon for markers that uses a simple `<div>`\n   * element instead of an image. Inherits from `Icon` but ignores the `iconUrl` and shadow options.\n   *\n   * @example\n   * ```js\n   * var myIcon = L.divIcon({className: 'my-div-icon'});\n   * // you can set .my-div-icon styles in CSS\n   *\n   * L.marker([50.505, 30.57], {icon: myIcon}).addTo(map);\n   * ```\n   *\n   * By default, it has a 'leaflet-div-icon' CSS class and is styled as a little white square with a shadow.\n   */\n\n  var DivIcon = Icon.extend({\n  \toptions: {\n  \t\t// @section\n  \t\t// @aka DivIcon options\n  \t\ticonSize: [12, 12], // also can be set through CSS\n\n  \t\t// iconAnchor: (Point),\n  \t\t// popupAnchor: (Point),\n\n  \t\t// @option html: String|HTMLElement = ''\n  \t\t// Custom HTML code to put inside the div element, empty by default. Alternatively,\n  \t\t// an instance of `HTMLElement`.\n  \t\thtml: false,\n\n  \t\t// @option bgPos: Point = [0, 0]\n  \t\t// Optional relative position of the background, in pixels\n  \t\tbgPos: null,\n\n  \t\tclassName: 'leaflet-div-icon'\n  \t},\n\n  \tcreateIcon: function (oldIcon) {\n  \t\tvar div = (oldIcon && oldIcon.tagName === 'DIV') ? oldIcon : document.createElement('div'),\n  \t\t    options = this.options;\n\n  \t\tif (options.html instanceof Element) {\n  \t\t\tempty(div);\n  \t\t\tdiv.appendChild(options.html);\n  \t\t} else {\n  \t\t\tdiv.innerHTML = options.html !== false ? options.html : '';\n  \t\t}\n\n  \t\tif (options.bgPos) {\n  \t\t\tvar bgPos = toPoint(options.bgPos);\n  \t\t\tdiv.style.backgroundPosition = (-bgPos.x) + 'px ' + (-bgPos.y) + 'px';\n  \t\t}\n  \t\tthis._setIconStyles(div, 'icon');\n\n  \t\treturn div;\n  \t},\n\n  \tcreateShadow: function () {\n  \t\treturn null;\n  \t}\n  });\n\n  // @factory L.divIcon(options: DivIcon options)\n  // Creates a `DivIcon` instance with the given options.\n  function divIcon(options) {\n  \treturn new DivIcon(options);\n  }\n\n  Icon.Default = IconDefault;\n\n  /*\n   * @class GridLayer\n   * @inherits Layer\n   * @aka L.GridLayer\n   *\n   * Generic class for handling a tiled grid of HTML elements. This is the base class for all tile layers and replaces `TileLayer.Canvas`.\n   * GridLayer can be extended to create a tiled grid of HTML elements like `<canvas>`, `<img>` or `<div>`. GridLayer will handle creating and animating these DOM elements for you.\n   *\n   *\n   * @section Synchronous usage\n   * @example\n   *\n   * To create a custom layer, extend GridLayer and implement the `createTile()` method, which will be passed a `Point` object with the `x`, `y`, and `z` (zoom level) coordinates to draw your tile.\n   *\n   * ```js\n   * var CanvasLayer = L.GridLayer.extend({\n   *     createTile: function(coords){\n   *         // create a <canvas> element for drawing\n   *         var tile = L.DomUtil.create('canvas', 'leaflet-tile');\n   *\n   *         // setup tile width and height according to the options\n   *         var size = this.getTileSize();\n   *         tile.width = size.x;\n   *         tile.height = size.y;\n   *\n   *         // get a canvas context and draw something on it using coords.x, coords.y and coords.z\n   *         var ctx = tile.getContext('2d');\n   *\n   *         // return the tile so it can be rendered on screen\n   *         return tile;\n   *     }\n   * });\n   * ```\n   *\n   * @section Asynchronous usage\n   * @example\n   *\n   * Tile creation can also be asynchronous, this is useful when using a third-party drawing library. Once the tile is finished drawing it can be passed to the `done()` callback.\n   *\n   * ```js\n   * var CanvasLayer = L.GridLayer.extend({\n   *     createTile: function(coords, done){\n   *         var error;\n   *\n   *         // create a <canvas> element for drawing\n   *         var tile = L.DomUtil.create('canvas', 'leaflet-tile');\n   *\n   *         // setup tile width and height according to the options\n   *         var size = this.getTileSize();\n   *         tile.width = size.x;\n   *         tile.height = size.y;\n   *\n   *         // draw something asynchronously and pass the tile to the done() callback\n   *         setTimeout(function() {\n   *             done(error, tile);\n   *         }, 1000);\n   *\n   *         return tile;\n   *     }\n   * });\n   * ```\n   *\n   * @section\n   */\n\n\n  var GridLayer = Layer.extend({\n\n  \t// @section\n  \t// @aka GridLayer options\n  \toptions: {\n  \t\t// @option tileSize: Number|Point = 256\n  \t\t// Width and height of tiles in the grid. Use a number if width and height are equal, or `L.point(width, height)` otherwise.\n  \t\ttileSize: 256,\n\n  \t\t// @option opacity: Number = 1.0\n  \t\t// Opacity of the tiles. Can be used in the `createTile()` function.\n  \t\topacity: 1,\n\n  \t\t// @option updateWhenIdle: Boolean = (depends)\n  \t\t// Load new tiles only when panning ends.\n  \t\t// `true` by default on mobile browsers, in order to avoid too many requests and keep smooth navigation.\n  \t\t// `false` otherwise in order to display new tiles _during_ panning, since it is easy to pan outside the\n  \t\t// [`keepBuffer`](#gridlayer-keepbuffer) option in desktop browsers.\n  \t\tupdateWhenIdle: mobile,\n\n  \t\t// @option updateWhenZooming: Boolean = true\n  \t\t// By default, a smooth zoom animation (during a [touch zoom](#map-touchzoom) or a [`flyTo()`](#map-flyto)) will update grid layers every integer zoom level. Setting this option to `false` will update the grid layer only when the smooth animation ends.\n  \t\tupdateWhenZooming: true,\n\n  \t\t// @option updateInterval: Number = 200\n  \t\t// Tiles will not update more than once every `updateInterval` milliseconds when panning.\n  \t\tupdateInterval: 200,\n\n  \t\t// @option zIndex: Number = 1\n  \t\t// The explicit zIndex of the tile layer.\n  \t\tzIndex: 1,\n\n  \t\t// @option bounds: LatLngBounds = undefined\n  \t\t// If set, tiles will only be loaded inside the set `LatLngBounds`.\n  \t\tbounds: null,\n\n  \t\t// @option minZoom: Number = 0\n  \t\t// The minimum zoom level down to which this layer will be displayed (inclusive).\n  \t\tminZoom: 0,\n\n  \t\t// @option maxZoom: Number = undefined\n  \t\t// The maximum zoom level up to which this layer will be displayed (inclusive).\n  \t\tmaxZoom: undefined,\n\n  \t\t// @option maxNativeZoom: Number = undefined\n  \t\t// Maximum zoom number the tile source has available. If it is specified,\n  \t\t// the tiles on all zoom levels higher than `maxNativeZoom` will be loaded\n  \t\t// from `maxNativeZoom` level and auto-scaled.\n  \t\tmaxNativeZoom: undefined,\n\n  \t\t// @option minNativeZoom: Number = undefined\n  \t\t// Minimum zoom number the tile source has available. If it is specified,\n  \t\t// the tiles on all zoom levels lower than `minNativeZoom` will be loaded\n  \t\t// from `minNativeZoom` level and auto-scaled.\n  \t\tminNativeZoom: undefined,\n\n  \t\t// @option noWrap: Boolean = false\n  \t\t// Whether the layer is wrapped around the antimeridian. If `true`, the\n  \t\t// GridLayer will only be displayed once at low zoom levels. Has no\n  \t\t// effect when the [map CRS](#map-crs) doesn't wrap around. Can be used\n  \t\t// in combination with [`bounds`](#gridlayer-bounds) to prevent requesting\n  \t\t// tiles outside the CRS limits.\n  \t\tnoWrap: false,\n\n  \t\t// @option pane: String = 'tilePane'\n  \t\t// `Map pane` where the grid layer will be added.\n  \t\tpane: 'tilePane',\n\n  \t\t// @option className: String = ''\n  \t\t// A custom class name to assign to the tile layer. Empty by default.\n  \t\tclassName: '',\n\n  \t\t// @option keepBuffer: Number = 2\n  \t\t// When panning the map, keep this many rows and columns of tiles before unloading them.\n  \t\tkeepBuffer: 2\n  \t},\n\n  \tinitialize: function (options) {\n  \t\tsetOptions(this, options);\n  \t},\n\n  \tonAdd: function () {\n  \t\tthis._initContainer();\n\n  \t\tthis._levels = {};\n  \t\tthis._tiles = {};\n\n  \t\tthis._resetView();\n  \t\tthis._update();\n  \t},\n\n  \tbeforeAdd: function (map) {\n  \t\tmap._addZoomLimit(this);\n  \t},\n\n  \tonRemove: function (map) {\n  \t\tthis._removeAllTiles();\n  \t\tremove(this._container);\n  \t\tmap._removeZoomLimit(this);\n  \t\tthis._container = null;\n  \t\tthis._tileZoom = undefined;\n  \t},\n\n  \t// @method bringToFront: this\n  \t// Brings the tile layer to the top of all tile layers.\n  \tbringToFront: function () {\n  \t\tif (this._map) {\n  \t\t\ttoFront(this._container);\n  \t\t\tthis._setAutoZIndex(Math.max);\n  \t\t}\n  \t\treturn this;\n  \t},\n\n  \t// @method bringToBack: this\n  \t// Brings the tile layer to the bottom of all tile layers.\n  \tbringToBack: function () {\n  \t\tif (this._map) {\n  \t\t\ttoBack(this._container);\n  \t\t\tthis._setAutoZIndex(Math.min);\n  \t\t}\n  \t\treturn this;\n  \t},\n\n  \t// @method getContainer: HTMLElement\n  \t// Returns the HTML element that contains the tiles for this layer.\n  \tgetContainer: function () {\n  \t\treturn this._container;\n  \t},\n\n  \t// @method setOpacity(opacity: Number): this\n  \t// Changes the [opacity](#gridlayer-opacity) of the grid layer.\n  \tsetOpacity: function (opacity) {\n  \t\tthis.options.opacity = opacity;\n  \t\tthis._updateOpacity();\n  \t\treturn this;\n  \t},\n\n  \t// @method setZIndex(zIndex: Number): this\n  \t// Changes the [zIndex](#gridlayer-zindex) of the grid layer.\n  \tsetZIndex: function (zIndex) {\n  \t\tthis.options.zIndex = zIndex;\n  \t\tthis._updateZIndex();\n\n  \t\treturn this;\n  \t},\n\n  \t// @method isLoading: Boolean\n  \t// Returns `true` if any tile in the grid layer has not finished loading.\n  \tisLoading: function () {\n  \t\treturn this._loading;\n  \t},\n\n  \t// @method redraw: this\n  \t// Causes the layer to clear all the tiles and request them again.\n  \tredraw: function () {\n  \t\tif (this._map) {\n  \t\t\tthis._removeAllTiles();\n  \t\t\tthis._update();\n  \t\t}\n  \t\treturn this;\n  \t},\n\n  \tgetEvents: function () {\n  \t\tvar events = {\n  \t\t\tviewprereset: this._invalidateAll,\n  \t\t\tviewreset: this._resetView,\n  \t\t\tzoom: this._resetView,\n  \t\t\tmoveend: this._onMoveEnd\n  \t\t};\n\n  \t\tif (!this.options.updateWhenIdle) {\n  \t\t\t// update tiles on move, but not more often than once per given interval\n  \t\t\tif (!this._onMove) {\n  \t\t\t\tthis._onMove = throttle(this._onMoveEnd, this.options.updateInterval, this);\n  \t\t\t}\n\n  \t\t\tevents.move = this._onMove;\n  \t\t}\n\n  \t\tif (this._zoomAnimated) {\n  \t\t\tevents.zoomanim = this._animateZoom;\n  \t\t}\n\n  \t\treturn events;\n  \t},\n\n  \t// @section Extension methods\n  \t// Layers extending `GridLayer` shall reimplement the following method.\n  \t// @method createTile(coords: Object, done?: Function): HTMLElement\n  \t// Called only internally, must be overridden by classes extending `GridLayer`.\n  \t// Returns the `HTMLElement` corresponding to the given `coords`. If the `done` callback\n  \t// is specified, it must be called when the tile has finished loading and drawing.\n  \tcreateTile: function () {\n  \t\treturn document.createElement('div');\n  \t},\n\n  \t// @section\n  \t// @method getTileSize: Point\n  \t// Normalizes the [tileSize option](#gridlayer-tilesize) into a point. Used by the `createTile()` method.\n  \tgetTileSize: function () {\n  \t\tvar s = this.options.tileSize;\n  \t\treturn s instanceof Point ? s : new Point(s, s);\n  \t},\n\n  \t_updateZIndex: function () {\n  \t\tif (this._container && this.options.zIndex !== undefined && this.options.zIndex !== null) {\n  \t\t\tthis._container.style.zIndex = this.options.zIndex;\n  \t\t}\n  \t},\n\n  \t_setAutoZIndex: function (compare) {\n  \t\t// go through all other layers of the same pane, set zIndex to max + 1 (front) or min - 1 (back)\n\n  \t\tvar layers = this.getPane().children,\n  \t\t    edgeZIndex = -compare(-Infinity, Infinity); // -Infinity for max, Infinity for min\n\n  \t\tfor (var i = 0, len = layers.length, zIndex; i < len; i++) {\n\n  \t\t\tzIndex = layers[i].style.zIndex;\n\n  \t\t\tif (layers[i] !== this._container && zIndex) {\n  \t\t\t\tedgeZIndex = compare(edgeZIndex, +zIndex);\n  \t\t\t}\n  \t\t}\n\n  \t\tif (isFinite(edgeZIndex)) {\n  \t\t\tthis.options.zIndex = edgeZIndex + compare(-1, 1);\n  \t\t\tthis._updateZIndex();\n  \t\t}\n  \t},\n\n  \t_updateOpacity: function () {\n  \t\tif (!this._map) { return; }\n\n  \t\t// IE doesn't inherit filter opacity properly, so we're forced to set it on tiles\n  \t\tif (ielt9) { return; }\n\n  \t\tsetOpacity(this._container, this.options.opacity);\n\n  \t\tvar now = +new Date(),\n  \t\t    nextFrame = false,\n  \t\t    willPrune = false;\n\n  \t\tfor (var key in this._tiles) {\n  \t\t\tvar tile = this._tiles[key];\n  \t\t\tif (!tile.current || !tile.loaded) { continue; }\n\n  \t\t\tvar fade = Math.min(1, (now - tile.loaded) / 200);\n\n  \t\t\tsetOpacity(tile.el, fade);\n  \t\t\tif (fade < 1) {\n  \t\t\t\tnextFrame = true;\n  \t\t\t} else {\n  \t\t\t\tif (tile.active) {\n  \t\t\t\t\twillPrune = true;\n  \t\t\t\t} else {\n  \t\t\t\t\tthis._onOpaqueTile(tile);\n  \t\t\t\t}\n  \t\t\t\ttile.active = true;\n  \t\t\t}\n  \t\t}\n\n  \t\tif (willPrune && !this._noPrune) { this._pruneTiles(); }\n\n  \t\tif (nextFrame) {\n  \t\t\tcancelAnimFrame(this._fadeFrame);\n  \t\t\tthis._fadeFrame = requestAnimFrame(this._updateOpacity, this);\n  \t\t}\n  \t},\n\n  \t_onOpaqueTile: falseFn,\n\n  \t_initContainer: function () {\n  \t\tif (this._container) { return; }\n\n  \t\tthis._container = create$1('div', 'leaflet-layer ' + (this.options.className || ''));\n  \t\tthis._updateZIndex();\n\n  \t\tif (this.options.opacity < 1) {\n  \t\t\tthis._updateOpacity();\n  \t\t}\n\n  \t\tthis.getPane().appendChild(this._container);\n  \t},\n\n  \t_updateLevels: function () {\n\n  \t\tvar zoom = this._tileZoom,\n  \t\t    maxZoom = this.options.maxZoom;\n\n  \t\tif (zoom === undefined) { return undefined; }\n\n  \t\tfor (var z in this._levels) {\n  \t\t\tz = Number(z);\n  \t\t\tif (this._levels[z].el.children.length || z === zoom) {\n  \t\t\t\tthis._levels[z].el.style.zIndex = maxZoom - Math.abs(zoom - z);\n  \t\t\t\tthis._onUpdateLevel(z);\n  \t\t\t} else {\n  \t\t\t\tremove(this._levels[z].el);\n  \t\t\t\tthis._removeTilesAtZoom(z);\n  \t\t\t\tthis._onRemoveLevel(z);\n  \t\t\t\tdelete this._levels[z];\n  \t\t\t}\n  \t\t}\n\n  \t\tvar level = this._levels[zoom],\n  \t\t    map = this._map;\n\n  \t\tif (!level) {\n  \t\t\tlevel = this._levels[zoom] = {};\n\n  \t\t\tlevel.el = create$1('div', 'leaflet-tile-container leaflet-zoom-animated', this._container);\n  \t\t\tlevel.el.style.zIndex = maxZoom;\n\n  \t\t\tlevel.origin = map.project(map.unproject(map.getPixelOrigin()), zoom).round();\n  \t\t\tlevel.zoom = zoom;\n\n  \t\t\tthis._setZoomTransform(level, map.getCenter(), map.getZoom());\n\n  \t\t\t// force the browser to consider the newly added element for transition\n  \t\t\tfalseFn(level.el.offsetWidth);\n\n  \t\t\tthis._onCreateLevel(level);\n  \t\t}\n\n  \t\tthis._level = level;\n\n  \t\treturn level;\n  \t},\n\n  \t_onUpdateLevel: falseFn,\n\n  \t_onRemoveLevel: falseFn,\n\n  \t_onCreateLevel: falseFn,\n\n  \t_pruneTiles: function () {\n  \t\tif (!this._map) {\n  \t\t\treturn;\n  \t\t}\n\n  \t\tvar key, tile;\n\n  \t\tvar zoom = this._map.getZoom();\n  \t\tif (zoom > this.options.maxZoom ||\n  \t\t\tzoom < this.options.minZoom) {\n  \t\t\tthis._removeAllTiles();\n  \t\t\treturn;\n  \t\t}\n\n  \t\tfor (key in this._tiles) {\n  \t\t\ttile = this._tiles[key];\n  \t\t\ttile.retain = tile.current;\n  \t\t}\n\n  \t\tfor (key in this._tiles) {\n  \t\t\ttile = this._tiles[key];\n  \t\t\tif (tile.current && !tile.active) {\n  \t\t\t\tvar coords = tile.coords;\n  \t\t\t\tif (!this._retainParent(coords.x, coords.y, coords.z, coords.z - 5)) {\n  \t\t\t\t\tthis._retainChildren(coords.x, coords.y, coords.z, coords.z + 2);\n  \t\t\t\t}\n  \t\t\t}\n  \t\t}\n\n  \t\tfor (key in this._tiles) {\n  \t\t\tif (!this._tiles[key].retain) {\n  \t\t\t\tthis._removeTile(key);\n  \t\t\t}\n  \t\t}\n  \t},\n\n  \t_removeTilesAtZoom: function (zoom) {\n  \t\tfor (var key in this._tiles) {\n  \t\t\tif (this._tiles[key].coords.z !== zoom) {\n  \t\t\t\tcontinue;\n  \t\t\t}\n  \t\t\tthis._removeTile(key);\n  \t\t}\n  \t},\n\n  \t_removeAllTiles: function () {\n  \t\tfor (var key in this._tiles) {\n  \t\t\tthis._removeTile(key);\n  \t\t}\n  \t},\n\n  \t_invalidateAll: function () {\n  \t\tfor (var z in this._levels) {\n  \t\t\tremove(this._levels[z].el);\n  \t\t\tthis._onRemoveLevel(Number(z));\n  \t\t\tdelete this._levels[z];\n  \t\t}\n  \t\tthis._removeAllTiles();\n\n  \t\tthis._tileZoom = undefined;\n  \t},\n\n  \t_retainParent: function (x, y, z, minZoom) {\n  \t\tvar x2 = Math.floor(x / 2),\n  \t\t    y2 = Math.floor(y / 2),\n  \t\t    z2 = z - 1,\n  \t\t    coords2 = new Point(+x2, +y2);\n  \t\tcoords2.z = +z2;\n\n  \t\tvar key = this._tileCoordsToKey(coords2),\n  \t\t    tile = this._tiles[key];\n\n  \t\tif (tile && tile.active) {\n  \t\t\ttile.retain = true;\n  \t\t\treturn true;\n\n  \t\t} else if (tile && tile.loaded) {\n  \t\t\ttile.retain = true;\n  \t\t}\n\n  \t\tif (z2 > minZoom) {\n  \t\t\treturn this._retainParent(x2, y2, z2, minZoom);\n  \t\t}\n\n  \t\treturn false;\n  \t},\n\n  \t_retainChildren: function (x, y, z, maxZoom) {\n\n  \t\tfor (var i = 2 * x; i < 2 * x + 2; i++) {\n  \t\t\tfor (var j = 2 * y; j < 2 * y + 2; j++) {\n\n  \t\t\t\tvar coords = new Point(i, j);\n  \t\t\t\tcoords.z = z + 1;\n\n  \t\t\t\tvar key = this._tileCoordsToKey(coords),\n  \t\t\t\t    tile = this._tiles[key];\n\n  \t\t\t\tif (tile && tile.active) {\n  \t\t\t\t\ttile.retain = true;\n  \t\t\t\t\tcontinue;\n\n  \t\t\t\t} else if (tile && tile.loaded) {\n  \t\t\t\t\ttile.retain = true;\n  \t\t\t\t}\n\n  \t\t\t\tif (z + 1 < maxZoom) {\n  \t\t\t\t\tthis._retainChildren(i, j, z + 1, maxZoom);\n  \t\t\t\t}\n  \t\t\t}\n  \t\t}\n  \t},\n\n  \t_resetView: function (e) {\n  \t\tvar animating = e && (e.pinch || e.flyTo);\n  \t\tthis._setView(this._map.getCenter(), this._map.getZoom(), animating, animating);\n  \t},\n\n  \t_animateZoom: function (e) {\n  \t\tthis._setView(e.center, e.zoom, true, e.noUpdate);\n  \t},\n\n  \t_clampZoom: function (zoom) {\n  \t\tvar options = this.options;\n\n  \t\tif (undefined !== options.minNativeZoom && zoom < options.minNativeZoom) {\n  \t\t\treturn options.minNativeZoom;\n  \t\t}\n\n  \t\tif (undefined !== options.maxNativeZoom && options.maxNativeZoom < zoom) {\n  \t\t\treturn options.maxNativeZoom;\n  \t\t}\n\n  \t\treturn zoom;\n  \t},\n\n  \t_setView: function (center, zoom, noPrune, noUpdate) {\n  \t\tvar tileZoom = Math.round(zoom);\n  \t\tif ((this.options.maxZoom !== undefined && tileZoom > this.options.maxZoom) ||\n  \t\t    (this.options.minZoom !== undefined && tileZoom < this.options.minZoom)) {\n  \t\t\ttileZoom = undefined;\n  \t\t} else {\n  \t\t\ttileZoom = this._clampZoom(tileZoom);\n  \t\t}\n\n  \t\tvar tileZoomChanged = this.options.updateWhenZooming && (tileZoom !== this._tileZoom);\n\n  \t\tif (!noUpdate || tileZoomChanged) {\n\n  \t\t\tthis._tileZoom = tileZoom;\n\n  \t\t\tif (this._abortLoading) {\n  \t\t\t\tthis._abortLoading();\n  \t\t\t}\n\n  \t\t\tthis._updateLevels();\n  \t\t\tthis._resetGrid();\n\n  \t\t\tif (tileZoom !== undefined) {\n  \t\t\t\tthis._update(center);\n  \t\t\t}\n\n  \t\t\tif (!noPrune) {\n  \t\t\t\tthis._pruneTiles();\n  \t\t\t}\n\n  \t\t\t// Flag to prevent _updateOpacity from pruning tiles during\n  \t\t\t// a zoom anim or a pinch gesture\n  \t\t\tthis._noPrune = !!noPrune;\n  \t\t}\n\n  \t\tthis._setZoomTransforms(center, zoom);\n  \t},\n\n  \t_setZoomTransforms: function (center, zoom) {\n  \t\tfor (var i in this._levels) {\n  \t\t\tthis._setZoomTransform(this._levels[i], center, zoom);\n  \t\t}\n  \t},\n\n  \t_setZoomTransform: function (level, center, zoom) {\n  \t\tvar scale = this._map.getZoomScale(zoom, level.zoom),\n  \t\t    translate = level.origin.multiplyBy(scale)\n  \t\t        .subtract(this._map._getNewPixelOrigin(center, zoom)).round();\n\n  \t\tif (any3d) {\n  \t\t\tsetTransform(level.el, translate, scale);\n  \t\t} else {\n  \t\t\tsetPosition(level.el, translate);\n  \t\t}\n  \t},\n\n  \t_resetGrid: function () {\n  \t\tvar map = this._map,\n  \t\t    crs = map.options.crs,\n  \t\t    tileSize = this._tileSize = this.getTileSize(),\n  \t\t    tileZoom = this._tileZoom;\n\n  \t\tvar bounds = this._map.getPixelWorldBounds(this._tileZoom);\n  \t\tif (bounds) {\n  \t\t\tthis._globalTileRange = this._pxBoundsToTileRange(bounds);\n  \t\t}\n\n  \t\tthis._wrapX = crs.wrapLng && !this.options.noWrap && [\n  \t\t\tMath.floor(map.project([0, crs.wrapLng[0]], tileZoom).x / tileSize.x),\n  \t\t\tMath.ceil(map.project([0, crs.wrapLng[1]], tileZoom).x / tileSize.y)\n  \t\t];\n  \t\tthis._wrapY = crs.wrapLat && !this.options.noWrap && [\n  \t\t\tMath.floor(map.project([crs.wrapLat[0], 0], tileZoom).y / tileSize.x),\n  \t\t\tMath.ceil(map.project([crs.wrapLat[1], 0], tileZoom).y / tileSize.y)\n  \t\t];\n  \t},\n\n  \t_onMoveEnd: function () {\n  \t\tif (!this._map || this._map._animatingZoom) { return; }\n\n  \t\tthis._update();\n  \t},\n\n  \t_getTiledPixelBounds: function (center) {\n  \t\tvar map = this._map,\n  \t\t    mapZoom = map._animatingZoom ? Math.max(map._animateToZoom, map.getZoom()) : map.getZoom(),\n  \t\t    scale = map.getZoomScale(mapZoom, this._tileZoom),\n  \t\t    pixelCenter = map.project(center, this._tileZoom).floor(),\n  \t\t    halfSize = map.getSize().divideBy(scale * 2);\n\n  \t\treturn new Bounds(pixelCenter.subtract(halfSize), pixelCenter.add(halfSize));\n  \t},\n\n  \t// Private method to load tiles in the grid's active zoom level according to map bounds\n  \t_update: function (center) {\n  \t\tvar map = this._map;\n  \t\tif (!map) { return; }\n  \t\tvar zoom = this._clampZoom(map.getZoom());\n\n  \t\tif (center === undefined) { center = map.getCenter(); }\n  \t\tif (this._tileZoom === undefined) { return; }\t// if out of minzoom/maxzoom\n\n  \t\tvar pixelBounds = this._getTiledPixelBounds(center),\n  \t\t    tileRange = this._pxBoundsToTileRange(pixelBounds),\n  \t\t    tileCenter = tileRange.getCenter(),\n  \t\t    queue = [],\n  \t\t    margin = this.options.keepBuffer,\n  \t\t    noPruneRange = new Bounds(tileRange.getBottomLeft().subtract([margin, -margin]),\n  \t\t                              tileRange.getTopRight().add([margin, -margin]));\n\n  \t\t// Sanity check: panic if the tile range contains Infinity somewhere.\n  \t\tif (!(isFinite(tileRange.min.x) &&\n  \t\t      isFinite(tileRange.min.y) &&\n  \t\t      isFinite(tileRange.max.x) &&\n  \t\t      isFinite(tileRange.max.y))) { throw new Error('Attempted to load an infinite number of tiles'); }\n\n  \t\tfor (var key in this._tiles) {\n  \t\t\tvar c = this._tiles[key].coords;\n  \t\t\tif (c.z !== this._tileZoom || !noPruneRange.contains(new Point(c.x, c.y))) {\n  \t\t\t\tthis._tiles[key].current = false;\n  \t\t\t}\n  \t\t}\n\n  \t\t// _update just loads more tiles. If the tile zoom level differs too much\n  \t\t// from the map's, let _setView reset levels and prune old tiles.\n  \t\tif (Math.abs(zoom - this._tileZoom) > 1) { this._setView(center, zoom); return; }\n\n  \t\t// create a queue of coordinates to load tiles from\n  \t\tfor (var j = tileRange.min.y; j <= tileRange.max.y; j++) {\n  \t\t\tfor (var i = tileRange.min.x; i <= tileRange.max.x; i++) {\n  \t\t\t\tvar coords = new Point(i, j);\n  \t\t\t\tcoords.z = this._tileZoom;\n\n  \t\t\t\tif (!this._isValidTile(coords)) { continue; }\n\n  \t\t\t\tvar tile = this._tiles[this._tileCoordsToKey(coords)];\n  \t\t\t\tif (tile) {\n  \t\t\t\t\ttile.current = true;\n  \t\t\t\t} else {\n  \t\t\t\t\tqueue.push(coords);\n  \t\t\t\t}\n  \t\t\t}\n  \t\t}\n\n  \t\t// sort tile queue to load tiles in order of their distance to center\n  \t\tqueue.sort(function (a, b) {\n  \t\t\treturn a.distanceTo(tileCenter) - b.distanceTo(tileCenter);\n  \t\t});\n\n  \t\tif (queue.length !== 0) {\n  \t\t\t// if it's the first batch of tiles to load\n  \t\t\tif (!this._loading) {\n  \t\t\t\tthis._loading = true;\n  \t\t\t\t// @event loading: Event\n  \t\t\t\t// Fired when the grid layer starts loading tiles.\n  \t\t\t\tthis.fire('loading');\n  \t\t\t}\n\n  \t\t\t// create DOM fragment to append tiles in one batch\n  \t\t\tvar fragment = document.createDocumentFragment();\n\n  \t\t\tfor (i = 0; i < queue.length; i++) {\n  \t\t\t\tthis._addTile(queue[i], fragment);\n  \t\t\t}\n\n  \t\t\tthis._level.el.appendChild(fragment);\n  \t\t}\n  \t},\n\n  \t_isValidTile: function (coords) {\n  \t\tvar crs = this._map.options.crs;\n\n  \t\tif (!crs.infinite) {\n  \t\t\t// don't load tile if it's out of bounds and not wrapped\n  \t\t\tvar bounds = this._globalTileRange;\n  \t\t\tif ((!crs.wrapLng && (coords.x < bounds.min.x || coords.x > bounds.max.x)) ||\n  \t\t\t    (!crs.wrapLat && (coords.y < bounds.min.y || coords.y > bounds.max.y))) { return false; }\n  \t\t}\n\n  \t\tif (!this.options.bounds) { return true; }\n\n  \t\t// don't load tile if it doesn't intersect the bounds in options\n  \t\tvar tileBounds = this._tileCoordsToBounds(coords);\n  \t\treturn toLatLngBounds(this.options.bounds).overlaps(tileBounds);\n  \t},\n\n  \t_keyToBounds: function (key) {\n  \t\treturn this._tileCoordsToBounds(this._keyToTileCoords(key));\n  \t},\n\n  \t_tileCoordsToNwSe: function (coords) {\n  \t\tvar map = this._map,\n  \t\t    tileSize = this.getTileSize(),\n  \t\t    nwPoint = coords.scaleBy(tileSize),\n  \t\t    sePoint = nwPoint.add(tileSize),\n  \t\t    nw = map.unproject(nwPoint, coords.z),\n  \t\t    se = map.unproject(sePoint, coords.z);\n  \t\treturn [nw, se];\n  \t},\n\n  \t// converts tile coordinates to its geographical bounds\n  \t_tileCoordsToBounds: function (coords) {\n  \t\tvar bp = this._tileCoordsToNwSe(coords),\n  \t\t    bounds = new LatLngBounds(bp[0], bp[1]);\n\n  \t\tif (!this.options.noWrap) {\n  \t\t\tbounds = this._map.wrapLatLngBounds(bounds);\n  \t\t}\n  \t\treturn bounds;\n  \t},\n  \t// converts tile coordinates to key for the tile cache\n  \t_tileCoordsToKey: function (coords) {\n  \t\treturn coords.x + ':' + coords.y + ':' + coords.z;\n  \t},\n\n  \t// converts tile cache key to coordinates\n  \t_keyToTileCoords: function (key) {\n  \t\tvar k = key.split(':'),\n  \t\t    coords = new Point(+k[0], +k[1]);\n  \t\tcoords.z = +k[2];\n  \t\treturn coords;\n  \t},\n\n  \t_removeTile: function (key) {\n  \t\tvar tile = this._tiles[key];\n  \t\tif (!tile) { return; }\n\n  \t\tremove(tile.el);\n\n  \t\tdelete this._tiles[key];\n\n  \t\t// @event tileunload: TileEvent\n  \t\t// Fired when a tile is removed (e.g. when a tile goes off the screen).\n  \t\tthis.fire('tileunload', {\n  \t\t\ttile: tile.el,\n  \t\t\tcoords: this._keyToTileCoords(key)\n  \t\t});\n  \t},\n\n  \t_initTile: function (tile) {\n  \t\taddClass(tile, 'leaflet-tile');\n\n  \t\tvar tileSize = this.getTileSize();\n  \t\ttile.style.width = tileSize.x + 'px';\n  \t\ttile.style.height = tileSize.y + 'px';\n\n  \t\ttile.onselectstart = falseFn;\n  \t\ttile.onmousemove = falseFn;\n\n  \t\t// update opacity on tiles in IE7-8 because of filter inheritance problems\n  \t\tif (ielt9 && this.options.opacity < 1) {\n  \t\t\tsetOpacity(tile, this.options.opacity);\n  \t\t}\n\n  \t\t// without this hack, tiles disappear after zoom on Chrome for Android\n  \t\t// https://github.com/Leaflet/Leaflet/issues/2078\n  \t\tif (android && !android23) {\n  \t\t\ttile.style.WebkitBackfaceVisibility = 'hidden';\n  \t\t}\n  \t},\n\n  \t_addTile: function (coords, container) {\n  \t\tvar tilePos = this._getTilePos(coords),\n  \t\t    key = this._tileCoordsToKey(coords);\n\n  \t\tvar tile = this.createTile(this._wrapCoords(coords), bind(this._tileReady, this, coords));\n\n  \t\tthis._initTile(tile);\n\n  \t\t// if createTile is defined with a second argument (\"done\" callback),\n  \t\t// we know that tile is async and will be ready later; otherwise\n  \t\tif (this.createTile.length < 2) {\n  \t\t\t// mark tile as ready, but delay one frame for opacity animation to happen\n  \t\t\trequestAnimFrame(bind(this._tileReady, this, coords, null, tile));\n  \t\t}\n\n  \t\tsetPosition(tile, tilePos);\n\n  \t\t// save tile in cache\n  \t\tthis._tiles[key] = {\n  \t\t\tel: tile,\n  \t\t\tcoords: coords,\n  \t\t\tcurrent: true\n  \t\t};\n\n  \t\tcontainer.appendChild(tile);\n  \t\t// @event tileloadstart: TileEvent\n  \t\t// Fired when a tile is requested and starts loading.\n  \t\tthis.fire('tileloadstart', {\n  \t\t\ttile: tile,\n  \t\t\tcoords: coords\n  \t\t});\n  \t},\n\n  \t_tileReady: function (coords, err, tile) {\n  \t\tif (err) {\n  \t\t\t// @event tileerror: TileErrorEvent\n  \t\t\t// Fired when there is an error loading a tile.\n  \t\t\tthis.fire('tileerror', {\n  \t\t\t\terror: err,\n  \t\t\t\ttile: tile,\n  \t\t\t\tcoords: coords\n  \t\t\t});\n  \t\t}\n\n  \t\tvar key = this._tileCoordsToKey(coords);\n\n  \t\ttile = this._tiles[key];\n  \t\tif (!tile) { return; }\n\n  \t\ttile.loaded = +new Date();\n  \t\tif (this._map._fadeAnimated) {\n  \t\t\tsetOpacity(tile.el, 0);\n  \t\t\tcancelAnimFrame(this._fadeFrame);\n  \t\t\tthis._fadeFrame = requestAnimFrame(this._updateOpacity, this);\n  \t\t} else {\n  \t\t\ttile.active = true;\n  \t\t\tthis._pruneTiles();\n  \t\t}\n\n  \t\tif (!err) {\n  \t\t\taddClass(tile.el, 'leaflet-tile-loaded');\n\n  \t\t\t// @event tileload: TileEvent\n  \t\t\t// Fired when a tile loads.\n  \t\t\tthis.fire('tileload', {\n  \t\t\t\ttile: tile.el,\n  \t\t\t\tcoords: coords\n  \t\t\t});\n  \t\t}\n\n  \t\tif (this._noTilesToLoad()) {\n  \t\t\tthis._loading = false;\n  \t\t\t// @event load: Event\n  \t\t\t// Fired when the grid layer loaded all visible tiles.\n  \t\t\tthis.fire('load');\n\n  \t\t\tif (ielt9 || !this._map._fadeAnimated) {\n  \t\t\t\trequestAnimFrame(this._pruneTiles, this);\n  \t\t\t} else {\n  \t\t\t\t// Wait a bit more than 0.2 secs (the duration of the tile fade-in)\n  \t\t\t\t// to trigger a pruning.\n  \t\t\t\tsetTimeout(bind(this._pruneTiles, this), 250);\n  \t\t\t}\n  \t\t}\n  \t},\n\n  \t_getTilePos: function (coords) {\n  \t\treturn coords.scaleBy(this.getTileSize()).subtract(this._level.origin);\n  \t},\n\n  \t_wrapCoords: function (coords) {\n  \t\tvar newCoords = new Point(\n  \t\t\tthis._wrapX ? wrapNum(coords.x, this._wrapX) : coords.x,\n  \t\t\tthis._wrapY ? wrapNum(coords.y, this._wrapY) : coords.y);\n  \t\tnewCoords.z = coords.z;\n  \t\treturn newCoords;\n  \t},\n\n  \t_pxBoundsToTileRange: function (bounds) {\n  \t\tvar tileSize = this.getTileSize();\n  \t\treturn new Bounds(\n  \t\t\tbounds.min.unscaleBy(tileSize).floor(),\n  \t\t\tbounds.max.unscaleBy(tileSize).ceil().subtract([1, 1]));\n  \t},\n\n  \t_noTilesToLoad: function () {\n  \t\tfor (var key in this._tiles) {\n  \t\t\tif (!this._tiles[key].loaded) { return false; }\n  \t\t}\n  \t\treturn true;\n  \t}\n  });\n\n  // @factory L.gridLayer(options?: GridLayer options)\n  // Creates a new instance of GridLayer with the supplied options.\n  function gridLayer(options) {\n  \treturn new GridLayer(options);\n  }\n\n  /*\r\n   * @class TileLayer\r\n   * @inherits GridLayer\r\n   * @aka L.TileLayer\r\n   * Used to load and display tile layers on the map. Note that most tile servers require attribution, which you can set under `Layer`. Extends `GridLayer`.\r\n   *\r\n   * @example\r\n   *\r\n   * ```js\r\n   * L.tileLayer('https://{s}.tile.openstreetmap.org/{z}/{x}/{y}.png?{foo}', {foo: 'bar', attribution: 'Map data &copy; <a href=\"https://www.openstreetmap.org/\">OpenStreetMap</a> contributors, <a href=\"https://creativecommons.org/licenses/by-sa/2.0/\">CC-BY-SA</a>'}).addTo(map);\r\n   * ```\r\n   *\r\n   * @section URL template\r\n   * @example\r\n   *\r\n   * A string of the following form:\r\n   *\r\n   * ```\r\n   * 'http://{s}.somedomain.com/blabla/{z}/{x}/{y}{r}.png'\r\n   * ```\r\n   *\r\n   * `{s}` means one of the available subdomains (used sequentially to help with browser parallel requests per domain limitation; subdomain values are specified in options; `a`, `b` or `c` by default, can be omitted), `{z}` — zoom level, `{x}` and `{y}` — tile coordinates. `{r}` can be used to add \"&commat;2x\" to the URL to load retina tiles.\r\n   *\r\n   * You can use custom keys in the template, which will be [evaluated](#util-template) from TileLayer options, like this:\r\n   *\r\n   * ```\r\n   * L.tileLayer('http://{s}.somedomain.com/{foo}/{z}/{x}/{y}.png', {foo: 'bar'});\r\n   * ```\r\n   */\r\n\r\n\r\n  var TileLayer = GridLayer.extend({\r\n\r\n  \t// @section\r\n  \t// @aka TileLayer options\r\n  \toptions: {\r\n  \t\t// @option minZoom: Number = 0\r\n  \t\t// The minimum zoom level down to which this layer will be displayed (inclusive).\r\n  \t\tminZoom: 0,\r\n\r\n  \t\t// @option maxZoom: Number = 18\r\n  \t\t// The maximum zoom level up to which this layer will be displayed (inclusive).\r\n  \t\tmaxZoom: 18,\r\n\r\n  \t\t// @option subdomains: String|String[] = 'abc'\r\n  \t\t// Subdomains of the tile service. Can be passed in the form of one string (where each letter is a subdomain name) or an array of strings.\r\n  \t\tsubdomains: 'abc',\r\n\r\n  \t\t// @option errorTileUrl: String = ''\r\n  \t\t// URL to the tile image to show in place of the tile that failed to load.\r\n  \t\terrorTileUrl: '',\r\n\r\n  \t\t// @option zoomOffset: Number = 0\r\n  \t\t// The zoom number used in tile URLs will be offset with this value.\r\n  \t\tzoomOffset: 0,\r\n\r\n  \t\t// @option tms: Boolean = false\r\n  \t\t// If `true`, inverses Y axis numbering for tiles (turn this on for [TMS](https://en.wikipedia.org/wiki/Tile_Map_Service) services).\r\n  \t\ttms: false,\r\n\r\n  \t\t// @option zoomReverse: Boolean = false\r\n  \t\t// If set to true, the zoom number used in tile URLs will be reversed (`maxZoom - zoom` instead of `zoom`)\r\n  \t\tzoomReverse: false,\r\n\r\n  \t\t// @option detectRetina: Boolean = false\r\n  \t\t// If `true` and user is on a retina display, it will request four tiles of half the specified size and a bigger zoom level in place of one to utilize the high resolution.\r\n  \t\tdetectRetina: false,\r\n\r\n  \t\t// @option crossOrigin: Boolean|String = false\r\n  \t\t// Whether the crossOrigin attribute will be added to the tiles.\r\n  \t\t// If a String is provided, all tiles will have their crossOrigin attribute set to the String provided. This is needed if you want to access tile pixel data.\r\n  \t\t// Refer to [CORS Settings](https://developer.mozilla.org/en-US/docs/Web/HTML/CORS_settings_attributes) for valid String values.\r\n  \t\tcrossOrigin: false\r\n  \t},\r\n\r\n  \tinitialize: function (url, options) {\r\n\r\n  \t\tthis._url = url;\r\n\r\n  \t\toptions = setOptions(this, options);\r\n\r\n  \t\t// detecting retina displays, adjusting tileSize and zoom levels\r\n  \t\tif (options.detectRetina && retina && options.maxZoom > 0) {\r\n\r\n  \t\t\toptions.tileSize = Math.floor(options.tileSize / 2);\r\n\r\n  \t\t\tif (!options.zoomReverse) {\r\n  \t\t\t\toptions.zoomOffset++;\r\n  \t\t\t\toptions.maxZoom--;\r\n  \t\t\t} else {\r\n  \t\t\t\toptions.zoomOffset--;\r\n  \t\t\t\toptions.minZoom++;\r\n  \t\t\t}\r\n\r\n  \t\t\toptions.minZoom = Math.max(0, options.minZoom);\r\n  \t\t}\r\n\r\n  \t\tif (typeof options.subdomains === 'string') {\r\n  \t\t\toptions.subdomains = options.subdomains.split('');\r\n  \t\t}\r\n\r\n  \t\t// for https://github.com/Leaflet/Leaflet/issues/137\r\n  \t\tif (!android) {\r\n  \t\t\tthis.on('tileunload', this._onTileRemove);\r\n  \t\t}\r\n  \t},\r\n\r\n  \t// @method setUrl(url: String, noRedraw?: Boolean): this\r\n  \t// Updates the layer's URL template and redraws it (unless `noRedraw` is set to `true`).\r\n  \t// If the URL does not change, the layer will not be redrawn unless\r\n  \t// the noRedraw parameter is set to false.\r\n  \tsetUrl: function (url, noRedraw) {\r\n  \t\tif (this._url === url && noRedraw === undefined) {\r\n  \t\t\tnoRedraw = true;\r\n  \t\t}\r\n\r\n  \t\tthis._url = url;\r\n\r\n  \t\tif (!noRedraw) {\r\n  \t\t\tthis.redraw();\r\n  \t\t}\r\n  \t\treturn this;\r\n  \t},\r\n\r\n  \t// @method createTile(coords: Object, done?: Function): HTMLElement\r\n  \t// Called only internally, overrides GridLayer's [`createTile()`](#gridlayer-createtile)\r\n  \t// to return an `<img>` HTML element with the appropriate image URL given `coords`. The `done`\r\n  \t// callback is called when the tile has been loaded.\r\n  \tcreateTile: function (coords, done) {\r\n  \t\tvar tile = document.createElement('img');\r\n\r\n  \t\ton(tile, 'load', bind(this._tileOnLoad, this, done, tile));\r\n  \t\ton(tile, 'error', bind(this._tileOnError, this, done, tile));\r\n\r\n  \t\tif (this.options.crossOrigin || this.options.crossOrigin === '') {\r\n  \t\t\ttile.crossOrigin = this.options.crossOrigin === true ? '' : this.options.crossOrigin;\r\n  \t\t}\r\n\r\n  \t\t/*\r\n  \t\t Alt tag is set to empty string to keep screen readers from reading URL and for compliance reasons\r\n  \t\t http://www.w3.org/TR/WCAG20-TECHS/H67\r\n  \t\t*/\r\n  \t\ttile.alt = '';\r\n\r\n  \t\t/*\r\n  \t\t Set role=\"presentation\" to force screen readers to ignore this\r\n  \t\t https://www.w3.org/TR/wai-aria/roles#textalternativecomputation\r\n  \t\t*/\r\n  \t\ttile.setAttribute('role', 'presentation');\r\n\r\n  \t\ttile.src = this.getTileUrl(coords);\r\n\r\n  \t\treturn tile;\r\n  \t},\r\n\r\n  \t// @section Extension methods\r\n  \t// @uninheritable\r\n  \t// Layers extending `TileLayer` might reimplement the following method.\r\n  \t// @method getTileUrl(coords: Object): String\r\n  \t// Called only internally, returns the URL for a tile given its coordinates.\r\n  \t// Classes extending `TileLayer` can override this function to provide custom tile URL naming schemes.\r\n  \tgetTileUrl: function (coords) {\r\n  \t\tvar data = {\r\n  \t\t\tr: retina ? '@2x' : '',\r\n  \t\t\ts: this._getSubdomain(coords),\r\n  \t\t\tx: coords.x,\r\n  \t\t\ty: coords.y,\r\n  \t\t\tz: this._getZoomForUrl()\r\n  \t\t};\r\n  \t\tif (this._map && !this._map.options.crs.infinite) {\r\n  \t\t\tvar invertedY = this._globalTileRange.max.y - coords.y;\r\n  \t\t\tif (this.options.tms) {\r\n  \t\t\t\tdata['y'] = invertedY;\r\n  \t\t\t}\r\n  \t\t\tdata['-y'] = invertedY;\r\n  \t\t}\r\n\r\n  \t\treturn template(this._url, extend(data, this.options));\r\n  \t},\r\n\r\n  \t_tileOnLoad: function (done, tile) {\r\n  \t\t// For https://github.com/Leaflet/Leaflet/issues/3332\r\n  \t\tif (ielt9) {\r\n  \t\t\tsetTimeout(bind(done, this, null, tile), 0);\r\n  \t\t} else {\r\n  \t\t\tdone(null, tile);\r\n  \t\t}\r\n  \t},\r\n\r\n  \t_tileOnError: function (done, tile, e) {\r\n  \t\tvar errorUrl = this.options.errorTileUrl;\r\n  \t\tif (errorUrl && tile.getAttribute('src') !== errorUrl) {\r\n  \t\t\ttile.src = errorUrl;\r\n  \t\t}\r\n  \t\tdone(e, tile);\r\n  \t},\r\n\r\n  \t_onTileRemove: function (e) {\r\n  \t\te.tile.onload = null;\r\n  \t},\r\n\r\n  \t_getZoomForUrl: function () {\r\n  \t\tvar zoom = this._tileZoom,\r\n  \t\tmaxZoom = this.options.maxZoom,\r\n  \t\tzoomReverse = this.options.zoomReverse,\r\n  \t\tzoomOffset = this.options.zoomOffset;\r\n\r\n  \t\tif (zoomReverse) {\r\n  \t\t\tzoom = maxZoom - zoom;\r\n  \t\t}\r\n\r\n  \t\treturn zoom + zoomOffset;\r\n  \t},\r\n\r\n  \t_getSubdomain: function (tilePoint) {\r\n  \t\tvar index = Math.abs(tilePoint.x + tilePoint.y) % this.options.subdomains.length;\r\n  \t\treturn this.options.subdomains[index];\r\n  \t},\r\n\r\n  \t// stops loading all tiles in the background layer\r\n  \t_abortLoading: function () {\r\n  \t\tvar i, tile;\r\n  \t\tfor (i in this._tiles) {\r\n  \t\t\tif (this._tiles[i].coords.z !== this._tileZoom) {\r\n  \t\t\t\ttile = this._tiles[i].el;\r\n\r\n  \t\t\t\ttile.onload = falseFn;\r\n  \t\t\t\ttile.onerror = falseFn;\r\n\r\n  \t\t\t\tif (!tile.complete) {\r\n  \t\t\t\t\ttile.src = emptyImageUrl;\r\n  \t\t\t\t\tremove(tile);\r\n  \t\t\t\t\tdelete this._tiles[i];\r\n  \t\t\t\t}\r\n  \t\t\t}\r\n  \t\t}\r\n  \t},\r\n\r\n  \t_removeTile: function (key) {\r\n  \t\tvar tile = this._tiles[key];\r\n  \t\tif (!tile) { return; }\r\n\r\n  \t\t// Cancels any pending http requests associated with the tile\r\n  \t\t// unless we're on Android's stock browser,\r\n  \t\t// see https://github.com/Leaflet/Leaflet/issues/137\r\n  \t\tif (!androidStock) {\r\n  \t\t\ttile.el.setAttribute('src', emptyImageUrl);\r\n  \t\t}\r\n\r\n  \t\treturn GridLayer.prototype._removeTile.call(this, key);\r\n  \t},\r\n\r\n  \t_tileReady: function (coords, err, tile) {\r\n  \t\tif (!this._map || (tile && tile.getAttribute('src') === emptyImageUrl)) {\r\n  \t\t\treturn;\r\n  \t\t}\r\n\r\n  \t\treturn GridLayer.prototype._tileReady.call(this, coords, err, tile);\r\n  \t}\r\n  });\r\n\r\n\r\n  // @factory L.tilelayer(urlTemplate: String, options?: TileLayer options)\r\n  // Instantiates a tile layer object given a `URL template` and optionally an options object.\r\n\r\n  function tileLayer(url, options) {\r\n  \treturn new TileLayer(url, options);\r\n  }\n\n  /*\r\n   * @class TileLayer.WMS\r\n   * @inherits TileLayer\r\n   * @aka L.TileLayer.WMS\r\n   * Used to display [WMS](https://en.wikipedia.org/wiki/Web_Map_Service) services as tile layers on the map. Extends `TileLayer`.\r\n   *\r\n   * @example\r\n   *\r\n   * ```js\r\n   * var nexrad = L.tileLayer.wms(\"http://mesonet.agron.iastate.edu/cgi-bin/wms/nexrad/n0r.cgi\", {\r\n   * \tlayers: 'nexrad-n0r-900913',\r\n   * \tformat: 'image/png',\r\n   * \ttransparent: true,\r\n   * \tattribution: \"Weather data © 2012 IEM Nexrad\"\r\n   * });\r\n   * ```\r\n   */\r\n\r\n  var TileLayerWMS = TileLayer.extend({\r\n\r\n  \t// @section\r\n  \t// @aka TileLayer.WMS options\r\n  \t// If any custom options not documented here are used, they will be sent to the\r\n  \t// WMS server as extra parameters in each request URL. This can be useful for\r\n  \t// [non-standard vendor WMS parameters](http://docs.geoserver.org/stable/en/user/services/wms/vendor.html).\r\n  \tdefaultWmsParams: {\r\n  \t\tservice: 'WMS',\r\n  \t\trequest: 'GetMap',\r\n\r\n  \t\t// @option layers: String = ''\r\n  \t\t// **(required)** Comma-separated list of WMS layers to show.\r\n  \t\tlayers: '',\r\n\r\n  \t\t// @option styles: String = ''\r\n  \t\t// Comma-separated list of WMS styles.\r\n  \t\tstyles: '',\r\n\r\n  \t\t// @option format: String = 'image/jpeg'\r\n  \t\t// WMS image format (use `'image/png'` for layers with transparency).\r\n  \t\tformat: 'image/jpeg',\r\n\r\n  \t\t// @option transparent: Boolean = false\r\n  \t\t// If `true`, the WMS service will return images with transparency.\r\n  \t\ttransparent: false,\r\n\r\n  \t\t// @option version: String = '1.1.1'\r\n  \t\t// Version of the WMS service to use\r\n  \t\tversion: '1.1.1'\r\n  \t},\r\n\r\n  \toptions: {\r\n  \t\t// @option crs: CRS = null\r\n  \t\t// Coordinate Reference System to use for the WMS requests, defaults to\r\n  \t\t// map CRS. Don't change this if you're not sure what it means.\r\n  \t\tcrs: null,\r\n\r\n  \t\t// @option uppercase: Boolean = false\r\n  \t\t// If `true`, WMS request parameter keys will be uppercase.\r\n  \t\tuppercase: false\r\n  \t},\r\n\r\n  \tinitialize: function (url, options) {\r\n\r\n  \t\tthis._url = url;\r\n\r\n  \t\tvar wmsParams = extend({}, this.defaultWmsParams);\r\n\r\n  \t\t// all keys that are not TileLayer options go to WMS params\r\n  \t\tfor (var i in options) {\r\n  \t\t\tif (!(i in this.options)) {\r\n  \t\t\t\twmsParams[i] = options[i];\r\n  \t\t\t}\r\n  \t\t}\r\n\r\n  \t\toptions = setOptions(this, options);\r\n\r\n  \t\tvar realRetina = options.detectRetina && retina ? 2 : 1;\r\n  \t\tvar tileSize = this.getTileSize();\r\n  \t\twmsParams.width = tileSize.x * realRetina;\r\n  \t\twmsParams.height = tileSize.y * realRetina;\r\n\r\n  \t\tthis.wmsParams = wmsParams;\r\n  \t},\r\n\r\n  \tonAdd: function (map) {\r\n\r\n  \t\tthis._crs = this.options.crs || map.options.crs;\r\n  \t\tthis._wmsVersion = parseFloat(this.wmsParams.version);\r\n\r\n  \t\tvar projectionKey = this._wmsVersion >= 1.3 ? 'crs' : 'srs';\r\n  \t\tthis.wmsParams[projectionKey] = this._crs.code;\r\n\r\n  \t\tTileLayer.prototype.onAdd.call(this, map);\r\n  \t},\r\n\r\n  \tgetTileUrl: function (coords) {\r\n\r\n  \t\tvar tileBounds = this._tileCoordsToNwSe(coords),\r\n  \t\t    crs = this._crs,\r\n  \t\t    bounds = toBounds(crs.project(tileBounds[0]), crs.project(tileBounds[1])),\r\n  \t\t    min = bounds.min,\r\n  \t\t    max = bounds.max,\r\n  \t\t    bbox = (this._wmsVersion >= 1.3 && this._crs === EPSG4326 ?\r\n  \t\t    [min.y, min.x, max.y, max.x] :\r\n  \t\t    [min.x, min.y, max.x, max.y]).join(','),\r\n  \t\t    url = TileLayer.prototype.getTileUrl.call(this, coords);\r\n  \t\treturn url +\r\n  \t\t\tgetParamString(this.wmsParams, url, this.options.uppercase) +\r\n  \t\t\t(this.options.uppercase ? '&BBOX=' : '&bbox=') + bbox;\r\n  \t},\r\n\r\n  \t// @method setParams(params: Object, noRedraw?: Boolean): this\r\n  \t// Merges an object with the new parameters and re-requests tiles on the current screen (unless `noRedraw` was set to true).\r\n  \tsetParams: function (params, noRedraw) {\r\n\r\n  \t\textend(this.wmsParams, params);\r\n\r\n  \t\tif (!noRedraw) {\r\n  \t\t\tthis.redraw();\r\n  \t\t}\r\n\r\n  \t\treturn this;\r\n  \t}\r\n  });\r\n\r\n\r\n  // @factory L.tileLayer.wms(baseUrl: String, options: TileLayer.WMS options)\r\n  // Instantiates a WMS tile layer object given a base URL of the WMS service and a WMS parameters/options object.\r\n  function tileLayerWMS(url, options) {\r\n  \treturn new TileLayerWMS(url, options);\r\n  }\n\n  TileLayer.WMS = TileLayerWMS;\n  tileLayer.wms = tileLayerWMS;\n\n  /*\n   * @class Renderer\n   * @inherits Layer\n   * @aka L.Renderer\n   *\n   * Base class for vector renderer implementations (`SVG`, `Canvas`). Handles the\n   * DOM container of the renderer, its bounds, and its zoom animation.\n   *\n   * A `Renderer` works as an implicit layer group for all `Path`s - the renderer\n   * itself can be added or removed to the map. All paths use a renderer, which can\n   * be implicit (the map will decide the type of renderer and use it automatically)\n   * or explicit (using the [`renderer`](#path-renderer) option of the path).\n   *\n   * Do not use this class directly, use `SVG` and `Canvas` instead.\n   *\n   * @event update: Event\n   * Fired when the renderer updates its bounds, center and zoom, for example when\n   * its map has moved\n   */\n\n  var Renderer = Layer.extend({\n\n  \t// @section\n  \t// @aka Renderer options\n  \toptions: {\n  \t\t// @option padding: Number = 0.1\n  \t\t// How much to extend the clip area around the map view (relative to its size)\n  \t\t// e.g. 0.1 would be 10% of map view in each direction\n  \t\tpadding: 0.1,\n\n  \t\t// @option tolerance: Number = 0\n  \t\t// How much to extend click tolerance round a path/object on the map\n  \t\ttolerance : 0\n  \t},\n\n  \tinitialize: function (options) {\n  \t\tsetOptions(this, options);\n  \t\tstamp(this);\n  \t\tthis._layers = this._layers || {};\n  \t},\n\n  \tonAdd: function () {\n  \t\tif (!this._container) {\n  \t\t\tthis._initContainer(); // defined by renderer implementations\n\n  \t\t\tif (this._zoomAnimated) {\n  \t\t\t\taddClass(this._container, 'leaflet-zoom-animated');\n  \t\t\t}\n  \t\t}\n\n  \t\tthis.getPane().appendChild(this._container);\n  \t\tthis._update();\n  \t\tthis.on('update', this._updatePaths, this);\n  \t},\n\n  \tonRemove: function () {\n  \t\tthis.off('update', this._updatePaths, this);\n  \t\tthis._destroyContainer();\n  \t},\n\n  \tgetEvents: function () {\n  \t\tvar events = {\n  \t\t\tviewreset: this._reset,\n  \t\t\tzoom: this._onZoom,\n  \t\t\tmoveend: this._update,\n  \t\t\tzoomend: this._onZoomEnd\n  \t\t};\n  \t\tif (this._zoomAnimated) {\n  \t\t\tevents.zoomanim = this._onAnimZoom;\n  \t\t}\n  \t\treturn events;\n  \t},\n\n  \t_onAnimZoom: function (ev) {\n  \t\tthis._updateTransform(ev.center, ev.zoom);\n  \t},\n\n  \t_onZoom: function () {\n  \t\tthis._updateTransform(this._map.getCenter(), this._map.getZoom());\n  \t},\n\n  \t_updateTransform: function (center, zoom) {\n  \t\tvar scale = this._map.getZoomScale(zoom, this._zoom),\n  \t\t    position = getPosition(this._container),\n  \t\t    viewHalf = this._map.getSize().multiplyBy(0.5 + this.options.padding),\n  \t\t    currentCenterPoint = this._map.project(this._center, zoom),\n  \t\t    destCenterPoint = this._map.project(center, zoom),\n  \t\t    centerOffset = destCenterPoint.subtract(currentCenterPoint),\n\n  \t\t    topLeftOffset = viewHalf.multiplyBy(-scale).add(position).add(viewHalf).subtract(centerOffset);\n\n  \t\tif (any3d) {\n  \t\t\tsetTransform(this._container, topLeftOffset, scale);\n  \t\t} else {\n  \t\t\tsetPosition(this._container, topLeftOffset);\n  \t\t}\n  \t},\n\n  \t_reset: function () {\n  \t\tthis._update();\n  \t\tthis._updateTransform(this._center, this._zoom);\n\n  \t\tfor (var id in this._layers) {\n  \t\t\tthis._layers[id]._reset();\n  \t\t}\n  \t},\n\n  \t_onZoomEnd: function () {\n  \t\tfor (var id in this._layers) {\n  \t